/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.okapi.common.Util;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UtilTest {
    private CharsetEncoder chsEnc;
    private DocumentBuilderFactory docBuilderFact;

    @Before
    public void setUp() throws Exception {
        this.docBuilderFact = DocumentBuilderFactory.newInstance();
        this.docBuilderFact.setValidating(false);
        this.chsEnc = Charset.forName("iso-8859-1").newEncoder();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void isEmptyNull() {
        Assert.assertTrue((String)"null should be empty", (boolean)Util.isEmpty((String)null));
    }

    @Test
    public void isEmptyEmpty() {
        Assert.assertTrue((String)"Empty should be empty", (boolean)Util.isEmpty(""));
    }

    @Test
    public void isEmptyNotEmpty() {
        Assert.assertFalse((String)"Not empty should be not empty", (boolean)Util.isEmpty("not"));
    }

    @Test
    public void isEmptyNotEmptyWhitespace() {
        Assert.assertFalse((String)"Space should not be empty", (boolean)Util.isEmpty(" "));
    }

    @Test
    public void isEmptyIgnoreWSNotEmptyWhitespace() {
        Assert.assertTrue((String)"Space should be empty", (boolean)Util.isEmpty(" ", true));
    }

    @Test
    public void isEmptyIgnoreWSEmpty() {
        Assert.assertTrue((String)"Empty should be empty", (boolean)Util.isEmpty("", true));
    }

    @Test
    public void isEmptyIgnoreWSNull() {
        Assert.assertTrue((String)"Null should be empty", (boolean)Util.isEmpty(null, true));
    }

    @Test
    public void isEmptyIgnoreWSNotEmpty() {
        Assert.assertFalse((String)"Not empty should be not empty", (boolean)Util.isEmpty("s", true));
    }

    @Test
    public void isEmptyIgnoreWSNotEmptyImmutable() {
        String tmp = "s ";
        Util.isEmpty(tmp, true);
        Assert.assertEquals((String)"tmp after method call", (Object)"s ", (Object)tmp);
    }

    @Test
    public void testTrimStart() {
        Assert.assertEquals((Object)"textz \t ", (Object)Util.trimStart(" \t ztextz \t ", " \tz"));
        Assert.assertEquals((Object)"", (Object)Util.trimStart(" \t ", " \tz"));
        Assert.assertEquals(null, (Object)Util.trimStart(null, " \tz"));
        Assert.assertEquals((Object)"", (Object)Util.trimStart("", " \tz"));
    }

    @Test
    public void testTrimEnd() {
        Assert.assertEquals((Object)" \t ztext", (Object)Util.trimEnd(" \t ztextz \t ", " \tz"));
        Assert.assertEquals((Object)"", (Object)Util.trimEnd(" \t ", " \tz"));
        Assert.assertEquals(null, (Object)Util.trimEnd(null, " \tz"));
        Assert.assertEquals((Object)"", (Object)Util.trimEnd("", " \tz"));
    }

    @Test
    public void testGetDirectoryName_BSlash() {
        String in = "C:\\test\\file";
        Assert.assertEquals((Object)"C:\\test", (Object)Util.getDirectoryName(in));
    }

    @Test
    public void testGetDirectoryName_MixedCases() {
        String in = "/home/test\\file";
        Assert.assertEquals((Object)"/home/test", (Object)Util.getDirectoryName(in));
    }

    @Test
    public void testGetDirectoryName_Slash() {
        String in = "/home/test/file";
        Assert.assertEquals((Object)"/home/test", (Object)Util.getDirectoryName(in));
    }

    @Test
    public void testGetDirectoryName_DirBSlash() {
        String in = "C:\\test\\";
        Assert.assertEquals((Object)"C:\\test", (Object)Util.getDirectoryName(in));
    }

    @Test
    public void testGetDirectoryName_DirSlash() {
        String in = "/home/test/";
        Assert.assertEquals((Object)"/home/test", (Object)Util.getDirectoryName(in));
    }

    @Test
    public void testGetDirectoryName_Filename() {
        String in = "myFile.ext";
        Assert.assertEquals((Object)"", (Object)Util.getDirectoryName(in));
    }

    @Test
    public void testGetDirectoryName_URL() {
        String in = "/C:/test/file.ext";
        Assert.assertEquals((Object)"/C:/test", (Object)Util.getDirectoryName(in));
    }

    @Test
    public void testEscapeToXML_Quote0() {
        String in = "&<>'\"";
        Assert.assertEquals((Object)"&amp;&lt;>'\"", (Object)Util.escapeToXML(in, 0, false, null));
    }

    @Test
    public void testEscapeToXML_Quote1() {
        String in = "&<>'\"";
        Assert.assertEquals((Object)"&amp;&lt;>&apos;&quot;", (Object)Util.escapeToXML(in, 1, false, null));
    }

    @Test
    public void testEscapeToXML_Quote2() {
        String in = "&<>'\"";
        Assert.assertEquals((Object)"&amp;&lt;>&#39;&quot;", (Object)Util.escapeToXML(in, 2, false, null));
    }

    @Test
    public void testEscapeToXML_Quote3() {
        String in = "&<>'\"";
        Assert.assertEquals((Object)"&amp;&lt;>'&quot;", (Object)Util.escapeToXML(in, 3, false, null));
    }

    @Test
    public void testEscapeToXML_GT() {
        String in = "&<>'\"";
        Assert.assertEquals((Object)"&amp;&lt;&gt;'&quot;", (Object)Util.escapeToXML(in, 3, true, null));
    }

    @Test
    public void testEscapeToXML_ExtCharsWithNull() {
        String in = "\u00d0\u0440Z\ud840\udc00";
        Assert.assertEquals((Object)"\u00d0\u0440Z\ud840\udc00", (Object)Util.escapeToXML(in, 0, false, null));
    }

    @Test
    public void testEscapeToXML_ExtCharsWithLatin1() {
        String in = "\u00d0\u0440Z\ud840\udc00";
        Assert.assertEquals((Object)"\u00d0&#x0440;Z&#x20000;", (Object)Util.escapeToXML(in, 0, false, this.chsEnc));
    }

    @Test
    public void testGetExtension() {
        String in = "myFile.abc.ext";
        Assert.assertEquals((Object)".ext", (Object)Util.getExtension(in));
    }

    @Test
    public void testGetExtension_Alone() {
        String in = ".ext";
        Assert.assertEquals((Object)".ext", (Object)Util.getExtension(in));
    }

    @Test
    public void testGetExtension_None() {
        String in = "myFile";
        Assert.assertEquals((Object)"", (Object)Util.getExtension(in));
    }

    @Test
    public void testGetExtension_Dot() {
        String in = "myFile.";
        Assert.assertEquals((Object)".", (Object)Util.getExtension(in));
    }

    @Test
    public void testGetPercentage() {
        Assert.assertEquals((long)45L, (long)Util.getPercentage(450, 1000));
    }

    @Test
    public void testGetPercentage_WithZero() {
        Assert.assertEquals((long)1L, (long)Util.getPercentage(10, 0));
    }

    @Test
    public void testIsSameLanguage_DoNotIgnoreRegion() {
        Assert.assertTrue((boolean)Util.isSameLanguage("en", "en", false));
        Assert.assertTrue((boolean)Util.isSameLanguage("en", "EN", false));
        Assert.assertTrue((boolean)Util.isSameLanguage("En", "eN", false));
        Assert.assertFalse((boolean)Util.isSameLanguage("en", "fr", false));
        Assert.assertFalse((boolean)Util.isSameLanguage("en", "en-us", false));
        Assert.assertFalse((boolean)Util.isSameLanguage("en-us", "en", false));
        Assert.assertFalse((boolean)Util.isSameLanguage("abc-xyz", "abc-QWE", false));
        Assert.assertFalse((boolean)Util.isSameLanguage("abc-xyz", "iop-QWE", false));
    }

    @Test
    public void testIsSameLanguage_IgnoreRegion() {
        Assert.assertTrue((boolean)Util.isSameLanguage("en", "en", true));
        Assert.assertTrue((boolean)Util.isSameLanguage("en", "EN", true));
        Assert.assertTrue((boolean)Util.isSameLanguage("En", "eN", true));
        Assert.assertFalse((boolean)Util.isSameLanguage("en", "fr", true));
        Assert.assertTrue((boolean)Util.isSameLanguage("en", "en-us", true));
        Assert.assertTrue((boolean)Util.isSameLanguage("en-us", "en", true));
        Assert.assertTrue((boolean)Util.isSameLanguage("abc-xyz", "abc-QWE", true));
        Assert.assertFalse((boolean)Util.isSameLanguage("abc-xyz", "iop-QWE", true));
    }

    @Test
    public void testGetTextContent_Simple() {
        Document doc = this.createXMLdocument("<d>\n\nText</d>");
        Element elem = doc.getDocumentElement();
        Assert.assertEquals((Object)"\n\nText", (Object)Util.getTextContent(elem));
    }

    @Test
    public void testGetTextContent_WithComment() {
        Document doc = this.createXMLdocument("<d><!--comment-->Text</d>");
        Element elem = doc.getDocumentElement();
        Assert.assertEquals((Object)"Text", (Object)Util.getTextContent(elem));
    }

    @Test
    public void testGetTextContent_Empty() {
        Document doc = this.createXMLdocument("<d/>");
        Element elem = doc.getDocumentElement();
        Assert.assertEquals((Object)"", (Object)Util.getTextContent(elem));
    }

    @Test
    public void testMin() {
        Assert.assertEquals((long)-10L, (long)Util.min(10, 20, 30, -10, 0, 5));
        Assert.assertEquals((long)-100L, (long)Util.min(-99, -98, -100, 1000));
        Assert.assertEquals((long)10L, (long)Util.min(10, 20, 30, 40, 15));
        Assert.assertEquals((long)0L, (long)Util.min(new int[0]));
    }

    @Test
    public void testToURI() {
        Assert.assertEquals((Object)"/C:/test", (Object)Util.toURI("C:\\test").getPath());
        Assert.assertEquals((Object)"/C:/test", (Object)Util.toURI("file:///C:/test").getPath());
        Assert.assertEquals((Object)"/C:/test", (Object)Util.toURI("/C:/test").getPath());
        Assert.assertEquals((Object)"/C:/test", (Object)Util.toURI("file:/C:/test").getPath());
    }

    @Test
    public void testEmptyURI() throws URISyntaxException {
        try {
            Assert.assertEquals((Object)"", (Object)Util.toURI(null).toString());
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Assert.assertEquals((Object)"", (Object)Util.toURI(null).getPath());
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Assert.assertEquals((Object)"", (Object)Util.makeURIFromPath(null));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Assert.assertEquals((Object)"", (Object)Util.toURI("").toString());
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Assert.assertEquals((Object)"", (Object)Util.toURI("").getPath());
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Assert.assertEquals((Object)"", (Object)Util.makeURIFromPath(""));
        }
        catch (IllegalArgumentException e) {
            return;
        }
        Assert.fail();
    }

    @Test
    public void testEnsureSeparator() {
        Assert.assertEquals(null, (Object)Util.ensureSeparator(null, false));
        Assert.assertEquals((Object)"", (Object)Util.ensureSeparator("", false));
        Assert.assertEquals((Object)"/C:/test/", (Object)Util.ensureSeparator("/C:/test/", false));
        Assert.assertEquals((Object)("/C:/test" + File.separator), (Object)Util.ensureSeparator("/C:/test" + File.separator, false));
        Assert.assertEquals((Object)"/C:/test/", (Object)Util.ensureSeparator("/C:/test" + File.separator, true));
        Assert.assertEquals((Object)("/C:/test" + File.separator), (Object)Util.ensureSeparator("/C:/test", false));
        Assert.assertEquals((Object)"/C:/test/", (Object)Util.ensureSeparator("/C:/test", true));
    }

    @Test
    public void testFixFilename() {
        Assert.assertEquals((Object)"", (Object)Util.fixFilename(null));
        Assert.assertEquals((Object)"", (Object)Util.fixFilename(null, null));
        Assert.assertEquals((Object)"abs:def", (Object)Util.fixFilename("abs:def", null));
        Assert.assertEquals((Object)"a_bc_de_fgh_ijk{l};mn_op_qr (s) t_uvw!x_y[z]", (Object)Util.fixFilename("a*bc:de<fgh>ijk{l};mn?op\\qr (s) t|uvw!x/y[z]"));
    }

    @Test
    public void testFixPath() {
        Assert.assertEquals((Object)"/C:/dir1/dir2/dir3/dir4/filename.ext", (Object)Util.fixPath("/C:/dir1////dir2/dir3/dir4/filename.ext"));
        Assert.assertEquals((Object)"/C:/dir1/dir2/dir3/dir4/filename.ext", (Object)Util.fixPath("/C:/dir1/dir2/////dir3/dir4/filename.ext"));
        Assert.assertEquals((Object)"/C:/dir1/dir2/dir3/dir4/filename.ext", (Object)Util.fixPath("/C:/dir1/dir2\\/dir3/dir4/filename.ext"));
        Assert.assertEquals((Object)"/C:/dir1/dir2/dir3/dir4/filename.ext", (Object)Util.fixPath("/C:/dir1/dir2//\\\\\\\\\\dir3/dir4/filename.ext"));
        Assert.assertEquals((Object)"/C:/dir1/dir2/dir3/dir4/filename.ext", (Object)Util.fixPath("/C:/dir1/dir2/dir3/dir4/\\filename.ext"));
        Assert.assertEquals((Object)"/C:/dir1/dir2/dir3/dir4/filename.ext", (Object)Util.fixPath("/C:/dir1//dir2/\\//\\\\dir3/dir4/filename.ext"));
        Assert.assertEquals((Object)"/C:/dir1/dir2/dir3/dir4/filename.ext", (Object)Util.fixPath("/C:/dir1//dir2\\/\\\\/\\//\\\\dir3/dir4/filename.ext"));
    }

    @Test
    public void testMapGetValue() {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("one", 1L);
        map.put("two", 2L);
        Assert.assertEquals((Object)1L, (Object)Util.getValue(map, "one", 0L));
        Assert.assertEquals((Object)2L, (Object)Util.getValue(map, "two", 0L));
        Assert.assertEquals((Object)0L, (Object)Util.getValue(map, "three", 0L));
        Assert.assertEquals((Object)5L, (Object)Util.getValue(map, "three", 5L));
    }

    @Test
    public void testNormalizRange() {
        int nv = Util.normalizeRange(0.0f, 100.0f, 50.0f);
        Assert.assertEquals((long)50L, (long)nv);
        nv = Util.normalizeRange(-5.0f, 5.0f, 0.0f);
        Assert.assertEquals((long)50L, (long)nv);
        nv = Util.normalizeRange(-5.0f, 5.0f, 5.0f);
        Assert.assertEquals((long)100L, (long)nv);
        nv = Util.normalizeRange(-5.0f, 5.0f, -5.0f);
        Assert.assertEquals((long)0L, (long)nv);
        nv = Util.normalizeRange(-100.0f, 100.0f, -30.0f);
        Assert.assertEquals((long)35L, (long)nv);
        nv = Util.normalizeRange(-100.0f, 100.0f, 30.0f);
        Assert.assertEquals((long)65L, (long)nv);
        nv = Util.normalizeRange(-100.0f, 100.0f, 0.0f);
        Assert.assertEquals((long)50L, (long)nv);
        nv = Util.normalizeRange(-100.0f, 100.0f, -100.0f);
        Assert.assertEquals((long)0L, (long)nv);
        nv = Util.normalizeRange(-100.0f, 100.0f, 100.0f);
        Assert.assertEquals((long)100L, (long)nv);
    }

    private Document createXMLdocument(String data) {
        InputSource input = new InputSource(new StringReader(data));
        Document doc = null;
        try {
            doc = this.docBuilderFact.newDocumentBuilder().parse(input);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        Assert.assertNotNull((Object)doc);
        return doc;
    }
}

