/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.annotation;

import java.security.InvalidParameterException;
import java.util.HashMap;
import net.sf.okapi.common.Util;

public class GenericAnnotation {
    private static final String FIELD_SEPARATOR = "\u001e";
    private static final String PART_SEPARATOR = "\u001f";
    private String type;
    private HashMap<String, Object> map;

    public GenericAnnotation(String type) {
        if (Util.isEmpty(type)) {
            throw new InvalidParameterException("The type of an annotation must not be null or empty.");
        }
        this.type = type;
    }

    public GenericAnnotation clone() {
        GenericAnnotation obj = new GenericAnnotation("z");
        obj.fromString(this.toString());
        return obj;
    }

    public String getType() {
        return this.type;
    }

    public String getString(String name) {
        if (this.map == null) {
            return null;
        }
        Object obj = this.map.get(name);
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof String)) {
            throw new InvalidParameterException(String.format("The field '%s' is not a string.", name));
        }
        return (String)obj;
    }

    public void setString(String name, String value) {
        this.setObject(name, value);
    }

    public Boolean getBoolean(String name) {
        if (this.map == null) {
            return null;
        }
        Object obj = this.map.get(name);
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof Boolean)) {
            throw new InvalidParameterException(String.format("The field '%s' is not a boolean.", name));
        }
        return (Boolean)obj;
    }

    public void setBoolean(String name, Boolean value) {
        this.setObject(name, value);
    }

    public Float getFloat(String name) {
        if (this.map == null) {
            return null;
        }
        Object obj = this.map.get(name);
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof Float)) {
            throw new InvalidParameterException(String.format("The field '%s' is not a float.", name));
        }
        return (Float)obj;
    }

    public void setFloat(String name, Float value) {
        this.setObject(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.type);
        if (this.map == null) {
            return sb.toString();
        }
        for (String name : this.map.keySet()) {
            Object value = this.map.get(name);
            sb.append(FIELD_SEPARATOR);
            sb.append(name);
            sb.append(PART_SEPARATOR);
            if (value instanceof String) {
                sb.append('s');
            } else if (value instanceof Boolean) {
                sb.append('b');
            } else if (value instanceof Float) {
                sb.append('f');
            }
            sb.append(PART_SEPARATOR);
            sb.append(value);
        }
        return sb.toString();
    }

    public void fromString(String storage) {
        String[] fields = storage.split(FIELD_SEPARATOR, 0);
        this.type = fields[0];
        for (int i = 1; i < fields.length; ++i) {
            String[] parts = fields[i].split(PART_SEPARATOR, -1);
            if (parts[1].equals("s")) {
                this.setString(parts[0], parts[2]);
                continue;
            }
            if (parts[1].equals("b")) {
                this.setBoolean(parts[0], parts[2].equals("true"));
                continue;
            }
            if (parts[1].equals("f")) {
                this.setFloat(parts[0], Float.valueOf(Float.parseFloat(parts[2])));
                continue;
            }
            throw new RuntimeException(String.format("Unknow field type in annotation: '%s'", parts[1]));
        }
    }

    private void setObject(String name, Object value) {
        if (Util.isEmpty(name)) {
            throw new InvalidParameterException("The field name must not be null or empty.");
        }
        if (this.map == null) {
            this.map = new HashMap();
        }
        if (value == null) {
            this.map.remove(name);
        } else {
            this.map.put(name, value);
        }
    }
}

