/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.annotation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.resource.InlineAnnotation;

public class GenericAnnotations
extends InlineAnnotation {
    private static final String ANNOTATION_SEPARATOR = "\u001d";
    List<GenericAnnotation> list;

    public GenericAnnotations() {
    }

    public GenericAnnotations(String storage) {
        this.fromString(storage);
    }

    @Override
    public GenericAnnotations clone() {
        return new GenericAnnotations(this.toString());
    }

    public int size() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    public List<GenericAnnotation> getAnnotations(String type) {
        if (Util.isEmpty(this.list)) {
            return Collections.emptyList();
        }
        ArrayList<GenericAnnotation> res = new ArrayList<GenericAnnotation>();
        for (GenericAnnotation ann : this.list) {
            if (!ann.getType().equals(type)) continue;
            res.add(ann);
        }
        return res;
    }

    public boolean hasAnnotation(String type) {
        if (Util.isEmpty(this.list)) {
            return false;
        }
        for (GenericAnnotation ann : this.list) {
            if (!ann.getType().equals(type)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        if (this.list != null) {
            this.list.clear();
        }
    }

    public void remove(GenericAnnotation annotation) {
        this.list.remove(annotation);
    }

    public GenericAnnotation add(String type) {
        GenericAnnotation ann = new GenericAnnotation(type);
        if (this.list == null) {
            this.list = new ArrayList<GenericAnnotation>();
        }
        this.list.add(ann);
        return ann;
    }

    @Override
    public String toString() {
        if (Util.isEmpty(this.list)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (GenericAnnotation ann : this.list) {
            if (sb.length() > 0) {
                sb.append(ANNOTATION_SEPARATOR);
            }
            sb.append(ann.toString());
        }
        return sb.toString();
    }

    @Override
    public void fromString(String storage) {
        String[] parts;
        for (String data : parts = storage.split(ANNOTATION_SEPARATOR, 0)) {
            GenericAnnotation ann = this.add("z");
            ann.fromString(data);
        }
    }
}

