/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.encoder;

import net.sf.okapi.common.encoder.DTDEncoder;
import net.sf.okapi.common.encoder.DefaultEncoder;
import net.sf.okapi.common.encoder.DummyParameters;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.encoder.HtmlEncoder;
import net.sf.okapi.common.encoder.PropertiesEncoder;
import net.sf.okapi.common.encoder.XMLEncoder;
import net.sf.okapi.common.filters.DummyFilter;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import org.junit.Assert;
import org.junit.Test;

public class EncodersTest {
    @Test
    public void testXMLEncoder() {
        XMLEncoder enc = new XMLEncoder();
        Assert.assertEquals((Object)"en", (Object)enc.toNative("language", "en"));
        Assert.assertEquals((Object)"windows-1252", (Object)enc.toNative("encoding", "windows-1252"));
        enc.setOptions(null, "us-ascii", "\n");
        Assert.assertEquals((Object)"&#x20000;", (Object)enc.encode("\ud840\udc00", EncoderContext.TEXT));
        Assert.assertEquals((Object)"&#x20000;", (Object)enc.encode(131072, EncoderContext.TEXT));
        Assert.assertEquals((Object)"abc", (Object)enc.encode("abc", EncoderContext.TEXT));
        Assert.assertEquals((Object)"a", (Object)enc.encode('a', EncoderContext.TEXT));
        Assert.assertEquals((Object)"a", (Object)enc.encode(97, EncoderContext.TEXT));
        enc.setOptions(null, "UTF-8", "\n");
        Assert.assertEquals((long)131072L, (long)enc.encode("\ud840\udc00", EncoderContext.TEXT).codePointAt(0));
        Assert.assertEquals((long)131072L, (long)enc.encode(131072, EncoderContext.TEXT).codePointAt(0));
        Assert.assertEquals((Object)"abc", (Object)enc.encode("abc", EncoderContext.TEXT));
        Assert.assertEquals((Object)"a", (Object)enc.encode(97, EncoderContext.TEXT));
        Assert.assertEquals((Object)"\u00a0", (Object)enc.encode("\u00a0", EncoderContext.TEXT));
        Assert.assertEquals((Object)"\u00a0", (Object)enc.encode('\u00a0', EncoderContext.TEXT));
        Assert.assertEquals((Object)"\u00a0", (Object)enc.encode(160, EncoderContext.TEXT));
        Assert.assertEquals((Object)">", (Object)enc.encode(">", EncoderContext.TEXT));
        Assert.assertEquals((Object)">", (Object)enc.encode(62, EncoderContext.TEXT));
        Assert.assertEquals((Object)">", (Object)enc.encode('>', EncoderContext.TEXT));
        DummyParameters params = new DummyParameters();
        params.setBoolean("escapeGT", true);
        params.setBoolean("escapeNbsp", true);
        enc.setOptions(params, "UTF-8", "\n");
        Assert.assertEquals((Object)"&#x00a0;", (Object)enc.encode("\u00a0", EncoderContext.TEXT));
        Assert.assertEquals((Object)"&#x00a0;", (Object)enc.encode('\u00a0', EncoderContext.TEXT));
        Assert.assertEquals((Object)"&#x00a0;", (Object)enc.encode(160, EncoderContext.TEXT));
        Assert.assertEquals((Object)"&gt;", (Object)enc.encode(">", EncoderContext.TEXT));
        Assert.assertEquals((Object)"&gt;", (Object)enc.encode(62, EncoderContext.TEXT));
        Assert.assertEquals((Object)"&gt;", (Object)enc.encode('>', EncoderContext.TEXT));
    }

    @Test
    public void testHTMLEncoder() {
        HtmlEncoder enc = new HtmlEncoder();
        Assert.assertEquals((Object)"en", (Object)enc.toNative("language", "en"));
        Assert.assertEquals((Object)"windows-1252", (Object)enc.toNative("encoding", "windows-1252"));
        enc.setOptions(null, "us-ascii", "\n");
        Assert.assertEquals((Object)"&#x20000;", (Object)enc.encode("\ud840\udc00", EncoderContext.TEXT));
        Assert.assertEquals((Object)"&#x20000;", (Object)enc.encode(131072, EncoderContext.TEXT));
        Assert.assertEquals((Object)"abc", (Object)enc.encode("abc", EncoderContext.TEXT));
        Assert.assertEquals((Object)"a", (Object)enc.encode('a', EncoderContext.TEXT));
        Assert.assertEquals((Object)"a", (Object)enc.encode(97, EncoderContext.TEXT));
        enc.setOptions(null, "UTF-8", "\r");
        Assert.assertEquals((long)131072L, (long)enc.encode("\ud840\udc00", EncoderContext.TEXT).codePointAt(0));
        Assert.assertEquals((long)131072L, (long)enc.encode(131072, EncoderContext.TEXT).codePointAt(0));
        Assert.assertEquals((Object)"abc\r", (Object)enc.encode("abc\n", EncoderContext.TEXT));
        Assert.assertEquals((Object)"a", (Object)enc.encode('a', EncoderContext.TEXT));
        Assert.assertEquals((Object)"a", (Object)enc.encode(97, EncoderContext.TEXT));
    }

    @Test
    public void testPropertiesEncoder() {
        PropertiesEncoder enc = new PropertiesEncoder();
        Assert.assertEquals((Object)"en", (Object)enc.toNative("language", "en"));
        Assert.assertEquals((Object)"windows-1252", (Object)enc.toNative("encoding", "windows-1252"));
        enc.setOptions(null, "us-ascii", "\n");
        Assert.assertEquals((Object)"\\ud840\\udc00", (Object)enc.encode("\ud840\udc00", EncoderContext.TEXT));
        Assert.assertEquals((Object)"\\ud840\\udc00", (Object)enc.encode(131072, EncoderContext.TEXT));
        Assert.assertEquals((Object)"abc", (Object)enc.encode("abc", EncoderContext.TEXT));
        Assert.assertEquals((Object)"a", (Object)enc.encode('a', EncoderContext.TEXT));
        Assert.assertEquals((Object)"a", (Object)enc.encode(97, EncoderContext.TEXT));
        enc.setOptions(null, "UTF-8", "\n");
        Assert.assertEquals((long)131072L, (long)enc.encode("\ud840\udc00", EncoderContext.TEXT).codePointAt(0));
        Assert.assertEquals((long)131072L, (long)enc.encode(131072, EncoderContext.TEXT).codePointAt(0));
        Assert.assertEquals((Object)"abc\\n", (Object)enc.encode("abc\n", EncoderContext.TEXT));
        Assert.assertEquals((Object)"a", (Object)enc.encode('a', EncoderContext.TEXT));
        Assert.assertEquals((Object)"a", (Object)enc.encode(97, EncoderContext.TEXT));
    }

    @Test
    public void testDefaultEncoder() {
        DefaultEncoder enc = new DefaultEncoder();
        Assert.assertEquals((Object)"en", (Object)enc.toNative("language", "en"));
        Assert.assertEquals((Object)"windows-1252", (Object)enc.toNative("encoding", "windows-1252"));
        enc.setOptions(null, "us-ascii", "\r\n");
        Assert.assertEquals((Object)"\ud840\udc00", (Object)enc.encode("\ud840\udc00", EncoderContext.TEXT));
        Assert.assertEquals((Object)"\ud840\udc00", (Object)enc.encode(131072, EncoderContext.TEXT));
        Assert.assertEquals((Object)"abc\r\n", (Object)enc.encode("abc\n", EncoderContext.TEXT));
        Assert.assertEquals((Object)"a", (Object)enc.encode('a', EncoderContext.TEXT));
        Assert.assertEquals((Object)"a", (Object)enc.encode(97, EncoderContext.TEXT));
        enc.setOptions(null, "UTF-8", "\r");
        Assert.assertEquals((long)131072L, (long)enc.encode("\ud840\udc00", EncoderContext.TEXT).codePointAt(0));
        Assert.assertEquals((long)131072L, (long)enc.encode(131072, EncoderContext.TEXT).codePointAt(0));
        Assert.assertEquals((Object)"abc\r", (Object)enc.encode("abc\n", EncoderContext.TEXT));
        Assert.assertEquals((Object)"a", (Object)enc.encode('a', EncoderContext.TEXT));
        Assert.assertEquals((Object)"a", (Object)enc.encode(97, EncoderContext.TEXT));
    }

    @Test
    public void testDTDEncoder() {
        DTDEncoder enc = new DTDEncoder();
        enc.setOptions(null, "us-ascii", "\n");
        Assert.assertEquals((Object)"&lt;&amp;&#37;", (Object)enc.encode("<&%", EncoderContext.TEXT));
        Assert.assertEquals((Object)"&#x20000;", (Object)enc.encode("\ud840\udc00", EncoderContext.TEXT));
        Assert.assertEquals((Object)"&#x20000;", (Object)enc.encode(131072, EncoderContext.TEXT));
        Assert.assertEquals((Object)"&#37;", (Object)enc.encode('%', EncoderContext.TEXT));
        Assert.assertEquals((Object)"&#37;", (Object)enc.encode(37, EncoderContext.TEXT));
    }

    @Test
    public void changeEncoderTest() {
        DummyFilter filter = new DummyFilter();
        EncoderManager em1 = filter.getEncoderManager();
        Assert.assertNotNull((Object)em1);
        em1.setDefaultOptions(null, "UTF-8", "\n");
        em1.updateEncoder("text/xml");
        Assert.assertEquals((Object)"net.sf.okapi.common.encoder.XMLEncoder", (Object)em1.getEncoder().getClass().getName());
        GenericFilterWriter gfw = new GenericFilterWriter(filter.createSkeletonWriter(), filter.getEncoderManager());
        EncoderManager em2 = gfw.getEncoderManager();
        Assert.assertSame((Object)em1, (Object)em2);
        em2.updateEncoder("bogus");
        Assert.assertEquals((Object)"net.sf.okapi.common.encoder.DefaultEncoder", (Object)em2.getEncoder().getClass().getName());
        em2.setMapping("text/xml", "net.sf.okapi.common.encoder.PropertiesEncoder");
        em2.updateEncoder("text/xml");
        Assert.assertEquals((Object)"net.sf.okapi.common.encoder.PropertiesEncoder", (Object)em2.getEncoder().getClass().getName());
        Assert.assertEquals((Object)"net.sf.okapi.common.encoder.PropertiesEncoder", (Object)em1.getEncoder().getClass().getName());
    }
}

