/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filterwriter;

import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.resource.TextFragment;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GenericContentTest {
    private GenericContent fmt;

    @Before
    public void setUp() throws Exception {
        this.fmt = new GenericContent();
    }

    @Test
    public void testSimple_Default() {
        TextFragment tf = this.createTextFragment();
        Assert.assertEquals((long)tf.getCodes().size(), (long)5L);
        String gtext = this.fmt.setContent(tf).toString();
        Assert.assertEquals((Object)"t1<1><2><3/>t2</2></1>t3", (Object)gtext);
        TextFragment tf2 = tf.clone();
        GenericContent.updateFragment(gtext, tf2, false);
        Assert.assertEquals((Object)"t1<1><2><3/>t2</2></1>t3", (Object)this.fmt.setContent(tf2).toString());
    }

    @Test
    public void testSimple_WithOption() {
        TextFragment tf = this.createTextFragment();
        Assert.assertEquals((long)tf.getCodes().size(), (long)5L);
        this.fmt.setContent(tf);
        Assert.assertEquals((Object)"t1<b1><b2><x1/>t2</b2></b1>t3", (Object)this.fmt.toString(true));
        Assert.assertEquals((Object)"t1<1><2><3/>t2</2></1>t3", (Object)this.fmt.toString(false));
    }

    @Test
    public void testMisOrderedCodes() {
        TextFragment tf = new TextFragment();
        tf.append("t1");
        tf.append(TextFragment.TagType.OPENING, "b1", "<b1>");
        tf.append("t2");
        tf.append(TextFragment.TagType.OPENING, "b2", "<b2>");
        tf.append("t3");
        tf.append(TextFragment.TagType.CLOSING, "b1", "</b1>");
        tf.append("t4");
        tf.append(TextFragment.TagType.CLOSING, "b2", "</b2>");
        tf.append("t5");
        this.fmt.setContent(tf);
        Assert.assertEquals((Object)"t1<b1>t2<b2>t3</b1>t4</b2>t5", (Object)this.fmt.toString(true));
        String gtext = this.fmt.toString(false);
        Assert.assertEquals((Object)"t1<b1/>t2<b2/>t3<e1/>t4<e2/>t5", (Object)gtext);
        TextFragment tf2 = tf.clone();
        GenericContent.updateFragment(gtext, tf2, false);
        Assert.assertEquals((Object)"t1<b1>t2<b2>t3</b1>t4</b2>t5", (Object)this.fmt.setContent(tf2).toString(true));
        Assert.assertEquals((Object)"t1<b1/>t2<b2/>t3<e1/>t4<e2/>t5", (Object)this.fmt.setContent(tf2).toString());
    }

    @Test
    public void testReOrderingCodes() {
        TextFragment tf = new TextFragment();
        tf.append("t1");
        tf.append(TextFragment.TagType.OPENING, "b1", "<b1>");
        tf.append("t2");
        tf.append(TextFragment.TagType.OPENING, "b2", "<b2>");
        tf.append("t3");
        tf.append(TextFragment.TagType.CLOSING, "b1", "</b1>");
        tf.append("t4");
        tf.append(TextFragment.TagType.CLOSING, "b2", "</b2>");
        tf.append("t5");
        this.fmt.setContent(tf);
        Assert.assertEquals((Object)"t1<b1>t2<b2>t3</b1>t4</b2>t5", (Object)this.fmt.toString(true));
        Assert.assertEquals((Object)"t1<b1/>t2<b2/>t3<e1/>t4<e2/>t5", (Object)this.fmt.toString(false));
    }

    @Test
    public void testLetterCodedToFragment() {
        String ori = "t1<g1>t2</g1><g2><x3/>t3<g4>t4</g4>t5</g2>t6<x5/>t<b6/>t<g7>t</g7>t<e6/><x8/><x9/><x10/>";
        TextFragment tf1 = GenericContent.fromLetterCodedToFragment(ori, null, false, true);
        Assert.assertNotNull((Object)tf1);
        Assert.assertEquals((long)15L, (long)tf1.getCodes().size());
        Assert.assertEquals((Object)"t1<1>t2</1><2><3/>t3<4>t4</4>t5</2>t6<5/>t<6>t<7>t</7>t</6><8/><9/><10/>", (Object)this.fmt.setContent(tf1).toString());
        TextFragment tf = this.createTextFragment();
        tf1 = GenericContent.fromLetterCodedToFragment(ori, tf, false, true);
        Assert.assertEquals((Object)tf, (Object)tf1);
        Assert.assertEquals((Object)"t1<1>t2</1><2><3/>t3<4>t4</4>t5</2>t6<5/>t<6>t<7>t</7>t</6><8/><9/><10/>", (Object)this.fmt.setContent(tf1).toString());
    }

    @Test
    public void testFragmentToLetterCoded() {
        TextFragment tf1 = this.createTextFragment();
        String res = GenericContent.fromFragmentToLetterCoded(tf1, true);
        Assert.assertEquals((Object)"t1<g1><g2><x3/>t2</g2></g1>t3", (Object)res);
        TextFragment tf2 = GenericContent.fromLetterCodedToFragment(res, null, false, true);
        Assert.assertEquals((Object)this.fmt.setContent(tf1).toString(), (Object)this.fmt.setContent(tf2).toString());
    }

    @Test
    public void testDataTransfer() {
        TextFragment tf = new TextFragment();
        tf.append("t1");
        tf.append(TextFragment.TagType.OPENING, "b1", "[b1]");
        tf.append(TextFragment.TagType.OPENING, "b2", "[b2]");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "[x/]");
        tf.append("t2");
        tf.append(TextFragment.TagType.CLOSING, "b2", "[/b2]");
        tf.append(TextFragment.TagType.CLOSING, "b1", "[/b1]");
        tf.append("t3");
        Assert.assertEquals((Object)"t1[b1][b2][x/]t2[/b2][/b1]t3", (Object)tf.toText());
        String res = GenericContent.fromFragmentToLetterCoded(tf, true);
        TextFragment tf2 = GenericContent.fromLetterCodedToFragment(res, tf, true, true);
        Assert.assertEquals((Object)"t1[b1][b2][x/]t2[/b2][/b1]t3", (Object)tf2.toText());
        TextFragment tf3 = GenericContent.fromLetterCodedToFragment(res, tf, false, true);
        Assert.assertEquals((Object)"t1<g1><g2><x3/>t2</g2></g1>t3", (Object)tf3.toText());
    }

    @Test
    public void testUpdate() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "[x/]");
        tf.append("A");
        tf.append(TextFragment.TagType.OPENING, "b1", "[b1]");
        tf.append("B");
        tf.append(TextFragment.TagType.CLOSING, "b1", "[/b1]");
        TextFragment tf2 = new TextFragment("", tf.getClonedCodes());
        GenericContent.updateFragment("<1/>ZZ<2>QQ</2>", tf2, false);
        Assert.assertEquals((Object)"[x/]ZZ[b1]QQ[/b1]", (Object)tf2.toText());
    }

    private TextFragment createTextFragment() {
        TextFragment tf = new TextFragment();
        tf.append("t1");
        tf.append(TextFragment.TagType.OPENING, "b1", "<b1>");
        tf.append(TextFragment.TagType.OPENING, "b2", "<b2>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("t2");
        tf.append(TextFragment.TagType.CLOSING, "b2", "</b2>");
        tf.append(TextFragment.TagType.CLOSING, "b1", "</b1>");
        tf.append("t3");
        return tf;
    }

    @Test
    public void testEncodeLetterCodesPlainOpenCloseTags() {
        this.testEncodeLetterCodeTags("<g1><g458></g458></g1>", "<gg1><gg458></gg458></gg1>");
    }

    @Test
    public void testDecodeLetterCodesOpenCloseTags() {
        this.testDecodeLetterCodeTags("<gg1><gg458></gg458></gg1>", "<g1><g458></g458></g1>");
    }

    @Test
    public void testRoundTripLetterCodesOpenCloseTags() {
        this.testRoundTripWithInlineCodes("<g1><g458></g458>", "</g1>");
    }

    @Test
    public void testEncodeLetterCodesIsolatedTags() {
        this.testEncodeLetterCodeTags("<x2/><b34/><e65432/>", "<xx2/><bb34/><ee65432/>");
    }

    @Test
    public void testDecodeLetterCodesIsolatedTags() {
        this.testDecodeLetterCodeTags("<xx2/><bb34/><ee65432/>", "<x2/><b34/><e65432/>");
    }

    @Test
    public void testRoundTripLetterCodesIsolatedTags() {
        this.testRoundTripWithInlineCodes("<x2/><b34/><e65432/>", "<b3/><x1/>");
    }

    @Test
    public void testEncodeLetterCodesPreEscapedTags() {
        this.testEncodeLetterCodeTags("<gg1></gg2><gggg1><xx3/><bb4/><ee5/><xxxx3/><bbbb4/><eeee5/>", "<ggg1></ggg2><ggggg1><xxx3/><bbb4/><eee5/><xxxxx3/><bbbbb4/><eeeee5/>");
    }

    @Test
    public void testDecodeLetterCodesPreEscapedTags() {
        this.testDecodeLetterCodeTags("<ggg1></ggg2><ggggg1><xxx3/><bbb4/><eee5/><xxxxx3/><bbbbb4/><eeeee5/>", "<gg1></gg2><gggg1><xx3/><bb4/><ee5/><xxxx3/><bbbb4/><eeee5/>");
    }

    @Test
    public void testRoundTripLetterCodesPreEscapedTags() {
        this.testRoundTripWithInlineCodes("<gg1></gg2><gggg1><xx3/><bb4/><ee5/>", "<xxxx3/><bbbb4/><eeee5/>");
    }

    @Test
    public void testEncodeLetterCodesNonDigitTags() {
        String nonMatchingCodes = "<g></g><ggg></ggg><x/><xx/><b/><bbbb/><e/><ee/>";
        this.testEncodeLetterCodeTags(nonMatchingCodes, nonMatchingCodes);
    }

    @Test
    public void testDecodeLetterCodesNonDigitTags() {
        String nonMatchingCodes = "<g></g><ggg></ggg><x/><xx/><b/><bbbb/><e/><ee/>";
        this.testDecodeLetterCodeTags(nonMatchingCodes, nonMatchingCodes);
    }

    @Test
    public void testRoundTripLetterCodesNonDigitTags() {
        this.testRoundTripWithInlineCodes("<g></g><ggg></ggg><x/>", "<xx/><b/><bbbb/><e/><ee/>");
    }

    @Test
    public void testEncodeLetterCodesInappropriateClosing() {
        String nonMatchingClosingTags = "<x><xx><b><bb><e><ee><x2><b34><e65432> </x></b></e></x2></b34></e65432> <xx3><bb4><ee5> <g/><ggg/>";
        this.testEncodeLetterCodeTags(nonMatchingClosingTags, nonMatchingClosingTags);
    }

    @Test
    public void testDecodeLetterCodesInappropriateClosing() {
        String nonMatchingClosingTags = "<x><xx><b><bb><e><ee><x2><b34><e65432> </x></b></e></x2></b34></e65432> <xx3><bb4><ee5> <g/><ggg/>";
        this.testDecodeLetterCodeTags(nonMatchingClosingTags, nonMatchingClosingTags);
    }

    @Test
    public void testRoundTripLetterCodesInappropriateClosing() {
        this.testRoundTripWithInlineCodes("<x><xx><b><bb><e><ee><x2><b34><e65432>", " </x></b></e></x2></b34></e65432> <xx3><bb4><ee5> <g/><ggg/>");
    }

    @Test
    public void testEncodeLetterCodesInappropriateLetters() {
        String inappropriateLettersTags = "<a><a1><z23><y1/></y1> <ba1><ab1><bab1></ba1></ab1></bab1><ba1/><ab1/><bab1/> <ex1/><be3/><xb4/><bxb2> <ggagg2><gygg3/><xxxs7/><bubb43/><evee98/>";
        this.testEncodeLetterCodeTags(inappropriateLettersTags, inappropriateLettersTags);
    }

    @Test
    public void testDecodeLetterCodesInappropriateLetters() {
        String inappropriateLettersTags = "<a><a1><z23><y1/></y1> <ba1><ab1><bab1></ba1></ab1></bab1><ba1/><ab1/><bab1/> <ex1/><be3/><xb4/><bxb2> <ggagg2><gygg3/><xxxs7/><bubb43/><evee98/>";
        this.testDecodeLetterCodeTags(inappropriateLettersTags, inappropriateLettersTags);
    }

    @Test
    public void testRoundTripLetterCodesInappropriateLetters() {
        this.testRoundTripWithInlineCodes("<a><a1><z23><y1/></y1> <ba1><ab1><bab1></ba1></ab1></bab1><ba1/><ab1/><bab1/>", " <ex1/><be3/><xb4/><bxb2> <ggagg2><gygg3/><xxxs7/><bubb43/><evee98/>");
    }

    private void testEncodeLetterCodeTags(String originalText, String encodedText) {
        TextFragment tf = new TextFragment(originalText);
        String letterCoded = GenericContent.fromFragmentToLetterCoded(tf, true);
        Assert.assertEquals((String)"tags that would match letter code tags should have their first letter prepended", (Object)encodedText, (Object)letterCoded);
    }

    private void testDecodeLetterCodeTags(String codedText, String decodedText) {
        TextFragment tf = GenericContent.fromLetterCodedToFragment(codedText, null, false, true);
        Assert.assertEquals((String)"tags that have been encoded should be decoded to their original state", (Object)decodedText, (Object)tf.toText());
    }

    private void testRoundTripWithInlineCodes(String firstPart, String secondPart) {
        TextFragment tf = this.createTextFragmentWithCodes(firstPart, secondPart);
        String before = tf.toText();
        String letterCoded = GenericContent.fromFragmentToLetterCoded(tf, true);
        TextFragment decoded = GenericContent.fromLetterCodedToFragment(letterCoded, tf, true, true);
        String after = decoded.toText();
        Assert.assertEquals((String)"fragment to letter-coded round trip should not change text fragment", (Object)before, (Object)after);
    }

    private TextFragment createTextFragmentWithCodes(String firstPart, String secondPart) {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a-tag", "[a]");
        tf.append(TextFragment.TagType.OPENING, "c-tag", "[c]");
        tf.append(firstPart);
        tf.append(TextFragment.TagType.PLACEHOLDER, "d-tag", "[d/]");
        tf.append(secondPart);
        tf.append(TextFragment.TagType.CLOSING, "c-tag", "[/c]");
        tf.append(TextFragment.TagType.CLOSING, "a-tag", "[/a]");
        return tf;
    }
}

