/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filterwriter;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.TestUtil;
import net.sf.okapi.common.filterwriter.XLIFFWriter;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class XLIFFWriterTest {
    private XLIFFWriter writer;
    private String root;
    private LocaleId locEN = LocaleId.fromString("en");
    private LocaleId locFR = LocaleId.fromString("fr");

    @Before
    public void setUp() {
        this.writer = new XLIFFWriter();
        this.root = TestUtil.getParentDir(this.getClass(), "/");
    }

    @Test
    public void testMinimal() throws IOException {
        this.writer.create(this.root + "out.xlf", null, this.locEN, null, null, "original.ext", null);
        this.writer.writeStartFile(null, null, null);
        this.writer.writeEndFile();
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\">\n<file original=\"unknown\" source-language=\"en\" datatype=\"x-undefined\">\n<body>\n</body>\n</file>\n</xliff>\n", (Object)result);
    }

    @Test
    public void testVeryMinimal() throws IOException {
        this.writer.create(this.root + "out.xlf", null, this.locEN, null, null, "original.ext", null);
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\">\n<file original=\"original.ext\" source-language=\"en\" datatype=\"x-undefined\">\n<body>\n</body>\n</file>\n</xliff>\n", (Object)result);
    }

    @Test
    public void testWithExtra() throws IOException {
        this.writer.create(this.root + "out.xlf", null, this.locEN, null, null, "original.ext", null);
        this.writer.writeStartFile(null, null, null, "<phase-group phase-name=\"a\" process-name=\"b\"/>");
        this.writer.writeEndFile();
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\">\n<file original=\"unknown\" source-language=\"en\" datatype=\"x-undefined\">\n<header><phase-group phase-name=\"a\" process-name=\"b\"/></header>\n<body>\n</body>\n</file>\n</xliff>\n", (Object)result);
    }

    @Test
    public void testBasicSourceOnly() throws IOException {
        this.writer.create(this.root + "out.xlf", null, this.locEN, null, null, "original.ext", null);
        TextUnit tu = new TextUnit("tu1", "src1 with <>");
        this.writer.writeTextUnit(tu);
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\">\n<file original=\"original.ext\" source-language=\"en\" datatype=\"x-undefined\">\n<body>\n<trans-unit id=\"tu1\">\n<source xml:lang=\"en\">src1 with &lt;></source>\n</trans-unit>\n</body>\n</file>\n</xliff>\n", (Object)result);
    }

    @Test
    public void testTextWithDefaultCodes() throws IOException {
        this.writer.create(this.root + "out.xlf", null, this.locEN, null, null, "original.ext", null);
        TextUnit tu = new TextUnit("tu1");
        tu.getSource().getFirstSegment().getContent().append(TextFragment.TagType.OPENING, "z", "<z>");
        tu.getSource().getFirstSegment().getContent().append("s1");
        tu.getSource().getFirstSegment().getContent().append(TextFragment.TagType.CLOSING, "z", "</z>");
        tu.getSource().getFirstSegment().getContent().append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>");
        this.writer.writeTextUnit(tu);
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\">\n<file original=\"original.ext\" source-language=\"en\" datatype=\"x-undefined\">\n<body>\n<trans-unit id=\"tu1\">\n<source xml:lang=\"en\"><g id=\"1\">s1</g><x id=\"2\"/></source>\n</trans-unit>\n</body>\n</file>\n</xliff>\n", (Object)result);
    }

    @Test
    public void testTextWithEncapsulatedCodes() throws IOException {
        this.writer.setPlaceholderMode(false);
        this.writer.create(this.root + "out.xlf", null, this.locEN, null, null, "original.ext", null);
        TextUnit tu = new TextUnit("tu1");
        tu.getSource().getFirstSegment().getContent().append(TextFragment.TagType.OPENING, "z", "<z>");
        tu.getSource().getFirstSegment().getContent().append("s1");
        tu.getSource().getFirstSegment().getContent().append(TextFragment.TagType.CLOSING, "z", "</z>");
        tu.getSource().getFirstSegment().getContent().append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>");
        this.writer.writeTextUnit(tu);
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\">\n<file original=\"original.ext\" source-language=\"en\" datatype=\"x-undefined\">\n<body>\n<trans-unit id=\"tu1\">\n<source xml:lang=\"en\"><bpt id=\"1\">&lt;z></bpt>s1<ept id=\"1\">&lt;/z></ept><ph id=\"2\">&lt;br/></ph></source>\n</trans-unit>\n</body>\n</file>\n</xliff>\n", (Object)result);
    }

    @Test
    public void testBasicSourceOnlyGtEscaped() throws IOException {
        this.writer.create(this.root + "out.xlf", null, this.locEN, null, null, "original.ext", null);
        TextUnit tu = new TextUnit("tu1", "src1 with <>");
        this.writer.setEscapeGt(true);
        this.writer.writeTextUnit(tu);
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\">\n<file original=\"original.ext\" source-language=\"en\" datatype=\"x-undefined\">\n<body>\n<trans-unit id=\"tu1\">\n<source xml:lang=\"en\">src1 with &lt;&gt;</source>\n</trans-unit>\n</body>\n</file>\n</xliff>\n", (Object)result);
    }

    @Test
    public void testBasicSourceAndTarget() throws IOException {
        this.writer.create(this.root + "out.xlf", null, this.locEN, this.locFR, null, "original.ext", null);
        TextUnit tu = new TextUnit("tu1", "src1<&\"'>");
        tu.setTarget(this.locFR, new TextContainer("trg1"));
        this.writer.writeTextUnit(tu);
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\">\n<file original=\"original.ext\" source-language=\"en\" target-language=\"fr\" datatype=\"x-undefined\">\n<body>\n<trans-unit id=\"tu1\">\n<source xml:lang=\"en\">src1&lt;&amp;\"'></source>\n<target xml:lang=\"fr\">trg1</target>\n</trans-unit>\n</body>\n</file>\n</xliff>\n", (Object)result);
    }

    @Test
    public void testCompleteSourceAndTarget() throws IOException {
        this.writer.create(this.root + "out.xlf", "skel.skl", this.locEN, this.locFR, "dtValue", "original.ext", "messageValue");
        TextUnit tu = new TextUnit("tu1", "src1<&\"'>");
        tu.setTarget(this.locFR, new TextContainer("trg1"));
        this.writer.writeTextUnit(tu);
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\">\n<!--messageValue-->\n<file original=\"original.ext\" source-language=\"en\" target-language=\"fr\" datatype=\"x-dtValue\">\n<header><skl><external-file href=\"skel.skl\"></external-file></skl></header>\n<body>\n<trans-unit id=\"tu1\">\n<source xml:lang=\"en\">src1&lt;&amp;\"'></source>\n<target xml:lang=\"fr\">trg1</target>\n</trans-unit>\n</body>\n</file>\n</xliff>\n", (Object)result);
    }

    @Test
    public void testBasicWithITSProperties() throws IOException {
        this.writer.create(this.root + "out.xlf", null, this.locEN, null, null, "original.ext", null);
        TextUnit tu = new TextUnit("tu1", "text");
        tu.setProperty(new Property("its-domains", "dom1, dom2"));
        tu.setProperty(new Property("its-externalResourcesRef", "http://example.com/res"));
        this.writer.writeTextUnit(tu);
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\">\n<file original=\"original.ext\" source-language=\"en\" datatype=\"x-undefined\">\n<body>\n<trans-unit id=\"tu1\" xmlns:okp=\"okapi-framework:xliff-extensions\" okp:itsExternalResourceRef=\"http://example.com/res\" okp:itsDomain=\"dom1, dom2\">\n<source xml:lang=\"en\">text</source>\n</trans-unit>\n</body>\n</file>\n</xliff>\n", (Object)result);
    }

    private String readFile(String path) throws IOException {
        byte[] buffer = new byte[1024];
        int count = 0;
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(path));
        StringBuilder sb = new StringBuilder();
        while ((count = bis.read(buffer)) != -1) {
            sb.append(new String(buffer, 0, count));
        }
        String tmp = sb.toString().replace("\r\n", "\n");
        tmp = tmp.replace("\r", "\n");
        return tmp;
    }
}

