/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.resource.CodeSimplifier;
import net.sf.okapi.common.resource.TextFragment;
import org.junit.Assert;
import org.junit.Test;

public class CodeSimplifierTest {
    GenericContent fmt;
    CodeSimplifier simplifier = new CodeSimplifier();

    public CodeSimplifierTest() {
        this.fmt = new GenericContent();
    }

    @Test
    public void testCodeReduction01() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        Assert.assertEquals((Object)"<1><2>T1</2></1>", (Object)this.fmt.setContent(tf).toString());
        this.simplifier.simplifyAll(tf, false);
        Assert.assertEquals((Object)"<1>T1</1>", (Object)this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction02() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x", "<x/>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        Assert.assertEquals((Object)"<1><2/><3>T1</3></1>", (Object)this.fmt.setContent(tf).toString());
        this.simplifier.simplifyAll(tf, false);
        Assert.assertEquals((Object)"<1>T1</1>", (Object)this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction03() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        Assert.assertEquals((Object)"<1><2/><3>T1</3><4/></1>", (Object)this.fmt.setContent(tf).toString());
        this.simplifier.simplifyAll(tf, false);
        Assert.assertEquals((Object)"<1>T1</1>", (Object)this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction04() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        Assert.assertEquals((Object)"<1><2/><3>T1</3>T2</1>", (Object)this.fmt.setContent(tf).toString());
        this.simplifier.simplifyAll(tf, false);
        Assert.assertEquals((Object)"<1><2>T1</2>T2</1>", (Object)this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction05() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        Assert.assertEquals((Object)"<1><2><3>T1</3></2>T2</1>", (Object)this.fmt.setContent(tf).toString());
        this.simplifier.simplifyAll(tf, false);
        Assert.assertEquals((Object)"<1><2>T1</2>T2</1>", (Object)this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction06() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        Assert.assertEquals((Object)"<1><2><3><4/>T1</3></2>T2</1><5/>", (Object)this.fmt.setContent(tf).toString());
        this.simplifier.simplifyAll(tf, false);
        Assert.assertEquals((Object)"<1><2>T1</2>T2</1>", (Object)this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction07() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        Assert.assertEquals((Object)"<1><2/>T1<3><4><5/></4></3>T2</1><6/>", (Object)this.fmt.setContent(tf).toString());
        this.simplifier.simplifyAll(tf, false);
        this.simplifier.simplifyEmptyOpeningClosing(tf);
        Assert.assertEquals((Object)"<1>T1<2/>T2</1>", (Object)this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction08() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append("T3");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        Assert.assertEquals((Object)"<1><2/>T1<3><4><5/></4>T2</3>T3</1><6/>", (Object)this.fmt.setContent(tf).toString());
        this.simplifier.simplifyAll(tf, false);
        Assert.assertEquals((Object)"<1>T1<2>T2</2>T3</1>", (Object)this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction09() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append("T3");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        Assert.assertEquals((Object)"<1><2/>T1</1><3><4/>T2</3><5>T3</5><6/>", (Object)this.fmt.setContent(tf).toString());
        this.simplifier.simplifyAll(tf, false);
        Assert.assertEquals((Object)"<1>T1</1><3>T2</3><5>T3</5>", (Object)this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction10() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append("T3");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        Assert.assertEquals((Object)"<1><2/>T1</1><3><4><5/>T2</4>T3</3><6/>", (Object)this.fmt.setContent(tf).toString());
        this.simplifier.simplifyAll(tf, false);
        Assert.assertEquals((Object)"<1>T1</1><3><4>T2</4>T3</3>", (Object)this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction11() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.OPENING, "d", "<d>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "d", "</d>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append("T3");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        Assert.assertEquals((Object)"<1><2><3/>T1</2><4><5><6/></5>T2</4>T3</1><7/>", (Object)this.fmt.setContent(tf).toString());
        this.simplifier.simplifyAll(tf, false);
        Assert.assertEquals((Object)"<1><2>T1</2><4>T2</4>T3</1>", (Object)this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction12() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        Assert.assertEquals((Object)"<b1/>", (Object)this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction13() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.OPENING, "d", "<d>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append("T3");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        Assert.assertEquals((Object)"<b1/><b2/><3/>T1<4><5><6/></5>T2</4>T3<e1/><7/>", (Object)this.fmt.setContent(tf).toString());
        this.simplifier.simplifyAll(tf, false);
        Assert.assertEquals((Object)"<1><b2/>T1<3>T2</3>T3</1>", (Object)this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction14() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append("T3");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.CLOSING, "d", "<d>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        Assert.assertEquals((Object)"<1><2/>T1<3><4><5/></4>T2</3>T3</1><e7/><6/>", (Object)this.fmt.setContent(tf).toString());
        this.simplifier.simplifyAll(tf, false);
        Assert.assertEquals((Object)"<1>T1<2>T2</2>T3</1><e7/>", (Object)this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction15() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append("T3");
        tf.append(TextFragment.TagType.CLOSING, "d", "<d>");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        Assert.assertEquals((Object)"<b1/><2/>T1<3><4><5/></4>T2</3>T3<e7/><e1/><6/>", (Object)this.fmt.setContent(tf).toString());
        this.simplifier.simplifyAll(tf, false);
        Assert.assertEquals((Object)"<1>T1<2>T2</2>T3<e7/></1>", (Object)this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction16() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append(TextFragment.TagType.CLOSING, "d", "<d>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append("T3");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        Assert.assertEquals((Object)"<b1/><2/>T1<b3/><b4/><e7/><5/><e4/>T2<e3/>T3<e1/><6/>", (Object)this.fmt.setContent(tf).toString());
        this.simplifier.simplifyAll(tf, false);
        Assert.assertEquals((Object)"<1>T1<2><3><e7/></3>T2</2>T3</1>", (Object)this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction17() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        Assert.assertEquals((Object)"<1/>T1<2/>", (Object)this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals((Object)"T1", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals((Object)"<x1/>", (Object)res[0]);
        Assert.assertEquals((Object)"<x2/>", (Object)res[1]);
    }

    @Test
    public void testCodeReduction18() {
        TextFragment tf = new TextFragment("T1");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("T2");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        Assert.assertEquals((Object)"T1<1/>T2<2/>", (Object)this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals((Object)"T1<1/>T2", (Object)this.fmt.setContent(tf).toString());
        Assert.assertTrue((res[0] == null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"<x2/>", (Object)res[1]);
    }

    @Test
    public void testCodeReduction19() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append("T3");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        Assert.assertEquals((Object)"<1/>T1<2><3><4/></3>T2</2>T3<5/>", (Object)this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals((Object)"T1<2>T2</2>T3", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals((Object)"<x1/>", (Object)res[0]);
        Assert.assertEquals((Object)"<x3/>", (Object)res[1]);
    }

    @Test
    public void testCodeReduction20() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append("T1");
        Assert.assertEquals((Object)"<1/><2/>T1", (Object)this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals((Object)"T1", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals((Object)"<x1/><x2/>", (Object)res[0]);
        Assert.assertEquals(null, (Object)res[1]);
    }

    @Test
    public void testCodeReduction21() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("T1");
        Assert.assertEquals((Object)"<b1/><b2/>T1", (Object)this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals((Object)"T1", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals((Object)"<a><b>", (Object)res[0]);
        Assert.assertEquals(null, (Object)res[1]);
    }

    @Test
    public void testCodeReduction22() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append(" ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append(" ");
        tf.append("T1");
        Assert.assertEquals((Object)"<1/> <2/> T1", (Object)this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals((Object)"T1", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals((Object)"<x1/> <x2/> ", (Object)res[0]);
        Assert.assertEquals(null, (Object)res[1]);
    }

    @Test
    public void testCodeReduction23() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        Assert.assertEquals((Object)"<1><2>T1</2></1>", (Object)this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals((Object)"T1", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals((Object)"<a><b>", (Object)res[0]);
        Assert.assertEquals((Object)"</b></a>", (Object)res[1]);
    }

    @Test
    public void testCodeReduction24() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        Assert.assertEquals((Object)"<b1/><b2/>T1<e1/><e2/>", (Object)this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals((Object)"T1", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals((Object)"<a><b>", (Object)res[0]);
        Assert.assertEquals((Object)"</a></b>", (Object)res[1]);
    }

    @Test
    public void testCodeReduction25() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(" ");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(" ");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        Assert.assertEquals((Object)"<1> <2>T1</2> </1>", (Object)this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals((Object)"T1", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals((Object)"<a> <b>", (Object)res[0]);
        Assert.assertEquals((Object)"</b> </a>", (Object)res[1]);
    }

    @Test
    public void testCodeReduction26() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(" ");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(" ");
        tf.append("T1");
        tf.append(" ");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(" ");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        Assert.assertEquals((Object)"<b1/> <b2/> T1 <e1/> <e2/>", (Object)this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals((Object)"T1", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals((Object)"<a> <b> ", (Object)res[0]);
        Assert.assertEquals((Object)" </a> </b>", (Object)res[1]);
    }

    @Test
    public void testCodeReduction27() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append(" ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append(" ");
        tf.append("T1");
        Assert.assertEquals((Object)"<1/> <2/> T1", (Object)this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals((Object)"T1", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals((Object)"<x1/> <x2/> ", (Object)res[0]);
    }

    @Test
    public void testCodeReduction28() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(" ");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        Assert.assertEquals((Object)"<b1/> <2>T1</2>", (Object)this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals((Object)"T1", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals((Object)"<a> <b>", (Object)res[0]);
        Assert.assertEquals((Object)"</b>", (Object)res[1]);
    }

    @Test
    public void testCodeReduction29() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        Assert.assertEquals((Object)"<b1/><2>T1</2>", (Object)this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals((Object)"T1", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals((Object)"<a><b>", (Object)res[0]);
        Assert.assertEquals((Object)"</b>", (Object)res[1]);
    }

    @Test
    public void testCodeReduction30() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append("T1");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        Assert.assertEquals((Object)"<b1/>T1<2>T2</2>", (Object)this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals((Object)"T1<2>T2</2>", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals((Object)"<a>", (Object)res[0]);
        Assert.assertEquals(null, (Object)res[1]);
    }

    @Test
    public void testCodeReduction31() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        Assert.assertEquals((Object)"<1>T1</1>T2<e2/>", (Object)this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals((Object)"<1>T1</1>T2", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals(null, (Object)res[0]);
        Assert.assertEquals((Object)"</a>", (Object)res[1]);
    }

    @Test
    public void testCodeReduction32() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(" ");
        tf.append("T1");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        Assert.assertEquals((Object)"<b1/> T1<2>T2</2>", (Object)this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals((Object)"T1<2>T2</2>", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals((Object)"<a> ", (Object)res[0]);
        Assert.assertEquals(null, (Object)res[1]);
    }

    @Test
    public void testCodeReduction33() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append("T2");
        tf.append(" ");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        Assert.assertEquals((Object)"<1>T1</1>T2 <e2/>", (Object)this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals((Object)"<1>T1</1>T2", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals(null, (Object)res[0]);
        Assert.assertEquals((Object)" </a>", (Object)res[1]);
    }

    @Test
    public void testCodeReduction34() {
        TextFragment tf = new TextFragment();
        tf.append("T1");
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append("T3");
        Assert.assertEquals((Object)"T1<1>T2</1>T3", (Object)this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals((Object)"T1<1>T2</1>T3", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals(null, (Object)res[0]);
        Assert.assertEquals(null, (Object)res[1]);
    }

    @Test
    public void testCodeReduction35() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append("T1");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        Assert.assertEquals((Object)"<b1/>T1<2></2>", (Object)this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals((Object)"T1", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals((Object)"<a>", (Object)res[0]);
        Assert.assertEquals((Object)"<b></b>", (Object)res[1]);
    }

    @Test
    public void testCodeReduction36() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append("T1");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(" ");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        Assert.assertEquals((Object)"<b1/>T1<2> </2>", (Object)this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals((Object)"T1", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals((Object)"<a>", (Object)res[0]);
        Assert.assertEquals((Object)"<b> </b>", (Object)res[1]);
    }

    @Test
    public void testCodeReduction37() {
        TextFragment tf = new TextFragment();
        tf.append("   ");
        tf.append("T1");
        tf.append("   ");
        Assert.assertEquals((Object)"   T1   ", (Object)this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals((Object)"   T1   ", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals(null, (Object)res[0]);
        Assert.assertEquals(null, (Object)res[1]);
    }

    @Test
    public void testCodeReduction38() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x4", "<x4/>");
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        Assert.assertEquals((Object)"<1/><2/>T1<3/><4/><5>T2</5>", (Object)this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals((Object)"T1<2>T2</2>", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals((Object)"<x1/><x2/>", (Object)res[0]);
        Assert.assertEquals(null, (Object)res[1]);
    }

    @Test
    public void testCodeReduction39() {
        TextFragment tf = new TextFragment();
        tf.append("T1");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        Assert.assertEquals((Object)"T1<1/><2/><3>T2</3>", (Object)this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals((Object)"T1<1>T2</1>", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals(null, (Object)res[0]);
        Assert.assertEquals(null, (Object)res[1]);
    }

    @Test
    public void testCodeReduction40() {
        TextFragment tf = new TextFragment();
        tf.append("T1");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        Assert.assertEquals((Object)"T1<1>T2</1>", (Object)this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals((Object)"T1<1>T2</1>", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals(null, (Object)res[0]);
        Assert.assertEquals(null, (Object)res[1]);
    }

    @Test
    public void testCodeReduction41() {
        TextFragment tf = new TextFragment();
        tf.append("T1");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        Assert.assertEquals((Object)"T1<1/><2>T2</2>", (Object)this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals((Object)"T1<1>T2</1>", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals(null, (Object)res[0]);
        Assert.assertEquals(null, (Object)res[1]);
    }

    @Test
    public void testCodeReduction42() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append("T3");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        Assert.assertEquals((Object)"<1>T1</1><2>T2</2><3>T3</3>", (Object)this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals((Object)"<1>T1</1><3>T2</3><5>T3</5>", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals(null, (Object)res[0]);
        Assert.assertEquals(null, (Object)res[1]);
    }

    @Test
    public void testCodeReduction43() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x4", "<x4/>");
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x5", "<x5/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x6", "<x6/>");
        Assert.assertEquals((Object)"<1/><2/>T1<3/><4/><5>T2</5><e8/><6/><7/>", (Object)this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals((Object)"T1<2>T2</2>", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals((Object)"<x1/><x2/>", (Object)res[0]);
        Assert.assertEquals((Object)"</b><x5/><x6/>", (Object)res[1]);
    }

    @Test
    public void testCodeReduction44() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("   ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x4", "<x4/>");
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append("T2");
        tf.append("   ");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append("   ");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x5", "<x5/>");
        tf.append("   ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x6", "<x6/>");
        Assert.assertEquals((Object)"<1/>   <2/>T1<3/><4/><5>T2   </5>   <e8/><6/>   <7/>", (Object)this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals((Object)"T1<2>T2   </2>", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals((Object)"<x1/>   <x2/>", (Object)res[0]);
        Assert.assertEquals((Object)"   </b><x5/>   <x6/>", (Object)res[1]);
    }

    @Test
    public void testCodeReduction45() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(" ");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append("T1");
        tf.append("   ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append("   ");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        Assert.assertEquals((Object)"<1><2> <3>T1   <4/>T2</3>   </2></1>", (Object)this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals((Object)"T1   <2/>T2", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals((Object)"<a><b> <c>", (Object)res[0]);
        Assert.assertEquals((Object)"</c>   </b></a>", (Object)res[1]);
    }

    @Test
    public void testCodeReduction46() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        Assert.assertEquals((Object)"<1><2>T1</2>T2</1>", (Object)this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals((Object)"<2>T1</2>T2", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals((Object)"<a>", (Object)res[0]);
        Assert.assertEquals((Object)"</a>", (Object)res[1]);
    }

    @Test
    public void testCodeReduction47() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x4", "<x4/>");
        Assert.assertEquals((Object)"<1/><2/><3/><4/>", (Object)this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, false);
        Assert.assertEquals((Object)"<1/>", (Object)this.fmt.setContent(tf).toString());
        Assert.assertNull((Object)res);
        Assert.assertEquals((long)1L, (long)tf.getCodes().size());
        Assert.assertEquals((Object)"x1", (Object)tf.getCode(0).getType());
    }

    @Test
    public void testCodeReduction48() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append(" ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        Assert.assertEquals((Object)"<1/> <2/>", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals((Object)"<x1/> <x2/>", (Object)tf.toText());
        String[] res = this.simplifier.simplifyAll(tf, false);
        Assert.assertEquals((Object)"<1/>", (Object)this.fmt.setContent(tf).toString());
        Assert.assertNull((Object)res);
        Assert.assertEquals((long)1L, (long)tf.getCodes().size());
        Assert.assertEquals((Object)"x1", (Object)tf.getCode(0).getType());
    }

    @Test
    public void testCodeReduction49() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(" ");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append("   ");
        tf.append("T1");
        tf.append("   ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append("   ");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        Assert.assertEquals((Object)"<1><2> <3>   T1   <4/>T2</3>   </2></1>", (Object)this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals((Object)"T1   <2/>T2", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals((Object)"<a><b> <c>   ", (Object)res[0]);
        Assert.assertEquals((Object)"</c>   </b></a>", (Object)res[1]);
    }

    @Test
    public void testCodeReduction50() {
        TextFragment tf = new TextFragment(".");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x/>");
        Assert.assertEquals((Object)".<1/><2/>", (Object)this.fmt.setContent(tf).toString());
        this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals((Object)".", (Object)this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction51() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append("The plan of");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x/>");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append("happiness");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append(TextFragment.TagType.OPENING, "d", "<d>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x/>");
        tf.append(TextFragment.TagType.CLOSING, "d", "</d>");
        Assert.assertEquals((Object)"<1>The plan of</1><2><3/></2><4>happiness</4><5><6/></5>", (Object)this.fmt.setContent(tf).toString());
        this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals((Object)"<1>The plan of</1><3>happiness</3>", (Object)this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction52() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x/>");
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x/>");
        tf.append("The plan of");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x4", "<x/>");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append("happiness");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append(TextFragment.TagType.OPENING, "d", "<d>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x5", "<x/>");
        tf.append(TextFragment.TagType.CLOSING, "d", "</d>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x6", "<x/>");
        Assert.assertEquals((Object)"<1/><2/><3><4/>The plan of</3><5><6/></5><7>happiness</7><8><9/></8><10/>", (Object)this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals((Object)"<1>The plan of</1><3>happiness</3>", (Object)this.fmt.setContent(tf).toString());
        Assert.assertEquals((long)2L, (long)res.length);
        Assert.assertEquals(null, (Object)res[0]);
        Assert.assertEquals(null, (Object)res[1]);
    }
}

