/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.TestUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.resource.RawDocument;
import org.junit.Assert;
import org.junit.Test;

public class RawDocumentTest {
    LocaleId locEN = LocaleId.fromString("en");

    @Test
    public void getReaderWithURI() throws URISyntaxException, IOException {
        RawDocument ir = new RawDocument(RawDocumentTest.class.getResource("/test.html").toURI(), "UTF-8", this.locEN);
        Reader r = ir.getReader();
        Assert.assertTrue((boolean)r.ready());
    }

    @Test(expected=OkapiIOException.class)
    public void getReaderWithExceptionUriNotFound() throws URISyntaxException {
        RawDocument ir = new RawDocument(new URI("file:///home/username/bad.bad"), "UTF-8", this.locEN);
        ir.getReader();
    }

    @Test(expected=OkapiIOException.class)
    public void getReaderWithExceptionIllegalUri() throws URISyntaxException {
        RawDocument ir = new RawDocument(new URI("/bad/bad"), "UTF-8", this.locEN);
        ir.getReader();
    }

    @Test
    public void testOutputIsDifferentFromInput() throws URISyntaxException, FileNotFoundException {
        String root = TestUtil.getParentDir(this.getClass(), "/safeouttest1.txt");
        File expectedFile = new File(Util.toURI(root + "safeouttest1.out.txt"));
        expectedFile.delete();
        RawDocument rd = new RawDocument(Util.toURI(root + "safeouttest1.txt"), "UTF-8", LocaleId.ENGLISH);
        this.writeStringAndFinalize(expectedFile.toURI(), rd, "test1");
        Assert.assertTrue((boolean)expectedFile.exists());
        Assert.assertEquals((long)5L, (long)expectedFile.length());
    }

    @Test
    public void testOutputIsSameAsInput() throws URISyntaxException, FileNotFoundException {
        String root = TestUtil.getParentDir(this.getClass(), "/safeouttest1.out.txt");
        File expectedFile = new File(Util.toURI(root + "safeouttest1.out.txt"));
        expectedFile.delete();
        RawDocument rd = new RawDocument(Util.toURI(root + "safeouttest1.out.txt"), "UTF-8", LocaleId.ENGLISH);
        this.writeStringAndFinalize(expectedFile.toURI(), rd, "test1+");
        Assert.assertTrue((boolean)expectedFile.exists());
        Assert.assertEquals((long)6L, (long)expectedFile.length());
    }

    @Test
    public void testTargetLocaleWithConstructors() {
        RawDocument rd = new RawDocument("abc", LocaleId.ENGLISH, LocaleId.RUSSIAN);
        Assert.assertEquals((Object)LocaleId.RUSSIAN, (Object)rd.getTargetLocale());
        Assert.assertEquals((long)1L, (long)rd.getTargetLocales().size());
        Assert.assertEquals((Object)LocaleId.RUSSIAN, (Object)rd.getTargetLocales().get(0));
        rd = new RawDocument(new File("test").toURI(), "UTF-8", LocaleId.ENGLISH, LocaleId.FRENCH);
        Assert.assertEquals((Object)LocaleId.FRENCH, (Object)rd.getTargetLocale());
        Assert.assertEquals((long)1L, (long)rd.getTargetLocales().size());
        Assert.assertEquals((Object)LocaleId.FRENCH, (Object)rd.getTargetLocales().get(0));
        rd = new RawDocument(System.in, "UTF-8", LocaleId.ENGLISH, LocaleId.SPANISH);
        Assert.assertEquals((Object)LocaleId.SPANISH, (Object)rd.getTargetLocale());
        Assert.assertEquals((long)1L, (long)rd.getTargetLocales().size());
        Assert.assertEquals((Object)LocaleId.SPANISH, (Object)rd.getTargetLocales().get(0));
        rd = new RawDocument(new File("test").toURI(), "UTF-8", LocaleId.ENGLISH, LocaleId.ITALIAN, "okf_xml");
        Assert.assertEquals((Object)LocaleId.ITALIAN, (Object)rd.getTargetLocale());
        Assert.assertEquals((long)1L, (long)rd.getTargetLocales().size());
        Assert.assertEquals((Object)LocaleId.ITALIAN, (Object)rd.getTargetLocales().get(0));
    }

    @Test
    public void testTargetLocaleWithSetters() {
        RawDocument rd = new RawDocument("abc", LocaleId.ENGLISH);
        rd.setTargetLocale(LocaleId.RUSSIAN);
        Assert.assertEquals((Object)LocaleId.RUSSIAN, (Object)rd.getTargetLocale());
        Assert.assertEquals((long)1L, (long)rd.getTargetLocales().size());
        Assert.assertEquals((Object)LocaleId.RUSSIAN, (Object)rd.getTargetLocales().get(0));
        rd = new RawDocument("abc", LocaleId.ENGLISH);
        ArrayList<LocaleId> list = new ArrayList<LocaleId>();
        list.add(LocaleId.FRENCH);
        rd.setTargetLocales(list);
        Assert.assertEquals((Object)LocaleId.FRENCH, (Object)rd.getTargetLocale());
        Assert.assertEquals((long)1L, (long)rd.getTargetLocales().size());
        Assert.assertEquals((Object)LocaleId.FRENCH, (Object)rd.getTargetLocales().get(0));
    }

    @Test
    public void testTargetLocaleOverrides() {
        RawDocument rd = new RawDocument("abc", LocaleId.ENGLISH);
        rd.setTargetLocale(LocaleId.RUSSIAN);
        Assert.assertEquals((Object)LocaleId.RUSSIAN, (Object)rd.getTargetLocale());
        Assert.assertEquals((long)1L, (long)rd.getTargetLocales().size());
        Assert.assertEquals((Object)LocaleId.RUSSIAN, (Object)rd.getTargetLocales().get(0));
        ArrayList<LocaleId> list = new ArrayList<LocaleId>();
        list.add(LocaleId.FRENCH);
        list.add(LocaleId.JAPANESE);
        rd.setTargetLocales(list);
        Assert.assertEquals((Object)LocaleId.FRENCH, (Object)rd.getTargetLocale());
        Assert.assertEquals((long)2L, (long)rd.getTargetLocales().size());
        Assert.assertEquals((Object)LocaleId.FRENCH, (Object)rd.getTargetLocales().get(0));
        rd.setTargetLocale(LocaleId.ITALIAN);
        Assert.assertEquals((Object)LocaleId.ITALIAN, (Object)rd.getTargetLocale());
        Assert.assertEquals((long)1L, (long)rd.getTargetLocales().size());
        Assert.assertEquals((Object)LocaleId.ITALIAN, (Object)rd.getTargetLocales().get(0));
    }

    private void writeStringAndFinalize(URI outputURI, RawDocument rd, String text) throws FileNotFoundException {
        File file = rd.createOutputFile(outputURI);
        PrintWriter writer = new PrintWriter(file);
        writer.write(text);
        writer.close();
        rd.finalizeOutput();
    }
}

