/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.skeleton;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonPart;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.SkeletonUtil;
import org.junit.Assert;
import org.junit.Test;

public class SkeletonUtilTest {
    private static final LocaleId ENUS = new LocaleId("en", "us");
    private static final LocaleId ESES = new LocaleId("es", "es");
    private static final LocaleId FRFR = new LocaleId("fr", "fr");

    @Test
    public void testParts() {
        TextUnit tu1 = new TextUnit("tu1");
        TextUnit tu2 = new TextUnit("tu2");
        GenericSkeleton skel1 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        Assert.assertEquals((long)0L, (long)SkeletonUtil.getNumParts(skel1));
        skel1.add("text1");
        Assert.assertEquals((long)1L, (long)SkeletonUtil.getNumParts(skel1));
        skel1.addContentPlaceholder(tu1);
        Assert.assertEquals((long)2L, (long)SkeletonUtil.getNumParts(skel1));
        skel1.add("text2");
        Assert.assertEquals((long)3L, (long)SkeletonUtil.getNumParts(skel1));
        skel1.attachParent(tu1);
        Assert.assertEquals((long)3L, (long)SkeletonUtil.getNumParts(skel1));
        skel1.add("text3");
        Assert.assertEquals((long)4L, (long)SkeletonUtil.getNumParts(skel1));
        skel1.addContentPlaceholder(tu1, ESES);
        Assert.assertEquals((long)5L, (long)SkeletonUtil.getNumParts(skel1));
        skel1.add("text4");
        Assert.assertEquals((long)6L, (long)SkeletonUtil.getNumParts(skel1));
        skel1.addValuePlaceholder(tu1, "prop", ESES);
        Assert.assertEquals((long)7L, (long)SkeletonUtil.getNumParts(skel1));
        skel1.add("text5");
        Assert.assertEquals((long)8L, (long)SkeletonUtil.getNumParts(skel1));
        skel1.addValuePlaceholder(tu1, "prop", LocaleId.EMPTY);
        Assert.assertEquals((long)9L, (long)SkeletonUtil.getNumParts(skel1));
        skel1.add("text6");
        Assert.assertEquals((long)10L, (long)SkeletonUtil.getNumParts(skel1));
        skel1.addValuePlaceholder(tu1, "prop", null);
        Assert.assertEquals((long)11L, (long)SkeletonUtil.getNumParts(skel1));
        skel1.add("text7");
        Assert.assertEquals((long)12L, (long)SkeletonUtil.getNumParts(skel1));
        skel1.addReference(tu2);
        Assert.assertEquals((long)13L, (long)SkeletonUtil.getNumParts(skel1));
        skel1.add("text8");
        Assert.assertEquals((long)14L, (long)SkeletonUtil.getNumParts(skel1));
    }

    @Test
    public void testTypes() {
        TextUnit tu1 = new TextUnit("tu1");
        TextUnit tu2 = new TextUnit("tu2");
        GenericSkeleton skel1 = new GenericSkeleton();
        GenericSkeleton skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        tu2.setSourceContent(new TextFragment("source"));
        tu2.setTargetContent(ESES, new TextFragment("target"));
        tu2.setProperty(new Property("res_prop", "res_prop_value"));
        tu2.setSourceProperty(new Property("src_prop", "src_prop_value"));
        tu2.setTargetProperty(ESES, new Property("trg_prop", "trg_prop_value"));
        Assert.assertEquals((long)0L, (long)SkeletonUtil.getNumParts(skel1));
        skel1.addContentPlaceholder(tu1);
        Assert.assertEquals((long)1L, (long)SkeletonUtil.getNumParts(skel1));
        GenericSkeletonPart p1 = SkeletonUtil.getPart(skel1, 0);
        Assert.assertTrue((boolean)SkeletonUtil.isSourcePlaceholder(p1, tu1));
        Assert.assertFalse((boolean)SkeletonUtil.isTargetPlaceholder(p1, tu1));
        Assert.assertFalse((boolean)SkeletonUtil.isValuePlaceholder(p1, tu1));
        Assert.assertFalse((boolean)SkeletonUtil.isExtSourcePlaceholder(p1, tu1));
        Assert.assertFalse((boolean)SkeletonUtil.isExtTargetPlaceholder(p1, tu1));
        Assert.assertFalse((boolean)SkeletonUtil.isExtValuePlaceholder(p1, tu1));
        Assert.assertFalse((boolean)SkeletonUtil.isReference(p1));
        Assert.assertEquals((long)0L, (long)SkeletonUtil.getNumParts(skel2));
        skel2.addContentPlaceholder(tu2);
        Assert.assertEquals((long)1L, (long)SkeletonUtil.getNumParts(skel2));
        skel2.addContentPlaceholder(tu2, ESES);
        Assert.assertEquals((long)2L, (long)SkeletonUtil.getNumParts(skel2));
        skel2.addValuePlaceholder(tu2, "res_prop", null);
        Assert.assertEquals((long)3L, (long)SkeletonUtil.getNumParts(skel2));
        skel2.addValuePlaceholder(tu2, "src_prop", LocaleId.EMPTY);
        Assert.assertEquals((long)4L, (long)SkeletonUtil.getNumParts(skel2));
        skel2.addValuePlaceholder(tu2, "trg_prop", ESES);
        Assert.assertEquals((long)5L, (long)SkeletonUtil.getNumParts(skel2));
        skel2.addReference(tu1);
        Assert.assertEquals((long)6L, (long)SkeletonUtil.getNumParts(skel2));
        skel2.add("plain text");
        Assert.assertEquals((long)7L, (long)SkeletonUtil.getNumParts(skel2));
        p1 = SkeletonUtil.getPart(skel2, 0);
        Assert.assertTrue((boolean)SkeletonUtil.isSourcePlaceholder(p1, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isTargetPlaceholder(p1, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isValuePlaceholder(p1, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtSourcePlaceholder(p1, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtTargetPlaceholder(p1, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtValuePlaceholder(p1, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isReference(p1));
        Assert.assertFalse((boolean)SkeletonUtil.isText(p1));
        GenericSkeletonPart p2 = SkeletonUtil.getPart(skel2, 1);
        Assert.assertFalse((boolean)SkeletonUtil.isSourcePlaceholder(p2, tu2));
        Assert.assertTrue((boolean)SkeletonUtil.isTargetPlaceholder(p2, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isValuePlaceholder(p2, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtSourcePlaceholder(p2, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtTargetPlaceholder(p2, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtValuePlaceholder(p2, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isReference(p2));
        Assert.assertFalse((boolean)SkeletonUtil.isText(p2));
        GenericSkeletonPart p3 = SkeletonUtil.getPart(skel2, 2);
        Assert.assertFalse((boolean)SkeletonUtil.isSourcePlaceholder(p3, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isTargetPlaceholder(p3, tu2));
        Assert.assertTrue((boolean)SkeletonUtil.isValuePlaceholder(p3, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtSourcePlaceholder(p3, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtTargetPlaceholder(p3, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtValuePlaceholder(p3, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isReference(p3));
        Assert.assertFalse((boolean)SkeletonUtil.isText(p3));
        GenericSkeletonPart p4 = SkeletonUtil.getPart(skel2, 3);
        Assert.assertFalse((boolean)SkeletonUtil.isSourcePlaceholder(p4, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isTargetPlaceholder(p4, tu2));
        Assert.assertTrue((boolean)SkeletonUtil.isValuePlaceholder(p4, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtSourcePlaceholder(p4, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtTargetPlaceholder(p4, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtValuePlaceholder(p4, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isReference(p4));
        Assert.assertFalse((boolean)SkeletonUtil.isText(p4));
        GenericSkeletonPart p5 = SkeletonUtil.getPart(skel2, 4);
        Assert.assertFalse((boolean)SkeletonUtil.isSourcePlaceholder(p5, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isTargetPlaceholder(p5, tu2));
        Assert.assertTrue((boolean)SkeletonUtil.isValuePlaceholder(p5, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtSourcePlaceholder(p5, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtTargetPlaceholder(p5, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtValuePlaceholder(p5, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isReference(p5));
        Assert.assertFalse((boolean)SkeletonUtil.isText(p5));
        GenericSkeletonPart p6 = SkeletonUtil.getPart(skel2, 5);
        Assert.assertFalse((boolean)SkeletonUtil.isSourcePlaceholder(p6, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isTargetPlaceholder(p6, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isValuePlaceholder(p6, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtSourcePlaceholder(p6, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtTargetPlaceholder(p6, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtValuePlaceholder(p6, tu2));
        Assert.assertTrue((boolean)SkeletonUtil.isReference(p6));
        Assert.assertFalse((boolean)SkeletonUtil.isText(p6));
        GenericSkeletonPart p7 = SkeletonUtil.getPart(skel2, 6);
        Assert.assertFalse((boolean)SkeletonUtil.isSourcePlaceholder(p7, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isTargetPlaceholder(p7, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isValuePlaceholder(p7, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtSourcePlaceholder(p7, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtTargetPlaceholder(p7, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtValuePlaceholder(p7, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isReference(p7));
        Assert.assertTrue((boolean)SkeletonUtil.isText(p7));
        skel2.changeSelfReferents(tu1);
        p1 = SkeletonUtil.getPart(skel2, 0);
        Assert.assertFalse((boolean)SkeletonUtil.isSourcePlaceholder(p1, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isTargetPlaceholder(p1, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isValuePlaceholder(p1, tu2));
        Assert.assertTrue((boolean)SkeletonUtil.isExtSourcePlaceholder(p1, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtTargetPlaceholder(p1, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtValuePlaceholder(p1, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isReference(p1));
        Assert.assertFalse((boolean)SkeletonUtil.isText(p1));
        p2 = SkeletonUtil.getPart(skel2, 1);
        Assert.assertFalse((boolean)SkeletonUtil.isSourcePlaceholder(p2, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isTargetPlaceholder(p2, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isValuePlaceholder(p2, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtSourcePlaceholder(p2, tu2));
        Assert.assertTrue((boolean)SkeletonUtil.isExtTargetPlaceholder(p2, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtValuePlaceholder(p2, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isReference(p2));
        Assert.assertFalse((boolean)SkeletonUtil.isText(p2));
        p3 = SkeletonUtil.getPart(skel2, 2);
        Assert.assertFalse((boolean)SkeletonUtil.isSourcePlaceholder(p3, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isTargetPlaceholder(p3, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isValuePlaceholder(p3, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtSourcePlaceholder(p3, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtTargetPlaceholder(p3, tu2));
        Assert.assertTrue((boolean)SkeletonUtil.isExtValuePlaceholder(p3, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isReference(p3));
        Assert.assertFalse((boolean)SkeletonUtil.isText(p3));
        p4 = SkeletonUtil.getPart(skel2, 3);
        Assert.assertFalse((boolean)SkeletonUtil.isSourcePlaceholder(p4, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isTargetPlaceholder(p4, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isValuePlaceholder(p4, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtSourcePlaceholder(p4, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtTargetPlaceholder(p4, tu2));
        Assert.assertTrue((boolean)SkeletonUtil.isExtValuePlaceholder(p4, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isReference(p4));
        Assert.assertFalse((boolean)SkeletonUtil.isText(p4));
        p5 = SkeletonUtil.getPart(skel2, 4);
        Assert.assertFalse((boolean)SkeletonUtil.isSourcePlaceholder(p5, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isTargetPlaceholder(p5, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isValuePlaceholder(p5, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtSourcePlaceholder(p5, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtTargetPlaceholder(p5, tu2));
        Assert.assertTrue((boolean)SkeletonUtil.isExtValuePlaceholder(p5, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isReference(p5));
        Assert.assertFalse((boolean)SkeletonUtil.isText(p5));
        p6 = SkeletonUtil.getPart(skel2, 5);
        Assert.assertFalse((boolean)SkeletonUtil.isSourcePlaceholder(p6, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isTargetPlaceholder(p6, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isValuePlaceholder(p6, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtSourcePlaceholder(p6, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtTargetPlaceholder(p6, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtValuePlaceholder(p6, tu2));
        Assert.assertTrue((boolean)SkeletonUtil.isReference(p6));
        Assert.assertFalse((boolean)SkeletonUtil.isText(p6));
        p7 = SkeletonUtil.getPart(skel2, 6);
        Assert.assertFalse((boolean)SkeletonUtil.isSourcePlaceholder(p7, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isTargetPlaceholder(p7, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isValuePlaceholder(p7, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtSourcePlaceholder(p7, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtTargetPlaceholder(p7, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isExtValuePlaceholder(p7, tu2));
        Assert.assertFalse((boolean)SkeletonUtil.isReference(p7));
        Assert.assertTrue((boolean)SkeletonUtil.isText(p7));
    }

    @Test
    public void testGenericSkeletonWriter() {
        GenericSkeletonWriter writer = new GenericSkeletonWriter();
        TextUnit tu1 = new TextUnit("tu1");
        TextUnit tu2 = new TextUnit("tu2");
        tu1.setSourceContent(new TextFragment("source"));
        tu1.setTargetContent(ESES, new TextFragment("target"));
        tu2.setSourceContent(new TextFragment("source2"));
        tu2.setTargetContent(ESES, new TextFragment("target2"));
        tu1.setProperty(new Property("res_prop", "res_prop_value"));
        tu1.setSourceProperty(new Property("src_prop", "src_prop_value"));
        tu1.setTargetProperty(ESES, new Property("trg_prop", "trg_prop_value"));
        tu2.setProperty(new Property("res_prop", "res_prop_value2"));
        tu2.setSourceProperty(new Property("src_prop", "src_prop_value2"));
        tu2.setTargetProperty(ESES, new Property("trg_prop", "trg_prop_value2"));
        StartDocument sd = new StartDocument("sd");
        sd.setMultilingual(false);
        sd.setLocale(ENUS);
        sd.setLineBreak("\n");
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"source", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"source", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"target", (Object)writer.processTextUnit(tu1));
        GenericSkeleton skel1 = new GenericSkeleton();
        GenericSkeleton skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.addContentPlaceholder(tu1);
        skel1.add("_text after");
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source_text after", (Object)writer.processTextUnit(tu1));
        tu1.setTargetContent(FRFR, new TextFragment("target_fr"));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_target_fr_text after", (Object)writer.processTextUnit(tu1));
        tu1.removeTarget(FRFR);
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_target_text after", (Object)writer.processTextUnit(tu1));
        skel1 = new GenericSkeleton();
        skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.addContentPlaceholder(tu1, ENUS);
        skel1.add("_text after");
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source_text after", (Object)writer.processTextUnit(tu1));
        skel1 = new GenericSkeleton();
        skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.addContentPlaceholder(tu1, FRFR);
        skel1.add("_text after");
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source_text after", (Object)writer.processTextUnit(tu1));
        skel1 = new GenericSkeleton();
        skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.addContentPlaceholder(tu1, ESES);
        skel1.add("_text after");
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_target_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_target_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_target_text after", (Object)writer.processTextUnit(tu1));
        skel1 = new GenericSkeleton();
        skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.addContentPlaceholder(tu1, FRFR);
        skel1.add("_text after");
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source_text after", (Object)writer.processTextUnit(tu1));
        skel1 = new GenericSkeleton();
        skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.addContentPlaceholder(tu1);
        skel1.changeSelfReferents(tu2);
        skel1.add("_text after");
        skel2.add("text before2_");
        skel2.addContentPlaceholder(tu2);
        skel2.add("_text after2");
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_target2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before2_source2_text after2", (Object)writer.processTextUnit(tu2));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before2_source2_text after2", (Object)writer.processTextUnit(tu2));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before2_target2_text after2", (Object)writer.processTextUnit(tu2));
        skel1 = new GenericSkeleton();
        skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.addContentPlaceholder(tu2);
        skel1.add("_text after");
        skel2.add("text before2_");
        skel2.addContentPlaceholder(tu2);
        skel2.add("_text after2");
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_target2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before2_source2_text after2", (Object)writer.processTextUnit(tu2));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before2_source2_text after2", (Object)writer.processTextUnit(tu2));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before2_target2_text after2", (Object)writer.processTextUnit(tu2));
        skel1 = new GenericSkeleton();
        skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.addContentPlaceholder(tu2, ENUS);
        skel1.add("_text after");
        skel2.add("text before2_");
        skel2.addContentPlaceholder(tu2);
        skel2.add("_text after2");
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source2_text after", (Object)writer.processTextUnit(tu1));
        skel1 = new GenericSkeleton();
        skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.addContentPlaceholder(tu2, FRFR);
        skel1.add("_text after");
        skel2.add("text before2_");
        skel2.addContentPlaceholder(tu2);
        skel2.add("_text after2");
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source2_text after", (Object)writer.processTextUnit(tu1));
        skel1 = new GenericSkeleton();
        skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.addContentPlaceholder(tu2, ESES);
        skel1.add("_text after");
        skel2.add("text before2_");
        skel2.addContentPlaceholder(tu2);
        skel2.add("_text after2");
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_target2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_target2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_target2_text after", (Object)writer.processTextUnit(tu1));
        skel1 = new GenericSkeleton();
        skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.addReference(tu2);
        skel1.add("_text after");
        skel2.add("text before2_");
        skel2.addContentPlaceholder(tu2);
        skel2.add("_text after2");
        tu2.setIsReferent(true);
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"", (Object)writer.processTextUnit(tu2));
        Assert.assertEquals((Object)"text before_[#$tu2]_text after", (Object)((Object)tu1.getSkeleton()).toString());
        Assert.assertEquals((Object)"text before_text before2_source2_text after2_text after", (Object)writer.processTextUnit(tu1));
        Assert.assertEquals((Object)"text before_[#$tu2]_text after", (Object)((Object)tu1.getSkeleton()).toString());
        tu2.setIsReferent(true);
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"", (Object)writer.processTextUnit(tu2));
        Assert.assertEquals((Object)"text before_text before2_target2_text after2_text after", (Object)writer.processTextUnit(tu1));
        skel1 = new GenericSkeleton();
        skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.addValuePlaceholder(tu1, "res_prop", LocaleId.EMPTY);
        skel1.add("_text after");
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_res_prop_value_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_res_prop_value_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_res_prop_value_text after", (Object)writer.processTextUnit(tu1));
        skel1 = new GenericSkeleton();
        skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.addValuePlaceholder(tu1, "src_prop", null);
        skel1.add("_text after");
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_src_prop_value_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_src_prop_value_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_src_prop_value_text after", (Object)writer.processTextUnit(tu1));
        skel1 = new GenericSkeleton();
        skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.addValuePlaceholder(tu1, "trg_prop", ESES);
        skel1.add("_text after");
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_trg_prop_value_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_trg_prop_value_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_trg_prop_value_text after", (Object)writer.processTextUnit(tu1));
        skel1 = new GenericSkeleton();
        skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.addValuePlaceholder(tu1, "res_prop", LocaleId.EMPTY);
        skel1.changeSelfReferents(tu2);
        skel1.add("_text after");
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_res_prop_value2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_res_prop_value2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_res_prop_value2_text after", (Object)writer.processTextUnit(tu1));
        skel1 = new GenericSkeleton();
        skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.addValuePlaceholder(tu1, "src_prop", null);
        skel1.changeSelfReferents(tu2);
        skel1.add("_text after");
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_src_prop_value2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_src_prop_value2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_src_prop_value2_text after", (Object)writer.processTextUnit(tu1));
        skel1 = new GenericSkeleton();
        skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.addValuePlaceholder(tu1, "trg_prop", ESES);
        skel1.add("_text after");
        skel1.changeSelfReferents(tu2);
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_trg_prop_value2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_trg_prop_value2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_trg_prop_value2_text after", (Object)writer.processTextUnit(tu1));
        skel1 = new GenericSkeleton();
        skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.add("text");
        skel1.add("_text after");
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_text_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_text_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_text_text after", (Object)writer.processTextUnit(tu1));
    }

    @Test
    public void testGenericSkeletonWriter_Multilingual() {
        GenericSkeletonWriter writer = new GenericSkeletonWriter();
        TextUnit tu1 = new TextUnit("tu1");
        TextUnit tu2 = new TextUnit("tu2");
        tu1.setSourceContent(new TextFragment("source"));
        tu1.setTargetContent(ESES, new TextFragment("target"));
        tu2.setSourceContent(new TextFragment("source2"));
        tu2.setTargetContent(ESES, new TextFragment("target2"));
        tu1.setProperty(new Property("res_prop", "res_prop_value"));
        tu1.setSourceProperty(new Property("src_prop", "src_prop_value"));
        tu1.setTargetProperty(ESES, new Property("trg_prop", "trg_prop_value"));
        tu2.setProperty(new Property("res_prop", "res_prop_value2"));
        tu2.setSourceProperty(new Property("src_prop", "src_prop_value2"));
        tu2.setTargetProperty(ESES, new Property("trg_prop", "trg_prop_value2"));
        StartDocument sd = new StartDocument("sd");
        sd.setMultilingual(true);
        sd.setLocale(ENUS);
        sd.setLineBreak("\n");
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"source", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"source", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"target", (Object)writer.processTextUnit(tu1));
        GenericSkeleton skel1 = new GenericSkeleton();
        GenericSkeleton skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.addContentPlaceholder(tu1);
        skel1.add("_text after");
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source_text after", (Object)writer.processTextUnit(tu1));
        tu1.setTargetContent(FRFR, new TextFragment("target_fr"));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source_text after", (Object)writer.processTextUnit(tu1));
        tu1.removeTarget(FRFR);
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source_text after", (Object)writer.processTextUnit(tu1));
        skel1 = new GenericSkeleton();
        skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.addContentPlaceholder(tu1, ENUS);
        skel1.add("_text after");
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source_text after", (Object)writer.processTextUnit(tu1));
        skel1 = new GenericSkeleton();
        skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.addContentPlaceholder(tu1, FRFR);
        skel1.add("_text after");
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source_text after", (Object)writer.processTextUnit(tu1));
        skel1 = new GenericSkeleton();
        skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.addContentPlaceholder(tu1, ESES);
        skel1.add("_text after");
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_target_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_target_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_target_text after", (Object)writer.processTextUnit(tu1));
        skel1 = new GenericSkeleton();
        skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.addContentPlaceholder(tu1, FRFR);
        skel1.add("_text after");
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source_text after", (Object)writer.processTextUnit(tu1));
        skel1 = new GenericSkeleton();
        skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.addContentPlaceholder(tu1);
        skel1.changeSelfReferents(tu2);
        skel1.add("_text after");
        skel2.add("text before2_");
        skel2.addContentPlaceholder(tu2);
        skel2.add("_text after2");
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before2_source2_text after2", (Object)writer.processTextUnit(tu2));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before2_source2_text after2", (Object)writer.processTextUnit(tu2));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before2_source2_text after2", (Object)writer.processTextUnit(tu2));
        skel1 = new GenericSkeleton();
        skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.addContentPlaceholder(tu2);
        skel1.add("_text after");
        skel2.add("text before2_");
        skel2.addContentPlaceholder(tu2);
        skel2.add("_text after2");
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before2_source2_text after2", (Object)writer.processTextUnit(tu2));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before2_source2_text after2", (Object)writer.processTextUnit(tu2));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before2_source2_text after2", (Object)writer.processTextUnit(tu2));
        skel1 = new GenericSkeleton();
        skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.addContentPlaceholder(tu2, ENUS);
        skel1.add("_text after");
        skel2.add("text before2_");
        skel2.addContentPlaceholder(tu2);
        skel2.add("_text after2");
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source2_text after", (Object)writer.processTextUnit(tu1));
        skel1 = new GenericSkeleton();
        skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.addContentPlaceholder(tu2, FRFR);
        skel1.add("_text after");
        skel2.add("text before2_");
        skel2.addContentPlaceholder(tu2);
        skel2.add("_text after2");
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_source2_text after", (Object)writer.processTextUnit(tu1));
        skel1 = new GenericSkeleton();
        skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.addContentPlaceholder(tu2, ESES);
        skel1.add("_text after");
        skel2.add("text before2_");
        skel2.addContentPlaceholder(tu2);
        skel2.add("_text after2");
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_target2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_target2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_target2_text after", (Object)writer.processTextUnit(tu1));
        skel1 = new GenericSkeleton();
        skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.addReference(tu2);
        skel1.add("_text after");
        skel2.add("text before2_");
        skel2.addContentPlaceholder(tu2);
        skel2.add("_text after2");
        tu2.setIsReferent(true);
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"", (Object)writer.processTextUnit(tu2));
        Assert.assertEquals((Object)"text before_text before2_source2_text after2_text after", (Object)writer.processTextUnit(tu1));
        tu2.setIsReferent(true);
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"", (Object)writer.processTextUnit(tu2));
        Assert.assertEquals((Object)"text before_text before2_source2_text after2_text after", (Object)writer.processTextUnit(tu1));
        skel1 = new GenericSkeleton();
        skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.addValuePlaceholder(tu1, "res_prop", LocaleId.EMPTY);
        skel1.add("_text after");
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_res_prop_value_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_res_prop_value_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_res_prop_value_text after", (Object)writer.processTextUnit(tu1));
        skel1 = new GenericSkeleton();
        skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.addValuePlaceholder(tu1, "src_prop", null);
        skel1.add("_text after");
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_src_prop_value_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_src_prop_value_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_src_prop_value_text after", (Object)writer.processTextUnit(tu1));
        skel1 = new GenericSkeleton();
        skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.addValuePlaceholder(tu1, "trg_prop", ESES);
        skel1.add("_text after");
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_trg_prop_value_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_trg_prop_value_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_trg_prop_value_text after", (Object)writer.processTextUnit(tu1));
        skel1 = new GenericSkeleton();
        skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.addValuePlaceholder(tu1, "res_prop", LocaleId.EMPTY);
        skel1.changeSelfReferents(tu2);
        skel1.add("_text after");
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_res_prop_value2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_res_prop_value2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_res_prop_value2_text after", (Object)writer.processTextUnit(tu1));
        skel1 = new GenericSkeleton();
        skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.addValuePlaceholder(tu1, "src_prop", null);
        skel1.changeSelfReferents(tu2);
        skel1.add("_text after");
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_src_prop_value2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_src_prop_value2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_src_prop_value2_text after", (Object)writer.processTextUnit(tu1));
        skel1 = new GenericSkeleton();
        skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.addValuePlaceholder(tu1, "trg_prop", ESES);
        skel1.add("_text after");
        skel1.changeSelfReferents(tu2);
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_trg_prop_value2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_trg_prop_value2_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_trg_prop_value2_text after", (Object)writer.processTextUnit(tu1));
        skel1 = new GenericSkeleton();
        skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        tu2.setSkeleton(skel2);
        skel1.add("text before_");
        skel1.add("text");
        skel1.add("_text after");
        writer.processStartDocument(ENUS, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_text_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(FRFR, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_text_text after", (Object)writer.processTextUnit(tu1));
        writer.processStartDocument(ESES, "UTF-8", null, new EncoderManager(), sd);
        Assert.assertEquals((Object)"text before_text_text after", (Object)writer.processTextUnit(tu1));
    }

    @Test
    public void testSplitSkeleton() {
        TextUnit tu = new TextUnit("tu1");
        GenericSkeleton skel = new GenericSkeleton();
        tu.setSkeleton(skel);
        skel.add("part 1");
        skel.add("part 2");
        skel.add("part 3");
        skel.addContentPlaceholder(tu);
        skel.add("part 4");
        skel.add("part 5");
        GenericSkeleton[] parts = SkeletonUtil.splitSkeleton(skel);
        Assert.assertEquals((long)2L, (long)parts.length);
        Assert.assertEquals((Object)"part 1part 2part 3", (Object)parts[0].toString());
        Assert.assertEquals((Object)"part 4part 5", (Object)parts[1].toString());
    }

    @Test
    public void testSplitSkeleton2() {
        TextUnit tu = new TextUnit("tu1");
        GenericSkeleton skel = new GenericSkeleton();
        tu.setSkeleton(skel);
        skel.add("part 1");
        skel.add("part 2");
        skel.add("part 3");
        skel.addContentPlaceholder(tu);
        GenericSkeleton[] parts = SkeletonUtil.splitSkeleton(skel);
        Assert.assertEquals((long)2L, (long)parts.length);
        Assert.assertEquals((Object)"part 1part 2part 3", (Object)parts[0].toString());
        Assert.assertEquals((Object)"", (Object)parts[1].toString());
    }

    @Test
    public void testSplitSkeleton3() {
        TextUnit tu = new TextUnit("tu1");
        GenericSkeleton skel = new GenericSkeleton();
        tu.setSkeleton(skel);
        skel.addContentPlaceholder(tu);
        skel.add("part 1");
        skel.add("part 2");
        skel.add("part 3");
        GenericSkeleton[] parts = SkeletonUtil.splitSkeleton(skel);
        Assert.assertEquals((long)2L, (long)parts.length);
        Assert.assertEquals((Object)"", (Object)parts[0].toString());
        Assert.assertEquals((Object)"part 1part 2part 3", (Object)parts[1].toString());
    }

    @Test
    public void testSplitSkeleton4() {
        TextUnit tu = new TextUnit("tu1");
        GenericSkeleton skel = new GenericSkeleton();
        tu.setSkeleton(skel);
        skel.add("part 1");
        skel.add("part 2");
        skel.add("part 3");
        GenericSkeleton[] parts = SkeletonUtil.splitSkeleton(skel);
        Assert.assertEquals((long)2L, (long)parts.length);
        Assert.assertEquals((Object)"part 1part 2part 3", (Object)parts[0].toString());
        Assert.assertEquals((Object)"", (Object)parts[1].toString());
    }
}

