/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.doxygen;

import java.util.IdentityHashMap;
import java.util.regex.Pattern;

public class DoxygenPatterns {
    public static final IdentityHashMap<Pattern, Pattern> tokenizerDelimiters;
    public static final IdentityHashMap<Pattern, Pattern> chunkDelimiters;
    public static final String BLANK_LINES = "(?:^|(?<=\\S))(?:\\s*(?:\\r?\\n)\\s*){2,}(?=\\S)";
    public static final Pattern BLANK_LINES_PATTERN;
    public static final String SINGLE_QUOTE_STRING = "(?<!\\\\)(?:\\\\{2})*(?<!')'(?!')";
    public static final Pattern SINGLE_QUOTE_STRING_PREFIX_PATTERN;
    public static final Pattern SINGLE_QUOTE_STRING_SUFFIX_PATTERN;
    public static final String DOUBLE_QUOTE_STRING = "(?<!\\\\)(?:\\\\{2})*(?<!\")\"(?!\")";
    public static final Pattern DOUBLE_QUOTE_STRING_PREFIX_PATTERN;
    public static final Pattern DOUBLE_QUOTE_STRING_SUFFIX_PATTERN;
    public static final String CPP_COMMENT_PREFIX = "(?<!\\/)\\/\\/[\\/!](?!\\/)";
    public static final Pattern CPP_COMMENT_PREFIX_PATTERN;
    public static final String CPP_COMMENT_SUFFIX = "\\r?\\n";
    public static final Pattern CPP_COMMENT_SUFFIX_PATTERN;
    public static final String CPP_EXCLUDE_COMMENT_PREFIX = "(?<!\\/)\\/\\/(?![\\/!])";
    public static final Pattern CPP_EXCLUDE_COMMENT_PREFIX_PATTERN;
    public static final Pattern CPP_EXCLUDE_COMMENT_SUFFIX_PATTERN;
    public static final String JAVADOC_COMMENT_PREFIX = "\\/\\*[\\*!](?![\\*/])[^\\S\\n]*\\n?";
    public static final Pattern JAVADOC_COMMENT_PREFIX_PATTERN;
    public static final String JAVADOC_COMMENT_SUFFIX = "[^\\S\\n\\r]*\\*\\/";
    public static final Pattern JAVADOC_COMMENT_SUFFIX_PATTERN;
    public static final String JAVADOC_EXCLUDE_COMMENT_PREFIX = "\\/\\*(?![\\*!])[^\\S\\n]*\\n?";
    public static final Pattern JAVADOC_EXCLUDE_COMMENT_PREFIX_PATTERN;
    public static final Pattern JAVADOC_EXCLUDE_COMMENT_SUFFIX_PATTERN;
    public static final String PYTHON_SINGLE_COMMENT_DELIMITER = "(?<!')'''(?!')";
    public static final Pattern PYTHON_SINGLE_COMMENT_PREFIX_PATTERN;
    public static final Pattern PYTHON_SINGLE_COMMENT_SUFFIX_PATTERN;
    public static final String PYTHON_DOUBLE_COMMENT_DELIMITER = "(?<!\")\"\"\"(?!\")";
    public static final Pattern PYTHON_DOUBLE_COMMENT_PREFIX_PATTERN;
    public static final Pattern PYTHON_DOUBLE_COMMENT_SUFFIX_PATTERN;
    public static final String MULTILINE_DECORATION = "^[^\\S\\r\\n]*\\*?[^\\S\\r\\n]*?(?=$|\\S)";
    public static final Pattern MULTILINE_DECORATION_PATTERN;
    public static final String DOXYGEN_COMMAND = "[\\\\@]\\w+(?:[\\[\\(\\{].*?[\\]\\)\\}])?|</?[a-z]+(?: [^>]*)?>|@[{}]";
    public static final Pattern DOXYGEN_COMMAND_PATTERN;
    public static final String MEMBER_COMMENT_PREFIX = "^<\\s+";
    public static final Pattern MEMBER_COMMENT_PREFIX_PATTERN;
    public static final Pattern MEMBER_COMMENT_SUFFIX_PATTERN;
    public static final String LIST_ITEM_PREFIX = "^(?:\\s*(?:[-+*]#?|\\d+\\.)\\s*|\\s*\\.\\s*$)";
    public static final Pattern LIST_ITEM_PREFIX_PATTERN;
    public static final String LIST_ITEM_SUFFIX = "^(?:\\s*(?:[-+*]#?|\\d+\\.)\\s*|\\s*\\.\\s*$)";
    public static final Pattern LIST_ITEM_SUFFIX_PATTERN;

    static {
        BLANK_LINES_PATTERN = Pattern.compile(BLANK_LINES);
        SINGLE_QUOTE_STRING_PREFIX_PATTERN = Pattern.compile(SINGLE_QUOTE_STRING);
        SINGLE_QUOTE_STRING_SUFFIX_PATTERN = Pattern.compile(SINGLE_QUOTE_STRING);
        DOUBLE_QUOTE_STRING_PREFIX_PATTERN = Pattern.compile(DOUBLE_QUOTE_STRING);
        DOUBLE_QUOTE_STRING_SUFFIX_PATTERN = Pattern.compile(DOUBLE_QUOTE_STRING);
        CPP_COMMENT_PREFIX_PATTERN = Pattern.compile(CPP_COMMENT_PREFIX);
        CPP_COMMENT_SUFFIX_PATTERN = Pattern.compile(CPP_COMMENT_SUFFIX);
        CPP_EXCLUDE_COMMENT_PREFIX_PATTERN = Pattern.compile(CPP_EXCLUDE_COMMENT_PREFIX);
        CPP_EXCLUDE_COMMENT_SUFFIX_PATTERN = Pattern.compile(CPP_COMMENT_SUFFIX);
        JAVADOC_COMMENT_PREFIX_PATTERN = Pattern.compile(JAVADOC_COMMENT_PREFIX);
        JAVADOC_COMMENT_SUFFIX_PATTERN = Pattern.compile(JAVADOC_COMMENT_SUFFIX);
        JAVADOC_EXCLUDE_COMMENT_PREFIX_PATTERN = Pattern.compile(JAVADOC_EXCLUDE_COMMENT_PREFIX);
        JAVADOC_EXCLUDE_COMMENT_SUFFIX_PATTERN = Pattern.compile(JAVADOC_COMMENT_SUFFIX);
        PYTHON_SINGLE_COMMENT_PREFIX_PATTERN = Pattern.compile(PYTHON_SINGLE_COMMENT_DELIMITER);
        PYTHON_SINGLE_COMMENT_SUFFIX_PATTERN = Pattern.compile(PYTHON_SINGLE_COMMENT_DELIMITER);
        PYTHON_DOUBLE_COMMENT_PREFIX_PATTERN = Pattern.compile(PYTHON_DOUBLE_COMMENT_DELIMITER);
        PYTHON_DOUBLE_COMMENT_SUFFIX_PATTERN = Pattern.compile(PYTHON_DOUBLE_COMMENT_DELIMITER);
        MULTILINE_DECORATION_PATTERN = Pattern.compile(MULTILINE_DECORATION, 8);
        DOXYGEN_COMMAND_PATTERN = Pattern.compile(DOXYGEN_COMMAND);
        MEMBER_COMMENT_PREFIX_PATTERN = Pattern.compile(MEMBER_COMMENT_PREFIX, 8);
        MEMBER_COMMENT_SUFFIX_PATTERN = Pattern.compile(CPP_COMMENT_SUFFIX);
        LIST_ITEM_PREFIX_PATTERN = Pattern.compile("^(?:\\s*(?:[-+*]#?|\\d+\\.)\\s*|\\s*\\.\\s*$)", 8);
        LIST_ITEM_SUFFIX_PATTERN = Pattern.compile("^(?:\\s*(?:[-+*]#?|\\d+\\.)\\s*|\\s*\\.\\s*$)", 8);
        tokenizerDelimiters = new IdentityHashMap();
        tokenizerDelimiters.put(JAVADOC_COMMENT_PREFIX_PATTERN, JAVADOC_COMMENT_SUFFIX_PATTERN);
        tokenizerDelimiters.put(CPP_COMMENT_PREFIX_PATTERN, CPP_COMMENT_SUFFIX_PATTERN);
        tokenizerDelimiters.put(PYTHON_SINGLE_COMMENT_PREFIX_PATTERN, PYTHON_SINGLE_COMMENT_SUFFIX_PATTERN);
        tokenizerDelimiters.put(PYTHON_DOUBLE_COMMENT_PREFIX_PATTERN, PYTHON_DOUBLE_COMMENT_SUFFIX_PATTERN);
        tokenizerDelimiters.put(SINGLE_QUOTE_STRING_PREFIX_PATTERN, SINGLE_QUOTE_STRING_SUFFIX_PATTERN);
        tokenizerDelimiters.put(DOUBLE_QUOTE_STRING_PREFIX_PATTERN, DOUBLE_QUOTE_STRING_SUFFIX_PATTERN);
        tokenizerDelimiters.put(CPP_EXCLUDE_COMMENT_PREFIX_PATTERN, CPP_EXCLUDE_COMMENT_SUFFIX_PATTERN);
        tokenizerDelimiters.put(JAVADOC_EXCLUDE_COMMENT_PREFIX_PATTERN, JAVADOC_EXCLUDE_COMMENT_SUFFIX_PATTERN);
        chunkDelimiters = new IdentityHashMap();
        chunkDelimiters.put(MEMBER_COMMENT_PREFIX_PATTERN, MEMBER_COMMENT_SUFFIX_PATTERN);
        chunkDelimiters.put(LIST_ITEM_PREFIX_PATTERN, LIST_ITEM_SUFFIX_PATTERN);
    }
}

