/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.its;

import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.ListUtil;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.TermsAnnotation;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filters.SubFilter;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.its.ContextItem;
import net.sf.okapi.filters.its.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.its.ITSEngine;
import org.w3c.its.TargetPointerEntry;

public abstract class ITSFilter
implements IFilter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Parameters params;
    protected EncoderManager encoderManager;
    protected Document doc;
    protected RawDocument input;
    protected String encoding;
    protected String docName;
    protected LocaleId srcLang;
    protected String lineBreak;
    protected boolean hasUTF8BOM;
    protected GenericSkeleton skel;
    protected IFilterConfigurationMapper fcMapper;
    private final String mimeType;
    private final boolean isHTML5;
    private String trgLangCode;
    private ITSEngine trav;
    private LinkedList<Event> queue;
    private int tuId;
    private IdGenerator otherId;
    private TextFragment frag;
    private Stack<ContextItem> context;
    private boolean canceled;
    private TermsAnnotation terms;
    private Map<String, String> variables;

    public ITSFilter(boolean isHTML5, String mimeType) {
        this.isHTML5 = isHTML5;
        this.mimeType = mimeType;
        this.params = new Parameters();
    }

    public void setITSVariables(Map<String, String> map) {
        this.variables = map;
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void close() {
        if (this.input != null) {
            this.input.close();
        }
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new GenericSkeletonWriter();
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new GenericFilterWriter(this.createSkeletonWriter(), this.getEncoderManager());
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.queue != null;
    }

    @Override
    public Event next() {
        if (this.canceled) {
            this.queue = null;
            return new Event(EventType.CANCELED);
        }
        if (this.queue == null) {
            return null;
        }
        do {
            if (this.queue.size() > 0) {
                Event event = this.queue.poll();
                if (event.getEventType() == EventType.END_DOCUMENT) {
                    this.queue = null;
                }
                return event;
            }
            this.process();
        } while (this.queue.size() != 0);
        return null;
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    protected abstract void initializeDocument();

    protected abstract void applyRules(ITSEngine var1);

    protected abstract void createStartDocumentSkeleton(StartDocument var1);

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.close();
        this.input = input;
        this.canceled = false;
        this.tuId = 0;
        this.otherId = new IdGenerator(null, "o");
        this.initializeDocument();
        this.trgLangCode = null;
        if (!Util.isNullOrEmpty(input.getTargetLocale())) {
            this.trgLangCode = input.getTargetLocale().toString().toLowerCase();
        }
        if (this.params.useCodeFinder) {
            this.params.codeFinder.compile();
        }
        this.trav = new ITSEngine(this.doc, input.getInputURI(), this.isHTML5, this.variables);
        if (this.params != null && this.params.getDocument() != null) {
            this.trav.addExternalRules(this.params.getDocument(), this.params.getURI());
        }
        this.applyRules(this.trav);
        this.trav.startTraversal();
        this.context = new Stack();
        this.queue = new LinkedList();
        StartDocument startDoc = new StartDocument(this.otherId.createId());
        startDoc.setName(this.docName);
        String realEnc = this.doc.getInputEncoding();
        if (realEnc != null) {
            this.encoding = realEnc;
        }
        startDoc.setEncoding(this.encoding, this.hasUTF8BOM);
        startDoc.setLineBreak(this.lineBreak);
        startDoc.setLocale(this.srcLang);
        this.params.quoteModeDefined = true;
        this.params.quoteMode = 3;
        if (!this.trav.getTranslatableAttributeRuleTriggered() && !this.params.escapeQuotes) {
            this.params.quoteModeDefined = true;
            this.params.quoteMode = 0;
        }
        startDoc.setFilterParameters(this.params);
        startDoc.setFilterWriter(this.createFilterWriter());
        startDoc.setType(this.mimeType);
        startDoc.setMimeType(this.mimeType);
        this.createStartDocumentSkeleton(startDoc);
        startDoc.setSkeleton(this.skel);
        this.queue.add(new Event(EventType.START_DOCUMENT, startDoc));
    }

    private void process() {
        this.frag = null;
        this.skel = new GenericSkeleton();
        if (this.context.size() > 0 && this.context.peek().translate) {
            this.frag = new TextFragment();
        }
        while (true) {
            Node node;
            if ((node = this.trav.nextNode()) == null) {
                Ending ending = new Ending(this.otherId.createId());
                if (this.skel != null && !this.skel.isEmpty()) {
                    ending.setSkeleton(this.skel);
                }
                this.queue.add(new Event(EventType.END_DOCUMENT, ending));
                return;
            }
            switch (node.getNodeType()) {
                case 4: {
                    if (this.frag == null) {
                        this.skel.append(this.buildCDATA(node));
                        break;
                    }
                    if (this.extract()) {
                        this.frag.append(node.getNodeValue());
                        break;
                    }
                    this.frag.append(TextFragment.TagType.PLACEHOLDER, null, this.buildCDATA(node));
                    break;
                }
                case 3: {
                    if (this.frag == null) {
                        this.skel.append(Util.escapeToXML(node.getNodeValue().replace("\n", this.lineBreak), 0, false, null));
                        break;
                    }
                    if (this.extract()) {
                        if (this.params.lineBreakAsCode) {
                            this.escapeAndAppend(this.frag, node.getNodeValue());
                            break;
                        }
                        this.frag.append(node.getNodeValue());
                        break;
                    }
                    this.frag.append(TextFragment.TagType.PLACEHOLDER, null, Util.escapeToXML(node.getNodeValue().replace("\n", this.params.escapeLineBreak ? "&#10;" : this.lineBreak), 0, false, null));
                    break;
                }
                case 1: {
                    if (!this.processElementTag(node)) break;
                    return;
                }
                case 7: {
                    if (this.frag == null) {
                        this.skel.add(this.buildPI(node));
                        break;
                    }
                    this.frag.append(TextFragment.TagType.PLACEHOLDER, null, this.buildPI(node));
                    break;
                }
                case 8: {
                    if (this.frag == null) {
                        this.skel.add(this.buildComment(node));
                        break;
                    }
                    this.frag.append(TextFragment.TagType.PLACEHOLDER, null, this.buildComment(node));
                    break;
                }
                case 5: {
                    if (this.trav.backTracking()) break;
                    if (this.frag == null) {
                        this.skel.add("&" + node.getNodeName() + ";");
                    } else {
                        this.frag.append(TextFragment.TagType.PLACEHOLDER, "ref", "&" + node.getNodeName() + ";");
                    }
                    if (!node.hasChildNodes()) break;
                    Node thisNode = node;
                    while ((node = this.trav.nextNode()) != thisNode) {
                    }
                    break;
                }
                case 10: {
                    break;
                }
                case 12: {
                    break;
                }
            }
        }
    }

    private void escapeAndAppend(TextFragment frag, String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '\n') {
                frag.append(TextFragment.TagType.PLACEHOLDER, "lb", "&#10;");
                continue;
            }
            frag.append(text.charAt(i));
        }
    }

    private void addStartTagToSkeleton(Node node) {
        boolean checkEncoding;
        StringBuilder tmp = new StringBuilder();
        tmp.append("<" + (node.getPrefix() == null ? "" : node.getPrefix() + ":") + node.getLocalName());
        boolean bl = checkEncoding = this.isHTML5 && node.getLocalName().equals("meta");
        if (node.hasAttributes()) {
            NamedNodeMap list = node.getAttributes();
            for (int i = 0; i < list.getLength(); ++i) {
                Attr attr = (Attr)list.item(i);
                if (!attr.getSpecified()) continue;
                tmp.append(" " + (attr.getPrefix() == null ? "" : attr.getPrefix() + ":") + attr.getLocalName() + "=\"");
                if (this.trav.getTranslate(attr) && attr.getValue().length() > 0) {
                    this.skel.append(tmp.toString());
                    tmp.setLength(0);
                    this.addAttributeTextUnit(attr, true);
                    tmp.append("\"");
                    continue;
                }
                if (attr.getName().equals("xml:lang")) {
                    tmp.append(Util.escapeToXML(attr.getNodeValue(), 3, false, null) + "\"");
                    continue;
                }
                if (this.isHTML5 && attr.getName().equals("lang")) {
                    tmp.append(Util.escapeToXML(attr.getNodeValue(), 3, false, null) + "\"");
                    continue;
                }
                if (checkEncoding && attr.getName().equals("charset")) {
                    DocumentPart dp = new DocumentPart(this.otherId.createId(), false);
                    dp.setProperty(new Property("encoding", this.encoding));
                    this.skel.append(tmp.toString());
                    this.skel.addValuePlaceholder(dp, "encoding", LocaleId.EMPTY);
                    this.skel.append("\"");
                    this.queue.add(new Event(EventType.DOCUMENT_PART, dp, this.skel));
                    this.skel = new GenericSkeleton();
                    tmp.setLength(0);
                    continue;
                }
                tmp.append(Util.escapeToXML(attr.getNodeValue(), 3, false, null) + "\"");
            }
        }
        if (!this.isHTML5 && !node.hasChildNodes()) {
            tmp.append("/");
        }
        tmp.append(">");
        this.skel.append(tmp.toString());
    }

    private void addStartTagToFragment(Node node) {
        StringBuilder tmp = new StringBuilder();
        String id = null;
        tmp.append("<" + (node.getPrefix() == null ? "" : node.getPrefix() + ":") + node.getLocalName());
        if (node.hasAttributes()) {
            NamedNodeMap list = node.getAttributes();
            for (int i = 0; i < list.getLength(); ++i) {
                Attr attr = (Attr)list.item(i);
                if (!attr.getSpecified()) continue;
                tmp.append(" " + (attr.getPrefix() == null ? "" : attr.getPrefix() + ":") + attr.getLocalName() + "=\"");
                if (this.trav.getTranslate(attr) && attr.getValue().length() > 0) {
                    id = this.addAttributeTextUnit(attr, false);
                    tmp.append(TextFragment.makeRefMarker(id));
                    tmp.append("\"");
                    continue;
                }
                if (attr.getName().equals("xml:lang")) {
                    tmp.append(Util.escapeToXML(attr.getNodeValue(), 3, false, null) + "\"");
                    continue;
                }
                tmp.append(Util.escapeToXML(attr.getNodeValue(), 3, false, null) + "\"");
            }
        }
        if (!this.isHTML5 && !node.hasChildNodes()) {
            tmp.append("/");
        }
        tmp.append(">");
        Code code = this.frag.append(node.hasChildNodes() ? TextFragment.TagType.OPENING : TextFragment.TagType.PLACEHOLDER, node.getLocalName(), tmp.toString());
        code.setReferenceFlag(id != null);
    }

    private String addAttributeTextUnit(Attr attr, boolean addToSkeleton) {
        String id = String.valueOf(++this.tuId);
        TextUnit tu = new TextUnit(id, attr.getValue(), true, this.mimeType);
        if (this.params.useCodeFinder) {
            TextFragment tf = tu.getSource().getFirstContent();
            this.params.codeFinder.process(tf);
        }
        ContextItem ci = new ContextItem(this.context.isEmpty() ? attr.getParentNode() : this.context.peek().node, this.trav, attr);
        if (!Util.isEmpty(ci.locNote)) {
            tu.setProperty(new Property("note", ci.locNote));
        }
        if (!Util.isEmpty(ci.domains)) {
            tu.setProperty(new Property("its-domains", ci.domains));
        }
        if (!Util.isEmpty(ci.externalRes)) {
            tu.setProperty(new Property("its-externalResourcesRef", ci.externalRes));
        }
        if (ci.storageSize != null) {
            tu.setProperty(new Property("its-storageSize", ci.storageSize));
        }
        if (ci.allowedChars != null) {
            tu.setProperty(new Property("its-allowedCharacters", ci.allowedChars));
        }
        this.queue.add(new Event(EventType.TEXT_UNIT, tu));
        if (addToSkeleton) {
            this.skel.addReference(tu);
        }
        return id;
    }

    private String buildEndTag(Node node) {
        if (node.hasChildNodes()) {
            return "</" + (node.getPrefix() == null ? "" : node.getPrefix() + ":") + node.getLocalName() + ">";
        }
        return "";
    }

    private String buildPI(Node node) {
        return "<?" + node.getNodeName() + " " + node.getNodeValue() + "?>";
    }

    private String buildCDATA(Node node) {
        return "<![CDATA[" + node.getNodeValue().replace("\n", this.lineBreak) + "]]>";
    }

    private String buildComment(Node node) {
        return "<!--" + node.getNodeValue().replace("\n", this.lineBreak) + "-->";
    }

    private boolean processElementTag(Node node) {
        if (this.trav.backTracking()) {
            if (this.trav.getTerm(null)) {
                if (this.terms == null) {
                    this.terms = new TermsAnnotation();
                }
                this.terms.add(node.getTextContent(), this.trav.getTermInfo(null));
            }
            if (this.frag == null) {
                this.skel.add(this.buildEndTag(node));
                if (node.isSameNode(this.context.peek().node)) {
                    this.context.pop();
                }
                if (this.isContextTranslatable()) {
                    this.frag = new TextFragment();
                }
            } else {
                if (node.isSameNode(this.context.peek().node)) {
                    return this.addTextUnit(node, true);
                }
                this.frag.append(TextFragment.TagType.CLOSING, node.getLocalName(), this.buildEndTag(node));
            }
        } else {
            TargetPointerEntry tpe;
            if (this.trav.getHasTargetPointer() && (tpe = this.trav.getTargetPointerEntry(node)) != null) {
                if (tpe.getTargetNode() == node) {
                    tpe.toString();
                } else {
                    tpe.toString();
                }
            }
            if (this.trav.getSubFilter(null) != null) {
                this.processSubFilterContent(node, this.trav.getSubFilter(null));
                this.moveToEnd(node);
                return true;
            }
            switch (this.trav.getWithinText()) {
                case 1: 
                case 2: {
                    if (this.frag == null) {
                        this.addStartTagToSkeleton(node);
                        if (!node.hasChildNodes()) break;
                        this.context.push(new ContextItem(node, this.trav));
                        break;
                    }
                    this.addStartTagToFragment(node);
                    break;
                }
                default: {
                    if (this.frag == null) {
                        this.addStartTagToSkeleton(node);
                        if (this.extract()) {
                            this.frag = new TextFragment();
                        }
                        if (!node.hasChildNodes()) break;
                        this.context.push(new ContextItem(node, this.trav));
                        break;
                    }
                    this.addTextUnit(node, false);
                    this.addStartTagToSkeleton(node);
                    if (this.extract()) {
                        this.frag = new TextFragment();
                    }
                    if (!node.hasChildNodes()) break;
                    this.context.push(new ContextItem(node, this.trav));
                }
            }
        }
        return false;
    }

    private void moveToEnd(Node start) {
        Node node = null;
        while ((node = this.trav.nextNode()) != null) {
            if (node != start) continue;
            return;
        }
    }

    private void processSubFilterContent(Node node, String configId) {
        this.addStartTagToSkeleton(node);
        IFilter sf = this.fcMapper.createFilter(configId, null);
        if (sf == null) {
            throw new OkapiBadFilterInputException(String.format("Could not instantiate subfilter '%s'.", configId));
        }
        this.encoderManager.setDefaultOptions(this.getParameters(), this.encoding, this.lineBreak);
        this.encoderManager.updateEncoder(this.getMimeType());
        SubFilter subfilter = new SubFilter(sf, this.getEncoderManager().getEncoder(), 1, "parentId", null);
        String content = node.getTextContent();
        subfilter.open(new RawDocument(content, this.srcLang));
        while (subfilter.hasNext()) {
            this.queue.add(subfilter.next());
        }
        subfilter.close();
        GenericSkeleton skelAfter = new GenericSkeleton();
        skelAfter.add(this.buildEndTag(node));
        this.queue.add(subfilter.createRefEvent(this.skel, skelAfter));
        this.skel = new GenericSkeleton();
    }

    private boolean extract() {
        if (!this.trav.getTranslate(null)) {
            return false;
        }
        String list = this.trav.getLocaleFilter();
        if (list == null || list.equals("*")) {
            return true;
        }
        if (list.length() == 0) {
            return false;
        }
        if (this.trgLangCode == null) {
            this.logger.warn("No target locale specified: Cannot use the provided ITS Locale Filter data category.");
            return true;
        }
        return this.extendedMatch(list, this.trgLangCode);
    }

    public boolean extendedMatch(String langRanges, String langTag) {
        for (String langRange : ListUtil.stringAsArray(langRanges.toLowerCase())) {
            if (!this.doesLangTagMacthesLangRange(langRange, langTag)) continue;
            return true;
        }
        return false;
    }

    private boolean doesLangTagMacthesLangRange(String langRange, String langTag) {
        String[] lrParts = langRange.toLowerCase().split("-", 0);
        String[] ltParts = langTag.toLowerCase().split("-", 0);
        int i = 0;
        int j = 0;
        String lrst = lrParts[i];
        String ltst = ltParts[j];
        ++j;
        if (!lrst.equals(ltst) && !lrst.equals("*")) {
            return false;
        }
        i = 1;
        j = 1;
        while (i < lrParts.length) {
            lrst = lrParts[i];
            if (lrst.equals("*")) {
                ++i;
                continue;
            }
            if (j >= ltParts.length) {
                return false;
            }
            if (ltParts[j].equals(lrst)) {
                ++i;
                ++j;
                continue;
            }
            if (ltParts[j].length() == 1) {
                return false;
            }
            ++j;
        }
        return true;
    }

    private boolean isContextTranslatable() {
        if (this.context.size() == 0) {
            return false;
        }
        return this.context.peek().translate;
    }

    private boolean addTextUnit(Node node, boolean popStack) {
        boolean extract;
        boolean bl = extract = this.frag.hasText(false) || this.params.extractIfOnlyCodes && this.frag.hasCode();
        if (extract) {
            if (this.params.useCodeFinder) {
                this.params.codeFinder.process(this.frag);
            }
            boolean bl2 = extract = this.frag.hasText(false) || this.params.extractIfOnlyCodes && this.frag.hasCode();
        }
        if (!extract) {
            if (!this.frag.isEmpty()) {
                this.skel.add(this.frag.toText().replace("\n", this.params.escapeLineBreak ? "&#10;" : this.lineBreak));
            }
            this.frag = null;
            if (popStack) {
                this.context.pop();
                this.skel.add(this.buildEndTag(node));
                if (this.isContextTranslatable()) {
                    this.frag = new TextFragment();
                }
            }
            return false;
        }
        TextUnit tu = new TextUnit(String.valueOf(++this.tuId));
        tu.setMimeType(this.mimeType);
        tu.setSourceContent(this.frag);
        if (!Util.isEmpty(this.context.peek().locNote)) {
            tu.setProperty(new Property("note", this.context.peek().locNote));
        }
        if (!Util.isEmpty(this.context.peek().domains)) {
            tu.setProperty(new Property("its-domains", this.context.peek().domains));
        }
        if (!Util.isEmpty(this.context.peek().externalRes)) {
            tu.setProperty(new Property("its-externalResourcesRef", this.context.peek().externalRes));
        }
        if (this.context.peek().storageSize != null) {
            tu.setProperty(new Property("its-storageSize", this.context.peek().storageSize));
        }
        if (this.context.peek().allowedChars != null) {
            tu.setProperty(new Property("its-allowedCharacters", this.context.peek().allowedChars));
        }
        if (this.terms != null) {
            tu.getSource().setAnnotation(this.terms);
            this.terms = null;
        }
        tu.setName(this.context.peek().idValue);
        if (this.isHTML5 && node.getNodeName().equals("pre")) {
            this.context.peek().preserveWS = true;
        }
        if (this.context.peek().preserveWS) {
            tu.setPreserveWhitespaces(true);
        } else {
            tu.setPreserveWhitespaces(false);
            tu.getSource().unwrap(false, true);
        }
        this.skel.addContentPlaceholder(tu);
        if (popStack) {
            this.context.pop();
            this.skel.add(this.buildEndTag(node));
        }
        tu.setSkeleton(this.skel);
        this.queue.add(new Event(EventType.TEXT_UNIT, tu));
        this.frag = null;
        if (popStack && this.isContextTranslatable()) {
            this.frag = new TextFragment();
        }
        this.skel = new GenericSkeleton();
        return true;
    }
}

