/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.railsyaml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.exceptions.OkapiUnsupportedEncodingException;
import net.sf.okapi.common.filters.AbstractFilter;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.filters.railsyaml.Parameters;
import net.sf.okapi.filters.railsyaml.YamlEventBuilder;

public class RailsYamlFilter
extends AbstractFilter {
    private static final int RESULT_END = 0;
    private static final int RESULT_ENTRY = 1;
    private static final int RESULT_DATA = 2;
    private static final int PARSE_STOP = 0;
    private static final int PARSE_CONTINUE = 1;
    private static final int ITEM_STRING = 0;
    private static final int ITEM_SKELETON = 1;
    private static final int ITEM_COMMENT = 2;
    private static final int ITEM_CONTAINER = 3;
    private static final int ITEM_NONE = 4;
    private static final String YAML_INDENTATION_REGEX = "( *)(.*)";
    private static final Pattern YAML_INDENTATION_PATTERN = Pattern.compile("( *)(.*)");
    private static final int YAML_INDENTATION_INDEX = 1;
    private static final String YAML_STRING_REGEX = "( *)(.*)(: *\")(.*)(\".*)";
    private static final Pattern YAML_STRING_PATTERN = Pattern.compile("( *)(.*)(: *\")(.*)(\".*)");
    private static final int YAML_STRING_INDEX_KEY = 2;
    private static final int YAML_STRING_INDEX_TU = 4;
    private static final String YAML_MIME_TYPE = "text/x-yaml";
    private YamlEventBuilder eventBuilder;
    private int parseState;
    private BufferedReader reader;
    private int tuid;
    private ITextUnit tuEntry;
    private GenericSkeleton skel;
    private String key = "";
    private int indentation;
    private Stack<KeyPair> keyStack;
    private boolean isUtf8Encoding = false;
    private boolean isUtf8Bom = false;
    private Parameters params;

    public RailsYamlFilter() {
        this.setMimeType(YAML_MIME_TYPE);
        this.setFilterWriter(this.createFilterWriter());
        this.setName("okf_railsyaml");
        this.setDisplayName("Ruby on Rails YAML Filter");
        this.addConfiguration(new FilterConfiguration(this.getName(), YAML_MIME_TYPE, this.getClass().getName(), "Ruby on Rails YAML", "Ruby on Rails YAML files", null, ".yml;"));
        this.parseState = 0;
        this.indentation = 0;
        this.keyStack = new Stack();
        this.params = new Parameters();
    }

    @Override
    protected boolean isUtf8Bom() {
        return this.isUtf8Bom;
    }

    @Override
    protected boolean isUtf8Encoding() {
        return this.isUtf8Encoding;
    }

    @Override
    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
            this.parseState = 0;
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.parseState != 0;
    }

    @Override
    public Event next() {
        int result;
        if (this.getEventBuilder().hasQueuedEvents()) {
            return this.getEventBuilder().next();
        }
        boolean resetBuffer = true;
        do {
            result = this.readEntry(resetBuffer);
            switch (result) {
                case 2: {
                    resetBuffer = false;
                    break;
                }
                case 1: {
                    Event e = new Event(EventType.TEXT_UNIT, this.getEventBuilder().postProcessTextUnit(this.tuEntry));
                    this.getEventBuilder().addFilterEvent(e);
                    resetBuffer = true;
                    break;
                }
                default: {
                    resetBuffer = true;
                }
            }
        } while (!this.getEventBuilder().hasQueuedEvents() && result != 0);
        if (this.parseState == 0) {
            this.getEventBuilder().flushRemainingTempEvents();
            this.getEventBuilder().addFilterEvent(this.createEndFilterEvent());
        }
        return this.getEventBuilder().next();
    }

    private int readEntry(boolean resetBuffer) {
        if (resetBuffer) {
            this.skel = new GenericSkeleton();
        }
        try {
            String line = this.reader.readLine();
            if (line == null) {
                this.parseState = 0;
                return 0;
            }
            switch (this.parseLine(line)) {
                case 2: {
                    this.getEventBuilder().addDocumentPart(line + this.getNewlineType());
                    return 2;
                }
                case 3: {
                    this.getEventBuilder().addDocumentPart(line + this.getNewlineType());
                    return 2;
                }
                case 0: {
                    return 1;
                }
                case 1: {
                    this.getEventBuilder().addDocumentPart(line + this.getNewlineType());
                    return 2;
                }
                case 4: {
                    this.getEventBuilder().addDocumentPart(line + this.getNewlineType());
                    return 2;
                }
            }
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        return 0;
    }

    private int parseLine(String line) {
        String tmpKey = "";
        String trimLine = line.trim();
        if (trimLine.length() == 0) {
            return 1;
        }
        if (trimLine.startsWith("#")) {
            return 2;
        }
        this.indentation = this.getIndentation(line);
        int colonIndex = trimLine.indexOf(58);
        if (colonIndex == trimLine.length() - 1) {
            while (!this.keyStack.empty() && this.indentation <= this.keyStack.peek().indent) {
                this.keyStack.pop();
            }
            this.keyStack.push(new KeyPair(this.indentation, trimLine.substring(0, colonIndex)));
            this.key = this.generateKey();
            return 3;
        }
        this.key = this.generateKey();
        Matcher matcher = YAML_STRING_PATTERN.matcher(line);
        if (matcher.matches()) {
            while (!this.keyStack.empty() && this.keyStack.peek().indent >= this.indentation) {
                this.keyStack.pop();
            }
            this.key = this.generateKey();
            tmpKey = line.substring(matcher.start(2), matcher.end(2)).trim();
            this.tuEntry = new TextUnit(String.valueOf(++this.tuid), matcher.group(4));
            this.tuEntry.setName(this.key + tmpKey);
            this.tuEntry.setMimeType(this.getMimeType());
            this.tuEntry.setPreserveWhitespaces(true);
            this.skel.append(line.substring(0, matcher.start(4)));
            this.skel.addContentPlaceholder(this.tuEntry, null);
            this.skel.append(matcher.group(5));
            this.skel.append(this.getNewlineType());
            this.tuEntry.setSkeleton(this.skel);
            Property propIndentation = new Property("indentation", String.valueOf(this.indentation));
            this.tuEntry.setProperty(propIndentation);
            if (this.params.useCodeFinder) {
                this.params.codeFinder.process(this.tuEntry.getSource().getFirstContent());
            }
            return 0;
        }
        return 4;
    }

    private int getIndentation(String line) {
        Matcher m = YAML_INDENTATION_PATTERN.matcher(line);
        if (m.matches()) {
            return m.group(1).length();
        }
        return 0;
    }

    private String generateKey() {
        String key = "";
        for (KeyPair kp : this.keyStack) {
            key = key + kp.key + ".";
        }
        return key;
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.close();
        this.parseState = 1;
        this.tuid = 0;
        if (this.params.useCodeFinder) {
            this.params.codeFinder.compile();
        }
        BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(input.getStream(), input.getEncoding());
        detector.detectAndRemoveBom();
        this.setNewlineType(detector.getNewlineType().toString());
        input.setEncoding(detector.getEncoding());
        String encoding = input.getEncoding();
        this.isUtf8Bom = detector.hasUtf8Bom();
        this.isUtf8Encoding = detector.hasUtf8Encoding();
        if (input.getInputURI() != null) {
            this.setDocumentName(input.getInputURI().getPath());
        }
        this.setOptions(input.getSourceLocale(), input.getTargetLocale(), encoding, generateSkeleton);
        try {
            this.reader = new BufferedReader(new InputStreamReader(detector.getInputStream(), encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new OkapiUnsupportedEncodingException(String.format("The encoding %s is not supported.", encoding), e);
        }
        if (this.eventBuilder == null) {
            this.eventBuilder = new YamlEventBuilder(this.getDocumentName(), this);
        } else {
            this.eventBuilder.reset(this.getDocumentName(), this);
        }
        this.getEventBuilder().addFilterEvent(this.createStartFilterEvent());
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    private YamlEventBuilder getEventBuilder() {
        return this.eventBuilder;
    }

    private class KeyPair {
        public int indent;
        public String key;

        public KeyPair(int i, String k) {
            this.indent = i;
            this.key = k;
        }
    }
}

