/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.tmx;

import javax.xml.stream.XMLStreamReader;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.AlignmentStatus;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.filters.tmx.TmxFilter;

public class TmxTuv {
    LocaleId lang;
    TmxFilter.TuvXmlLang trgType;
    int langCount;
    GenericSkeleton skelBefore = new GenericSkeleton();
    GenericSkeleton skelAfter = new GenericSkeleton();
    TextContainer tc = new TextContainer();
    boolean finishedSegSection;

    TmxTuv(LocaleId lang, TmxFilter.TuvXmlLang trgType, int counter, int segType) {
        this.lang = lang;
        this.trgType = trgType;
        this.langCount = counter;
        if (segType == 0) {
            this.tc.setHasBeenSegmentedFlag(true);
            this.tc.getSegments().setAlignmentStatus(AlignmentStatus.ALIGNED);
        } else if (segType == 1) {
            this.tc.setHasBeenSegmentedFlag(false);
            this.tc.getSegments().setAlignmentStatus(AlignmentStatus.NOT_ALIGNED);
        }
    }

    void parseStartElement(XMLStreamReader reader, TmxFilter.TuvXmlLang tuvTrgType, boolean processAllTargets) {
        this.parseStartElement(reader, tuvTrgType, processAllTargets, null);
    }

    String parseStartElement(XMLStreamReader reader, TmxFilter.TuvXmlLang tuvTrgType, boolean processAllTargets, String elem) {
        int i;
        String propName = "";
        String prefix = reader.getPrefix();
        if (prefix == null || prefix.length() == 0) {
            this.skelBefore.append("<" + reader.getLocalName());
        } else {
            this.skelBefore.append("<" + prefix + ":" + reader.getLocalName());
        }
        int count = reader.getNamespaceCount();
        for (i = 0; i < count; ++i) {
            prefix = reader.getNamespacePrefix(i);
            this.skelBefore.append(String.format(" xmlns%s=\"%s\"", prefix.length() > 0 ? ":" + prefix : "", reader.getNamespaceURI(i)));
        }
        count = reader.getAttributeCount();
        for (i = 0; i < count; ++i) {
            if (!reader.isAttributeSpecified(i)) continue;
            prefix = reader.getAttributePrefix(i);
            this.skelBefore.append(String.format(" %s%s=\"%s\"", prefix == null || prefix.length() == 0 ? "" : prefix + ":", reader.getAttributeLocalName(i), reader.getAttributeValue(i)));
            if (elem != null && elem.equals("prop")) {
                if (!reader.getAttributeLocalName(i).equals("type")) continue;
                propName = reader.getAttributeValue(i);
                continue;
            }
            if (elem != null && elem.equals("note") || tuvTrgType != TmxFilter.TuvXmlLang.SOURCE && tuvTrgType != TmxFilter.TuvXmlLang.TARGET && !processAllTargets) continue;
            this.tc.setProperty(new Property(reader.getAttributeLocalName(i), reader.getAttributeValue(i), true));
        }
        this.skelBefore.append(">");
        if (elem != null && elem.equals("note")) {
            propName = "note";
        }
        return propName;
    }

    void appendToSkel(String pskel) {
        if (!this.finishedSegSection) {
            this.skelBefore.append(pskel);
        } else {
            this.skelAfter.append(pskel);
        }
    }

    void parseEndElement(XMLStreamReader reader) {
        this.parseEndElement(reader, false);
    }

    void parseEndElement(XMLStreamReader reader, boolean addToSkelBefore) {
        String ns = reader.getPrefix();
        if (ns == null || ns.length() == 0) {
            if (addToSkelBefore) {
                this.skelBefore.append("</" + reader.getLocalName() + ">");
            } else {
                this.skelAfter.append("</" + reader.getLocalName() + ">");
            }
        } else {
            if (addToSkelBefore) {
                this.skelBefore.append("</" + ns + ":" + reader.getLocalName() + ">");
            } else {
                this.skelAfter.append("</" + ns + ":" + reader.getLocalName() + ">");
            }
            this.skelBefore.append("</" + ns + ":" + reader.getLocalName() + ">");
        }
    }

    void setProperty(Property prop) {
        Property existingProp = this.tc.getProperty(prop.getName());
        if (existingProp != null) {
            existingProp.setValue(existingProp.getValue() + ", " + prop.getValue());
        } else {
            this.tc.setProperty(prop);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("-----TmxTuv-----\n");
        sb.append("Trg Lang: " + this.lang + "     Trg Type: " + (Object)((Object)this.trgType) + "     Counter: " + this.langCount + "\n");
        sb.append("Skel Before: " + this.skelBefore + "\n");
        for (String pname : this.tc.getPropertyNames()) {
            sb.append("Prop Name: " + pname + "     Prop Value: " + this.tc.getProperty(pname) + "\n");
        }
        sb.append(this.tc.getCodedText() + "\n");
        sb.append("Skel After: " + this.skelAfter + "\n\n");
        return sb.toString();
    }
}

