/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.versifiedtxt;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.AbstractFilter;
import net.sf.okapi.common.filters.EventBuilder;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.AlignmentStatus;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.filters.versifiedtxt.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters
public class VersifiedTextFilter
extends AbstractFilter {
    private static final Map<String, String> REPLACABLES = new HashMap<String, String>();
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final int BUFFER_SIZE = 2800;
    private static final String VERSIFIED_ID = "^([0-9]+)$";
    private static final Pattern VERSIFIED_ID_COMPILED;
    public static final String VERSIFIED_TXT_MIME_TYPE = "text/x-versified-txt";
    private static final String VERSE = "^[ \\t]*\\|v([^ ]+)[ \\t]*(\\(([^()]+)\\))?(\\+\\|)?[ \\t]*$";
    private static final Pattern VERSE_COMPILED;
    private static final String TRADOS_SEGMENTS = "\\{0>(.*?)<\\}[0-9]+\\{>(.*?)<0\\}";
    private static final Pattern TRADOS_SEGMENTS_COMPILED;
    private static final String TRADOS_LEAVINGS = "(\\{0>)|(<0\\})|(<\\}[0-9]+\\{>)|(<\\})|(\\{>)";
    private static final Pattern TRADOS_LEAVINGS_COMPILED;
    private static final String CHAPTER = "^[ \t]*\\|c.+[ \t]*$";
    private static final String BOOK = "^[ \t]*\\|b.+[ \t]*$";
    private static final String TARGET = "^[ \t]*<TARGET>[ \t]*$";
    private static final String PLACEHOLDER = "(\\{|</?)([0-9]+)(\\}|>)";
    private static final Pattern PLACEHOLDER_PATTERN;
    private String newline = "\n";
    private String currentChapter = "";
    private String currentBook = "";
    private int currentChar;
    private EventBuilder eventBuilder;
    private EncoderManager encoderManager;
    private boolean hasUtf8Bom;
    private boolean hasUtf8Encoding;
    private BufferedReader versifiedFileReader;
    private RawDocument currentRawDocument;
    private BOMNewlineEncodingDetector detector;
    private StartSubDocument startSubDocument;
    private Parameters params;
    private StringBuilder filterBuffer;
    private boolean foundVerse = false;
    private boolean foundBook = false;
    private boolean trados = false;

    public VersifiedTextFilter() {
        this.setMimeType(VERSIFIED_TXT_MIME_TYPE);
        this.setMultilingual(false);
        this.setFilterWriter(new GenericFilterWriter(this.createSkeletonWriter(), this.getEncoderManager()));
        this.setName("okf_versifiedtxt");
        this.setDisplayName("Versified Text Filter");
        this.addConfiguration(new FilterConfiguration(this.getName(), VERSIFIED_TXT_MIME_TYPE, this.getClass().getName(), "Versified Text", "Versified Text Documents"));
        this.setParameters(new Parameters());
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return super.createFilterWriter();
    }

    @Override
    public void open(RawDocument input) {
        this.foundVerse = false;
        this.foundBook = false;
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.close();
        this.currentRawDocument = input;
        this.currentChapter = "";
        this.currentBook = "";
        this.currentChar = -2;
        this.filterBuffer = new StringBuilder(2799);
        if (input.getInputURI() != null) {
            this.setDocumentName(input.getInputURI().getPath());
        }
        this.detector = new BOMNewlineEncodingDetector(input.getStream(), input.getEncoding());
        this.detector.detectAndRemoveBom();
        this.setEncoding(input.getEncoding());
        this.hasUtf8Bom = this.detector.hasUtf8Bom();
        this.hasUtf8Encoding = this.detector.hasUtf8Encoding();
        this.newline = this.detector.getNewlineType().toString();
        this.setNewlineType(this.newline);
        String detectedEncoding = this.getEncoding();
        if (this.detector.isDefinitive()) {
            detectedEncoding = this.detector.getEncoding();
            this.LOGGER.debug(String.format("Overridding user set encoding (if any). Setting auto-detected encoding (%s).", detectedEncoding));
        } else if (!this.detector.isDefinitive() && this.getEncoding().equals("null")) {
            detectedEncoding = this.detector.getEncoding();
            this.LOGGER.debug(String.format("Default encoding and detected encoding not found. Using best guess encoding (%s)", detectedEncoding));
        }
        input.setEncoding(detectedEncoding);
        this.setEncoding(detectedEncoding);
        this.setOptions(input.getSourceLocale(), input.getTargetLocale(), detectedEncoding, generateSkeleton);
        this.versifiedFileReader = new BufferedReader(input.getReader());
        String line = "";
        int bufferCount = 0;
        try {
            this.versifiedFileReader.mark(2800);
            while ((line = this.versifiedFileReader.readLine()) != null && (bufferCount += line.length() + 2) < 2800) {
                if (line.matches(TARGET)) {
                    this.setMultilingual(true);
                    this.trados = false;
                    break;
                }
                if (!line.matches(TRADOS_SEGMENTS)) continue;
                this.setMultilingual(true);
                this.trados = true;
                break;
            }
            this.versifiedFileReader.reset();
        }
        catch (IOException e) {
            throw new OkapiIOException("IO error detecting if file is multilingual: " + (line == null ? "unkown line" : line), e);
        }
        if (this.eventBuilder == null) {
            this.eventBuilder = new EventBuilder();
        } else {
            this.eventBuilder.reset(null, this);
        }
    }

    @Override
    public void close() {
        if (this.currentRawDocument != null) {
            this.currentRawDocument.close();
        }
        if (this.versifiedFileReader != null) {
            try {
                this.versifiedFileReader.close();
            }
            catch (IOException e) {
                this.LOGGER.warn("Error closing the versified text buffered reader.", e);
            }
        }
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping(VERSIFIED_TXT_MIME_TYPE, "net.sf.okapi.common.encoder.DefaultEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public boolean hasNext() {
        return this.eventBuilder.hasNext();
    }

    @Override
    public Event next() {
        String currentLine = null;
        if (this.eventBuilder.hasQueuedEvents()) {
            return this.eventBuilder.next();
        }
        while (this.currentChar != -1 && !this.isCanceled()) {
            try {
                this.currentChar = this.versifiedFileReader.read();
                this.filterBuffer.append((char)this.currentChar);
                if (this.currentChar != 13 && this.currentChar != 10 && this.currentChar != -1) continue;
                this.filterBuffer.setLength(this.filterBuffer.length() - 1);
                currentLine = this.filterBuffer.toString();
                currentLine = Util.trimEnd(currentLine, "\r\n");
                this.filterBuffer = new StringBuilder(2799);
                if (this.currentChar == -1 && currentLine.isEmpty()) break;
                this.newline = this.handleNewline();
                if (this.currentChar == -1) {
                    this.newline = "";
                }
                if (currentLine.matches(VERSE)) {
                    this.handleDocumentPart(currentLine + this.newline);
                    Matcher m = VERSE_COMPILED.matcher(currentLine);
                    String verseId = "";
                    String sid = null;
                    if (m.matches()) {
                        verseId = m.group(1);
                        sid = m.group(3);
                    }
                    this.handleVerse(this.versifiedFileReader, currentLine, verseId, sid);
                    this.foundVerse = true;
                } else if (currentLine.matches(BOOK)) {
                    this.currentBook = currentLine.substring(2);
                    this.setDocumentName(this.currentBook);
                    this.eventBuilder.addFilterEvent(this.createStartFilterEvent());
                    this.handleDocumentPart(currentLine + this.newline);
                    this.foundBook = true;
                } else if (currentLine.matches(CHAPTER)) {
                    this.currentChapter = currentLine.substring(2);
                    if (this.startSubDocument != null) {
                        this.eventBuilder.endSubDocument();
                    }
                    this.handleSubDocument(this.currentChapter);
                    this.handleDocumentPart(currentLine + this.newline);
                } else {
                    this.handleDocumentPart(currentLine + this.newline);
                }
                if (!this.eventBuilder.hasQueuedEvents()) continue;
                break;
            }
            catch (IOException e) {
                throw new OkapiIOException("IO error reading versified file at: " + (currentLine == null ? "unkown line" : currentLine), e);
            }
        }
        if (this.currentChar == -1) {
            if (this.startSubDocument != null) {
                this.eventBuilder.endSubDocument();
            }
            this.eventBuilder.flushRemainingTempEvents();
            if (!this.foundBook) {
                this.eventBuilder.addFilterEvent(this.createStartFilterEvent());
                this.LOGGER.warn("Missing book marker at start of document: |b");
            }
            this.eventBuilder.addFilterEvent(this.createEndFilterEvent());
            if (!this.foundVerse) {
                throw new OkapiBadFilterInputException("There are no verse codes in this document");
            }
        }
        return this.eventBuilder.next();
    }

    @Override
    protected boolean isUtf8Bom() {
        return this.hasUtf8Bom;
    }

    @Override
    protected boolean isUtf8Encoding() {
        return this.hasUtf8Encoding;
    }

    private String handleNewline() throws IOException {
        String newline = "\n";
        switch (this.detector.getNewlineType()) {
            case CR: {
                newline = "\r";
                break;
            }
            case CRLF: {
                newline = "\r\n";
                this.versifiedFileReader.read();
                break;
            }
            case LF: {
                newline = "\n";
            }
        }
        return newline;
    }

    private void handleSubDocument(String chapter) {
        this.startSubDocument = this.eventBuilder.startSubDocument();
        this.startSubDocument.setName(chapter);
    }

    private void handleVerse(BufferedReader verse, String currentVerse, String verseId, String sid) throws IOException {
        String currentLine = null;
        StringBuilder source = new StringBuilder(2800);
        StringBuilder target = new StringBuilder(2800);
        boolean targetTag = false;
        verse.mark(2800);
        while (this.currentChar != -1) {
            try {
                this.currentChar = this.versifiedFileReader.read();
                this.filterBuffer.append((char)this.currentChar);
                if (this.currentChar != 13 && this.currentChar != 10 && this.currentChar != -1) continue;
                this.filterBuffer.setLength(this.filterBuffer.length() - 1);
                currentLine = this.filterBuffer.toString();
                currentLine = Util.trimEnd(currentLine, "\r\n");
                this.filterBuffer = new StringBuilder(2799);
                this.newline = this.handleNewline();
                if (currentLine.matches(VERSE) || currentLine.matches(BOOK) || currentLine.matches(CHAPTER)) {
                    verse.reset();
                    break;
                }
                if (currentLine.matches(TARGET)) {
                    targetTag = true;
                    continue;
                }
                if (targetTag) {
                    target.append(currentLine + "\n");
                } else {
                    source.append(currentLine + "\n");
                }
                verse.mark(2800);
            }
            catch (IOException e) {
                throw new OkapiIOException("IO error reading versified file at: " + (currentLine == null ? "unkown line" : currentLine), e);
            }
        }
        String modifiedSource = this.chopNewline(source.toString());
        String modifiedTarget = this.chopNewline(target.toString());
        if (this.currentChar != -1) {
            if (targetTag) {
                modifiedSource = this.chopNewline(modifiedSource);
                modifiedTarget = this.chopNewline(modifiedTarget);
            } else {
                modifiedSource = this.chopNewline(this.chopNewline(modifiedSource));
            }
        } else if (targetTag) {
            modifiedTarget = Util.trimEnd(modifiedTarget, "\n");
        } else {
            modifiedSource = Util.trimEnd(modifiedSource, "\n");
        }
        if (targetTag && this.currentChar == -1 && this.chopNewline(modifiedTarget).isEmpty()) {
            modifiedTarget = "";
        }
        this.eventBuilder.startTextUnit();
        ITextUnit tu = this.buildTextUnit(modifiedSource, modifiedTarget, targetTag, this.trados);
        GenericSkeleton skel = new GenericSkeleton();
        skel.addContentPlaceholder(tu);
        if (targetTag) {
            skel.add(this.newline + "<TARGET>" + this.newline);
            skel.addContentPlaceholder(tu, this.getTrgLoc());
        }
        if (this.currentChar != -1) {
            skel.add(this.newline + this.newline);
        }
        tu.setSkeleton(skel);
        Matcher m = VERSIFIED_ID_COMPILED.matcher(verseId);
        if (sid != null) {
            tu.setName(sid);
            tu.setId(verseId);
        } else if (m.matches()) {
            tu.setName(this.currentBook + ":" + this.currentChapter + ":" + m.group(1));
            tu.setId(this.currentChapter + (this.currentChapter != null && this.currentChapter.isEmpty() ? "" : ":") + m.group(1));
        } else {
            tu.setName(verseId);
            tu.setId(verseId);
        }
        tu.setMimeType(this.getMimeType());
        this.eventBuilder.endTextUnit();
    }

    private String replacePlacebles(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        for (String r : REPLACABLES.keySet()) {
            text = text.replace(r, REPLACABLES.get(r));
        }
        return text;
    }

    private ITextUnit buildTextUnit(String source, String target, boolean targetTag, boolean trados) {
        ITextUnit tu = this.eventBuilder.peekTempEvent().getTextUnit();
        source = this.replacePlacebles(source);
        target = this.replacePlacebles(target);
        if (trados) {
            tu = this.buildTextUnitForTrados(source);
        } else {
            this.buildTextUnitForNonTrados(source, true);
            if (targetTag) {
                this.buildTextUnitForNonTrados(target, false);
            }
        }
        return tu;
    }

    private ITextUnit buildTextUnitForTrados(String text) {
        ITextUnit tu = this.eventBuilder.peekTempEvent().getTextUnit();
        Matcher m = TRADOS_SEGMENTS_COMPILED.matcher(text);
        int i = 0;
        if (m.find()) {
            tu.createTarget(this.getTrgLoc(), true, 0);
            m.reset();
            while (m.find()) {
                Segment srcSeg = new Segment(Integer.toString(++i), this.buildTextFragment(m.group(1)));
                Segment trgSeg = new Segment(Integer.toString(i), this.buildTextFragment(m.group(2)));
                tu.getSource().append(srcSeg);
                tu.getTarget(this.getTrgLoc()).append(trgSeg);
            }
            tu.getTarget(this.getTrgLoc()).getSegments().setAlignmentStatus(AlignmentStatus.ALIGNED);
        } else {
            if (TRADOS_LEAVINGS_COMPILED.matcher(text).find()) {
                throw new OkapiBadFilterInputException("Trados segment markers found in source or target text: " + text);
            }
            this.buildTextUnitForNonTrados(text, true);
            this.LOGGER.warn("In a Trados bilingual document but found no segment markers. Treating as monlingual text: " + text);
        }
        return tu;
    }

    private TextFragment buildTextFragment(String text) {
        TextFragment tf = new TextFragment();
        Matcher m = PLACEHOLDER_PATTERN.matcher(text);
        if (m.find()) {
            m.reset();
            String[] chunks = PLACEHOLDER_PATTERN.split(text);
            for (int i = 0; i < chunks.length; ++i) {
                tf.append(chunks[i]);
                if (!m.find()) continue;
                String ph = text.substring(m.start(), m.end());
                Code c = new Code(TextFragment.TagType.PLACEHOLDER, ph, ph);
                c.setId(Integer.parseInt(m.group(2)));
                tf.append(c);
            }
        } else {
            tf.append(text);
        }
        return tf;
    }

    private void buildTextUnitForNonTrados(String text, boolean source) {
        if (TRADOS_LEAVINGS_COMPILED.matcher(text).find()) {
            throw new OkapiBadFilterInputException("Trados segment markers found in source or target text: " + text);
        }
        if (source) {
            this.eventBuilder.setTargetLocale(null);
        } else {
            this.eventBuilder.setTargetLocale(this.getTrgLoc());
        }
        Matcher m = PLACEHOLDER_PATTERN.matcher(text);
        if (m.find()) {
            m.reset();
            String[] chunks = PLACEHOLDER_PATTERN.split(text);
            for (int i = 0; i < chunks.length; ++i) {
                this.eventBuilder.addToTextUnit(chunks[i]);
                if (!m.find()) continue;
                String ph = text.substring(m.start(), m.end());
                Code c = new Code(TextFragment.TagType.PLACEHOLDER, ph, ph);
                c.setId(Integer.parseInt(m.group(2)));
                this.eventBuilder.addToTextUnit(c);
            }
        } else {
            this.eventBuilder.addToTextUnit(text);
        }
    }

    private void handleDocumentPart(String part) {
        this.eventBuilder.addDocumentPart(part);
    }

    private String chopNewline(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        if (text.charAt(text.length() - 1) == '\n') {
            return text.substring(0, text.length() - 1);
        }
        return text;
    }

    static {
        REPLACABLES.put("{tab}", "\t");
        REPLACABLES.put("{nb}", "\u00a0");
        REPLACABLES.put("{em}", "\u2014");
        REPLACABLES.put("{en}", "\u2013");
        REPLACABLES.put("{emsp}", "\u2003");
        REPLACABLES.put("{ensp}", "\u2002");
        VERSIFIED_ID_COMPILED = Pattern.compile(VERSIFIED_ID);
        VERSE_COMPILED = Pattern.compile(VERSE);
        TRADOS_SEGMENTS_COMPILED = Pattern.compile(TRADOS_SEGMENTS, 104);
        TRADOS_LEAVINGS_COMPILED = Pattern.compile(TRADOS_LEAVINGS, 104);
        PLACEHOLDER_PATTERN = Pattern.compile(PLACEHOLDER);
    }
}

