/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.wiki;

import java.util.Map;
import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.filters.wiki.WikiFilter;
import org.yaml.snakeyaml.Yaml;

public class Parameters
extends BaseParameters {
    public static final String WIKI_PARAMETERS = "wikiConfiguration.yml";
    private Yaml yaml = new Yaml();
    private Map<String, Object> config;
    private boolean preserveWhitespace = false;

    public Parameters() {
        this.reset();
    }

    @Override
    public void reset() {
        this.config = (Map)this.yaml.load(WikiFilter.class.getResourceAsStream(WIKI_PARAMETERS));
        this.initialize();
    }

    private void initialize() {
        Object whitespace = this.config.get("preserve_whitespace");
        if (whitespace != null) {
            this.preserveWhitespace = (Boolean)whitespace;
        }
    }

    @Override
    public String toString() {
        return this.yaml.dump(this.config);
    }

    @Override
    public void fromString(String data) {
        this.config = (Map)this.yaml.load(data);
        this.initialize();
    }

    public boolean isPreserveWhitespace() {
        return this.preserveWhitespace;
    }
}

