/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.wiki;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiFileNotFoundException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.ISkeletonWriter;

public class WikiWriter
implements IFilterWriter {
    private OutputStream output;
    private String outputPath;
    private OutputStreamWriter writer;
    private LocaleId language;
    private String encoding;
    private String linebreak;
    private File tempFile;
    private GenericContent formatter = new GenericContent();
    private HashMap<String, String> referencedText = new HashMap();

    @Override
    public String getName() {
        return "WikiWriter";
    }

    @Override
    public void setOptions(LocaleId language, String defaultEncoding) {
        this.language = language;
        this.encoding = defaultEncoding;
    }

    @Override
    public void setOutput(String path) {
        this.close();
        this.outputPath = path;
    }

    @Override
    public void setOutput(OutputStream output) {
        this.close();
        this.outputPath = null;
        this.output = output;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.processStartDocument(event);
                break;
            }
            case END_DOCUMENT: {
                this.processEndDocument();
                break;
            }
            case START_GROUP: {
                this.processStartGroup(event);
                break;
            }
            case END_GROUP: {
                this.processEndGroup();
                break;
            }
            case TEXT_UNIT: {
                this.processTextUnit(event);
                break;
            }
            case DOCUMENT_PART: {
                this.processDocumentPart(event);
                break;
            }
            default: {
                event = Event.NOOP_EVENT;
            }
        }
        return event;
    }

    private void processEndGroup() {
    }

    private void processStartGroup(Event event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.writer == null) {
            return;
        }
        IOException err = null;
        InputStream orig = null;
        OutputStream dest = null;
        try {
            this.writer.close();
            this.writer = null;
            this.output.close();
            this.output = null;
            if (this.tempFile != null) {
                int len;
                dest = new FileOutputStream(this.outputPath);
                orig = new FileInputStream(this.tempFile);
                byte[] buffer = new byte[2048];
                while ((len = orig.read(buffer)) > 0) {
                    dest.write(buffer, 0, len);
                }
            }
        }
        catch (IOException e) {
            err = e;
        }
        finally {
            if (dest != null) {
                try {
                    dest.close();
                }
                catch (IOException e) {
                    err = e;
                }
                dest = null;
            }
            if (orig != null) {
                try {
                    orig.close();
                }
                catch (IOException e) {
                    err = e;
                }
                orig = null;
                if (err != null) {
                    throw new RuntimeException(err);
                }
                if (this.tempFile != null) {
                    this.tempFile.delete();
                    this.tempFile = null;
                }
            }
        }
    }

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public void setParameters(IParameters params) {
    }

    @Override
    public void cancel() {
    }

    @Override
    public EncoderManager getEncoderManager() {
        return null;
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }

    private void createWriter(StartDocument startDoc) {
        this.linebreak = startDoc.getLineBreak();
        try {
            String originalEnc;
            this.tempFile = null;
            if (this.output == null) {
                boolean useTemp = false;
                File f = new File(this.outputPath);
                if (f.exists()) {
                    boolean bl = useTemp = !f.delete();
                }
                if (useTemp) {
                    this.tempFile = File.createTempFile("wkmrkTmp", null);
                    this.output = new BufferedOutputStream(new FileOutputStream(this.tempFile.getAbsolutePath()));
                } else {
                    Util.createDirectories(this.outputPath);
                    this.output = new BufferedOutputStream(new FileOutputStream(this.outputPath));
                }
            }
            if ((originalEnc = startDoc.getEncoding()) == null) {
                originalEnc = Charset.defaultCharset().name();
            }
            if (this.encoding == null) {
                this.encoding = originalEnc;
            }
            this.writer = new OutputStreamWriter(this.output, this.encoding);
            boolean useUTF8BOM = false;
            if ("utf-8".equalsIgnoreCase(this.encoding) && "utf-8".equalsIgnoreCase(originalEnc)) {
                useUTF8BOM = false;
            }
            Util.writeBOMIfNeeded(this.writer, useUTF8BOM, this.encoding);
        }
        catch (FileNotFoundException e) {
            throw new OkapiFileNotFoundException(e);
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    private void processStartDocument(Event event) {
        StartDocument sd = event.getStartDocument();
        this.createWriter(sd);
        this.referencedText.clear();
    }

    private void processEndDocument() {
        this.close();
    }

    private void processTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        GenericSkeleton skel = (GenericSkeleton)tu.getSkeleton();
        assert (skel != null);
        StringBuilder tuText = new StringBuilder();
        tuText.append(skel.toString());
        TextContainer bodyContainer = null;
        bodyContainer = tu.hasTarget(this.language) ? tu.getTarget(this.language) : tu.getSource();
        this.referencedText.put("$self$", this.formatter.printSegmentedContent(bodyContainer, false, true));
        Object[] refMarkInfo = TextFragment.getRefMarker(tuText);
        while (refMarkInfo != null) {
            assert (this.referencedText.containsKey(refMarkInfo[0]));
            tuText.replace((Integer)refMarkInfo[1], (Integer)refMarkInfo[2], this.referencedText.get(refMarkInfo[0]));
            refMarkInfo = TextFragment.getRefMarker(tuText);
        }
        if (tu.getReferenceCount() > 0) {
            this.referencedText.put(tu.getId(), tuText.toString());
            return;
        }
        try {
            this.writer.write(tuText.toString());
        }
        catch (IOException e) {
            throw new OkapiIOException("Error writing a wiki markup file.", e);
        }
    }

    private void processDocumentPart(Event event) {
        try {
            DocumentPart part = event.getDocumentPart();
            this.writer.write(part.toString());
        }
        catch (IOException e) {
            throw new OkapiIOException("Error writing a wiki markup file.", e);
        }
    }
}

