/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.extra.steps;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.lib.extra.OkapiComponent;

public abstract class AbstractPipelineStep
extends OkapiComponent
implements IPipelineStep {
    private LocaleId srcLoc;
    private LocaleId trgLoc;
    private boolean isLastOutputStep = false;

    protected LocaleId getSourceLocale() {
        return this.srcLoc;
    }

    protected LocaleId getTargetLocale() {
        return this.trgLoc;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public String getHelpLocation() {
        return this.getName() + " Step";
    }

    @Override
    public Event handleEvent(Event event) {
        if (event == null) {
            return null;
        }
        switch (event.getEventType()) {
            case START_BATCH: {
                this.component_init();
                event = this.handleStartBatch(event);
                break;
            }
            case END_BATCH: {
                this.component_done();
                event = this.handleEndBatch(event);
                break;
            }
            case START_BATCH_ITEM: {
                event = this.handleStartBatchItem(event);
                break;
            }
            case END_BATCH_ITEM: {
                event = this.handleEndBatchItem(event);
                break;
            }
            case RAW_DOCUMENT: {
                event = this.handleRawDocument(event);
                break;
            }
            case START_DOCUMENT: {
                event = this.handleStartDocument(event);
                break;
            }
            case END_DOCUMENT: {
                event = this.handleEndDocument(event);
                break;
            }
            case START_SUBDOCUMENT: {
                event = this.handleStartSubDocument(event);
                break;
            }
            case END_SUBDOCUMENT: {
                event = this.handleEndSubDocument(event);
                break;
            }
            case START_GROUP: {
                event = this.handleStartGroup(event);
                break;
            }
            case END_GROUP: {
                event = this.handleEndGroup(event);
                break;
            }
            case START_SUBFILTER: {
                event = this.handleStartSubfilter(event);
                break;
            }
            case END_SUBFILTER: {
                event = this.handleEndSubfilter(event);
                break;
            }
            case TEXT_UNIT: {
                event = this.handleTextUnit(event);
                break;
            }
            case DOCUMENT_PART: {
                event = this.handleDocumentPart(event);
                break;
            }
            case CUSTOM: {
                event = this.handleCustom(event);
            }
        }
        return event;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public boolean isLastOutputStep() {
        return this.isLastOutputStep;
    }

    @Override
    public void setLastOutputStep(boolean isLastStep) {
        this.isLastOutputStep = isLastStep;
    }

    protected Event handleStartBatch(Event event) {
        return event;
    }

    protected Event handleEndBatch(Event event) {
        return event;
    }

    protected Event handleStartBatchItem(Event event) {
        return event;
    }

    protected Event handleEndBatchItem(Event event) {
        return event;
    }

    protected Event handleRawDocument(Event event) {
        return event;
    }

    protected Event handleStartDocument(Event event) {
        StartDocument sd = (StartDocument)event.getResource();
        if (sd != null) {
            this.srcLoc = sd.getLocale();
        }
        return event;
    }

    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourceLocale(LocaleId sourceLocale) {
        this.srcLoc = sourceLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.trgLoc = targetLocale;
    }

    protected Event handleEndDocument(Event event) {
        return event;
    }

    protected Event handleStartSubDocument(Event event) {
        return event;
    }

    protected Event handleEndSubDocument(Event event) {
        return event;
    }

    protected Event handleStartGroup(Event event) {
        return event;
    }

    protected Event handleEndGroup(Event event) {
        return event;
    }

    protected Event handleStartSubfilter(Event event) {
        return event;
    }

    protected Event handleEndSubfilter(Event event) {
        return event;
    }

    protected Event handleTextUnit(Event event) {
        return event;
    }

    protected Event handleDocumentPart(Event event) {
        return event;
    }

    protected Event handleCustom(Event event) {
        return event;
    }
}

