/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.okapi.common.ClassUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.lib.persistence.IPersistenceBean;
import net.sf.okapi.lib.persistence.IPersistenceSession;
import net.sf.okapi.lib.persistence.NamespaceMapper;
import net.sf.okapi.lib.persistence.SessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanMapper {
    private static final String MAPPER_NOT_INIT = "BeanMapper: bean mapping is not initialized";
    private static final String MAPPER_UNK_CLASS = "BeanMapper: unknown class: %s";
    private static final String MAPPER_EMPTY_REF = "BeanMapper: class reference cannot be empty";
    private static final String MAPPER_NOT_REG = "No bean class registered for %s, using %s for %s instead.";
    private static final String OBJ_MAPPER_NOT_INIT = "BeanMapper: object mapping is not initialized";
    private static final String OBJ_MAPPER_EMPTY_REF = "BeanMapper: bean class reference cannot be empty";
    private static final String PROXIES_CANT_INST = "BeanMapper: cannot instantiate a proxy for %s";
    private static final String PROXIES_NOT_INIT = "BeanMapper: proxy mapping is not initialized";
    private LinkedHashMap<Class<?>, Class<? extends IPersistenceBean<?>>> beanClassMapping;
    private HashMap<Class<? extends IPersistenceBean<?>>, Class<?>> objectClassMapping;
    private ArrayList<Class<?>> loggedClasses;
    private ArrayList<String> loggedClassNames;
    private ConcurrentHashMap<String, IPersistenceBean<?>> proxies;
    private IPersistenceSession session;
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    public BeanMapper(IPersistenceSession session) {
        this.session = session;
        this.beanClassMapping = new LinkedHashMap();
        this.objectClassMapping = new HashMap();
        this.proxies = new ConcurrentHashMap();
        this.loggedClasses = new ArrayList();
        this.loggedClassNames = new ArrayList();
    }

    public void reset() {
        this.beanClassMapping.clear();
        this.objectClassMapping.clear();
        this.proxies.clear();
        this.loggedClasses.clear();
        this.loggedClassNames.clear();
    }

    public void registerBean(Class<?> classRef, Class<? extends IPersistenceBean<?>> beanClassRef) {
        if (classRef == null || beanClassRef == null) {
            throw new IllegalArgumentException();
        }
        if (this.beanClassMapping == null) {
            throw new RuntimeException(MAPPER_NOT_INIT);
        }
        this.beanClassMapping.put(classRef, beanClassRef);
        if (this.objectClassMapping == null) {
            throw new RuntimeException(OBJ_MAPPER_NOT_INIT);
        }
        this.objectClassMapping.put(beanClassRef, classRef);
        if (this.proxies == null) {
            throw new RuntimeException(PROXIES_NOT_INIT);
        }
        String objClassName = ClassUtil.getQualifiedClassName(classRef);
        String beanClassName = ClassUtil.getQualifiedClassName(classRef);
        try {
            IPersistenceBean<?> proxy = ClassUtil.instantiateClass(beanClassRef);
            if (proxy != null) {
                proxy.setRefId(0L);
            }
            this.proxies.put(objClassName, proxy);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format(PROXIES_CANT_INST, beanClassName), e);
        }
    }

    public <T> Class<IPersistenceBean<T>> getBeanClass(Class<T> classRef) {
        if (classRef == null) {
            throw new IllegalArgumentException(MAPPER_EMPTY_REF);
        }
        if (this.beanClassMapping == null) {
            throw new RuntimeException(MAPPER_NOT_INIT);
        }
        Class<IPersistenceBean<T>> beanClass = this.beanClassMapping.get(classRef);
        if (beanClass == null) {
            if (IPersistenceBean.class.isAssignableFrom(classRef)) {
                beanClass = classRef;
            } else {
                for (Class<T> clazz : this.beanClassMapping.keySet()) {
                    if (!clazz.isAssignableFrom(classRef)) continue;
                    beanClass = this.beanClassMapping.get(clazz);
                    if (this.session.getState() != SessionState.WRITING || this.loggedClasses.contains(classRef)) break;
                    this.loggedClasses.add(classRef);
                    this.LOGGER.warn(String.format(MAPPER_NOT_REG, ClassUtil.getQualifiedClassName(classRef), ClassUtil.getQualifiedClassName(beanClass), ClassUtil.getQualifiedClassName(clazz)));
                    break;
                }
            }
            if (beanClass == null && !this.loggedClasses.contains(classRef)) {
                this.loggedClasses.add(classRef);
                this.LOGGER.warn(String.format("No bean class registered for %s", ClassUtil.getQualifiedClassName(classRef)));
            }
        }
        return beanClass;
    }

    public Class<?> getObjectClass(Class<? extends IPersistenceBean<?>> beanClassRef) {
        if (beanClassRef == null) {
            throw new IllegalArgumentException(OBJ_MAPPER_EMPTY_REF);
        }
        if (this.objectClassMapping == null) {
            throw new RuntimeException(OBJ_MAPPER_NOT_INIT);
        }
        return this.objectClassMapping.get(beanClassRef);
    }

    public Class<?> getClass(String objClassName) {
        return ClassUtil.getClass(NamespaceMapper.getMapping(objClassName));
    }

    public IPersistenceBean<?> getProxy(String objClassName) {
        if (Util.isEmpty(objClassName)) {
            return null;
        }
        IPersistenceBean<?> proxy = this.proxies.get(NamespaceMapper.getMapping(objClassName));
        if (proxy == null && !this.loggedClassNames.contains(objClassName)) {
            this.loggedClassNames.add(objClassName);
            this.LOGGER.warn(String.format("No proxy found for %s", objClassName));
        }
        return proxy;
    }

    public IPersistenceBean<?> getProxy(Class<?> objClassRef) {
        if (objClassRef == null) {
            return null;
        }
        return this.getProxy(objClassRef.getName());
    }

    public Class<? extends IPersistenceBean<?>> getBeanClass(String className) {
        Class<IPersistenceBean<?>> res = null;
        try {
            res = this.getBeanClass(Class.forName(NamespaceMapper.getMapping(className)));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(String.format(MAPPER_UNK_CLASS, className));
        }
        return res;
    }
}

