/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.persistence;

import net.sf.okapi.common.ClassUtil;
import net.sf.okapi.lib.persistence.IPersistenceBean;
import net.sf.okapi.lib.persistence.IPersistenceSession;
import net.sf.okapi.lib.persistence.ReferenceResolver;

public abstract class PersistenceBean<PutCoreClassHere>
implements IPersistenceBean<PutCoreClassHere> {
    private long refId = ReferenceResolver.generateRefId();
    private boolean busy = false;

    protected abstract PutCoreClassHere createObject(IPersistenceSession var1);

    protected abstract void setObject(PutCoreClassHere var1, IPersistenceSession var2);

    protected abstract void fromObject(PutCoreClassHere var1, IPersistenceSession var2);

    @Override
    public long getRefId() {
        return this.refId;
    }

    @Override
    public void setRefId(long refId) {
        this.refId = refId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T get(Class<T> classRef, IPersistenceSession session) {
        if (this.busy) {
            throw new RuntimeException(String.format("PersistenceBean: recursive get() in %s", ClassUtil.getQualifiedClassName(this.getClass())));
        }
        Object obj = session.getObject(this.refId);
        if (obj == null) {
            this.busy = true;
            try {
                obj = this.createObject(session);
            }
            finally {
                this.busy = false;
            }
        }
        if (obj != null && this.refId != 0L) {
            session.setRefIdForObject(obj, this.refId);
            this.setObject(obj, session);
        }
        return classRef.cast(obj);
    }

    @Override
    public IPersistenceBean<PutCoreClassHere> set(PutCoreClassHere obj, IPersistenceSession session) {
        if (obj != null) {
            this.fromObject(obj, session);
        }
        return this;
    }
}

