/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.ReferenceParameter;
import net.sf.okapi.lib.verification.PatternItem;
import net.sf.okapi.lib.verification.QualityCheckSession;

public class Parameters
extends BaseParameters {
    public static final String FILE_EXTENSION = ".qccfg";
    public static final int SCOPE_ALL = 0;
    public static final int SCOPE_APPROVEDONLY = 1;
    public static final int SCOPE_NOTAPPROVEDONLY = 2;
    private static final String OUTPUTPATH = "outputPath";
    private static final String OUTPUTTYPE = "outputType";
    private static final String AUTOOPEN = "autoOpen";
    private static final String LEADINGWS = "leadingWS";
    private static final String TRAILINGWS = "trailingWS";
    private static final String EMPTYTARGET = "emptyTarget";
    private static final String EMPTYSOURCE = "emptySource";
    private static final String TARGETSAMEASSOURCE = "targetSameAsSource";
    private static final String TARGETSAMEASSOURCE_FORSAMELANGUAGE = "targetSameAsSourceForSameLanguage";
    private static final String TARGETSAMEASSOURCE_WITHCODES = "targetSameAsSourceWithCodes";
    private static final String CODEDIFFERENCE = "codeDifference";
    private static final String GUESSOPENCLOSE = "guessOpenClose";
    private static final String CHECKXLIFFSCHEMA = "checkXliffSchema";
    private static final String CHECKPATTERNS = "checkPatterns";
    private static final String PATTERNCOUNT = "patternCount";
    private static final String USEPATTERN = "usePattern";
    private static final String FROMSOURCEPATTERN = "fromSourcePattern";
    private static final String SEVERITYPATTERN = "severityPattern";
    private static final String SOURCEPATTERN = "sourcePattern";
    private static final String TARGETPATTERN = "targetPattern";
    private static final String DESCPATTERN = "descPattern";
    private static final String CHECKWITHLT = "checkWithLT";
    private static final String SERVERURL = "serverURL";
    private static final String TRANSLATELTMSG = "translateLTMsg";
    private static final String LTBILINGUALMODE = "ltBilingualMode";
    private static final String LTTRANSLATIONSOURCE = "ltTranslationSource";
    private static final String LTTRANSLATIONTARGET = "ltTranslationTarget";
    private static final String LTTRANSLATIONSERVICEKEY = "ltTranslationServiceKey";
    private static final String SAVESESSION = "saveSession";
    private static final String SESSIONPATH = "sessionPath";
    private static final String DOUBLEDWORD = "doubledWord";
    private static final String DOUBLEDWORDEXCEPTIONS = "doubledWordExceptions";
    private static final String CHECKSTORAGESIZE = "checkStorageSize";
    private static final String CHECKMAXCHARLENGTH = "checkMaxCharLength";
    private static final String MAXCHARLENGTHBREAK = "maxCharLengthBreak";
    private static final String MAXCHARLENGTHABOVE = "maxCharLengthAbove";
    private static final String MAXCHARLENGTHBELOW = "maxCharLengthBelow";
    private static final String CHECKMINCHARLENGTH = "checkMinCharLength";
    private static final String MINCHARLENGTHBREAK = "minCharLengthBreak";
    private static final String MINCHARLENGTHABOVE = "minCharLengthAbove";
    private static final String MINCHARLENGTHBELOW = "minCharLengthBelow";
    private static final String CHECKABSOLUTEMAXCHARLENGTH = "checkAbsoluteMaxCharLength";
    private static final String ABSOLUTEMAXCHARLENGTH = "absoluteMaxCharLength";
    private static final String CHECKCHARACTERS = "checkCharacters";
    private static final String CHECKALLOWEDCHARACTERS = "checkAllowedCharacters";
    private static final String CHARSET = "charset";
    private static final String EXTRACHARSALLOWED = "extraCharsAllowed";
    private static final String CORRUPTEDCHARACTERS = "corruptedCharacters";
    private static final String SCOPE = "scope";
    private static final String EXTRACODESALLOWED = "extraCodesAllowed";
    private static final String MISSINGCODESALLOWED = "missingCodesAllowed";
    private static final String CHECKTERMS = "checkTerms";
    private static final String TERMSPATH = "termsPath";
    private static final String STRINGMODE = "stringMode";
    private static final String BETWEENCODES = "betweenCodes";
    private static final String TYPESTOIGNORE = "typesToIgnore";
    String outputPath;
    int outputType;
    boolean autoOpen;
    boolean leadingWS;
    boolean trailingWS;
    boolean emptyTarget;
    boolean emptySource;
    boolean targetSameAsSource;
    boolean targetSameAsSourceForSameLanguage;
    boolean targetSameAsSourceWithCodes;
    boolean codeDifference;
    boolean guessOpenClose;
    boolean checkXliffSchema;
    boolean checkPatterns;
    List<PatternItem> patterns;
    boolean checkWithLT;
    String serverURL;
    boolean translateLTMsg;
    boolean ltBilingualMode;
    String ltTranslationSource;
    String ltTranslationTarget;
    String ltTranslationServiceKey;
    boolean saveSession;
    String sessionPath;
    boolean doubledWord;
    String doubledWordExceptions;
    boolean checkStorageSize;
    boolean checkMaxCharLength;
    int maxCharLengthBreak;
    int maxCharLengthAbove;
    int maxCharLengthBelow;
    boolean checkMinCharLength;
    int minCharLengthBreak;
    int minCharLengthAbove;
    int minCharLengthBelow;
    boolean checkAbsoluteMaxCharLength;
    int absoluteMaxCharLength;
    boolean checkCharacters;
    boolean checkAllowedCharacters;
    String charset;
    String extraCharsAllowed;
    boolean corruptedCharacters;
    int scope;
    List<String> extraCodesAllowed;
    List<String> missingCodesAllowed;
    String typesToIgnore;
    boolean checkTerms;
    String termsPath;
    boolean stringMode;
    boolean betweenCodes;

    public Parameters() {
        this.reset();
    }

    public List<String> getExtraCodesAllowed() {
        return this.extraCodesAllowed;
    }

    public List<String> getMissingCodesAllowed() {
        return this.missingCodesAllowed;
    }

    public String getTypesToIgnore() {
        return this.typesToIgnore;
    }

    public void setTypesToIgnore(String typesToIgnore) {
        this.typesToIgnore = typesToIgnore;
    }

    public int getScope() {
        return this.scope;
    }

    public void setScope(int scope) {
        this.scope = scope;
    }

    public boolean getCorruptedCharacters() {
        return this.corruptedCharacters;
    }

    public void setCorruptedCharacters(boolean corruptedCharacters) {
        this.corruptedCharacters = corruptedCharacters;
    }

    public boolean getCheckAllowedCharacters() {
        return this.checkAllowedCharacters;
    }

    public void setCheckAllowedCharacters(boolean checkAllowedCharacters) {
        this.checkAllowedCharacters = checkAllowedCharacters;
    }

    public boolean getCheckCharacters() {
        return this.checkCharacters;
    }

    public void setCheckCharacters(boolean checkCharacters) {
        this.checkCharacters = checkCharacters;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getExtraCharsAllowed() {
        return this.extraCharsAllowed;
    }

    public void setExtraCharsAllowed(String extraCharsAllowed) {
        this.extraCharsAllowed = extraCharsAllowed;
    }

    public boolean getCheckStorageSize() {
        return this.checkStorageSize;
    }

    public void setCheckStorageSize(boolean checkStorageSize) {
        this.checkStorageSize = checkStorageSize;
    }

    public boolean getCheckMaxCharLength() {
        return this.checkMaxCharLength;
    }

    public void setCheckMaxCharLength(boolean checkMaxCharLength) {
        this.checkMaxCharLength = checkMaxCharLength;
    }

    public int getMaxCharLengthBreak() {
        return this.maxCharLengthBreak;
    }

    public void setMaxCharLengthBreak(int maxCharLengthBreak) {
        this.maxCharLengthBreak = maxCharLengthBreak;
    }

    public int getMaxCharLengthAbove() {
        return this.maxCharLengthAbove;
    }

    public void setMaxCharLengthAbove(int maxCharLengthAbove) {
        this.maxCharLengthAbove = maxCharLengthAbove;
    }

    public int getMaxCharLengthBelow() {
        return this.maxCharLengthBelow;
    }

    public void setMaxCharLengthBelow(int maxCharLengthBelow) {
        this.maxCharLengthBelow = maxCharLengthBelow;
    }

    public boolean getCheckMinCharLength() {
        return this.checkMinCharLength;
    }

    public void setCheckMinCharLength(boolean checkMinCharLength) {
        this.checkMinCharLength = checkMinCharLength;
    }

    public int getMinCharLengthBreak() {
        return this.minCharLengthBreak;
    }

    public void setMinCharLengthBreak(int minCharLengthBreak) {
        this.minCharLengthBreak = minCharLengthBreak;
    }

    public int getMinCharLengthAbove() {
        return this.minCharLengthAbove;
    }

    public void setMinCharLengthAbove(int minCharLengthAbove) {
        this.minCharLengthAbove = minCharLengthAbove;
    }

    public int getMinCharLengthBelow() {
        return this.minCharLengthBelow;
    }

    public void setMinCharLengthBelow(int minCharLengthBelow) {
        this.minCharLengthBelow = minCharLengthBelow;
    }

    public boolean getCheckAbsoluteMaxCharLength() {
        return this.checkAbsoluteMaxCharLength;
    }

    public void setCheckAbsoluteMaxCharLength(boolean checkAbsoluteMaxCharLength) {
        this.checkAbsoluteMaxCharLength = checkAbsoluteMaxCharLength;
    }

    public int getAbsoluteMaxCharLength() {
        return this.absoluteMaxCharLength;
    }

    public void setAbsoluteMaxCharLength(int absoluteMaxCharLength) {
        this.absoluteMaxCharLength = absoluteMaxCharLength;
    }

    public boolean getDoubledWord() {
        return this.doubledWord;
    }

    public void setDoubledWord(boolean doubledWord) {
        this.doubledWord = doubledWord;
    }

    public String getDoubledWordExceptions() {
        return this.doubledWordExceptions;
    }

    public void setDoubledWordExceptions(String doubledWordExceptions) {
        this.doubledWordExceptions = doubledWordExceptions;
    }

    public boolean getSaveSession() {
        return this.saveSession;
    }

    public void setSaveSession(boolean saveSession) {
        this.saveSession = saveSession;
    }

    public String getSessionPath() {
        return this.sessionPath;
    }

    public void setSessionPath(String sessionPath) {
        this.sessionPath = sessionPath;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public int getOutputType() {
        return this.outputType;
    }

    public void setOutputType(int outputType) {
        this.outputType = outputType;
    }

    public boolean getAutoOpen() {
        return this.autoOpen;
    }

    public void setAutoOpen(boolean autoOpen) {
        this.autoOpen = autoOpen;
    }

    public boolean getLeadingWS() {
        return this.leadingWS;
    }

    public void setLeadingWS(boolean leadingWS) {
        this.leadingWS = leadingWS;
    }

    public boolean getTrailingWS() {
        return this.trailingWS;
    }

    public void setTrailingWS(boolean trailingWS) {
        this.trailingWS = trailingWS;
    }

    public boolean getEmptyTarget() {
        return this.emptyTarget;
    }

    public void setEmptyTarget(boolean emptyTarget) {
        this.emptyTarget = emptyTarget;
    }

    public boolean getEmptySource() {
        return this.emptySource;
    }

    public void setEmptySource(boolean emptySource) {
        this.emptySource = emptySource;
    }

    public boolean getTargetSameAsSource() {
        return this.targetSameAsSource;
    }

    public void setTargetSameAsSource(boolean targetSameAsSource) {
        this.targetSameAsSource = targetSameAsSource;
    }

    public boolean getTargetSameAsSourceForSameLanguage() {
        return this.targetSameAsSourceForSameLanguage;
    }

    public void setTargetSameAsSourceForSameLanguage(boolean targetSameAsSourceForSameLanguage) {
        this.targetSameAsSourceForSameLanguage = targetSameAsSourceForSameLanguage;
    }

    public boolean getTargetSameAsSourceWithCodes() {
        return this.targetSameAsSourceWithCodes;
    }

    public void setTargetSameAsSourceWithCodes(boolean targetSameAsSourceWithCodes) {
        this.targetSameAsSourceWithCodes = targetSameAsSourceWithCodes;
    }

    public boolean getCodeDifference() {
        return this.codeDifference;
    }

    public void setCodeDifference(boolean codeDifference) {
        this.codeDifference = codeDifference;
    }

    public boolean getGuessOpenClose() {
        return this.guessOpenClose;
    }

    public void setGuessOpenClose(boolean guessOpenClose) {
        this.guessOpenClose = guessOpenClose;
    }

    public boolean getCheckXliffSchema() {
        return this.checkXliffSchema;
    }

    public void setCheckXliffSchema(boolean schema) {
        this.checkXliffSchema = schema;
    }

    public boolean getCheckPatterns() {
        return this.checkPatterns;
    }

    public void setCheckPatterns(boolean patterns) {
        this.checkPatterns = patterns;
    }

    public List<PatternItem> getPatterns() {
        return this.patterns;
    }

    public void setPatterns(List<PatternItem> patterns) {
        this.patterns = patterns;
    }

    public boolean getCheckWithLT() {
        return this.checkWithLT;
    }

    public void setCheckWithLT(boolean checkWithLT) {
        this.checkWithLT = checkWithLT;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public void setServerURL(String serverURL) {
        this.serverURL = serverURL;
    }

    public boolean getTranslateLTMsg() {
        return this.translateLTMsg;
    }

    public void setTranslateLTMsg(boolean translateLTMsg) {
        this.translateLTMsg = translateLTMsg;
    }

    public boolean getLtBilingualMode() {
        return this.ltBilingualMode;
    }

    public void setLtBilingualMode(boolean ltBilingualMode) {
        this.ltBilingualMode = ltBilingualMode;
    }

    public String getLtTranslationSource() {
        return this.ltTranslationSource;
    }

    public void setLtTranslationSource(String ltTranslationSource) {
        this.ltTranslationSource = ltTranslationSource;
    }

    public String getLtTranslationTarget() {
        return this.ltTranslationTarget;
    }

    public void setLtTranslationTarget(String ltTranslationTarget) {
        this.ltTranslationTarget = ltTranslationTarget;
    }

    public String getLtTranslationServiceKey() {
        return this.ltTranslationServiceKey;
    }

    public void setLtTranslationServiceKey(String ltTranslationServiceKey) {
        this.ltTranslationServiceKey = ltTranslationServiceKey;
    }

    public boolean getCheckTerms() {
        return this.checkTerms;
    }

    public void setCheckTerms(boolean checkTerms) {
        this.checkTerms = checkTerms;
    }

    public boolean getStringMode() {
        return this.stringMode;
    }

    public void setStringMode(boolean stringMode) {
        this.stringMode = stringMode;
    }

    public boolean getBetweenCodes() {
        return this.betweenCodes;
    }

    public void setBetweenCodes(boolean betweenCodes) {
        this.betweenCodes = betweenCodes;
    }

    @ReferenceParameter
    public String getTermsPath() {
        return this.termsPath;
    }

    public void setTermsPath(String termsPath) {
        this.termsPath = termsPath;
    }

    @Override
    public void reset() {
        this.outputPath = "${rootDir}/qa-report.html";
        this.outputType = 0;
        this.autoOpen = true;
        this.leadingWS = true;
        this.trailingWS = true;
        this.emptyTarget = true;
        this.emptySource = true;
        this.targetSameAsSource = true;
        this.targetSameAsSourceForSameLanguage = false;
        this.targetSameAsSourceWithCodes = true;
        this.codeDifference = true;
        this.guessOpenClose = true;
        this.checkXliffSchema = true;
        this.checkPatterns = true;
        this.checkWithLT = false;
        this.serverURL = "http://localhost:8081/";
        this.translateLTMsg = false;
        this.ltBilingualMode = false;
        this.ltTranslationSource = "";
        this.ltTranslationTarget = "en";
        this.ltTranslationServiceKey = "";
        this.saveSession = true;
        this.sessionPath = "${rootDir}/qa-session" + QualityCheckSession.FILE_EXTENSION;
        this.doubledWord = true;
        this.doubledWordExceptions = "sie;vous;nous";
        this.corruptedCharacters = true;
        this.scope = 0;
        this.checkMaxCharLength = true;
        this.maxCharLengthBreak = 20;
        this.maxCharLengthAbove = 200;
        this.maxCharLengthBelow = 350;
        this.checkMinCharLength = true;
        this.minCharLengthBreak = 20;
        this.minCharLengthAbove = 45;
        this.minCharLengthBelow = 30;
        this.checkStorageSize = true;
        this.checkAbsoluteMaxCharLength = false;
        this.absoluteMaxCharLength = 255;
        this.checkAllowedCharacters = true;
        this.checkCharacters = false;
        this.charset = "ISO-8859-1";
        this.extraCharsAllowed = "";
        this.checkTerms = false;
        this.termsPath = "";
        this.stringMode = false;
        this.betweenCodes = false;
        this.patterns = new ArrayList<PatternItem>();
        this.patterns.add(new PatternItem("[\\(\\)]", "<same>", true, 0, "Parentheses"));
        this.patterns.add(new PatternItem("[\\p{Ps}\\p{Pe}&&[^\\(\\)]]", "<same>", true, 0, "Bracketing characters (except parentheses)"));
        this.patterns.add(new PatternItem("[\\w\\.\\-]+@[\\w\\.\\-]+", "<same>", true, 1, "Email addresses"));
        this.patterns.add(new PatternItem("https?:[\\w/\\.:;+\\-~\\%#\\$?=&,()]+[\\w/:;+\\-~\\%#\\$?=&,()]+|www\\.[\\w/\\.:;+\\-~\\%#\\$?=&,()]+|ftp:[\\w/\\.:;+\\-~\\%#?=&,]+", "<same>", true, 1, "URLs"));
        this.patterns.add(new PatternItem("\\b(?:\\d{1,3}\\.){3}\\d{1,3}\\b", "<same>", true, 2, "IP addresses"));
        this.patterns.add(new PatternItem("%(([-0+#]?)[-0+#]?)((\\d\\$)?)(([\\d\\*]*)(\\.[\\d\\*]*)?)[dioxXucsfeEgGpn]", "<same>", true, 2, "C-style printf codes"));
        PatternItem item = new PatternItem("<same>", "([\\p{Ll}\\p{Lu}\\p{Lt}\\p{Lo}])\\1\\1", true, 1, "Tripled letter");
        item.fromSource = false;
        this.patterns.add(item);
        this.extraCodesAllowed = new ArrayList<String>();
        this.missingCodesAllowed = new ArrayList<String>();
        this.typesToIgnore = "mrk;x-df-s;";
    }

    @Override
    public void fromString(String data) {
        int i;
        this.reset();
        this.buffer.fromString(data);
        this.outputPath = this.buffer.getString(OUTPUTPATH, this.outputPath);
        this.outputType = this.buffer.getInteger(OUTPUTTYPE, this.outputType);
        this.autoOpen = this.buffer.getBoolean(AUTOOPEN, this.autoOpen);
        this.leadingWS = this.buffer.getBoolean(LEADINGWS, this.leadingWS);
        this.trailingWS = this.buffer.getBoolean(TRAILINGWS, this.trailingWS);
        this.emptyTarget = this.buffer.getBoolean(EMPTYTARGET, this.emptyTarget);
        this.emptySource = this.buffer.getBoolean(EMPTYSOURCE, this.emptySource);
        this.targetSameAsSource = this.buffer.getBoolean(TARGETSAMEASSOURCE, this.targetSameAsSource);
        this.targetSameAsSourceForSameLanguage = this.buffer.getBoolean(TARGETSAMEASSOURCE_FORSAMELANGUAGE, this.targetSameAsSourceForSameLanguage);
        this.targetSameAsSourceWithCodes = this.buffer.getBoolean(TARGETSAMEASSOURCE_WITHCODES, this.targetSameAsSourceWithCodes);
        this.codeDifference = this.buffer.getBoolean(CODEDIFFERENCE, this.codeDifference);
        this.guessOpenClose = this.buffer.getBoolean(GUESSOPENCLOSE, this.guessOpenClose);
        this.checkWithLT = this.buffer.getBoolean(CHECKWITHLT, this.checkWithLT);
        this.serverURL = this.buffer.getString(SERVERURL, this.serverURL);
        this.translateLTMsg = this.buffer.getBoolean(TRANSLATELTMSG, this.translateLTMsg);
        this.ltBilingualMode = this.buffer.getBoolean(LTBILINGUALMODE, this.ltBilingualMode);
        this.ltTranslationSource = this.buffer.getString(LTTRANSLATIONSOURCE, this.ltTranslationSource);
        this.ltTranslationTarget = this.buffer.getString(LTTRANSLATIONTARGET, this.ltTranslationTarget);
        this.ltTranslationServiceKey = this.buffer.getEncodedString(LTTRANSLATIONSERVICEKEY, this.ltTranslationServiceKey);
        this.saveSession = this.buffer.getBoolean(SAVESESSION, this.saveSession);
        this.sessionPath = this.buffer.getString(SESSIONPATH, this.sessionPath);
        this.doubledWord = this.buffer.getBoolean(DOUBLEDWORD, this.doubledWord);
        this.doubledWordExceptions = this.buffer.getString(DOUBLEDWORDEXCEPTIONS, this.doubledWordExceptions);
        this.corruptedCharacters = this.buffer.getBoolean(CORRUPTEDCHARACTERS, this.corruptedCharacters);
        this.scope = this.buffer.getInteger(SCOPE, this.scope);
        this.checkStorageSize = this.buffer.getBoolean(CHECKSTORAGESIZE, this.checkStorageSize);
        this.checkMaxCharLength = this.buffer.getBoolean(CHECKMAXCHARLENGTH, this.checkMaxCharLength);
        this.maxCharLengthBreak = this.buffer.getInteger(MAXCHARLENGTHBREAK, this.maxCharLengthBreak);
        this.maxCharLengthAbove = this.buffer.getInteger(MAXCHARLENGTHABOVE, this.maxCharLengthAbove);
        this.maxCharLengthBelow = this.buffer.getInteger(MAXCHARLENGTHBELOW, this.maxCharLengthBelow);
        this.checkMinCharLength = this.buffer.getBoolean(CHECKMINCHARLENGTH, this.checkMinCharLength);
        this.minCharLengthBreak = this.buffer.getInteger(MINCHARLENGTHBREAK, this.minCharLengthBreak);
        this.minCharLengthAbove = this.buffer.getInteger(MINCHARLENGTHABOVE, this.minCharLengthAbove);
        this.minCharLengthBelow = this.buffer.getInteger(MINCHARLENGTHBELOW, this.minCharLengthBelow);
        this.checkAbsoluteMaxCharLength = this.buffer.getBoolean(CHECKABSOLUTEMAXCHARLENGTH, this.checkAbsoluteMaxCharLength);
        this.absoluteMaxCharLength = this.buffer.getInteger(ABSOLUTEMAXCHARLENGTH, this.absoluteMaxCharLength);
        this.checkAllowedCharacters = this.buffer.getBoolean(CHECKALLOWEDCHARACTERS, this.checkAllowedCharacters);
        this.checkCharacters = this.buffer.getBoolean(CHECKCHARACTERS, this.checkCharacters);
        this.charset = this.buffer.getString(CHARSET, this.charset);
        this.extraCharsAllowed = this.buffer.getString(EXTRACHARSALLOWED, this.extraCharsAllowed);
        this.checkTerms = this.buffer.getBoolean(CHECKTERMS, this.checkTerms);
        this.termsPath = this.buffer.getString(TERMSPATH, this.termsPath);
        this.stringMode = this.buffer.getBoolean(STRINGMODE, this.stringMode);
        this.betweenCodes = this.buffer.getBoolean(BETWEENCODES, this.betweenCodes);
        this.checkXliffSchema = this.buffer.getBoolean(CHECKXLIFFSCHEMA, this.checkXliffSchema);
        this.checkPatterns = this.buffer.getBoolean(CHECKPATTERNS, this.checkPatterns);
        int count = this.buffer.getInteger(PATTERNCOUNT, 0);
        if (count > 0) {
            this.patterns.clear();
        }
        for (i = 0; i < count; ++i) {
            boolean enabled = this.buffer.getBoolean(String.format("%s%d", USEPATTERN, i), true);
            int severity = this.buffer.getInteger(String.format("%s%d", SEVERITYPATTERN, i), 1);
            boolean fromSource = this.buffer.getBoolean(String.format("%s%d", FROMSOURCEPATTERN, i), true);
            String source = this.buffer.getString(String.format("%s%d", SOURCEPATTERN, i), "");
            String target = this.buffer.getString(String.format("%s%d", TARGETPATTERN, i), "<same>");
            String desc = this.buffer.getString(String.format("%s%d", DESCPATTERN, i), "");
            this.patterns.add(new PatternItem(source, target, enabled, severity, fromSource, desc));
        }
        count = this.buffer.getInteger(EXTRACODESALLOWED, 0);
        if (count > 0) {
            this.extraCodesAllowed.clear();
        }
        for (i = 0; i < count; ++i) {
            this.extraCodesAllowed.add(this.buffer.getString(String.format("%s%d", EXTRACODESALLOWED, i), ""));
        }
        count = this.buffer.getInteger(MISSINGCODESALLOWED, 0);
        if (count > 0) {
            this.missingCodesAllowed.clear();
        }
        for (i = 0; i < count; ++i) {
            this.missingCodesAllowed.add(this.buffer.getString(String.format("%s%d", MISSINGCODESALLOWED, i), ""));
        }
        this.typesToIgnore = this.buffer.getString(TYPESTOIGNORE, this.typesToIgnore);
    }

    @Override
    public String toString() {
        int i;
        this.buffer.reset();
        this.buffer.setString(OUTPUTPATH, this.outputPath);
        this.buffer.setInteger(OUTPUTTYPE, this.outputType);
        this.buffer.setBoolean(AUTOOPEN, this.autoOpen);
        this.buffer.setBoolean(LEADINGWS, this.leadingWS);
        this.buffer.setBoolean(TRAILINGWS, this.trailingWS);
        this.buffer.setBoolean(EMPTYTARGET, this.emptyTarget);
        this.buffer.setBoolean(EMPTYSOURCE, this.emptySource);
        this.buffer.setBoolean(TARGETSAMEASSOURCE, this.targetSameAsSource);
        this.buffer.setBoolean(TARGETSAMEASSOURCE_FORSAMELANGUAGE, this.targetSameAsSourceForSameLanguage);
        this.buffer.setBoolean(TARGETSAMEASSOURCE_WITHCODES, this.targetSameAsSourceWithCodes);
        this.buffer.setBoolean(CODEDIFFERENCE, this.codeDifference);
        this.buffer.setBoolean(GUESSOPENCLOSE, this.guessOpenClose);
        this.buffer.setBoolean(CHECKWITHLT, this.checkWithLT);
        this.buffer.setString(SERVERURL, this.serverURL);
        this.buffer.setBoolean(TRANSLATELTMSG, this.translateLTMsg);
        this.buffer.setBoolean(LTBILINGUALMODE, this.ltBilingualMode);
        this.buffer.setString(LTTRANSLATIONSOURCE, this.ltTranslationSource);
        this.buffer.setString(LTTRANSLATIONTARGET, this.ltTranslationTarget);
        this.buffer.setEncodedString(LTTRANSLATIONSERVICEKEY, this.ltTranslationServiceKey);
        this.buffer.setBoolean(SAVESESSION, this.saveSession);
        this.buffer.setString(SESSIONPATH, this.sessionPath);
        this.buffer.setBoolean(DOUBLEDWORD, this.doubledWord);
        this.buffer.setString(DOUBLEDWORDEXCEPTIONS, this.doubledWordExceptions);
        this.buffer.setBoolean(CORRUPTEDCHARACTERS, this.corruptedCharacters);
        this.buffer.setInteger(SCOPE, this.scope);
        this.buffer.setBoolean(CHECKSTORAGESIZE, this.checkStorageSize);
        this.buffer.setBoolean(CHECKMAXCHARLENGTH, this.checkMaxCharLength);
        this.buffer.setInteger(MAXCHARLENGTHBREAK, this.maxCharLengthBreak);
        this.buffer.setInteger(MAXCHARLENGTHABOVE, this.maxCharLengthAbove);
        this.buffer.setInteger(MAXCHARLENGTHBELOW, this.maxCharLengthBelow);
        this.buffer.setBoolean(CHECKMINCHARLENGTH, this.checkMinCharLength);
        this.buffer.setInteger(MINCHARLENGTHBREAK, this.minCharLengthBreak);
        this.buffer.setInteger(MINCHARLENGTHABOVE, this.minCharLengthAbove);
        this.buffer.setInteger(MINCHARLENGTHBELOW, this.minCharLengthBelow);
        this.buffer.setBoolean(CHECKABSOLUTEMAXCHARLENGTH, this.checkAbsoluteMaxCharLength);
        this.buffer.setInteger(ABSOLUTEMAXCHARLENGTH, this.absoluteMaxCharLength);
        this.buffer.setBoolean(CHECKALLOWEDCHARACTERS, this.checkAllowedCharacters);
        this.buffer.setBoolean(CHECKCHARACTERS, this.checkCharacters);
        this.buffer.setString(CHARSET, this.charset);
        this.buffer.setString(EXTRACHARSALLOWED, this.extraCharsAllowed);
        this.buffer.setBoolean(CHECKTERMS, this.checkTerms);
        this.buffer.setString(TERMSPATH, this.termsPath);
        this.buffer.setBoolean(STRINGMODE, this.stringMode);
        this.buffer.setBoolean(BETWEENCODES, this.betweenCodes);
        this.buffer.setBoolean(CHECKXLIFFSCHEMA, this.checkXliffSchema);
        this.buffer.setBoolean(CHECKPATTERNS, this.checkPatterns);
        this.buffer.setInteger(PATTERNCOUNT, this.patterns.size());
        for (i = 0; i < this.patterns.size(); ++i) {
            this.buffer.setBoolean(String.format("%s%d", USEPATTERN, i), this.patterns.get((int)i).enabled);
            this.buffer.setBoolean(String.format("%s%d", FROMSOURCEPATTERN, i), this.patterns.get((int)i).fromSource);
            this.buffer.setInteger(String.format("%s%d", SEVERITYPATTERN, i), this.patterns.get((int)i).severity);
            this.buffer.setString(String.format("%s%d", SOURCEPATTERN, i), this.patterns.get((int)i).source);
            this.buffer.setString(String.format("%s%d", TARGETPATTERN, i), this.patterns.get((int)i).target);
            this.buffer.setString(String.format("%s%d", DESCPATTERN, i), this.patterns.get((int)i).description);
        }
        this.buffer.setInteger(EXTRACODESALLOWED, this.extraCodesAllowed.size());
        for (i = 0; i < this.extraCodesAllowed.size(); ++i) {
            this.buffer.setString(String.format("%s%d", EXTRACODESALLOWED, i), this.extraCodesAllowed.get(i));
        }
        this.buffer.setInteger(MISSINGCODESALLOWED, this.missingCodesAllowed.size());
        for (i = 0; i < this.missingCodesAllowed.size(); ++i) {
            this.buffer.setString(String.format("%s%d", MISSINGCODESALLOWED, i), this.missingCodesAllowed.get(i));
        }
        this.buffer.setString(TYPESTOIGNORE, this.typesToIgnore);
        return this.buffer.toString();
    }
}

