/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import net.sf.okapi.lib.xliff.CMarker;
import net.sf.okapi.lib.xliff.Util;
import org.oasisopen.xliff.v2.Directionality;
import org.oasisopen.xliff.v2.IAMarker;
import org.oasisopen.xliff.v2.ICMarker;
import org.oasisopen.xliff.v2.IDataStore;
import org.oasisopen.xliff.v2.IFragment;
import org.oasisopen.xliff.v2.IMarker;
import org.oasisopen.xliff.v2.IMarkers;
import org.oasisopen.xliff.v2.MarkerType;
import org.oasisopen.xliff.v2.OriginalDataStyle;

public class Fragment
implements IFragment {
    private static final long serialVersionUID = 64L;
    public static final char CODE_OPENING = '\ue101';
    public static final char CODE_CLOSING = '\ue102';
    public static final char CODE_PLACEHOLDER = '\ue103';
    public static final char ANNO_OPENING = '\ue104';
    public static final char ANNO_CLOSING = '\ue105';
    public static final int INDEX_BASE = 57616;
    public static final int INDEX_MAX = 6127;
    public static final int ORIGINALDATA_AUTO = 0;
    public static final int ORIGINALDATA_INSIDE = 1;
    public static final int ORIGINALDATA_OUTSIDE = 2;
    public static final int ORIGINALDATA_REMOVE = 3;
    private boolean isTarget;
    private StringBuilder ctext;
    private IMarkers markers;
    private Directionality dir = Directionality.INHERITED;

    public static char toChar(int index) {
        if (index > 6127) {
            throw new InvalidParameterException(String.format("This implementation cannot have content with more than %d markers.", 6127));
        }
        return (char)(index + 57616);
    }

    public static int toIndex(char index) {
        return index - 57616;
    }

    public static boolean isMarker(int codePoint) {
        switch (codePoint) {
            case 57601: 
            case 57602: 
            case 57603: 
            case 57604: 
            case 57605: {
                return true;
            }
        }
        return false;
    }

    public Fragment(IDataStore store) {
        this(store, false);
    }

    public Fragment(IDataStore store, boolean target) {
        if (store == null) {
            throw new InvalidParameterException("The store parameter cannot be null.");
        }
        this.isTarget = target;
        this.ctext = new StringBuilder();
        this.markers = this.isTarget ? store.getTargetMarkers() : store.getSourceMarkers();
    }

    public Fragment(IDataStore store, boolean target, String plainText) {
        this(store, target);
        this.ctext = new StringBuilder(plainText);
    }

    @Override
    public IFragment deepCopy(IDataStore store, boolean target) {
        Fragment frag = new Fragment(store, target);
        frag.ctext = this.ctext;
        for (IMarker marker : this.markers) {
            frag.markers.add(marker.deepCopy());
        }
        return frag;
    }

    @Override
    public String toString() {
        return this.ctext.toString();
    }

    @Override
    public String getCodedText() {
        return this.ctext.toString();
    }

    @Override
    public void setCodedText(String codedText) {
        this.ctext = new StringBuilder(codedText);
    }

    @Override
    public String toXLIFF(OriginalDataStyle style) {
        switch (style) {
            case OUTSIDE: {
                return this.toXLIFFWithOriginalData();
            }
        }
        return this.toXLIFF();
    }

    @Override
    public IDataStore getDataStore() {
        return this.markers.getDataStore();
    }

    private String toXLIFFWithOriginalData() {
        StringBuilder tmp = new StringBuilder();
        ArrayList<String> verified = new ArrayList<String>();
        block6: for (int i = 0; i < this.ctext.length(); ++i) {
            IAMarker ann;
            ICMarker cm;
            int cp = this.ctext.codePointAt(i);
            if (cp == 57601) {
                cm = (ICMarker)this.markers.get(Fragment.toIndex(this.ctext.charAt(++i)));
                ICMarker closing = null;
                closing = (ICMarker)this.getWellFormedClosing(cm, i);
                if (closing != null) {
                    tmp.append(String.format("<pc id=\"%s\"", cm.getId()));
                    verified.add(cm.getId());
                    if (cm.getCanOverlap()) {
                        tmp.append(String.format(" %s=\"yes\"", "canOverlap"));
                    }
                } else {
                    tmp.append(String.format("<sc id=\"%s\"", cm.getId()));
                    if (!cm.getCanOverlap()) {
                        tmp.append(String.format(" %s=\"no\"", "canOverlap"));
                    }
                    if (!this.unitHasClosing(cm)) {
                        tmp.append(" isolated=\"yes\"");
                    }
                }
                this.printCommonAttributes(cm, tmp, closing, true);
                if (cm.hasOriginalData()) {
                    String ending = closing == null ? "" : "Start";
                    tmp.append(String.format(" nid%s=\"%s\"", ending, this.markers.getDataStore().getIdForOriginalData(cm.getOriginalData())));
                }
                tmp.append(closing == null ? "/>" : ">");
                continue;
            }
            if (cp == 57602) {
                boolean isolated;
                if (verified.contains((cm = (ICMarker)this.markers.get(Fragment.toIndex(this.ctext.charAt(++i)))).getId())) {
                    tmp.append("</pc>");
                    continue;
                }
                tmp.append("<ec");
                boolean bl = isolated = !this.unitHasOpening(cm);
                if (isolated) {
                    tmp.append(String.format(" id=\"%s\"", cm.getId()));
                    tmp.append(" isolated=\"yes\"");
                } else {
                    tmp.append(String.format(" rid=\"%s\"", cm.getId()));
                }
                if (!cm.getCanOverlap()) {
                    tmp.append(String.format(" %s=\"no\"", "canOverlap"));
                }
                this.printCommonAttributes(cm, tmp, null, false);
                if (cm.hasOriginalData()) {
                    tmp.append(String.format(" nid=\"%s\"", this.markers.getDataStore().getIdForOriginalData(cm.getOriginalData())));
                }
                tmp.append("/>");
                continue;
            }
            if (cp == 57603) {
                int index = Fragment.toIndex(this.ctext.charAt(++i));
                cm = (ICMarker)this.markers.get(index);
                tmp.append(String.format("<ph id=\"%s\"", cm.getId()));
                this.printCommonAttributes(cm, tmp, null, false);
                if (cm.hasOriginalData()) {
                    tmp.append(String.format(" nid=\"%s\"", this.markers.getDataStore().getIdForOriginalData(cm.getOriginalData())));
                }
                tmp.append("/>");
                continue;
            }
            if (cp == 57604) {
                IAMarker closing;
                if ((closing = (IAMarker)this.getWellFormedClosing(ann = (IAMarker)this.markers.get(Fragment.toIndex(this.ctext.charAt(++i))), i)) != null) {
                    tmp.append(String.format("<%s id=\"%s\"", "mrk", ann.getId()));
                } else {
                    tmp.append(String.format("<%s id=\"%s\"", "sm", ann.getId()));
                }
                if (!ann.getType().equals("generic")) {
                    tmp.append(" type=\"" + ann.getType() + "\"");
                }
                if (!Util.isNullOrEmpty(ann.getTranslate())) {
                    tmp.append(" translate=\"" + ann.getTranslate() + "\"");
                }
                if (!Util.isNullOrEmpty(ann.getValue())) {
                    tmp.append(" value=\"" + Util.toXML(ann.getValue(), true) + "\"");
                }
                if (!Util.isNullOrEmpty(ann.getRef())) {
                    tmp.append(" ref=\"" + Util.toXML(ann.getRef(), true) + "\"");
                }
                if (closing != null) {
                    verified.add(ann.getId());
                    tmp.append(">");
                    continue;
                }
                tmp.append("/>");
                continue;
            }
            if (cp == 57605) {
                if (verified.contains((ann = (IAMarker)this.markers.get(Fragment.toIndex(this.ctext.charAt(++i)))).getId())) {
                    tmp.append("</mrk>");
                    continue;
                }
                tmp.append(String.format("<%s rid=\"%s\"", "em", ann.getId()));
                tmp.append("/>");
                continue;
            }
            switch (cp) {
                case 13: {
                    tmp.append("&#13;");
                    continue block6;
                }
                case 60: {
                    tmp.append("&lt;");
                    continue block6;
                }
                case 38: {
                    tmp.append("&amp;");
                    continue block6;
                }
                case 9: 
                case 10: {
                    tmp.append((char)cp);
                    continue block6;
                }
                default: {
                    if (cp < 32 || cp > 55295 && cp < 57344 || cp == 65535) {
                        tmp.append(String.format("<cp hex=\"%04X\"/>", cp));
                        continue block6;
                    }
                    if (cp < 65535) {
                        tmp.append((char)cp);
                        continue block6;
                    }
                    if (cp <= 65535) continue block6;
                    tmp.append(Character.toChars(cp));
                    ++i;
                }
            }
        }
        return tmp.toString();
    }

    private boolean unitHasClosing(ICMarker cm) {
        if (this.markers == null) {
            return false;
        }
        for (IMarker marker : this.markers) {
            if (!cm.getId().equals(marker.getId()) || marker.getMarkerType() != MarkerType.CLOSING) continue;
            return true;
        }
        return false;
    }

    private boolean unitHasOpening(ICMarker cm) {
        if (this.markers == null) {
            return false;
        }
        for (IMarker marker : this.markers) {
            if (!cm.getId().equals(marker.getId()) || marker.getMarkerType() != MarkerType.OPENING) continue;
            return true;
        }
        return false;
    }

    private void printCommonAttributes(ICMarker cm, StringBuilder tmp, ICMarker closing, boolean outputNidEnd) {
        String ending;
        if (cm.getType() != null) {
            tmp.append(String.format(" type=\"%s\"", cm.getType()));
        }
        if (!cm.getCanCopy()) {
            tmp.append(String.format(" %s=\"no\"", "canCopy"));
        }
        if (!cm.getCanDelete()) {
            tmp.append(String.format(" %s=\"no\"", "canDelete"));
        }
        if (!cm.getCanReorder()) {
            tmp.append(String.format(" %s=\"no\"", "canReorder"));
        }
        String string = ending = closing == null ? "" : "Start";
        if (cm.getEquiv() != null) {
            tmp.append(String.format(" equiv%s=\"%s\"", ending, cm.getEquiv()));
        }
        if (cm.getDisp() != null) {
            tmp.append(String.format(" disp%s=\"%s\"", ending, cm.getDisp()));
        }
        if (cm.getSubFlows() != null) {
            tmp.append(String.format(" subFlows%s=\"%s\"", ending, cm.getSubFlows()));
        }
        if (closing != null) {
            if (closing.getEquiv() != null) {
                tmp.append(String.format(" equivEnd=\"%s\"", closing.getEquiv()));
            }
            if (closing.getDisp() != null) {
                tmp.append(String.format(" dispEnd=\"%s\"", closing.getDisp()));
            }
            if (closing.getSubFlows() != null) {
                tmp.append(String.format(" subFlowsEnd=\"%s\"", closing.getSubFlows()));
            }
            if (outputNidEnd && closing.hasOriginalData()) {
                tmp.append(String.format(" nidEnd=\"%s\"", this.markers.getDataStore().getIdForOriginalData(closing.getOriginalData())));
            }
        }
    }

    @Override
    public String toXLIFF() {
        StringBuilder tmp = new StringBuilder();
        ArrayList<String> verified = new ArrayList<String>();
        block6: for (int i = 0; i < this.ctext.length(); ++i) {
            IAMarker ann;
            ICMarker cm;
            IMarker closing;
            int cp = this.ctext.codePointAt(i);
            if (cp == 57601) {
                if ((closing = (ICMarker)this.getWellFormedClosing(cm = (ICMarker)this.markers.get(Fragment.toIndex(this.ctext.charAt(++i))), i)) != null) {
                    tmp.append(String.format("<pc id=\"%s\"", cm.getId()));
                    if (cm.getCanOverlap()) {
                        tmp.append(String.format(" %s=\"yes\"", "canOverlap"));
                    }
                    this.printCommonAttributes(cm, tmp, (ICMarker)closing, false);
                    verified.add(cm.getId());
                    tmp.append(">");
                    continue;
                }
                tmp.append(String.format("<sc id=\"%s\"", cm.getId()));
                if (!cm.getCanOverlap()) {
                    tmp.append(String.format(" %s=\"no\"", "canOverlap"));
                }
                if (!this.unitHasClosing(cm)) {
                    tmp.append(" isolated=\"yes\"");
                }
                this.printCommonAttributes(cm, tmp, null, false);
                tmp.append("/>");
                continue;
            }
            if (cp == 57602) {
                boolean isolated;
                if (verified.contains((cm = (ICMarker)this.markers.get(Fragment.toIndex(this.ctext.charAt(++i)))).getId())) {
                    tmp.append("</pc>");
                    continue;
                }
                tmp.append("<ec");
                boolean bl = isolated = !this.unitHasOpening(cm);
                if (isolated) {
                    tmp.append(String.format(" id=\"%s\"", cm.getId()));
                    tmp.append(" isolated=\"yes\"");
                } else {
                    tmp.append(String.format(" rid=\"%s\"", cm.getId()));
                }
                if (!cm.getCanOverlap()) {
                    tmp.append(String.format(" %s=\"no\"", "canOverlap"));
                }
                this.printCommonAttributes(cm, tmp, null, false);
                tmp.append("/>");
                continue;
            }
            if (cp == 57603) {
                cm = (ICMarker)this.markers.get(Fragment.toIndex(this.ctext.charAt(++i)));
                tmp.append(String.format("<ph id=\"%s\"", cm.getId()));
                this.printCommonAttributes(cm, tmp, null, false);
                tmp.append("/>");
                continue;
            }
            if (cp == 57604) {
                if ((closing = (IAMarker)this.getWellFormedClosing(ann = (IAMarker)this.markers.get(Fragment.toIndex(this.ctext.charAt(++i))), i)) != null) {
                    tmp.append(String.format("<%s id=\"%s\" type=\"%s\"", "mrk", ann.getId(), ann.getType()));
                    if (!Util.isNullOrEmpty(ann.getValue())) {
                        tmp.append(" value=\"" + Util.toXML(ann.getValue(), true) + "\"");
                    }
                    verified.add(ann.getId());
                    tmp.append(">");
                    continue;
                }
                tmp.append(String.format("<%s id=\"%s\" type=\"%s\"", "sm", ann.getId(), ann.getType()));
                if (!Util.isNullOrEmpty(ann.getValue())) {
                    tmp.append(" value=\"" + Util.toXML(ann.getValue(), true) + "\"");
                }
                tmp.append("/>");
                continue;
            }
            if (cp == 57605) {
                if (verified.contains((ann = (IAMarker)this.markers.get(Fragment.toIndex(this.ctext.charAt(++i)))).getId())) {
                    tmp.append("</mrk>");
                    continue;
                }
                tmp.append(String.format("<%s rid=\"%s\"", "em", ann.getId()));
                tmp.append("/>");
                continue;
            }
            switch (cp) {
                case 13: {
                    tmp.append("&#13;");
                    continue block6;
                }
                case 60: {
                    tmp.append("&lt;");
                    continue block6;
                }
                case 38: {
                    tmp.append("&amp;");
                    continue block6;
                }
                case 9: 
                case 10: {
                    tmp.append((char)cp);
                    continue block6;
                }
                default: {
                    if (cp < 32 || cp > 55295 && cp < 57344 || cp == 65535) {
                        tmp.append(String.format("<cp hex=\"%04X\"/>", cp));
                        continue block6;
                    }
                    if (cp < 65535) {
                        tmp.append((char)cp);
                        continue block6;
                    }
                    if (cp <= 65535) continue block6;
                    tmp.append(Character.toChars(cp));
                    ++i;
                }
            }
        }
        return tmp.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.ctext.length() == 0;
    }

    @Override
    public boolean isTarget() {
        return this.isTarget;
    }

    @Override
    public boolean hasMarker() {
        return this.markers.size() > 0;
    }

    @Override
    public IMarker getWellFormedClosing(IMarker openingMarker, int from) {
        Stack<String> stack = new Stack<String>();
        for (int i = from; i < this.ctext.length(); ++i) {
            IMarker marker;
            char ch = this.ctext.charAt(i);
            if (ch == '\ue101' || ch == '\ue104') {
                marker = this.markers.get(Fragment.toIndex(this.ctext.charAt(++i)));
                stack.push(marker.getId());
                continue;
            }
            if (ch == '\ue102' || ch == '\ue105') {
                if ((marker = this.markers.get(Fragment.toIndex(this.ctext.charAt(++i)))).getId().equals(openingMarker.getId())) {
                    if (stack.isEmpty()) {
                        return marker;
                    }
                    return null;
                }
                if (stack.isEmpty()) {
                    return null;
                }
                stack.remove(marker.getId());
                continue;
            }
            if (ch != '\ue103') continue;
            ++i;
        }
        return null;
    }

    @Override
    public void append(String plainText) {
        this.ctext.append(plainText);
    }

    @Override
    public void append(char ch) {
        this.ctext.append(ch);
    }

    @Override
    public IMarker append(IMarker marker) {
        this.markers.add(marker);
        switch (marker.getMarkerType()) {
            case OPENING: {
                this.ctext.append("" + (marker.isCode() ? (char)'\ue101' : '\ue104') + Fragment.toChar(this.markers.size() - 1));
                break;
            }
            case CLOSING: {
                this.ctext.append("" + (marker.isCode() ? (char)'\ue102' : '\ue105') + Fragment.toChar(this.markers.size() - 1));
                break;
            }
            case PLACEHOLDER: {
                this.ctext.append("\ue103" + Fragment.toChar(this.markers.size() - 1));
            }
        }
        return marker;
    }

    @Override
    public ICMarker append(ICMarker cm) {
        this.markers.add(cm);
        switch (cm.getMarkerType()) {
            case OPENING: {
                this.ctext.append("\ue101" + Fragment.toChar(this.markers.size() - 1));
                break;
            }
            case CLOSING: {
                this.ctext.append("\ue102" + Fragment.toChar(this.markers.size() - 1));
                break;
            }
            case PLACEHOLDER: {
                this.ctext.append("\ue103" + Fragment.toChar(this.markers.size() - 1));
            }
        }
        return cm;
    }

    @Override
    public IAMarker append(IAMarker am) {
        this.markers.add(am);
        switch (am.getMarkerType()) {
            case OPENING: {
                this.ctext.append("\ue104" + Fragment.toChar(this.markers.size() - 1));
                break;
            }
            case CLOSING: {
                this.ctext.append("\ue105" + Fragment.toChar(this.markers.size() - 1));
            }
        }
        return am;
    }

    @Override
    public ICMarker append(MarkerType type, String id, String originalData, boolean canOverlap) {
        if (this.markers == null) {
            throw new RuntimeException("Cannot add CMarkers in this fragment because it has no associated store.");
        }
        CMarker cm = new CMarker(type, id, originalData);
        cm.setCanOverlap(canOverlap);
        return this.append(cm);
    }

    @Override
    public ICMarker appendPlaceholder(String id, String originalData) {
        return this.append(MarkerType.PLACEHOLDER, id, originalData, false);
    }

    @Override
    public void append(IFragment fragment) {
        for (Object obj : fragment) {
            if (obj instanceof IMarker) {
                this.append(((IMarker)obj).deepCopy());
                continue;
            }
            this.append((String)obj);
        }
    }

    @Override
    public Iterator<Object> iterator() {
        return new Iterator<Object>(){
            int pos = 0;

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The method remove() not supported.");
            }

            @Override
            public Object next() {
                int start = this.pos;
                while (this.pos < Fragment.this.ctext.length()) {
                    if (Fragment.isMarker(Fragment.this.ctext.codePointAt(this.pos))) {
                        if (start < this.pos) {
                            return Fragment.this.ctext.substring(start, this.pos);
                        }
                        this.pos += 2;
                        return Fragment.this.markers.get(Fragment.toIndex(Fragment.this.ctext.charAt(this.pos - 1)));
                    }
                    ++this.pos;
                }
                return Fragment.this.ctext.substring(start);
            }

            @Override
            public boolean hasNext() {
                return this.pos < Fragment.this.ctext.length();
            }
        };
    }

    @Override
    public boolean equals(IFragment fragment) {
        if (fragment == null) {
            throw new NullPointerException("The parameter fragment must not be null.");
        }
        if (this == fragment) {
            return true;
        }
        Iterator<Object> thisIter = this.iterator();
        Iterator thatIter = fragment.iterator();
        while (thisIter.hasNext()) {
            if (!thatIter.hasNext()) {
                return false;
            }
            Object thisObj = thisIter.next();
            Object thatObj = thatIter.next();
            if (thisObj instanceof String) {
                if (!(thatObj instanceof String)) {
                    return false;
                }
                if (thisObj.equals(thatObj)) continue;
                return false;
            }
            if (thatObj instanceof String) {
                return false;
            }
            if (((IMarker)thisObj).equals((IMarker)thatObj)) continue;
            return false;
        }
        return !thatIter.hasNext();
    }

    @Override
    public Directionality getDir(boolean resolved) {
        if (resolved && this.dir == Directionality.INHERITED) {
            if (this.isTarget) {
                return this.markers.getDataStore().getTargetDir();
            }
            return this.markers.getDataStore().getSourceDir();
        }
        return this.dir;
    }

    @Override
    public void setDir(Directionality dir) {
        this.dir = dir;
    }
}

