/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff;

import org.oasisopen.xliff.v2.MarkerType;

public class Util {
    static final String VALUE_YES = "yes";
    static final String VALUE_NO = "no";
    static final String VALUE_LTR = "ltr";
    static final String VALUE_RTL = "rtl";
    static final String ELEM_XLIFF = "xliff";
    static final String ELEM_SECTION = "file";
    static final String ELEM_SKELETON = "skeleton";
    static final String ELEM_GROUP = "group";
    static final String ELEM_UNIT = "unit";
    static final String ELEM_SEGMENT = "segment";
    static final String ELEM_IGNORABLE = "ignorable";
    static final String ELEM_SOURCE = "source";
    static final String ELEM_TARGET = "target";
    static final String ELEM_CANDIDATES = "matches";
    static final String ELEM_CANDIDATE = "match";
    static final String ELEM_GLOSSENTRY = "glossEntry";
    static final String ELEM_CUSTPROP = "meta";
    static final String ELEM_TERM = "term";
    static final String ELEM_TRANSLATION = "translation";
    static final String ELEM_DEFINITION = "definition";
    static final String ELEM_NOTES = "notes";
    static final String ELEM_NOTE = "note";
    static final String ELEM_PLACEHOLDER = "ph";
    static final String ELEM_PAIREDCODES = "pc";
    static final String ELEM_OPENINGCODE = "sc";
    static final String ELEM_CLOSINGCODE = "ec";
    static final String ELEM_PAIREDANNO = "mrk";
    static final String ELEM_OPENINGANNO = "sm";
    static final String ELEM_CLOSINGANNO = "em";
    static final String ELEM_CP = "cp";
    static final String ELEM_ORIGINALDATA = "originalData";
    static final String ELEM_DATA = "data";
    static final String ATTR_ID = "id";
    static final String ATTR_RID = "rid";
    static final String ATTR_NID = "nid";
    static final String ATTR_TYPE = "type";
    static final String ATTR_ISOLATED = "isolated";
    static final String ATTR_CANOVERLAP = "canOverlap";
    static final String ATTR_HEX = "hex";
    static final String ATTR_SRCDIR = "srcDir";
    static final String ATTR_TRGDIR = "trgDir";
    static final String ATTR_DIR = "dir";
    static final String ATTR_EQUIV = "equiv";
    static final String ATTR_EQUIVSTART = "equivStart";
    static final String ATTR_EQUIVEND = "equivEnd";
    static final String ATTR_DISP = "disp";
    static final String ATTR_DISPSTART = "dispStart";
    static final String ATTR_DISPEND = "dispEnd";
    static final String ATTR_SUBFLOWS = "subFlows";
    static final String ATTR_SUBFLOWSSTART = "subFlowsStart";
    static final String ATTR_SUBFLOWSEND = "subFlowsEnd";
    static final String ATTR_NIDSTART = "nidStart";
    static final String ATTR_NIDEND = "nidEnd";
    static final String ATTR_SOURCELANG = "srcLang";
    static final String ATTR_TARGETLANG = "tgtLang";
    static final String ATTR_APPLIESTO = "appliesTo";
    static final String ATTR_VALUE = "value";
    static final String ATTR_REF = "ref";
    static final String ATTR_TRANSLATE = "translate";
    static final String ATTR_APPROVED = "approved";
    static final String ATTR_ORDER = "order";
    static final String ATTR_CANDELETE = "canDelete";
    static final String ATTR_CANREORDER = "canReorder";
    static final String ATTR_CANCOPY = "canCopy";
    static final String ATTR_SIMILARITY = "similarity";
    static final String ATTR_ORIGIN = "origin";

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static String toXML(String text, boolean attribute) {
        StringBuilder tmp = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '&') {
                tmp.append("&amp;");
                continue;
            }
            if (ch == '<') {
                tmp.append("&lt;");
                continue;
            }
            if (attribute && ch == '\"') {
                tmp.append("&quot;");
                continue;
            }
            tmp.append(ch);
        }
        return tmp.toString();
    }

    static String toSafeXML(String text) {
        StringBuilder tmp = new StringBuilder(text.length());
        block5: for (int i = 0; i < text.length(); ++i) {
            int cp = text.codePointAt(i);
            switch (cp) {
                case 38: {
                    tmp.append("&amp;");
                    continue block5;
                }
                case 60: {
                    tmp.append("&lt;");
                    continue block5;
                }
                case 9: 
                case 10: 
                case 13: {
                    tmp.append((char)cp);
                    continue block5;
                }
                default: {
                    if (cp < 32 || cp > 55295 && cp < 57344 || cp == 65535) {
                        tmp.append(String.format("<cp hex=\"%04X\"/>", cp));
                        continue block5;
                    }
                    if (cp < 65535) {
                        tmp.append((char)cp);
                        continue block5;
                    }
                    if (cp <= 65535) continue block5;
                    tmp.append(Character.toChars(cp));
                    ++i;
                    continue block5;
                }
            }
        }
        return tmp.toString();
    }

    static int compareAllowingNull(String s1, String s2) {
        if (s1 == null) {
            if (s2 == null) {
                return 0;
            }
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    static String toInternalId(String id, MarkerType markerType) {
        switch (markerType) {
            case CLOSING: {
                return "c" + id;
            }
            case OPENING: {
                return "o" + id;
            }
        }
        return "p" + id;
    }
}

