/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.charlisting;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.steps.charlisting.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class CharListingStep
extends BasePipelineStep {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Parameters params = new Parameters();
    private Hashtable<Character, Integer> charList;

    @Override
    public void destroy() {
        if (this.charList != null) {
            this.charList.clear();
            this.charList = null;
        }
    }

    @Override
    public String getDescription() {
        return "Generate a list of all the characters in the source content of a set of documents. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public String getName() {
        return "Used Characters Listing";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.charList = new Hashtable();
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Event handleEndBatch(Event event) {
        PrintWriter writer = null;
        try {
            Util.createDirectories(this.params.getOutputPath());
            writer = new PrintWriter(this.params.getOutputPath(), "UTF-8");
            if (!Util.isOSCaseSensitive()) {
                writer.write(65279);
            }
            block10: for (char key : this.charList.keySet()) {
                switch (key) {
                    case '\t': 
                    case '\n': 
                    case '\r': {
                        writer.println(String.format("U+%04X\t'0x%d'\t%d", key, (int)key, this.charList.get(Character.valueOf(key))));
                        continue block10;
                    }
                }
                writer.println(String.format("U+%04X\t'%c'\t%d", key, Character.valueOf(key), this.charList.get(Character.valueOf(key))));
            }
        }
        catch (FileNotFoundException e) {
            this.logger.error(String.format("Error with '%s'.", this.params.getOutputPath()), e);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error(String.format("Encoding error with '%s'.", this.params.getOutputPath()), e);
        }
        finally {
            if (writer != null) {
                writer.close();
                writer = null;
                if (this.params.isAutoOpen()) {
                    Util.openURL(new File(this.params.getOutputPath()).getAbsolutePath());
                }
            }
        }
        return event;
    }

    @Override
    protected Event handleTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        if (!tu.isTranslatable()) {
            return event;
        }
        for (TextPart part : tu.getSource()) {
            String text = part.text.getCodedText();
            for (int i = 0; i < text.length(); ++i) {
                if (TextFragment.isMarker(text.charAt(i))) {
                    ++i;
                    continue;
                }
                if (this.charList.containsKey(Character.valueOf(text.charAt(i)))) {
                    this.charList.put(Character.valueOf(text.charAt(i)), this.charList.get(Character.valueOf(text.charAt(i))) + 1);
                    continue;
                }
                this.charList.put(Character.valueOf(text.charAt(i)), 1);
            }
        }
        return event;
    }
}

