/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.codesremoval;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.ListSelectionPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    public static final int REMOVECODE_KEEPCONTENT = 0;
    public static final int KEEPCODE_REMOVECONTENT = 1;
    public static final int REMOVECODE_REMOVECONTENT = 2;
    private static final String STRIPSOURCE = "stripSource";
    private static final String STRIPTARGET = "stripTarget";
    private static final String MODE = "mode";
    private static final String INCLUDENONTRANSLATABLE = "includeNonTranslatable";
    private boolean stripSource;
    private boolean stripTarget;
    private int mode;
    private boolean includeNonTranslatable;

    public Parameters() {
        this.reset();
    }

    public boolean getStripSource() {
        return this.stripSource;
    }

    public void setStripSource(boolean stripSource) {
        this.stripSource = stripSource;
    }

    public boolean getStripTarget() {
        return this.stripTarget;
    }

    public void setStripTarget(boolean stripTarget) {
        this.stripTarget = stripTarget;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public boolean getIncludeNonTranslatable() {
        return this.includeNonTranslatable;
    }

    public void setIncludeNonTranslatable(boolean includeNonTranslatable) {
        this.includeNonTranslatable = includeNonTranslatable;
    }

    @Override
    public void reset() {
        this.stripSource = true;
        this.stripTarget = true;
        this.mode = 2;
        this.includeNonTranslatable = true;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.stripSource = this.buffer.getBoolean(STRIPSOURCE, this.stripSource);
        this.stripTarget = this.buffer.getBoolean(STRIPTARGET, this.stripTarget);
        this.mode = this.buffer.getInteger(MODE, this.mode);
        this.includeNonTranslatable = this.buffer.getBoolean(INCLUDENONTRANSLATABLE, this.includeNonTranslatable);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setBoolean(STRIPSOURCE, this.stripSource);
        this.buffer.setBoolean(STRIPTARGET, this.stripTarget);
        this.buffer.setInteger(MODE, this.mode);
        this.buffer.setBoolean(INCLUDENONTRANSLATABLE, this.includeNonTranslatable);
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(MODE, "What to remove", "Select what parts of the inline codes to remove");
        desc.add(STRIPSOURCE, "Strip codes in the source text", null);
        desc.add(STRIPTARGET, "Strip codes in the target text", null);
        desc.add(INCLUDENONTRANSLATABLE, "Apply to non-translatable text units", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Codes Removal", true, false);
        String[] values = new String[]{"0", "1", "2"};
        String[] labels = new String[]{"Remove code marker, but keep code content  (\"<ph x='1'>[X]</ph>\" ==> \"[X]\")", "Remove code content, but keep code marker  (\"<ph x='1'>[X]</ph>\" ==> \"<ph x='1'/>\")", "Remove code marker and code content  (\"<ph x='1'>[X]</ph>\" ==> \"\")"};
        ListSelectionPart lsp = desc.addListSelectionPart(paramDesc.get(MODE), values);
        lsp.setChoicesLabels(labels);
        desc.addCheckboxPart(paramDesc.get(STRIPSOURCE));
        desc.addCheckboxPart(paramDesc.get(STRIPTARGET));
        desc.addCheckboxPart(paramDesc.get(INCLUDENONTRANSLATABLE));
        return desc;
    }
}

