/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.enrycher;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.steps.enrycher.Parameters;

public class EnrycherClient {
    private Parameters params = new Parameters();
    private String lang = "en";

    public IParameters getParameters() {
        return this.params;
    }

    public void setParameters(Parameters params) {
        this.params = params;
    }

    public void setLocale(LocaleId locId) {
        this.lang = locId.getLanguage();
    }

    public String processContent(String text) {
        OutputStreamWriter wr = null;
        BufferedReader rd = null;
        try {
            String line;
            URL url = new URL(this.params.getBaseUrl() + this.lang + "/run.html5its2");
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", "text/html");
            wr = new OutputStreamWriter(conn.getOutputStream());
            String data = text;
            wr.write(data);
            wr.flush();
            rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((line = rd.readLine()) != null) {
                sb.append(line + "\n");
            }
            wr.close();
            rd.close();
            String string = sb.toString();
            return string;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Invalid URL:\n" + e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException("Input/Output error:\n" + e.getMessage());
        }
        finally {
            try {
                if (wr != null) {
                    wr.close();
                }
                if (rd != null) {
                    rd.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

