/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.enrycher;

import java.util.LinkedList;
import java.util.List;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Source;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.MultiEvent;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.steps.enrycher.EnrycherClient;
import net.sf.okapi.steps.enrycher.Parameters;

@UsingParameters(value=Parameters.class)
public class EnrycherStep
extends BasePipelineStep {
    private static final int MAXEVENTS = 20;
    private LinkedList<Event> events;
    private int maxEvents = 20;
    private boolean needReset;
    private EnrycherClient client = new EnrycherClient();

    private void closeAndClean() {
        if (this.events != null) {
            this.events.clear();
            this.events = null;
        }
    }

    @Override
    public String getName() {
        return "Enrycher";
    }

    @Override
    public String getDescription() {
        return "Applies Enrycher ITS annotations to the source content. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public IParameters getParameters() {
        return this.client.getParameters();
    }

    @Override
    public void setParameters(IParameters params) {
        this.client.setParameters((Parameters)params);
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.events = new LinkedList();
        this.maxEvents = 20;
        if (this.maxEvents < 1 || this.maxEvents > 1000) {
            this.maxEvents = 20;
        }
        return event;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_BATCH: {
                return this.handleStartBatch(event);
            }
            case TEXT_UNIT: {
                return this.storeAndPossiblyProcess(event, false);
            }
            case DOCUMENT_PART: 
            case START_GROUP: 
            case END_GROUP: 
            case START_SUBFILTER: 
            case END_SUBFILTER: {
                return this.storeAndPossiblyProcess(event, false);
            }
            case CUSTOM: 
            case MULTI_EVENT: 
            case START_SUBDOCUMENT: 
            case END_DOCUMENT: 
            case END_SUBDOCUMENT: {
                return this.storeAndPossiblyProcess(event, true);
            }
            case CANCELED: 
            case END_BATCH: {
                this.closeAndClean();
                break;
            }
        }
        return event;
    }

    private Event processEvents() {
        this.getTranslations();
        this.needReset = true;
        return new Event(EventType.MULTI_EVENT, new MultiEvent(this.events));
    }

    private Event storeAndPossiblyProcess(Event event, boolean mustProcess) {
        if (this.needReset) {
            this.needReset = false;
            this.events.clear();
        }
        this.events.add(event);
        if (mustProcess || this.events.size() >= this.maxEvents) {
            return this.processEvents();
        }
        return Event.NOOP_EVENT;
    }

    private void getTranslations() {
        LinkedList<ITextUnit> tus = new LinkedList<ITextUnit>();
        if (this.events.isEmpty()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (Event event : this.events) {
            TextFragment tf;
            ITextUnit tu;
            if (!event.isTextUnit() || !(tu = event.getTextUnit()).isTranslatable() || tu.getSource().hasBeenSegmented() || !(tf = tu.getSource().getFirstContent()).hasText()) continue;
            tus.add(tu);
            String stext = this.toCodedHTML(tf);
            sb.append("<p id=" + String.format("%s", tu.getId()) + ">" + stext + "</p>\n");
        }
        if (!tus.isEmpty()) {
            String fromEnrycher = this.client.processContent(sb.toString());
            Source source = new Source(fromEnrycher);
            for (ITextUnit tu : tus) {
                if (tu.getSource().hasBeenSegmented()) continue;
                Element p = source.getElementById(tu.getId());
                Source pSource = new Source(p.getContent().toString());
                List<Element> spans = this.getItsElements(pSource);
                List<Insertion> insertions = this.getInsertions(tu.getSource().getFirstContent().toString(), pSource.toString(), spans);
                this.annotateFragment(tu.getSource().getFirstContent(), insertions);
            }
        }
    }

    public String toCodedHTML(TextFragment fragment) {
        if (fragment == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String text = fragment.getCodedText();
        block7: for (int i = 0; i < text.length(); ++i) {
            switch (text.charAt(i)) {
                case '\ue101': {
                    Code code = fragment.getCode(text.charAt(++i));
                    sb.append(String.format("<u id='%d'>", code.getId()));
                    continue block7;
                }
                case '\ue102': {
                    ++i;
                    sb.append("</u>");
                    continue block7;
                }
                case '\ue103': {
                    Code code = fragment.getCode(text.charAt(++i));
                    sb.append(String.format("<br id='%d'/>", code.getId()));
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                default: {
                    sb.append(text.charAt(i));
                }
            }
        }
        return sb.toString();
    }

    List<Insertion> getInsertions(String firstStr, String secondStr, List<Element> itsSpans) {
        LinkedList<Insertion> insertions = new LinkedList<Insertion>();
        int index1 = 0;
        int index2 = 0;
        for (Element itsSpan : itsSpans) {
            Insertion ins = this.getInsertion(index1, firstStr, index2, secondStr, itsSpan);
            index1 = ins.end;
            index2 = itsSpan.getEndTag().getEnd();
            insertions.add(ins);
        }
        return insertions;
    }

    Insertion getInsertion(int firstPos, String firstStr, int secondPos, String secondStr, Element span) {
        Insertion insertion = new Insertion();
        insertion.begin = this.getInsertionPosition(firstPos, firstStr, secondPos, secondStr, span.getStartTag().getBegin());
        insertion.end = this.getInsertionPosition(insertion.begin, firstStr, span.getStartTag().getEnd(), secondStr, span.getEndTag().getBegin());
        insertion.genAnn = this.createAnnotation(span);
        return insertion;
    }

    GenericAnnotations createAnnotation(Element itsSpan) {
        GenericAnnotations gas = new GenericAnnotations();
        GenericAnnotation ga = gas.add("disambiguation");
        Attributes attributes = itsSpan.getAttributes();
        for (Attribute attr : attributes) {
            if (!attr.getKey().startsWith("its-disambig-")) continue;
            ga.setString(attr.getKey(), attr.getValue());
        }
        return gas;
    }

    int getInsertionPosition(int firstPos, String firstStr, int secondPos, String secondStr, int secondMaxPos) {
        while (secondPos < secondMaxPos && firstStr.charAt(firstPos) == secondStr.charAt(secondPos)) {
            ++firstPos;
            ++secondPos;
        }
        if (secondPos == secondMaxPos) {
            return firstPos;
        }
        return -1;
    }

    void annotateFragment(TextFragment tf, List<Insertion> insertions) {
        int offset = 0;
        for (Insertion insertion : insertions) {
            tf.annotate(insertion.begin + offset, insertion.end + offset, "disambig", insertion.genAnn);
            offset += 4;
        }
    }

    List<Element> getItsElements(Source doc) {
        LinkedList<Element> itsSpans = new LinkedList<Element>();
        block0: for (Element span : doc.getAllElements("span")) {
            for (Attribute a : span.getAttributes()) {
                if (!a.getKey().startsWith("its-disambig-")) continue;
                itsSpans.add(span);
                continue block0;
            }
        }
        return itsSpans;
    }

    class Insertion {
        public int begin;
        public int end;
        public GenericAnnotations genAnn;

        Insertion() {
        }
    }
}

