/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.enrycher;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String BASEURL = "baseUrl";
    private String baseUrl;

    public Parameters() {
        this.reset();
    }

    @Override
    public void reset() {
        this.setBaseUrl("http://aidemo.ijs.si/mlw");
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.baseUrl = this.buffer.getString(BASEURL, this.baseUrl);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setParameter(BASEURL, this.baseUrl);
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(BASEURL, "URL of the Enrycher Web service", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Enrycher", true, false);
        desc.addTextInputPart(paramsDesc.get(BASEURL));
        return desc;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = Util.ensureSeparator(baseUrl, true);
    }
}

