/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.generatesimpletm;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiBadStepInputException;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.steps.generatesimpletm.Parameters;
import net.sf.okapi.tm.simpletm.Database;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class GenerateSimpleTmStep
extends BasePipelineStep {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Database simpleTm = null;
    private Parameters params = new Parameters();
    private LocaleId targetLocale;
    private String fileName;
    private int countIsNotTranslatable;
    private int countTuNotAdded;
    private int countTusAdded;
    private int countSegsAdded;
    private boolean isMultilingual;
    private String rootDir;

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.ROOT_DIRECTORY)
    public void setRootDirectory(String rootDir) {
        this.rootDir = rootDir;
    }

    @Override
    public String getName() {
        return "Generate SimpleTM";
    }

    @Override
    public String getDescription() {
        return "Generates a SimpleTM translation memory from multilingual input files. Expects filter events. Sends back: filter events.";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        if (Util.isEmpty(this.params.getTmPath())) {
            throw new OkapiBadStepInputException("Please provide a valid path and name for the TM.");
        }
        return event;
    }

    @Override
    protected Event handleStartBatchItem(Event event) {
        if (this.simpleTm == null) {
            this.simpleTm = new Database();
            this.simpleTm.create(Util.fillRootDirectoryVariable(this.params.getTmPath(), this.rootDir), true, this.targetLocale);
        }
        return event;
    }

    @Override
    protected Event handleEndBatchItem(Event event) {
        this.logger.info(String.format("\nSimpleTM output: %s", this.fileName));
        this.logger.info(String.format("Untranslatable text units = %d", this.countIsNotTranslatable));
        this.logger.info(String.format("Translatable text units but failed to add = %d", this.countTuNotAdded));
        this.logger.info(String.format("Text units added = %d", this.countTusAdded));
        this.logger.info(String.format("Segments added = %d", this.countSegsAdded));
        return event;
    }

    @Override
    protected Event handleEndBatch(Event event) {
        this.logger.info(String.format("Total untranslatable text units = %d", this.countIsNotTranslatable));
        this.logger.info(String.format("Total text units (Translatable) that failed to add = %d", this.countTuNotAdded));
        this.logger.info(String.format("Total text units added = %d", this.countTusAdded));
        this.logger.info(String.format("Total segments added = %d", this.countSegsAdded));
        this.logger.info(String.format("Total entries in generated simpleTm = %d", this.simpleTm.getEntryCount()));
        this.simpleTm.close();
        return event;
    }

    @Override
    protected Event handleStartDocument(Event event) {
        StartDocument sd = (StartDocument)event.getResource();
        this.fileName = Util.getFilename(sd.getName(), true);
        this.isMultilingual = sd.isMultilingual();
        if (!this.isMultilingual) {
            this.logger.warn("File " + this.fileName + " is not processed as a multiLingual file and cannot be used to populate the SimpleTm.");
        }
        return event;
    }

    @Override
    protected Event handleTextUnit(Event event) {
        int added;
        Property propFName;
        if (!this.isMultilingual) {
            ++this.countTuNotAdded;
            return event;
        }
        ITextUnit tu = event.getTextUnit();
        if (!tu.isTranslatable()) {
            ++this.countIsNotTranslatable;
            return event;
        }
        if (tu.getSource() == null) {
            this.logger.warn("TextUnit is missing source content.");
            ++this.countTuNotAdded;
            return event;
        }
        if (!tu.hasTarget(this.targetLocale) || tu.getTarget(this.targetLocale) == null) {
            this.logger.warn(String.format("TextUnit is missing '%s' target.", this.targetLocale));
            ++this.countTuNotAdded;
            return event;
        }
        Property propGName = tu.getProperty("GroupName");
        if (propGName == null) {
            propGName = tu.getProperty("Txt::GroupName");
        }
        if ((propFName = tu.getProperty("FileName")) == null) {
            propFName = tu.getProperty("Txt::FileName");
        }
        if ((added = this.simpleTm.addEntry(tu, propGName == null ? tu.getName() : propGName.getValue(), propFName == null ? this.fileName : propFName.getValue())) == 0) {
            ++this.countTuNotAdded;
        } else if (added > 0) {
            ++this.countTusAdded;
            this.countSegsAdded += added;
        }
        return event;
    }
}

