/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.gttbatchtranslation;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Source;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IWaitDialog;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.XMLWriter;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filterwriter.TMXWriter;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.lib.gtt.GTTClient;
import net.sf.okapi.lib.translation.QueryUtil;
import net.sf.okapi.steps.gttbatchtranslation.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class GTTBatchTranslationStep
extends BasePipelineStep {
    private static final long MAXSIZE = 1044480L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Parameters params = new Parameters();
    private QueryUtil qutil;
    private XMLWriter htmlWriter;
    private TMXWriter tmxWriter;
    private ArrayList<File> blocks;
    private GTTClient gtt;
    private LocaleId sourceLocale;
    private LocaleId targetLocale;
    private String tmId;
    private String rootDir;
    private int subDocId;
    private Map<String, String> attributes;
    private IWaitDialog waitDlg;
    private long count;
    private CharsetEncoder encoder;

    private void closeAndClean() {
        if (this.tmxWriter != null) {
            this.tmxWriter.writeEndDocument();
            this.tmxWriter.close();
            this.tmxWriter = null;
        }
        if (this.gtt != null && this.tmId != null) {
            this.gtt.deleteTM(this.tmId);
        }
    }

    @Override
    public String getDescription() {
        return "Creates a TM from the input documents using the Google Translator Toolkit. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public String getName() {
        return "GTT Batch Translation";
    }

    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourceLocale(LocaleId sourceLocale) {
        this.sourceLocale = sourceLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.ROOT_DIRECTORY)
    public void setRootDirectory(String rootDir) {
        this.rootDir = rootDir;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.blocks = new ArrayList();
        this.qutil = new QueryUtil();
        try {
            this.waitDlg = (IWaitDialog)Class.forName(this.params.getWaitClass()).newInstance();
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not create waiting dialog.");
        }
        this.gtt = new GTTClient(this.params.getEmail() + "-GTTBTrans-1");
        this.gtt.setCredentials(this.params.getEmail(), this.params.getPassword());
        this.gtt.setLanguages(this.sourceLocale, this.targetLocale);
        this.tmId = this.gtt.createTM("tempTM");
        if (this.tmId == null) {
            throw new RuntimeException("Could not create the initial temporary TM on GTT.");
        }
        String tmxOutputPath = Util.fillRootDirectoryVariable(this.params.getTmxPath(), this.rootDir);
        tmxOutputPath = LocaleId.replaceVariables(tmxOutputPath, this.sourceLocale, this.targetLocale);
        this.tmxWriter = new TMXWriter(tmxOutputPath);
        this.tmxWriter.writeStartDocument(this.sourceLocale, this.targetLocale, this.getClass().getCanonicalName(), "1", "sentence", null, "unknown");
        this.attributes = new Hashtable<String, String>();
        if (this.params.getMarkAsMT()) {
            this.attributes.put("creationid", "MT!");
        }
        this.attributes.put("Txt::Origin", "Google-GTT");
        this.encoder = Charset.forName("UTF-8").newEncoder();
        return event;
    }

    @Override
    protected Event handleEndBatch(Event event) {
        if (!this.blocks.isEmpty()) {
            this.processExtractionBlocks();
        }
        this.closeAndClean();
        return event;
    }

    @Override
    protected Event handleStartDocument(Event event) {
        this.subDocId = 0;
        this.startExtractedBlock();
        return event;
    }

    @Override
    protected Event handleEndDocument(Event event) {
        this.endExtractedBlock();
        return event;
    }

    @Override
    protected Event handleStartSubDocument(Event event) {
        ++this.subDocId;
        return event;
    }

    @Override
    protected Event handleEndSubDocument(Event event) {
        return event;
    }

    @Override
    protected Event handleTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        if (!tu.isTranslatable()) {
            return event;
        }
        ISegments segs = tu.getSourceSegments();
        for (Segment seg : segs) {
            if (!seg.text.hasText()) continue;
            this.htmlWriter.writeStartElement("p");
            String out = String.format("%d:%s:%s", this.subDocId, tu.getId(), seg.id);
            this.count += (long)(out.length() + 10);
            this.htmlWriter.writeAttributeString("id", out);
            out = this.qutil.toCodedHTML(seg.text);
            try {
                this.count += (long)this.encoder.encode(CharBuffer.wrap(out)).array().length;
            }
            catch (CharacterCodingException e) {
                // empty catch block
            }
            this.htmlWriter.writeRawXML(out);
            this.htmlWriter.writeEndElementLineBreak();
        }
        if (this.count >= 1044480L) {
            this.endExtractedBlock();
            this.startExtractedBlock();
        }
        return event;
    }

    private void startExtractedBlock() {
        try {
            File tmpFile = File.createTempFile("gttbt_", ".html");
            this.blocks.add(tmpFile);
            this.htmlWriter = new XMLWriter(tmpFile.getPath());
            this.htmlWriter.writeStartElement("html");
            this.htmlWriter.writeStartElement("meta");
            this.htmlWriter.writeAttributeString("http-equiv", "Content-Type");
            this.htmlWriter.writeAttributeString("content", "text/html; charset=UTF-8");
            this.htmlWriter.writeEndElementLineBreak();
            this.count = 100L;
        }
        catch (IOException e) {
            throw new OkapiIOException("Error creating extraction file.", e);
        }
    }

    private void endExtractedBlock() {
        this.htmlWriter.writeEndElementLineBreak();
        this.htmlWriter.close();
        if (this.blocks.size() >= 4) {
            this.processExtractionBlocks();
        }
    }

    private void processExtractionBlocks() {
        ArrayList<String> docIds = new ArrayList<String>();
        for (File inputFile : this.blocks) {
            String docId = this.gtt.uploadDocument(inputFile.getPath(), Util.getFilename(inputFile.getPath(), true), this.tmId);
            if (docId == null) {
                throw new RuntimeException(String.format("Could not upload block %s.", inputFile.getPath()));
            }
            docIds.add(docId);
            if (!this.params.getOpenGttPages()) continue;
            Util.openURL("http://translate.google.com/toolkit/workbench?did=" + docId);
        }
        int res = this.waitDlg.waitForUserInput("Please click Continue when you have open and save each uploaded block of text in GTT.", "Continue");
        if (res == 0) {
            this.cancel();
            return;
        }
        int i = 0;
        for (String docId : docIds) {
            File inputFile = this.blocks.get(i);
            File outputFile = new File(inputFile.getPath() + ".out");
            this.gtt.downloadDocument(docId, outputFile);
            this.gtt.deleteDocument(docId, true);
            this.alignTranslations(inputFile, outputFile);
            inputFile.delete();
            outputFile.delete();
            ++i;
        }
        this.blocks.clear();
    }

    private void alignTranslations(File inputFile, File outputFile) {
        try {
            Source trgHtml = new Source(outputFile.toURI().toURL());
            trgHtml.fullSequentialParse();
            List<Element> trgEntries = trgHtml.getAllElements("p");
            Source srcHtml = new Source(inputFile.toURI().toURL());
            srcHtml.fullSequentialParse();
            List<Element> srcEntries = srcHtml.getAllElements("p");
            int i = 0;
            for (Element srcElem : srcEntries) {
                Element trgElem = trgEntries.get(i);
                String id = srcElem.getAttributeValue("id");
                if (!id.equals(trgElem.getAttributeValue("id"))) {
                    throw new OkapiIOException(String.format("Source and target mismatched for %s", id));
                }
                try {
                    TextFragment srcFrag = this.qutil.fromCodedHTMLToFragment(srcElem.getContent().toString(), null);
                    TextFragment trgFrag = this.qutil.fromCodedHTMLToFragment(trgElem.getContent().toString(), null);
                    this.tmxWriter.writeTU(srcFrag, trgFrag, null, this.attributes);
                }
                catch (Throwable e) {
                    this.logger.warn(String.format("Skipping entry '%d'.\n", id) + e.getMessage());
                    continue;
                }
                ++i;
            }
        }
        catch (MalformedURLException e) {
            throw new OkapiIOException("Bad URL for temporary HTML", e);
        }
        catch (IOException e) {
            throw new OkapiIOException("Cannot open temporary HTML", e);
        }
    }
}

