/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.idaligner;

import java.util.HashMap;
import java.util.Map;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.exceptions.OkapiBadStepInputException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.TMXWriter;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.steps.idaligner.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class IdBasedAlignerStep
extends BasePipelineStep {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private Parameters params = new Parameters();
    private IFilter filter = null;
    private IFilterConfigurationMapper fcMapper;
    private LocaleId sourceLocale;
    private LocaleId targetLocale;
    private RawDocument targetInput = null;
    private TMXWriter tmx;
    private Map<String, ITextUnit> targetTextUnitMap;
    private boolean useTargetText;
    private boolean hasNoMatch;

    @StepParameterMapping(parameterType=StepParameterType.FILTER_CONFIGURATION_MAPPER)
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourceLocale(LocaleId sourceLocale) {
        this.sourceLocale = sourceLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.SECOND_INPUT_RAWDOC)
    public void setSecondInput(RawDocument secondInput) {
        this.targetInput = secondInput;
    }

    @Override
    public String getDescription() {
        return "Align text units in two id-based files (e.g. Java properties). Expects: filter events. Sends back: filter events.";
    }

    @Override
    public String getName() {
        return "Id-Based Aligner";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        if (this.tmx == null && this.params.getGenerateTMX()) {
            this.tmx = new TMXWriter(this.params.getTmxOutputPath());
            this.tmx.writeStartDocument(this.sourceLocale, this.targetLocale, this.getClass().getName(), null, "paragraph", null, null);
        }
        return event;
    }

    @Override
    protected Event handleEndBatch(Event event) {
        if (this.tmx != null) {
            this.tmx.writeEndDocument();
            this.tmx.close();
            this.tmx = null;
        }
        return event;
    }

    @Override
    protected Event handleStartDocument(Event event) {
        if (this.targetInput == null) {
            throw new OkapiBadStepInputException("Second input file (target) not configured.");
        }
        this.hasNoMatch = false;
        this.getTargetTextUnits();
        return event;
    }

    @Override
    protected Event handleEndDocument(Event event) {
        if (this.hasNoMatch) {
            this.LOGGER.warn("One or more entries has no match.");
        }
        if (this.filter != null) {
            this.filter.close();
        }
        return event;
    }

    @Override
    protected Event handleTextUnit(Event sourceEvent) {
        int score = 100;
        if (sourceEvent.getTextUnit().getSource().hasBeenSegmented()) {
            throw new OkapiBadStepInputException("IdBasedAlignerStep only aligns unsegmented text units.");
        }
        ITextUnit sourceTu = sourceEvent.getTextUnit();
        if (!sourceTu.isTranslatable() || sourceTu.isEmpty() || !sourceTu.getSource().hasText()) {
            return sourceEvent;
        }
        ITextUnit alignedTextUnit = sourceTu.clone();
        TextContainer targetTC = alignedTextUnit.createTarget(this.targetLocale, false, 2);
        ITextUnit refTu = this.targetTextUnitMap.get(sourceTu.getName());
        TextContainer refTc = null;
        boolean missingReferenceMatch = true;
        if (refTu != null && !refTu.isEmpty()) {
            if (this.useTargetText) {
                TextContainer srcRefTc = refTu.getSource();
                if (srcRefTc.compareTo(alignedTextUnit.getSource(), true) == 0) {
                    refTc = refTu.getTarget(this.targetLocale);
                } else {
                    missingReferenceMatch = false;
                }
            } else {
                refTc = refTu.getSource();
            }
        }
        if (refTc != null && refTc.hasText()) {
            alignedTextUnit.getSource().getFirstContent().alignCodeIds(refTc.getFirstContent());
            TextFragment tf = TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(sourceTu.getSource().getFirstContent(), refTc.getFirstContent(), true, false, null, alignedTextUnit);
            if (this.params.isCopyToTarget()) {
                targetTC.setContent(tf);
                Property prop = refTc.getProperty("approved");
                if (prop != null) {
                    targetTC.setProperty(prop.clone());
                }
            }
            if (this.params.isStoreAsAltTranslation()) {
                AltTranslation alt = new AltTranslation(this.sourceLocale, this.targetLocale, alignedTextUnit.getSource().getUnSegmentedContentCopy(), null, tf, MatchType.EXACT_UNIQUE_ID, score, this.getName());
                AltTranslationsAnnotation alta = TextUnitUtil.addAltTranslation(targetTC, alt);
                alta.sort();
            }
        } else {
            if (missingReferenceMatch) {
                if (sourceTu.getName() == null) {
                    this.LOGGER.info(String.format("Entry without original identifier (id='%s').", sourceTu.getId()));
                    this.hasNoMatch = true;
                } else {
                    this.LOGGER.info("No match found for " + sourceTu.getName());
                    this.hasNoMatch = true;
                }
            } else {
                this.LOGGER.info("Source texts differ for " + sourceTu.getName());
                this.hasNoMatch = true;
            }
            if (this.params.getReplaceWithSource()) {
                alignedTextUnit.setTarget(this.targetLocale, sourceTu.getSource());
            }
        }
        if (!this.params.getGenerateTMX()) {
            return new Event(EventType.TEXT_UNIT, alignedTextUnit);
        }
        this.tmx.writeTUFull(alignedTextUnit);
        return sourceEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTargetTextUnits() {
        try {
            this.targetTextUnitMap = new HashMap<String, ITextUnit>();
            this.filter = this.fcMapper.createFilter(this.targetInput.getFilterConfigId(), null);
            this.filter.open(this.targetInput);
            while (this.filter.hasNext()) {
                Event event = this.filter.next();
                if (event.getEventType() == EventType.TEXT_UNIT) {
                    ITextUnit tu = event.getTextUnit();
                    if (!tu.getSource().hasText()) continue;
                    if (tu.getName() == null) {
                        this.LOGGER.info(String.format("Missing original identifier in target (id='%s').", tu.getId()));
                        this.hasNoMatch = true;
                        continue;
                    }
                    if (this.targetTextUnitMap.get(tu.getName()) != null) {
                        this.LOGGER.info("Duplicate entry for " + tu.getName());
                        this.hasNoMatch = true;
                        continue;
                    }
                    this.targetTextUnitMap.put(tu.getName(), tu);
                    continue;
                }
                if (event.getEventType() != EventType.START_DOCUMENT) continue;
                this.useTargetText = event.getStartDocument().isMultilingual();
            }
        }
        finally {
            if (this.filter != null) {
                this.filter.close();
            }
        }
    }
}

