/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.leveraging;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filterwriter.TMXWriter;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.lib.translation.QueryManager;
import net.sf.okapi.lib.translation.ResourceItem;
import net.sf.okapi.steps.leveraging.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class LeveragingStep
extends BasePipelineStep {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Parameters params = new Parameters();
    private LocaleId sourceLocale;
    private LocaleId targetLocale;
    private QueryManager qm;
    private TMXWriter tmxWriter;
    private String rootDir;
    private String inputRootDir;
    private boolean initDone;
    private int totalCount;
    private int exactCount;
    private int fuzzyCount;
    private int iQueryId;
    private ClassLoader connectorContext;

    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourceLocale(LocaleId sourceLocale) {
        this.sourceLocale = sourceLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.ROOT_DIRECTORY)
    public void setRootDirectory(String rootDir) {
        this.rootDir = rootDir;
    }

    @StepParameterMapping(parameterType=StepParameterType.INPUT_ROOT_DIRECTORY)
    public void setInputRootDirectory(String inputRootDir) {
        this.inputRootDir = inputRootDir;
    }

    @Override
    public String getName() {
        return "Leveraging";
    }

    @Override
    public String getDescription() {
        return "Leverage existing translation into the text units content of a document. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.totalCount = 0;
        this.exactCount = 0;
        this.fuzzyCount = 0;
        this.initDone = false;
        return event;
    }

    @Override
    protected Event handleEndBatch(Event event) {
        if (!this.params.getLeverage()) {
            return event;
        }
        this.logger.info(String.format("\nTotals:\nProcesseed segments = %d", this.totalCount));
        this.logger.info(String.format("Best matches that are exact = %d", this.exactCount));
        this.logger.info(String.format("Best matches that are fuzzy = %d", this.fuzzyCount));
        this.destroy();
        return event;
    }

    @Override
    protected Event handleStartDocument(Event event) {
        if (!this.params.getLeverage()) {
            return event;
        }
        if (!this.initDone) {
            this.initialize();
        }
        this.qm.setLanguages(this.sourceLocale, this.targetLocale);
        this.qm.resetCounters();
        return event;
    }

    @Override
    protected Event handleEndDocument(Event event) {
        if (!this.params.getLeverage()) {
            return event;
        }
        this.totalCount += this.qm.getTotalSegments();
        this.exactCount += this.qm.getExactBestMatches();
        this.fuzzyCount += this.qm.getFuzzyBestMatches();
        this.logger.info(String.format("Processeed segments = %d", this.qm.getTotalSegments()));
        this.logger.info(String.format("Best matches that are exact = %d", this.qm.getExactBestMatches()));
        this.logger.info(String.format("Best matches that are fuzzy = %d", this.qm.getFuzzyBestMatches()));
        return event;
    }

    @Override
    protected Event handleTextUnit(Event event) {
        if (!this.params.getLeverage()) {
            return event;
        }
        ITextUnit tu = event.getTextUnit();
        if (!tu.isTranslatable()) {
            return event;
        }
        boolean approved = false;
        Property prop = tu.getTargetProperty(this.targetLocale, "approved");
        if (prop != null && "yes".equals(prop.getValue())) {
            approved = true;
        }
        if (approved) {
            return event;
        }
        this.qm.leverage(tu);
        if (this.tmxWriter != null) {
            this.tmxWriter.writeAlternates(tu, this.targetLocale);
        }
        return event;
    }

    @Override
    public void destroy() {
        if (this.qm != null) {
            this.qm.close();
            this.qm = null;
        }
        if (this.tmxWriter != null) {
            this.tmxWriter.writeEndDocument();
            this.tmxWriter.close();
            this.tmxWriter = null;
        }
    }

    private void initialize() {
        if (!this.params.getLeverage()) {
            this.initDone = true;
            return;
        }
        this.qm = new QueryManager();
        this.qm.setNoQueryThreshold(this.params.getNoQueryThreshold());
        this.qm.setThreshold(this.params.getThreshold());
        this.qm.setRootDirectory(this.rootDir);
        this.iQueryId = this.connectorContext == null || this.connectorContext == Thread.currentThread().getContextClassLoader() ? this.qm.addAndInitializeResource(this.params.getResourceClassName(), null, this.params.getResourceParameters()) : this.qm.addAndInitializeResource(this.params.getResourceClassName(), null, this.connectorContext, this.params.getResourceParameters());
        ResourceItem res = this.qm.getResource(this.iQueryId);
        this.logger.info("Leveraging settings: " + res.name);
        this.logger.info(res.query.getSettingsDisplay());
        String targetPrefix = this.params.getUseTargetPrefix() ? this.params.getTargetPrefix() : null;
        this.qm.setOptions(this.params.getFillTarget() ? this.params.getFillTargetThreshold() : Integer.MAX_VALUE, true, true, this.params.getDowngradeIdenticalBestMatches(), targetPrefix, this.params.getTargetPrefixThreshold(), this.params.getCopySourceOnNoText());
        if (this.params.getMakeTMX()) {
            String realPath = Util.fillRootDirectoryVariable(this.params.getTMXPath(), this.rootDir);
            realPath = Util.fillInputRootDirectoryVariable(realPath, this.inputRootDir);
            realPath = LocaleId.replaceVariables(realPath, this.sourceLocale, this.targetLocale);
            this.tmxWriter = new TMXWriter(realPath);
            this.tmxWriter.setUseMTPrefix(this.params.getUseMTPrefix());
            this.tmxWriter.writeStartDocument(this.sourceLocale, this.targetLocale, this.getClass().getName(), "1", "sentence", "undefined", "undefined");
        }
        this.initDone = true;
    }

    public void setConnectorContext(ClassLoader connectorContext) {
        this.connectorContext = connectorContext;
    }
}

