/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.paraaligner;

import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.steps.gcaligner.AlignmentFunction;
import net.sf.okapi.steps.gcaligner.AlignmentScorer;
import net.sf.okapi.steps.gcaligner.DpMatrix;
import net.sf.okapi.steps.gcaligner.DpMatrixCell;
import net.sf.okapi.steps.gcaligner.Penalties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParagraphAligner {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final long MAX_CELL_SIZE = 80000L;
    private List<AlignmentScorer<ITextUnit>> scorerList;

    public ParagraphAligner(List<AlignmentScorer<ITextUnit>> scorerList) {
        this.scorerList = scorerList;
    }

    public List<ITextUnit> align(List<ITextUnit> sourceParagraphs, List<ITextUnit> targetParagraphs, LocaleId srcLocale, LocaleId trgLocale, boolean outputOneTOneMatchesOnly) {
        return this.alignWithoutSkeletonAlignment(sourceParagraphs, targetParagraphs, srcLocale, trgLocale, outputOneTOneMatchesOnly);
    }

    private List<ITextUnit> alignWithoutSkeletonAlignment(List<ITextUnit> sourceParagraphs, List<ITextUnit> targetParagraphs, LocaleId srcLocale, LocaleId trgLocale, boolean outputOneTOneMatchesOnly) {
        AlignmentFunction<ITextUnit> alignmentFunction = new AlignmentFunction<ITextUnit>(srcLocale, trgLocale, this.scorerList, new Penalties());
        return this.alignSegments(sourceParagraphs, targetParagraphs, srcLocale, trgLocale, alignmentFunction, outputOneTOneMatchesOnly);
    }

    private List<ITextUnit> alignSegments(List<ITextUnit> sourceParagraphs, List<ITextUnit> targetParagraphs, LocaleId srcLocale, LocaleId trgLocale, AlignmentFunction<ITextUnit> alignmentFunction, boolean outputOneTOneMatchesOnly) {
        if ((long)(sourceParagraphs.size() * targetParagraphs.size()) > 80000L) {
            throw new IllegalArgumentException("Too many segments. Can only align " + Long.toString(80000L) + ". Where the number equals the source segments times the target segments.");
        }
        DpMatrix<ITextUnit> matrix = new DpMatrix<ITextUnit>(sourceParagraphs, targetParagraphs, alignmentFunction);
        List<DpMatrixCell> result = matrix.align();
        for (DpMatrixCell cell : result) {
            ITextUnit targetSegment;
            ITextUnit sourceSegment;
            if (outputOneTOneMatchesOnly) {
                if (cell.getState() != 3) continue;
                sourceSegment = matrix.getAlignmentElementX(cell.getXindex());
                targetSegment = matrix.getAlignmentElementY(cell.getYindex());
                continue;
            }
            if (cell.getState() == 1) {
                sourceSegment = matrix.getAlignmentElementX(cell.getXindex());
                this.LOGGER.warn(sourceSegment.toString() + "\nTarget segment deleted (TU ID: " + sourceSegment.getName() + "): Non 1-1 match. Please confirm alignment.");
                continue;
            }
            if (cell.getState() == 2) {
                ITextUnit targetSegment2 = matrix.getAlignmentElementY(cell.getYindex());
                this.LOGGER.warn(targetSegment2.toString() + "\nSource segment deleted (TU ID: " + targetSegment2.getName() + "): Non 1-1 match. Please confirm alignment.");
                continue;
            }
            if (cell.getState() == 3) {
                sourceSegment = matrix.getAlignmentElementX(cell.getXindex());
                targetSegment = matrix.getAlignmentElementY(cell.getYindex());
                continue;
            }
            if (cell.getState() != 4) continue;
            List<ITextUnit> sourceSegments = matrix.getAlignmentElementsX(cell.getMultiMatchXIndexBegin(), cell.getMultiMatchXIndexEnd());
            List<ITextUnit> targetSegments = matrix.getAlignmentElementsY(cell.getMultiMatchYIndexBegin(), cell.getMultiMatchYIndexEnd());
            this.LOGGER.warn(sourceSegments.get(0).getSource().toString() + "\nMulti-ITextUnit Match (TU ID: " + sourceSegments.get(0).getName() + "): Non 1-1 match. Please confirm alignment.");
        }
        return sourceParagraphs;
    }
}

