/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.paraaligner;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.steps.gcaligner.AlignmentScorer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParagraphGaleAndChurch
implements AlignmentScorer<ITextUnit> {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final int BIG_DISTANCE = 2500;
    private double m_charDist;

    @Override
    public void setLocales(LocaleId p_sourceLocale, LocaleId p_targetLocale) {
        this.m_charDist = this.getCharacterDistribution(p_sourceLocale, p_targetLocale);
        this.LOGGER.trace("Character Distribution = " + this.m_charDist);
    }

    @Override
    public int substitutionScore(ITextUnit p_sourceTuv, ITextUnit p_targetTuv) {
        int sourceLength = p_sourceTuv.toString().length();
        int targetLength = p_targetTuv.toString().length();
        return this.match(sourceLength, targetLength);
    }

    @Override
    public int deletionScore(ITextUnit p_sourceTuv) {
        int sourceLength = p_sourceTuv.toString().length();
        return this.match(sourceLength, 0);
    }

    @Override
    public int insertionScore(ITextUnit p_targetTuv) {
        int targetLength = p_targetTuv.toString().length();
        return this.match(0, targetLength);
    }

    @Override
    public int contractionScore(ITextUnit p_sourceTuv1, ITextUnit p_sourceTuv2, ITextUnit p_targetTuv) {
        int sourceLength1 = p_sourceTuv1.toString().length();
        int sourceLength2 = p_sourceTuv2.toString().length();
        int targetLength = p_targetTuv.toString().length();
        return this.match(sourceLength1 + sourceLength2, targetLength);
    }

    @Override
    public int expansionScore(ITextUnit p_sourceTuv, ITextUnit p_targetTuv1, ITextUnit p_targetTuv2) {
        int sourceLength = p_sourceTuv.toString().length();
        int targetLength1 = p_targetTuv1.toString().length();
        int targetLength2 = p_targetTuv2.toString().length();
        return this.match(sourceLength, targetLength1 + targetLength2);
    }

    @Override
    public int meldingScore(ITextUnit p_sourceTuv1, ITextUnit p_sourceTuv2, ITextUnit p_targetTuv1, ITextUnit p_targetTuv2) {
        int sourceLength1 = p_sourceTuv1.toString().length();
        int sourceLength2 = p_sourceTuv2.toString().length();
        int targetLength1 = p_targetTuv1.toString().length();
        int targetLength2 = p_targetTuv2.toString().length();
        return this.match(sourceLength1 + sourceLength2, targetLength1 + targetLength2);
    }

    private double pnorm(double z) {
        double t = 1.0 / (1.0 + 0.2316419 * z);
        double pd = 1.0 - 0.3989423 * Math.exp(-z * z / 2.0) * ((((1.330274429 * t - 1.821255978) * t + 1.781477937) * t - 0.356563782) * t + 0.31938153) * t;
        return pd;
    }

    public int match(int len1, int len2) {
        double pd;
        double var_per_eng_char = 6.8;
        if (len1 == 0 && len2 == 0) {
            return 0;
        }
        double mean = ((double)len1 + (double)len2 / this.m_charDist) / 2.0;
        double z = (this.m_charDist * (double)len1 - (double)len2) / Math.sqrt(var_per_eng_char * mean);
        if (z < 0.0) {
            z = -z;
        }
        if ((pd = 2.0 * (1.0 - this.pnorm(z))) > 0.0) {
            return (int)(-100.0 * Math.log(pd));
        }
        return 2500;
    }

    public double prob(int len1, int len2) {
        double var_per_eng_char = 6.8;
        if (len1 == 0 && len2 == 0) {
            return 0.0;
        }
        double mean = ((double)len1 + (double)len2 / this.m_charDist) / 2.0;
        double z = (this.m_charDist * (double)len1 - (double)len2) / Math.sqrt(var_per_eng_char * mean);
        if (z < 0.0) {
            z = -z;
        }
        double pd = 2.0 * (1.0 - this.pnorm(z));
        return pd;
    }

    private double getCharacterDistribution(LocaleId p_sourceLocale, LocaleId p_targetLocale) {
        double charDist = 1.0;
        try {
            double srcCharDist = this.getCharDistProperty(p_sourceLocale);
            double trgCharDist = this.getCharDistProperty(p_targetLocale);
            charDist = trgCharDist / srcCharDist;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return charDist;
    }

    private double getCharDistProperty(LocaleId p_locale) throws Exception {
        String lang = p_locale.getLanguage();
        String locale = p_locale.toString();
        ResourceBundle res = ResourceBundle.getBundle("net/sf/okapi/steps/gcaligner/CharDist");
        String charDistStr = null;
        try {
            charDistStr = res.getString(lang);
        }
        catch (MissingResourceException e) {
            try {
                charDistStr = res.getString(locale);
            }
            catch (MissingResourceException e2) {
                charDistStr = "1";
            }
        }
        return Double.parseDouble(charDistStr);
    }
}

