/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.translationcomparison;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.PathInputPart;
import net.sf.okapi.common.uidescription.TextInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    public static final String GENERATETMX = "generateTMX";
    public static final String TMXPATH = "tmxPath";
    public static final String GENERATEHTML = "generateHTML";
    public static final String GENERICCODES = "genericCodes";
    public static final String AUTOOPEN = "autoOpen";
    public static final String TARGET2SUFFIX = "target2Suffix";
    public static final String TARGET3SUFFIX = "target3Suffix";
    public static final String DOCUMENT1LABEL = "document1Label";
    public static final String DOCUMENT2LABEL = "document2Label";
    public static final String DOCUMENT3LABEL = "document3Label";
    public static final String CASESENSITIVE = "caseSensitive";
    public static final String WHITESPACESENSITIVE = "whitespaceSensitive";
    public static final String PUNCTUATIONSENSITIVE = "punctuationSensitive";
    private boolean generateTMX;
    private String tmxPath;
    private boolean generateHTML;
    private boolean genericCodes;
    private boolean autoOpen;
    private boolean caseSensitive;
    private boolean whitespaceSensitive;
    private boolean punctuationSensitive;
    private String target2Suffix;
    private String target3Suffix;
    private String document1Label;
    private String document2Label;
    private String document3Label;

    public Parameters() {
        this.reset();
    }

    public boolean isGenerateTMX() {
        return this.generateTMX;
    }

    public void setGenerateTMX(boolean generateTMX) {
        this.generateTMX = generateTMX;
    }

    public String getTmxPath() {
        return this.tmxPath;
    }

    public void setTmxPath(String tmxPath) {
        this.tmxPath = tmxPath;
    }

    public boolean isGenerateHTML() {
        return this.generateHTML;
    }

    public void setGenerateHTML(boolean generateHTML) {
        this.generateHTML = generateHTML;
    }

    public boolean getGenericCodes() {
        return this.genericCodes;
    }

    public void setGenericCodes(boolean genericCodes) {
        this.genericCodes = genericCodes;
    }

    public boolean isAutoOpen() {
        return this.autoOpen;
    }

    public void setAutoOpen(boolean autoOpen) {
        this.autoOpen = autoOpen;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isWhitespaceSensitive() {
        return this.whitespaceSensitive;
    }

    public void setWhitespaceSensitive(boolean whitespaceSensitive) {
        this.whitespaceSensitive = whitespaceSensitive;
    }

    public boolean isPunctuationSensitive() {
        return this.punctuationSensitive;
    }

    public void setPunctuationSensitive(boolean punctuationSensitive) {
        this.punctuationSensitive = punctuationSensitive;
    }

    public String getTarget2Suffix() {
        return this.target2Suffix;
    }

    public void setTarget2Suffix(String target2Suffix) {
        this.target2Suffix = target2Suffix;
    }

    public String getTarget3Suffix() {
        return this.target3Suffix;
    }

    public void setTarget3Suffix(String target3Suffix) {
        this.target3Suffix = target3Suffix;
    }

    public String getDocument1Label() {
        return this.document1Label;
    }

    public void setDocument1Label(String document1Label) {
        this.document1Label = document1Label;
    }

    public String getDocument2Label() {
        return this.document2Label;
    }

    public void setDocument2Label(String document2Label) {
        this.document2Label = document2Label;
    }

    public String getDocument3Label() {
        return this.document3Label;
    }

    public void setDocument3Label(String document3Label) {
        this.document3Label = document3Label;
    }

    @Override
    public void reset() {
        this.generateTMX = false;
        this.tmxPath = "comparison.tmx";
        this.generateHTML = true;
        this.autoOpen = true;
        this.genericCodes = true;
        this.caseSensitive = true;
        this.whitespaceSensitive = true;
        this.punctuationSensitive = true;
        this.target2Suffix = "-t2";
        this.target3Suffix = "-t3";
        this.document1Label = "Trans1";
        this.document2Label = "Trans2";
        this.document3Label = "Trans3";
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.generateTMX = this.buffer.getBoolean(GENERATETMX, this.generateTMX);
        this.tmxPath = this.buffer.getString(TMXPATH, this.tmxPath);
        this.generateHTML = this.buffer.getBoolean(GENERATEHTML, this.generateHTML);
        this.autoOpen = this.buffer.getBoolean(AUTOOPEN, this.autoOpen);
        this.genericCodes = this.buffer.getBoolean(GENERICCODES, this.genericCodes);
        this.caseSensitive = this.buffer.getBoolean(CASESENSITIVE, this.caseSensitive);
        this.whitespaceSensitive = this.buffer.getBoolean(WHITESPACESENSITIVE, this.whitespaceSensitive);
        this.punctuationSensitive = this.buffer.getBoolean(PUNCTUATIONSENSITIVE, this.punctuationSensitive);
        this.target2Suffix = this.buffer.getString(TARGET2SUFFIX, this.target2Suffix);
        this.target3Suffix = this.buffer.getString(TARGET3SUFFIX, this.target3Suffix);
        this.document1Label = this.buffer.getString(DOCUMENT1LABEL, this.document1Label);
        this.document2Label = this.buffer.getString(DOCUMENT2LABEL, this.document2Label);
        this.document3Label = this.buffer.getString(DOCUMENT3LABEL, this.document3Label);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setBoolean(GENERATETMX, this.generateTMX);
        this.buffer.setParameter(TMXPATH, this.tmxPath);
        this.buffer.setBoolean(GENERATEHTML, this.generateHTML);
        this.buffer.setBoolean(AUTOOPEN, this.autoOpen);
        this.buffer.setBoolean(GENERICCODES, this.genericCodes);
        this.buffer.setBoolean(CASESENSITIVE, this.caseSensitive);
        this.buffer.setBoolean(WHITESPACESENSITIVE, this.whitespaceSensitive);
        this.buffer.setBoolean(PUNCTUATIONSENSITIVE, this.punctuationSensitive);
        this.buffer.setParameter(TARGET2SUFFIX, this.target2Suffix);
        this.buffer.setParameter(TARGET3SUFFIX, this.target3Suffix);
        this.buffer.setParameter(DOCUMENT1LABEL, this.document1Label);
        this.buffer.setParameter(DOCUMENT2LABEL, this.document2Label);
        this.buffer.setParameter(DOCUMENT3LABEL, this.document3Label);
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(GENERATETMX, "Generate a TMX output document", "Generates an output document in TMX");
        desc.add(TMXPATH, "TMX output path", "Full path of the output TMX file");
        desc.add(GENERATEHTML, "Generate output tables in HTML", "Generates output tables in HTML");
        desc.add(GENERICCODES, "Use generic representation (e.g. <1>...</1>) for the inline codes", null);
        desc.add(AUTOOPEN, "Opens the first HTML output after completion", null);
        desc.add(TARGET2SUFFIX, "Suffix for target language code of document 2", null);
        desc.add(TARGET3SUFFIX, "Suffix for target language code of document 3", null);
        desc.add(DOCUMENT1LABEL, "Label for the document 1", null);
        desc.add(DOCUMENT2LABEL, "Label for the document 2", null);
        desc.add(DOCUMENT3LABEL, "Label for the document 3", null);
        desc.add(CASESENSITIVE, "Take into account case differences", "Takes into account case differences");
        desc.add(WHITESPACESENSITIVE, "Take into account whitespace differences", "Takes into account whitespace differences");
        desc.add(PUNCTUATIONSENSITIVE, "Take into account punctuation differences", "Takes into account punctuation differences");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Translation Comparison", true, false);
        CheckboxPart cbpHTML = desc.addCheckboxPart(paramsDesc.get(GENERATEHTML));
        desc.addCheckboxPart(paramsDesc.get(GENERICCODES)).setMasterPart(cbpHTML, true);
        desc.addCheckboxPart(paramsDesc.get(AUTOOPEN)).setMasterPart(cbpHTML, true);
        CheckboxPart cbpTMX = desc.addCheckboxPart(paramsDesc.get(GENERATETMX));
        PathInputPart pip = desc.addPathInputPart(paramsDesc.get(TMXPATH), "TMX Document", true);
        pip.setBrowseFilters("TMX Documents (*.tmx)\tAll Files (*.*)", "*.tmx\t*.*");
        pip.setMasterPart(cbpTMX, true);
        pip.setWithLabel(false);
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(TARGET2SUFFIX));
        tip.setMasterPart(cbpTMX, true);
        tip = desc.addTextInputPart(paramsDesc.get(TARGET3SUFFIX));
        tip.setMasterPart(cbpTMX, true);
        tip = desc.addTextInputPart(paramsDesc.get(DOCUMENT1LABEL));
        tip.setMasterPart(cbpHTML, true);
        tip.setVertical(false);
        tip = desc.addTextInputPart(paramsDesc.get(DOCUMENT2LABEL));
        tip.setMasterPart(cbpHTML, true);
        tip.setVertical(false);
        tip = desc.addTextInputPart(paramsDesc.get(DOCUMENT3LABEL));
        tip.setMasterPart(cbpHTML, true);
        tip.setVertical(false);
        desc.addCheckboxPart(paramsDesc.get(CASESENSITIVE));
        desc.addCheckboxPart(paramsDesc.get(WHITESPACESENSITIVE));
        desc.addCheckboxPart(paramsDesc.get(PUNCTUATIONSENSITIVE));
        return desc;
    }
}

