/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffkit.reader;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Range;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextUnitMerger {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean useApprovedOnly;
    private boolean updateApprovedFlag;
    private LocaleId trgLoc;

    public void mergeTargets(ITextUnit tu, ITextUnit tuFromTrans) {
        if (!tu.isTranslatable()) {
            return;
        }
        if (!tu.getId().equals(tuFromTrans.getId())) {
            this.logger.warn(String.format("ID mismatch: Original item id=\"%s\" package item id=\"%s\".", tu.getId(), tuFromTrans.getId()));
            return;
        }
        if (!tuFromTrans.hasTarget(this.trgLoc) && !tu.getSource().isEmpty()) {
            this.logger.warn(String.format("Item id=\"%s\": No translation provided; using source instead.", tu.getId()));
            return;
        }
        boolean isTransApproved = false;
        Property prop = tuFromTrans.getTargetProperty(this.trgLoc, "approved");
        if (prop != null) {
            isTransApproved = prop.getValue().equals("yes");
        }
        if (this.useApprovedOnly && !isTransApproved) {
            this.logger.warn(String.format("Item id='%s': Target is not approved; using source instead.", tu.getId()));
            return;
        }
        TextContainer fromTrans = tuFromTrans.getTarget(this.trgLoc);
        if (fromTrans == null) {
            if (tuFromTrans.getSource().isEmpty()) {
                return;
            }
            this.logger.warn(String.format("Item id='%s': No target in XLIFF; using source instead.", tu.getId()));
            return;
        }
        boolean mergeAsSegments = true;
        ArrayList<Range> ranges = null;
        List<Range> srcRanges = null;
        if (mergeAsSegments) {
            ranges = new ArrayList<Range>();
            srcRanges = tuFromTrans.getSourceSegments().getRanges();
        }
        TextContainer origFromTrans = fromTrans.clone();
        if (!fromTrans.contentIsOneSegment()) {
            fromTrans.getSegments().joinAll(ranges);
        }
        TextContainer srcCont = !tu.getSource().contentIsOneSegment() ? tu.getSource() : tu.getSource();
        List<Code> transCodes = this.transferCodes(fromTrans, srcCont, tu);
        TextContainer trgCont = tu.createTarget(this.trgLoc, false, 7);
        if (!trgCont.contentIsOneSegment()) {
            trgCont.getSegments().joinAll();
        }
        if (this.updateApprovedFlag) {
            prop = trgCont.getProperty("approved");
            if (prop == null) {
                prop = trgCont.setProperty(new Property("approved", "no"));
            }
            prop.setValue("yes");
        }
        try {
            trgCont.getFirstContent().setCodedText(fromTrans.getCodedText(), transCodes, false);
            if (mergeAsSegments) {
                trgCont.getSegments().create(ranges, true);
            }
        }
        catch (RuntimeException e) {
            this.logger.error(String.format("Inline code error with item id=\"%s\".\n" + e.getLocalizedMessage(), tu.getId()));
            tu.setTarget(this.trgLoc, tu.getSource());
        }
        for (Segment seg : origFromTrans.getSegments()) {
            Segment tseg = trgCont.getSegments().get(seg.id);
            if (tseg == null || seg.getAnnotations() == null) continue;
            for (IAnnotation ann : seg.getAnnotations()) {
                tseg.setAnnotation(ann);
            }
        }
    }

    private List<Code> transferCodes(TextContainer fromTrans, TextContainer srcCont, ITextUnit tu) {
        int i;
        List<Code> transCodes = fromTrans.getFirstContent().getCodes();
        List<Code> oriCodes = srcCont.getFirstContent().getCodes();
        if (transCodes.size() == 0 && oriCodes.size() == 0) {
            return transCodes;
        }
        int[] oriIndices = new int[oriCodes.size()];
        for (int i2 = 0; i2 < oriIndices.length; ++i2) {
            oriIndices[i2] = i2;
        }
        int done = 0;
        for (i = 0; i < transCodes.size(); ++i) {
            Code transCode = transCodes.get(i);
            transCode.setOuterData(null);
            Code oriCode = null;
            for (int j = 0; j < oriIndices.length; ++j) {
                if (oriIndices[j] == -1 || oriCodes.get(oriIndices[j]).getId() != transCode.getId()) continue;
                oriCode = oriCodes.get(oriIndices[j]);
                oriIndices[j] = -1;
                ++done;
                break;
            }
            if (oriCode == null) {
                if (transCode.hasData()) continue;
                this.logger.warn(String.format("The extra target code id='%d' does not have corresponding data (item id='%s', name='%s')", transCode.getId(), tu.getId(), tu.getName() == null ? "" : tu.getName()));
                continue;
            }
            if (oriCode.hasOuterData()) {
                transCode.setOuterData(oriCode.getOuterData());
            } else if (!transCode.hasData()) {
                transCode.setData(oriCode.getData());
            }
            transCode.setReferenceFlag(oriCode.hasReference());
        }
        if (oriCodes.size() > done) {
            for (i = 0; i < oriIndices.length; ++i) {
                Code code;
                if (oriIndices[i] == -1 || (code = oriCodes.get(oriIndices[i])).isDeleteable()) continue;
                this.logger.warn(String.format("The code id='%d' (%s) is missing in target (item id='%s', name='%s')", code.getId(), code.getData(), tu.getId(), tu.getName() == null ? "" : tu.getName()));
                this.logger.info("Source='" + tu.getSource().toString() + "'");
            }
        }
        return transCodes;
    }

    public boolean isUseApprovedOnly() {
        return this.useApprovedOnly;
    }

    public void setUseApprovedOnly(boolean useApprovedOnly) {
        this.useApprovedOnly = useApprovedOnly;
    }

    public boolean isUpdateApprovedFlag() {
        return this.updateApprovedFlag;
    }

    public void setUpdateApprovedFlag(boolean updateApprovedFlag) {
        this.updateApprovedFlag = updateApprovedFlag;
    }

    public LocaleId getTrgLoc() {
        return this.trgLoc;
    }

    public void setTrgLoc(LocaleId trgLoc) {
        this.trgLoc = trgLoc;
    }
}

