/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.its;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.exceptions.OkapiIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.its.IProcessor;
import org.w3c.its.ITSException;
import org.w3c.its.ITSRule;
import org.w3c.its.ITSTrace;
import org.w3c.its.ITraversal;
import org.w3c.its.NSContextManager;
import org.w3c.its.TargetPointerEntry;
import org.w3c.its.VariableResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ITSEngine
implements IProcessor,
ITraversal {
    public static final String ITS_VERSION1 = "1.0";
    public static final String ITS_VERSION2 = "2.0";
    public static final String XML_NS_URI = "http://www.w3.org/XML/1998/namespace";
    public static final String XML_NS_PREFIX = "xml";
    public static final String ITS_NS_URI = "http://www.w3.org/2005/11/its";
    public static final String ITS_NS_PREFIX = "its";
    public static final String ITSX_NS_URI = "http://www.w3.org/2008/12/its-extensions";
    public static final String ITSX_NS_PREFIX = "itsx";
    public static final String XLINK_NS_URI = "http://www.w3.org/1999/xlink";
    public static final String XLINK_NS_PREFIX = "xlink";
    public static final String HTML_NS_URI = "http://www.w3.org/1999/xhtml";
    public static final String HTML_NS_PREFIX = "h";
    public static final String ITS_MIMETYPE = "application/its+xml";
    private static final String FLAGNAME = "\u00ff";
    private static final String FLAGSEP = "\u001c";
    private static final String FLAGDEFAULTDATA = "????????????????\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c";
    private static final String SRC_TRGPTRFLAGNAME = "\u10ff";
    private static final String TRG_TRGPTRFLAGNAME = "\u20ff";
    private static final String LQISSUE = "its-lqi";
    private static final String LQIISSUESREF = "lqiIssuesRef";
    private static final String LQITYPE = "lqiType";
    private static final String LQICOMMENT = "lqiComment";
    private static final String LQISEVERITY = "lqiSeverity";
    private static final String LQIPROFILEREF = "lqiProfileRef";
    private static final String LQIENABLED = "lqiEnabled";
    private static final String PTRPREFIX = "@@";
    private static final int FP_TRANSLATE = 0;
    private static final int FP_DIRECTIONALITY = 1;
    private static final int FP_WITHINTEXT = 2;
    private static final int FP_TERMINOLOGY = 3;
    private static final int FP_LOCNOTE = 4;
    private static final int FP_PRESERVEWS = 5;
    private static final int FP_LANGINFO = 6;
    private static final int FP_DOMAIN = 7;
    private static final int FP_EXTERNALRES = 8;
    private static final int FP_LOCFILTER = 9;
    private static final int FP_LQISSUE = 10;
    private static final int FP_STORAGESIZE = 11;
    private static final int FP_ALLOWEDCHARS = 12;
    private static final int FP_SUBFILTER = 13;
    private static final int FP_TARGETPOINTER = 14;
    private static final int FP_TOOLSREF = 15;
    private static final int FP_TERMINOLOGY_DATA = 0;
    private static final int FP_LOCNOTE_DATA = 1;
    private static final int FP_LANGINFO_DATA = 2;
    private static final int FP_TARGETPOINTER_DATA = 3;
    private static final int FP_IDVALUE_DATA = 4;
    private static final int FP_DOMAIN_DATA = 5;
    private static final int FP_EXTERNALRES_DATA = 6;
    private static final int FP_LOCFILTER_DATA = 7;
    private static final int FP_LQISSUE_DATA = 8;
    private static final int FP_STORAGESIZE_DATA = 9;
    private static final int FP_ALLOWEDCHARS_DATA = 10;
    private static final int FP_SUBFILTER_DATA = 11;
    private static final int FP_TOOLSREF_DATA = 12;
    private static final int INFOTYPE_TEXT = 0;
    private static final int INFOTYPE_REF = 1;
    private static final int INFOTYPE_POINTER = 2;
    private static final int INFOTYPE_REFPOINTER = 3;
    private final boolean isHTML5;
    private DocumentBuilderFactory fact;
    private Document doc;
    private URI docURI;
    private NSContextManager nsContext;
    private VariableResolver varResolver;
    private XPathFactory xpFact;
    private XPath xpath;
    private ArrayList<ITSRule> rules;
    private Node node;
    private boolean startTraversal;
    private Stack<ITSTrace> trace;
    private boolean backTracking;
    private boolean translatableAttributeRuleTriggered;
    private boolean targetPointerRuleTriggered;
    private boolean hasTargetPointer;
    private String version;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ITSEngine(Document doc, URI docURI) {
        this(doc, docURI, false, null);
    }

    public ITSEngine(Document doc, URI docURI, boolean isHTML5, Map<String, String> map) {
        this.doc = doc;
        this.docURI = docURI;
        this.isHTML5 = isHTML5;
        this.node = null;
        this.rules = new ArrayList();
        this.nsContext = new NSContextManager();
        this.nsContext.addNamespace(ITS_NS_PREFIX, ITS_NS_URI);
        this.nsContext.addNamespace(ITSX_NS_PREFIX, ITSX_NS_URI);
        if (isHTML5) {
            this.nsContext.addNamespace(HTML_NS_PREFIX, HTML_NS_URI);
        }
        this.varResolver = new VariableResolver();
        if (!Util.isEmpty(map)) {
            for (String name : map.keySet()) {
                this.varResolver.add(new QName(name), map.get(name), true);
            }
        }
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.xpFact = XPathFactory.newInstance();
        this.xpath = this.xpFact.newXPath();
        this.xpath.setNamespaceContext(this.nsContext);
        this.xpath.setXPathVariableResolver(this.varResolver);
    }

    public void setVariables(Map<String, String> map) {
    }

    public boolean getTranslatableAttributeRuleTriggered() {
        return this.translatableAttributeRuleTriggered;
    }

    public boolean getTargetPointerRuleTriggered() {
        return this.targetPointerRuleTriggered;
    }

    public XPath getXPath() {
        return this.xpath;
    }

    private void ensureDocumentBuilderExist() {
        if (this.fact == null) {
            this.fact = DocumentBuilderFactory.newInstance();
            this.fact.setNamespaceAware(true);
            this.fact.setValidating(false);
        }
    }

    @Override
    public void addExternalRules(URI docURI) {
        try {
            this.ensureDocumentBuilderExist();
            Document rulesDoc = this.fact.newDocumentBuilder().parse(docURI.toString());
            this.addExternalRules(rulesDoc, docURI);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addExternalRules(Document rulesDoc, URI docURI) {
        this.compileRules(rulesDoc, docURI, false);
    }

    private void compileRulesInScripts(Document hostDoc, URI docURI, boolean isInternal) {
        try {
            XPathExpression expr = this.xpath.compile("//h:script[@type='application/its+xml']");
            NodeList nl = (NodeList)expr.evaluate(hostDoc, XPathConstants.NODESET);
            for (int i = 0; i < nl.getLength(); ++i) {
                Element elem = (Element)nl.item(i);
                String content = elem.getTextContent();
                if (content == null) continue;
                if ((content = content.trim()).startsWith("<!--")) {
                    content = content.substring(4);
                }
                if (content.endsWith("-->")) {
                    content = content.substring(0, content.length() - 3);
                }
                content = content.trim();
                this.ensureDocumentBuilderExist();
                InputSource is = new InputSource(new ByteArrayInputStream(content.getBytes()));
                Document scriptDoc = this.fact.newDocumentBuilder().parse(is);
                this.compileRules(scriptDoc, docURI, isInternal);
            }
        }
        catch (Throwable e) {
            throw new ITSException("Error processing ITS markup in HTML script.\n" + e.getMessage());
        }
    }

    private void compileRules(Document rulesDoc, URI docURI, boolean isInternal) {
        try {
            XPathExpression expr = this.xpath.compile("//*[@selector]//namespace::*");
            NodeList nl = (NodeList)expr.evaluate(rulesDoc, XPathConstants.NODESET);
            for (int i = 0; i < nl.getLength(); ++i) {
                String prefix = nl.item(i).getLocalName();
                if (XML_NS_PREFIX.equals(prefix)) continue;
                String uri = nl.item(i).getNodeValue();
                this.nsContext.addNamespace(prefix, uri);
            }
            expr = this.xpath.compile("//its:rules");
            nl = (NodeList)expr.evaluate(rulesDoc, XPathConstants.NODESET);
            if (nl.getLength() == 0) {
                return;
            }
            for (int i = 0; i < nl.getLength(); ++i) {
                NodeList nl2;
                Element rulesElem = (Element)nl.item(i);
                this.version = rulesElem.getAttributeNS(null, "version");
                if (!this.version.equals(ITS_VERSION1) && !this.version.equals(ITS_VERSION2)) {
                    throw new ITSException(String.format("Invalid or missing ITS version (\"%s\")", this.version));
                }
                String href = rulesElem.getAttributeNS(XLINK_NS_URI, "href");
                if (href.length() > 0) {
                    int n = href.lastIndexOf(35);
                    if (n > -1) {
                        href = href.substring(0, n);
                    }
                    String baseFolder = "";
                    if (docURI != null) {
                        baseFolder = this.getPartBeforeFile(docURI);
                    }
                    for (Node node = rulesElem; node != null; node = node.getParentNode()) {
                        String xmlBase;
                        if (node.getNodeType() != 1 || (xmlBase = node.getAttribute("xml:base")).length() <= 0) continue;
                        if (xmlBase.endsWith("/")) {
                            xmlBase = xmlBase.substring(0, xmlBase.length() - 1);
                        }
                        baseFolder = !baseFolder.startsWith("/") ? xmlBase + "/" + baseFolder : xmlBase + baseFolder;
                    }
                    if (baseFolder.length() > 0) {
                        if (baseFolder.endsWith("/")) {
                            baseFolder = baseFolder.substring(0, baseFolder.length() - 1);
                        }
                        href = !href.startsWith("/") ? baseFolder + "/" + href : baseFolder + href;
                    }
                    URI linkedDoc = new URI(href);
                    this.loadLinkedRules(linkedDoc, isInternal);
                }
                if ((nl2 = (NodeList)(expr = this.xpath.compile("//its:*|//itsx:*")).evaluate(rulesElem, XPathConstants.NODESET)).getLength() != 0) {
                    for (int j = 0; j < nl2.getLength(); ++j) {
                        Element ruleElem = (Element)nl2.item(j);
                        String locName = ruleElem.getLocalName();
                        if ("translateRule".equals(locName)) {
                            this.compileTranslateRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("withinTextRule".equals(locName)) {
                            this.compileWithinTextRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("langRule".equals(locName)) {
                            this.compileLangRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("dirRule".equals(locName)) {
                            this.compileDirRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("locNoteRule".equals(locName)) {
                            this.compileLocNoteRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("termRule".equals(locName)) {
                            this.compileTermRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("idValueRule".equals(locName)) {
                            this.compileIdValueRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("domainRule".equals(locName)) {
                            this.compileDomainRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("targetPointerRule".equals(locName)) {
                            this.compileTargetPointerRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("localeFilterRule".equals(locName)) {
                            this.compileLocaleFilterRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("preserveSpaceRule".equals(locName)) {
                            this.compilePrserveSpaceRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("externalResourceRefRule".equals(locName)) {
                            this.compileExternalResourceRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("locQualityIssueRule".equals(locName)) {
                            this.compileLocQualityIssueRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("storageSizeRule".equals(locName)) {
                            this.compileStorageSizeRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("allowedCharactersRule".equals(locName)) {
                            this.compileAllowedCharactersRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("subFilterRule".equals(locName)) {
                            this.compileSubFilterRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("param".equals(locName)) {
                            this.processParam(ruleElem);
                            continue;
                        }
                        if ("rules".equals(locName) || "span".equals(locName) || "locQualityIssues".equals(locName) || "locQualityIssue".equals(locName) || "locNote".equals(locName)) continue;
                        this.logger.warn("Unknown element '{}'.", (Object)ruleElem.getNodeName());
                    }
                    continue;
                }
                break;
            }
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void processParam(Element elem) {
        String value = elem.getTextContent();
        String name = elem.getAttribute("name");
        if (name.isEmpty()) {
            throw new ITSException("Invalid value for 'name' in param.");
        }
        this.varResolver.add(new QName(name), value, false);
    }

    public String getPartBeforeFile(URI uri) {
        String tmp = uri.toString();
        int n = tmp.lastIndexOf(47);
        if (n == -1) {
            return uri.toString();
        }
        return tmp.substring(0, n + 1);
    }

    private void loadLinkedRules(URI docURI, boolean isInternal) {
        try {
            this.ensureDocumentBuilderExist();
            Document rulesDoc = this.fact.newDocumentBuilder().parse(docURI.toString());
            this.compileRules(rulesDoc, docURI, isInternal);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void compileTranslateRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(2L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String value = elem.getAttribute("translate");
        if ("yes".equals(value)) {
            rule.flag = true;
        } else if ("no".equals(value)) {
            rule.flag = false;
        } else {
            throw new ITSException("Invalid value for 'translate'.");
        }
        value = elem.getAttributeNS(ITSX_NS_URI, "idValue");
        if (!value.isEmpty()) {
            if (this.version.equals(ITS_VERSION2)) {
                this.logger.warn("This document uses the {}:idValue extension instead of the ITS 2.0 Id Value data category.", (Object)ITSX_NS_URI);
            }
            rule.idValue = value;
        }
        if (!(value = elem.getAttributeNS(ITSX_NS_URI, "whiteSpaces")).isEmpty()) {
            if (this.version.equals(ITS_VERSION2)) {
                this.logger.warn("This document uses the {}:whiteSpaces extension instead of the ITS 2.0 Preserve Space data category.", (Object)ITSX_NS_URI);
            }
            if ("preserve".equals(value)) {
                rule.preserveWS = true;
            } else if ("default".equals(value)) {
                rule.preserveWS = false;
            } else {
                throw new ITSException("Invalid value for 'whiteSpaces'.");
            }
        }
        this.rules.add(rule);
    }

    private void compileDirRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(32L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String value = elem.getAttribute("dir");
        if ("ltr".equals(value)) {
            rule.value = 1;
        } else if ("rtl".equals(value)) {
            rule.value = 0;
        } else if ("lro".equals(value)) {
            rule.value = 3;
        } else if ("rlo".equals(value)) {
            rule.value = 2;
        } else {
            throw new ITSException("Invalid value for 'dir'.");
        }
        this.rules.add(rule);
    }

    private void compileWithinTextRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(4L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String value = elem.getAttribute("withinText");
        if ("yes".equals(value)) {
            rule.value = 1;
        } else if ("no".equals(value)) {
            rule.value = 0;
        } else if ("nested".equals(value)) {
            rule.value = 2;
        } else {
            throw new ITSException("Invalid value for 'withinText'.");
        }
        this.rules.add(rule);
    }

    private void compileIdValueRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(128L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String value = elem.getAttribute("idValue");
        if (value.isEmpty()) {
            throw new ITSException("Invalid value for 'idValue'.");
        }
        rule.idValue = value;
        this.rules.add(rule);
    }

    private void compileDomainRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(256L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String pointer = elem.getAttribute("domainPointer");
        if (pointer.isEmpty()) {
            throw new ITSException("Invalid value for 'domainPointer'.");
        }
        rule.info = pointer;
        rule.map = this.fromStringToMap(elem.getAttribute("domainMapping"));
        this.rules.add(rule);
    }

    private void compileExternalResourceRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(1024L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String pointer = elem.getAttribute("externalResourceRefPointer");
        if (pointer.isEmpty()) {
            throw new ITSException("Invalid value for 'externalResourceRefPointer'.");
        }
        rule.info = pointer;
        this.rules.add(rule);
    }

    private void compileStorageSizeRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(16384L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String[] np = this.retrieveStorageSizeData(elem, false, false);
        String storageSizeP = null;
        if (elem.hasAttribute("storageSizePointer")) {
            storageSizeP = elem.getAttribute("storageSizePointer");
        }
        String storageEncodingP = null;
        if (elem.hasAttribute("storageEncodingPointer")) {
            storageEncodingP = elem.getAttribute("storageEncodingPointer");
        }
        if (Util.isEmpty(np[0]) && Util.isEmpty(storageSizeP)) {
            throw new ITSException("You must have at least an attribute storageSize or storageSizePointer.");
        }
        rule.map = new HashMap<String, String>();
        if (!Util.isEmpty(np[0])) {
            if (!Util.isEmpty(storageSizeP)) {
                throw new ITSException("Cannot have both storageSize and storageSizePointer.");
            }
            rule.map.put("size", np[0]);
        } else {
            rule.map.put("sizePointer", storageSizeP);
        }
        if (!Util.isEmpty(np[1])) {
            if (!Util.isEmpty(storageEncodingP)) {
                throw new ITSException("Cannot have both storageEncoding and storageEncodingPointer.");
            }
            rule.map.put("encoding", np[1]);
        } else {
            rule.map.put("encodingPointer", storageEncodingP);
        }
        if (!Util.isEmpty(np[2])) {
            rule.map.put("linebreak", np[2]);
        }
        this.rules.add(rule);
    }

    private void compileAllowedCharactersRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(32768L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        rule.info = this.retrieveAllowedCharsData(elem, false, false);
        String allowedCharsP = null;
        if (elem.hasAttribute("allowedCharactersPointer")) {
            allowedCharsP = elem.getAttribute("allowedCharactersPointer");
        }
        if (Util.isEmpty(rule.info) && Util.isEmpty(allowedCharsP)) {
            throw new ITSException("You must have at least an attribute allowedCharacters or allowedCharactersPointer.");
        }
        if (!Util.isEmpty(rule.info)) {
            if (!Util.isEmpty(allowedCharsP)) {
                throw new ITSException("Cannot have both allowedCharacters and allowedCharactersPointer.");
            }
        } else {
            rule.info = allowedCharsP;
            rule.infoType = 2;
        }
        this.rules.add(rule);
    }

    private void compileLocQualityIssueRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(8192L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String[] np = this.retrieveLocQualityIssueData(elem, false);
        String issuesRefP = null;
        if (elem.hasAttribute("locQualityIssuesRefPointer")) {
            issuesRefP = elem.getAttribute("locQualityIssuesRefPointer");
        }
        String typeP = null;
        if (elem.hasAttribute("locQualityIssueTypePointer")) {
            typeP = elem.getAttribute("locQualityIssueTypePointer");
        }
        String commentP = null;
        if (elem.hasAttribute("locQualityIssueCommentPointer")) {
            commentP = elem.getAttribute("locQualityIssueCommentPointer");
        }
        if (Util.isEmpty(np[0]) && Util.isEmpty(issuesRefP) && Util.isEmpty(np[1]) && Util.isEmpty(typeP) && Util.isEmpty(np[2]) && Util.isEmpty(commentP)) {
            throw new ITSException("You must have at least a type or a comment or isses reference ainformation defined.");
        }
        rule.annotations = new GenericAnnotations();
        GenericAnnotation ann = this.addIssueItem(rule.annotations);
        if (!Util.isEmpty(np[0])) {
            if (!Util.isEmpty(issuesRefP)) {
                throw new ITSException("Cannot have both locQualityIssuesRef and locQualityIssuesRefPointer.");
            }
            rule.info = np[0];
            rule.infoType = 1;
        } else if (issuesRefP != null) {
            rule.info = issuesRefP;
            rule.infoType = 3;
        }
        if (!Util.isEmpty(np[1])) {
            if (!Util.isEmpty(typeP)) {
                throw new ITSException("Cannot have both locQualityIssueType and locQualityIssueTypePointer.");
            }
            ann.setString(LQITYPE, np[1]);
        } else if (typeP != null) {
            ann.setString(LQITYPE, PTRPREFIX + typeP);
        }
        if (!Util.isEmpty(np[2])) {
            if (!Util.isEmpty(commentP)) {
                throw new ITSException("Cannot have both locQualityIssueComment and locQualityIssueCommentPointer.");
            }
            ann.setString(LQICOMMENT, np[2]);
        } else if (commentP != null) {
            ann.setString(LQICOMMENT, PTRPREFIX + commentP);
        }
        String severityP = null;
        if (elem.hasAttribute("locQualityIssueSeverityPointer")) {
            severityP = elem.getAttribute("locQualityIssueSeverityPointer");
        }
        if (!Util.isEmpty(np[3])) {
            if (!Util.isEmpty(severityP)) {
                throw new ITSException("Cannot have both locQualityIssueSeverity and locQualityIssueSeverityPointer.");
            }
            ann.setString(LQISEVERITY, np[3]);
        } else if (severityP != null) {
            ann.setString(LQISEVERITY, PTRPREFIX + severityP);
        }
        String profileRefP = null;
        if (elem.hasAttribute("locQualityIssueProfileRefPointer")) {
            profileRefP = elem.getAttribute("locQualityIssueProfileRefPointer");
        }
        if (!Util.isEmpty(np[4])) {
            if (!Util.isEmpty(profileRefP)) {
                throw new ITSException("Cannot have both locQualityIssueProfileRef and locQualityIssueProfileRefPointer.");
            }
            ann.setString(LQIPROFILEREF, np[4]);
        } else if (profileRefP != null) {
            ann.setString(LQIPROFILEREF, PTRPREFIX + profileRefP);
        }
        String enabledP = null;
        if (elem.hasAttribute("locQualityIssueEnabledPointer")) {
            profileRefP = elem.getAttribute("locQualityIssueEnabledPointer");
            ann.setString(LQIENABLED, PTRPREFIX + enabledP);
        } else {
            ann.setString(LQIENABLED, np[5]);
        }
        this.rules.add(rule);
    }

    private void compileLocaleFilterRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(2048L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        rule.info = this.retrieveLocaleFilterList(elem, false, false);
        this.rules.add(rule);
    }

    private void compileSubFilterRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(65536L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        rule.info = this.retrieveSubFilter(elem, false, false);
        this.rules.add(rule);
    }

    private void compilePrserveSpaceRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(4096L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String value = elem.getAttribute("space");
        if (!"preserve".equals(value) && !"default".equals(value)) {
            throw new ITSException("Invalid value for 'space'.");
        }
        rule.preserveWS = "preserve".equals(value);
        this.rules.add(rule);
    }

    private void compileTargetPointerRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(512L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String pointer = elem.getAttribute("targetPointer");
        if (pointer.isEmpty()) {
            throw new ITSException("Invalid value for 'targetPointer'.");
        }
        rule.info = pointer;
        this.rules.add(rule);
    }

    private Map<String, String> fromStringToMap(String mapping) {
        if (mapping.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, String> map = null;
        if (!mapping.isEmpty()) {
            String[] pairs = mapping.split(",", 0);
            char endQuote = '\u0000';
            boolean state = false;
            for (String pair : pairs) {
                pair = pair.trim();
                StringBuilder left = new StringBuilder();
                StringBuilder right = new StringBuilder();
                StringBuilder str = left;
                block6: for (int i = 0; i < pair.length(); ++i) {
                    char ch = pair.charAt(i);
                    switch (ch) {
                        case '\"': {
                            if (!state) {
                                endQuote = ch;
                                state = true;
                                continue block6;
                            }
                            if (ch == endQuote) {
                                state = false;
                                continue block6;
                            }
                            str.append(ch);
                            continue block6;
                        }
                        case '\'': {
                            if (!state) {
                                endQuote = ch;
                                state = true;
                                continue block6;
                            }
                            if (ch == endQuote) {
                                state = false;
                                continue block6;
                            }
                            str.append(ch);
                            continue block6;
                        }
                        case ' ': {
                            if (state) {
                                str.append(' ');
                                continue block6;
                            }
                            str = right;
                            continue block6;
                        }
                        default: {
                            str.append(pair.charAt(i));
                        }
                    }
                }
                if (left.length() == 0 || right.length() == 0) {
                    throw new ITSException("Invalid pair in mapping value.");
                }
                if (map == null) {
                    map = new LinkedHashMap<String, String>();
                }
                map.put(left.toString().toLowerCase(), right.toString());
            }
        }
        return map;
    }

    private void compileTermRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(16L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String value = elem.getAttribute("term");
        if ("yes".equals(value)) {
            rule.flag = true;
        } else if ("no".equals(value)) {
            rule.flag = false;
        } else {
            throw new ITSException("Invalid value for 'term'.");
        }
        value = elem.getAttribute("termInfoPointer");
        String value2 = elem.getAttribute("termInfoRef");
        String value3 = elem.getAttribute("termInfoRefPointer");
        if (value.length() > 0) {
            rule.infoType = 2;
            rule.info = value;
            if (value2.length() > 0 || value3.length() > 0) {
                throw new ITSException("Too many termInfo attributes specified");
            }
        } else if (value2.length() > 0) {
            rule.infoType = 1;
            rule.info = value2;
            if (value3.length() > 0) {
                throw new ITSException("Too many termInfo attributes specified");
            }
        } else if (value3.length() > 0) {
            rule.infoType = 3;
            rule.info = value3;
        }
        this.rules.add(rule);
    }

    private void compileLocNoteRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(8L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        rule.flag = this.retrieveLocNoteType(elem, false, true, false);
        String value1 = "";
        NodeList list = elem.getElementsByTagNameNS(ITS_NS_URI, "locNote");
        if (list.getLength() > 0) {
            value1 = ITSEngine.getTextContent(list.item(0));
        }
        String value2 = elem.getAttribute("locNotePointer");
        String value3 = elem.getAttribute("locNoteRef");
        String value4 = elem.getAttribute("locNoteRefPointer");
        if (value1.length() > 0) {
            rule.infoType = 0;
            rule.info = value1;
            if (value2.length() > 0 || value3.length() > 0 || value4.length() > 0) {
                throw new ITSException("Too many locNote attributes specified");
            }
        } else if (value2.length() > 0) {
            rule.infoType = 2;
            rule.info = value2;
            if (value3.length() > 0 || value4.length() > 0) {
                throw new ITSException("Too many locNote attributes specified");
            }
        } else if (value3.length() > 0) {
            rule.infoType = 1;
            rule.info = value3;
            if (value4.length() > 0) {
                throw new ITSException("Too many locNote attributes specified");
            }
        } else if (value4.length() > 0) {
            rule.infoType = 3;
            rule.info = value4;
        }
        this.rules.add(rule);
    }

    private void compileLangRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(1L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        rule.info = elem.getAttribute("langPointer");
        if (rule.info.isEmpty()) {
            throw new ITSException("langPointer attribute missing.");
        }
        this.rules.add(rule);
    }

    @Override
    public void applyRules(long dataCategories) {
        this.translatableAttributeRuleTriggered = false;
        this.targetPointerRuleTriggered = false;
        this.version = "0";
        this.processGlobalRules(dataCategories);
        this.processLocalRules(dataCategories);
        this.prepareTargetPointers();
    }

    private void removeFlag(Node node) {
        if (node == null) {
            return;
        }
        node.setUserData(FLAGNAME, null, null);
        if (node.hasChildNodes()) {
            this.removeFlag(node.getFirstChild());
        }
        if (node.getNextSibling() != null) {
            this.removeFlag(node.getNextSibling());
        }
    }

    @Override
    public void disapplyRules() {
        this.removeFlag(this.doc.getDocumentElement());
        this.translatableAttributeRuleTriggered = false;
        this.targetPointerRuleTriggered = false;
    }

    @Override
    public boolean backTracking() {
        return this.backTracking;
    }

    @Override
    public Node nextNode() {
        if (this.startTraversal) {
            this.startTraversal = false;
            ITSTrace startTrace = new ITSTrace();
            this.backTracking = false;
            startTrace.translate = true;
            startTrace.isChildDone = true;
            this.trace.push(startTrace);
            this.node = this.doc.getFirstChild();
            this.trace.push(new ITSTrace(this.trace.peek(), false));
            this.updateTraceData(this.node);
            return this.node;
        }
        if (this.node != null) {
            this.backTracking = false;
            if (!this.trace.peek().isChildDone && this.node.hasChildNodes()) {
                ITSTrace tmp = new ITSTrace(this.trace.peek(), true);
                this.trace.pop();
                this.trace.push(tmp);
                this.node = this.node.getFirstChild();
                this.trace.push(new ITSTrace(this.trace.peek(), false));
            } else {
                Node TmpNode = this.node.getNextSibling();
                if (TmpNode == null) {
                    this.node = this.node.getParentNode();
                    this.trace.pop();
                    this.backTracking = true;
                } else {
                    this.node = TmpNode;
                    this.trace.pop();
                    this.trace.push(new ITSTrace(this.trace.peek(), false));
                }
            }
        }
        this.updateTraceData(this.node);
        return this.node;
    }

    private void updateTraceData(Node newNode) {
        String value;
        if (newNode == null) {
            return;
        }
        String data = (String)newNode.getUserData(FLAGNAME);
        if (data == null) {
            return;
        }
        if (data.charAt(0) != '?') {
            boolean bl = this.trace.peek().translate = data.charAt(0) == 'y';
        }
        if (!(value = this.getFlagData(data, 4)).isEmpty()) {
            this.trace.peek().idValue = value;
        }
        if (data.charAt(7) != '?') {
            this.trace.peek().domains = this.getFlagData(data, 5);
        }
        if (data.charAt(8) != '?') {
            this.trace.peek().externalRes = this.getFlagData(data, 6);
        }
        if (data.charAt(9) != '?') {
            this.trace.peek().localeFilter = this.getFlagData(data, 7);
        }
        if (data.charAt(10) != '?') {
            this.trace.peek().lqIssues = new GenericAnnotations(this.getFlagData(data, 8));
        }
        if (data.charAt(11) != '?') {
            String[] values = this.fromSingleString(this.getFlagData(data, 9));
            this.trace.peek().storageSize = values[0];
            this.trace.peek().storageEncoding = values[1];
            this.trace.peek().lineBreakType = values[2];
        }
        if (data.charAt(12) != '?') {
            this.trace.peek().allowedChars = this.getFlagData(data, 10);
        }
        this.trace.peek().targetPointer = this.getFlagData(data, 3);
        if (data.charAt(1) != '?') {
            switch (data.charAt(1)) {
                case '0': {
                    this.trace.peek().dir = 1;
                    break;
                }
                case '1': {
                    this.trace.peek().dir = 0;
                    break;
                }
                case '2': {
                    this.trace.peek().dir = 3;
                    break;
                }
                case '3': {
                    this.trace.peek().dir = 3;
                }
            }
        }
        if (data.charAt(2) != '?') {
            switch (data.charAt(2)) {
                case '0': {
                    this.trace.peek().withinText = 0;
                    break;
                }
                case '1': {
                    this.trace.peek().withinText = 1;
                    break;
                }
                case '2': {
                    this.trace.peek().withinText = 2;
                }
            }
        }
        if (data.charAt(3) != '?') {
            this.trace.peek().term = data.charAt(3) == 'y';
            this.trace.peek().termInfo = this.getFlagData(data, 0);
        }
        if (data.charAt(4) != '?') {
            this.trace.peek().locNote = this.getFlagData(data, 1);
            String string = this.trace.peek().locNoteType = data.charAt(4) == 'a' ? "alert" : "description";
        }
        if (data.charAt(5) != '?') {
            boolean bl = this.trace.peek().preserveWS = data.charAt(5) == 'y';
        }
        if (data.charAt(6) != '?') {
            this.trace.peek().language = this.getFlagData(data, 2);
        }
        if (data.charAt(13) != '?') {
            this.trace.peek().subFilter = this.getFlagData(data, 11);
        }
        if (data.charAt(15) != '?') {
            Map<String, String> oldMap = this.toolsRefToMap(this.trace.peek().toolsRef);
            Map<String, String> newMap = this.toolsRefToMap(this.getFlagData(data, 12));
            oldMap.putAll(newMap);
            this.trace.peek().toolsRef = this.mapToToolsRef(oldMap);
        }
    }

    private Map<String, String> toolsRefToMap(String data) {
        String[] list;
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (Util.isEmpty(data)) {
            return map;
        }
        for (String tmp : list = data.split(" ", 0)) {
            int n = tmp.indexOf(124);
            if (n == -1) {
                this.logger.warn("Invalid toolsRef value '{}'", (Object)tmp);
                continue;
            }
            map.put(tmp.substring(0, n), tmp.substring(n + 1));
        }
        return map;
    }

    private String mapToToolsRef(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        for (String dc : map.keySet()) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(dc + "|" + map.get(dc));
        }
        return sb.toString();
    }

    @Override
    public void startTraversal() {
        this.node = null;
        this.trace = new Stack();
        this.startTraversal = true;
    }

    private void clearInternalGlobalRules() {
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!this.rules.get((int)i).isInternal) continue;
            this.rules.remove(i);
            --i;
        }
    }

    private void processGlobalRules(long dataCategories) {
        try {
            this.clearInternalGlobalRules();
            if (this.isHTML5) {
                this.compileRulesInScripts(this.doc, this.docURI, true);
            } else {
                this.compileRules(this.doc, this.docURI, true);
            }
            for (ITSRule rule : this.rules) {
                if ((dataCategories & rule.ruleType) == 0L) continue;
                XPathExpression expr = this.xpath.compile(rule.selector);
                NodeList NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (int i = 0; i < NL.getLength(); ++i) {
                    String data1;
                    if (rule.ruleType == 2L) {
                        this.setFlag(NL.item(i), 0, rule.flag ? (char)'y' : 'n', true);
                        if (NL.item(i).getNodeType() == 2 && rule.flag) {
                            this.translatableAttributeRuleTriggered = true;
                        }
                        if (rule.idValue != null) {
                            this.setFlag(NL.item(i), 4, this.resolveExpressionAsString(NL.item(i), rule.idValue), true);
                        }
                        this.setFlag(NL.item(i), 5, rule.preserveWS ? (char)'y' : '?', true);
                        continue;
                    }
                    if (rule.ruleType == 32L) {
                        this.setFlag(NL.item(i), 1, String.valueOf(rule.value).charAt(0), true);
                        continue;
                    }
                    if (rule.ruleType == 4L) {
                        this.setFlag(NL.item(i), 2, String.valueOf(rule.value).charAt(0), true);
                        continue;
                    }
                    if (rule.ruleType == 16L) {
                        this.setFlag(NL.item(i), 3, rule.flag ? (char)'y' : 'n', true);
                        switch (rule.infoType) {
                            case 2: {
                                this.setFlag(NL.item(i), 0, this.resolvePointer(NL.item(i), rule.info), true);
                                break;
                            }
                            case 1: {
                                this.setFlag(NL.item(i), 0, "REF:" + rule.info, true);
                                break;
                            }
                            case 3: {
                                this.setFlag(NL.item(i), 0, "REF:" + this.resolvePointer(NL.item(i), rule.info), true);
                            }
                        }
                        continue;
                    }
                    if (rule.ruleType == 8L) {
                        this.setFlag(NL.item(i), 4, rule.flag ? (char)'a' : 'd', true);
                        switch (rule.infoType) {
                            case 0: {
                                this.setFlag(NL.item(i), 1, rule.info, true);
                                break;
                            }
                            case 2: {
                                this.setFlag(NL.item(i), 1, this.resolvePointer(NL.item(i), rule.info), true);
                                break;
                            }
                            case 1: {
                                this.setFlag(NL.item(i), 1, "REF:" + rule.info, true);
                                break;
                            }
                            case 3: {
                                this.setFlag(NL.item(i), 1, "REF:" + this.resolvePointer(NL.item(i), rule.info), true);
                            }
                        }
                        continue;
                    }
                    if (rule.ruleType == 1L) {
                        this.setFlag(NL.item(i), 6, 'y', true);
                        this.setFlag(NL.item(i), 2, this.resolvePointer(NL.item(i), rule.info), true);
                        continue;
                    }
                    if (rule.ruleType == 1024L) {
                        this.setFlag(NL.item(i), 8, 'y', true);
                        this.setFlag(NL.item(i), 6, this.resolvePointer(NL.item(i), rule.info), true);
                        continue;
                    }
                    if (rule.ruleType == 2048L) {
                        this.setFlag(NL.item(i), 9, 'y', true);
                        this.setFlag(NL.item(i), 7, rule.info, true);
                        continue;
                    }
                    if (rule.ruleType == 4096L) {
                        this.setFlag(NL.item(i), 5, rule.preserveWS ? (char)'y' : '?', true);
                        continue;
                    }
                    if (rule.ruleType == 128L) {
                        if (rule.idValue == null) continue;
                        this.setFlag(NL.item(i), 4, this.resolveExpressionAsString(NL.item(i), rule.idValue), true);
                        continue;
                    }
                    if (rule.ruleType == 256L) {
                        List<String> list = this.resolveExpressionAsList(NL.item(i), rule.info);
                        if (list.isEmpty()) continue;
                        StringBuilder tmp = new StringBuilder();
                        List<String> values = null;
                        for (String item : list) {
                            values = this.fromDomainItemToValues(item, rule.map, values);
                        }
                        for (String value : values) {
                            if (tmp.length() > 0) {
                                tmp.append(", ");
                            }
                            tmp.append(value);
                        }
                        this.setFlag(NL.item(i), 7, 'y', true);
                        this.setFlag(NL.item(i), 5, tmp.toString(), true);
                        continue;
                    }
                    if (rule.ruleType == 512L) {
                        this.targetPointerRuleTriggered = true;
                        this.setFlag(NL.item(i), 3, rule.info, true);
                        continue;
                    }
                    if (rule.ruleType == 8192L) {
                        GenericAnnotations anns = null;
                        data1 = rule.info;
                        if (data1 != null) {
                            if (rule.infoType == 3) {
                                data1 = this.resolvePointer(NL.item(i), data1);
                            }
                            anns = this.fetchLocQualityStandoffData(data1);
                        } else {
                            GenericAnnotation ann = rule.annotations.getAnnotations(LQISSUE).get(0);
                            anns = new GenericAnnotations();
                            GenericAnnotation upd = this.addIssueItem(anns);
                            data1 = ann.getString(LQITYPE);
                            if (data1 != null) {
                                if (data1.startsWith(PTRPREFIX)) {
                                    data1 = this.resolvePointer(NL.item(i), data1.substring(2));
                                }
                                upd.setString(LQITYPE, data1);
                            }
                            if ((data1 = ann.getString(LQICOMMENT)) != null) {
                                if (data1.startsWith(PTRPREFIX)) {
                                    data1 = this.resolvePointer(NL.item(i), data1.substring(2));
                                }
                                upd.setString(LQICOMMENT, data1);
                            }
                            if ((data1 = ann.getString(LQISEVERITY)) != null) {
                                if (data1.startsWith(PTRPREFIX)) {
                                    data1 = this.resolvePointer(NL.item(i), data1.substring(2));
                                }
                                upd.setFloat(LQISEVERITY, Float.valueOf(Float.parseFloat(data1)));
                            }
                            if ((data1 = ann.getString(LQIPROFILEREF)) != null) {
                                if (data1.startsWith(PTRPREFIX)) {
                                    data1 = this.resolvePointer(NL.item(i), data1.substring(2));
                                }
                                upd.setString(LQIPROFILEREF, data1);
                            }
                            if ((data1 = ann.getString(LQIENABLED)) != null) {
                                if (data1.startsWith(PTRPREFIX)) {
                                    data1 = this.resolvePointer(NL.item(i), data1.substring(2));
                                }
                                upd.setBoolean(LQIENABLED, data1.equals("yes"));
                            }
                        }
                        this.setFlag(NL.item(i), 10, 'y', true);
                        this.setFlag(NL.item(i), 8, anns.toString(), true);
                        continue;
                    }
                    if (rule.ruleType == 32768L) {
                        data1 = rule.infoType == 2 ? this.resolvePointer(NL.item(i), rule.info) : rule.info;
                        this.setFlag(NL.item(i), 12, 'y', true);
                        this.setFlag(NL.item(i), 10, data1, true);
                        continue;
                    }
                    if (rule.ruleType == 16384L) {
                        String data3;
                        String data2;
                        data1 = rule.map.get("size");
                        if (data1 == null && !Util.isEmpty(data1 = rule.map.get("sizePointer"))) {
                            data1 = this.resolvePointer(NL.item(i), data1);
                        }
                        if ((data2 = rule.map.get("encoding")) == null && !Util.isEmpty(data2 = rule.map.get("encodingPointer"))) {
                            data2 = this.resolvePointer(NL.item(i), data2);
                        }
                        if ((data3 = rule.map.get("linebreak")) == null && !Util.isEmpty(data3 = rule.map.get("linebreakPointer"))) {
                            data3 = this.resolvePointer(NL.item(i), data3);
                        }
                        this.setFlag(NL.item(i), 11, 'y', true);
                        this.setFlag(NL.item(i), 9, this.toSingleString(data1, data2, data3), true);
                        continue;
                    }
                    if (rule.ruleType != 65536L) continue;
                    this.setFlag(NL.item(i), 13, 'y', true);
                    this.setFlag(NL.item(i), 11, rule.info, true);
                }
            }
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    private GenericAnnotation addIssueItem(GenericAnnotations anns) {
        GenericAnnotation ann = anns.add(LQISSUE);
        ann.setBoolean(LQIENABLED, true);
        return ann;
    }

    private List<String> fromDomainItemToValues(String text, Map<String, String> map, List<String> list) {
        if (list == null) {
            list = new ArrayList<String>();
        }
        String[] parts = text.split(",", 0);
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = parts[i].trim();
            if (parts[i].startsWith("'") || parts[i].startsWith("\"")) {
                parts[i] = parts[i].substring(1);
            }
            if (!parts[i].endsWith("'") && !parts[i].endsWith("\"")) continue;
            parts[i] = parts[i].substring(0, parts[i].length() - 1);
        }
        for (String part : parts) {
            if (map != null && map.containsKey(part.toLowerCase())) {
                part = map.get(part);
            }
            if (list.contains(part)) continue;
            list.add(part);
        }
        return list;
    }

    private String toSingleString(String ... values) {
        StringBuilder data = new StringBuilder();
        for (String value : values) {
            if (value == null) {
                data.append("\u001a");
            }
            if (value != null) {
                data.append(value);
            }
            data.append("\u001d");
        }
        return data.toString();
    }

    private String[] fromSingleString(String data) {
        String[] values = data.split("\u001d", -1);
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].equals("\u001a")) continue;
            values[i] = null;
        }
        return values;
    }

    private void processLocalRules(long dataCategories) {
        try {
            String[] values;
            String value;
            Attr attr;
            int i;
            NodeList NL;
            XPathExpression expr;
            if ((dataCategories & 2L) > 0L) {
                expr = this.isHTML5 ? this.xpath.compile("//*/@translate") : this.xpath.compile("//*/@its:translate|//its:span/@translate");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (i = 0; i < NL.getLength(); ++i) {
                    attr = (Attr)NL.item(i);
                    if (ITS_NS_URI.equals(attr.getOwnerElement().getNamespaceURI()) && "translateRule".equals(attr.getOwnerElement().getLocalName())) continue;
                    String value2 = attr.getValue();
                    if (!"yes".equals(value2) && !"no".equals(value2)) {
                        throw new ITSException("Invalid value for 'translate'.");
                    }
                    this.setFlag((Node)attr.getOwnerElement(), 0, value2.charAt(0), attr.getSpecified());
                }
            }
            if ((dataCategories & 0x20L) > 0L) {
                expr = this.isHTML5 ? this.xpath.compile("//*/@dir") : this.xpath.compile("//*/@its:dir|//its:span/@dir");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (i = 0; i < NL.getLength(); ++i) {
                    attr = (Attr)NL.item(i);
                    if (ITS_NS_URI.equals(attr.getOwnerElement().getNamespaceURI()) && "dirRule".equals(attr.getOwnerElement().getLocalName())) continue;
                    int n = 1;
                    if ("rtl".equals(attr.getValue())) {
                        n = 1;
                    } else if ("ltr".equals(attr.getValue())) {
                        n = 0;
                    } else if ("rlo".equals(attr.getValue())) {
                        n = 2;
                    } else if ("lro".equals(attr.getValue())) {
                        n = 3;
                    } else {
                        throw new ITSException("Invalid value for 'dir'.");
                    }
                    this.setFlag((Node)attr.getOwnerElement(), 1, String.format("%d", n).charAt(0), attr.getSpecified());
                }
            }
            if ((dataCategories & 0x10L) > 0L) {
                expr = this.isHTML5 ? this.xpath.compile("//*/@its-term|//*/@its-term-info-ref") : this.xpath.compile("//*/@its:term|//its:span/@term|//*/@its:termInfoRef|//its:span/@termInfoRef");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (int i2 = 0; i2 < NL.getLength(); ++i2) {
                    attr = (Attr)NL.item(i2);
                    String localName = attr.getLocalName();
                    if (ITS_NS_URI.equals(attr.getOwnerElement().getNamespaceURI()) && "termRule".equals(attr.getOwnerElement().getLocalName())) continue;
                    if (localName.equals("term") || localName.equals("its-term")) {
                        String value3 = attr.getValue();
                        if (!"yes".equals(value3) && !"no".equals(value3)) {
                            throw new ITSException("Invalid value for 'term'.");
                        }
                        this.setFlag((Node)attr.getOwnerElement(), 3, value3.charAt(0), attr.getSpecified());
                        continue;
                    }
                    if (!localName.equals("termInfoRef") && !localName.equals("its-term-info-ref")) continue;
                    this.setFlag((Node)attr.getOwnerElement(), 0, "REF:" + attr.getValue(), attr.getSpecified());
                }
            }
            if ((dataCategories & 8L) > 0L) {
                expr = this.isHTML5 ? this.xpath.compile("//*/@its-loc-note|//*/@its-loc-note-ref") : this.xpath.compile("//*/@its:locNote|//its:span/@locNote|//*/@its:locNoteRef|//its:span/@locNoteRef");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (int i3 = 0; i3 < NL.getLength(); ++i3) {
                    attr = (Attr)NL.item(i3);
                    String localName = attr.getLocalName();
                    if (ITS_NS_URI.equals(attr.getOwnerElement().getNamespaceURI()) && "locNoteRule".equals(attr.getOwnerElement().getLocalName())) continue;
                    boolean qualified = true;
                    String ns = attr.getOwnerElement().getNamespaceURI();
                    if (!Util.isEmpty(ns)) {
                        qualified = !ns.equals(ITS_NS_URI);
                    }
                    boolean alert = this.retrieveLocNoteType(attr.getOwnerElement(), qualified, false, this.isHTML5);
                    this.setFlag((Node)attr.getOwnerElement(), 4, alert ? (char)'a' : 'd', attr.getSpecified());
                    if (localName.equals("locNote") || localName.equals("its-loc-note")) {
                        this.setFlag((Node)attr.getOwnerElement(), 1, attr.getValue(), attr.getSpecified());
                        continue;
                    }
                    if (!localName.equals("locNoteRef") && !localName.equals("its-loc-note-ref")) continue;
                    this.setFlag((Node)attr.getOwnerElement(), 1, "REF:" + attr.getValue(), attr.getSpecified());
                }
            }
            if ((dataCategories & 1L) > 0L) {
                expr = this.xpath.compile("//*/@xml:lang");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (i = 0; i < NL.getLength(); ++i) {
                    attr = (Attr)NL.item(i);
                    this.setFlag((Node)attr.getOwnerElement(), 6, 'y', attr.getSpecified());
                    this.setFlag((Node)attr.getOwnerElement(), 2, attr.getValue(), attr.getSpecified());
                }
            }
            if ((dataCategories & 4L) > 0L && this.isVersion2()) {
                expr = this.isHTML5 ? this.xpath.compile("//*/@its-within-text") : this.xpath.compile("//*/@its:withinText");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (i = 0; i < NL.getLength(); ++i) {
                    char ch;
                    attr = (Attr)NL.item(i);
                    if (ITS_NS_URI.equals(attr.getOwnerElement().getNamespaceURI()) && "withinTextRule".equals(attr.getOwnerElement().getLocalName())) continue;
                    String value4 = attr.getValue();
                    if ("no".equals(value4)) {
                        ch = '0';
                    } else if ("yes".equals(value4)) {
                        ch = '1';
                    } else if ("nested".equals(value4)) {
                        ch = '2';
                    } else {
                        throw new ITSException("Invalid value for 'withinText'.");
                    }
                    this.setFlag((Node)attr.getOwnerElement(), 2, ch, attr.getSpecified());
                }
            }
            expr = this.xpath.compile("//*/@xml:space");
            NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
            for (i = 0; i < NL.getLength(); ++i) {
                attr = (Attr)NL.item(i);
                String value5 = attr.getValue();
                if (!"preserve".equals(value5) && !"default".equals(value5)) {
                    throw new ITSException("Invalid value for 'xml:space'.");
                }
                this.setFlag((Node)attr.getOwnerElement(), 5, "preserve".equals(value5) ? (char)'y' : '?', attr.getSpecified());
            }
            expr = this.isHTML5 ? this.xpath.compile("//*/@its-tools-ref") : this.xpath.compile("//*/@its:toolsRef");
            NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
            for (i = 0; i < NL.getLength(); ++i) {
                attr = (Attr)NL.item(i);
                String value6 = attr.getValue();
                this.setFlag((Node)attr.getOwnerElement(), 15, value6 != null ? (char)'y' : '?', attr.getSpecified());
                this.setFlag((Node)attr.getOwnerElement(), 12, value6, attr.getSpecified());
            }
            if ((dataCategories & 0x800L) > 0L && this.isVersion2()) {
                expr = this.isHTML5 ? this.xpath.compile("//*/@its-locale-filter-list") : this.xpath.compile("//*/@its:localeFilterList|//its:span/@localeFilterList");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (i = 0; i < NL.getLength(); ++i) {
                    attr = (Attr)NL.item(i);
                    if (ITS_NS_URI.equals(attr.getOwnerElement().getNamespaceURI()) && "localeFilterRule".equals(attr.getOwnerElement().getLocalName())) continue;
                    boolean qualified = true;
                    String ns = attr.getOwnerElement().getNamespaceURI();
                    if (!Util.isEmpty(ns)) {
                        qualified = !ns.equals(ITS_NS_URI);
                    }
                    value = this.retrieveLocaleFilterList(attr.getOwnerElement(), qualified, this.isHTML5);
                    this.setFlag((Node)attr.getOwnerElement(), 9, 'y', attr.getSpecified());
                    this.setFlag((Node)attr.getOwnerElement(), 7, value, attr.getSpecified());
                }
            }
            expr = this.xpath.compile("//*/@xml:id");
            NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
            for (i = 0; i < NL.getLength(); ++i) {
                attr = (Attr)NL.item(i);
                String value7 = attr.getValue();
                if (value7 == null || value7.length() <= 0) continue;
                this.setFlag((Node)attr.getOwnerElement(), 4, value7, attr.getSpecified());
            }
            if ((dataCategories & 0x2000L) > 0L && this.isVersion2()) {
                expr = this.xpath.compile("//*/@its:locQualityIssueType|//its:span/@locQualityIssueType|//*/@its:locQualityIssueComment|//its:span/@locQualityIssueComment|//*/@its:locQualityIssuesRef|//its:span/@locQualityIssuesRef");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (i = 0; i < NL.getLength(); ++i) {
                    attr = (Attr)NL.item(i);
                    if (ITS_NS_URI.equals(attr.getOwnerElement().getNamespaceURI()) && "locQualityIssueRule".equals(attr.getOwnerElement().getLocalName())) continue;
                    boolean qualified = true;
                    String ns = attr.getOwnerElement().getNamespaceURI();
                    if (!Util.isEmpty(ns)) {
                        qualified = !ns.equals(ITS_NS_URI);
                    }
                    values = this.retrieveLocQualityIssueData(attr.getOwnerElement(), qualified);
                    GenericAnnotations anns = null;
                    if (values[0] != null) {
                        anns = this.fetchLocQualityStandoffData(values[0]);
                    } else {
                        anns = new GenericAnnotations();
                        GenericAnnotation ann = this.addIssueItem(anns);
                        if (values[1] != null) {
                            ann.setString(LQITYPE, values[1]);
                        }
                        if (values[2] != null) {
                            ann.setString(LQICOMMENT, values[2]);
                        }
                        if (values[3] != null) {
                            ann.setFloat(LQISEVERITY, Float.valueOf(Float.parseFloat(values[3])));
                        }
                        if (values[4] != null) {
                            ann.setString(LQIPROFILEREF, values[4]);
                        }
                        if (values[5] != null) {
                            ann.setBoolean(LQIENABLED, values[5].equals("yes"));
                        }
                    }
                    this.setFlag((Node)attr.getOwnerElement(), 10, 'y', attr.getSpecified());
                    this.setFlag((Node)attr.getOwnerElement(), 8, anns.toString(), attr.getSpecified());
                }
            }
            if ((dataCategories & 0x8000L) > 0L && this.isVersion2()) {
                expr = this.isHTML5 ? this.xpath.compile("//*/@its-allowed-characters") : this.xpath.compile("//*/@its:allowedCharacters|//its:span/@allowedCharacters");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (i = 0; i < NL.getLength(); ++i) {
                    attr = (Attr)NL.item(i);
                    if (ITS_NS_URI.equals(attr.getOwnerElement().getNamespaceURI()) && "allowedCharactersRule".equals(attr.getOwnerElement().getLocalName())) continue;
                    boolean qualified = true;
                    String ns = attr.getOwnerElement().getNamespaceURI();
                    if (!Util.isEmpty(ns)) {
                        qualified = !ns.equals(ITS_NS_URI);
                    }
                    value = this.retrieveAllowedCharsData(attr.getOwnerElement(), qualified, this.isHTML5);
                    this.setFlag((Node)attr.getOwnerElement(), 12, 'y', attr.getSpecified());
                    this.setFlag((Node)attr.getOwnerElement(), 10, value, attr.getSpecified());
                }
            }
            if ((dataCategories & 0x4000L) > 0L && this.isVersion2()) {
                expr = this.isHTML5 ? this.xpath.compile("//*/@its-storage-size") : this.xpath.compile("//*/@its:storageSize|//its:span/@storageSize");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (i = 0; i < NL.getLength(); ++i) {
                    attr = (Attr)NL.item(i);
                    if (ITS_NS_URI.equals(attr.getOwnerElement().getNamespaceURI()) && "storageSizeRule".equals(attr.getOwnerElement().getLocalName())) continue;
                    boolean qualified = true;
                    String ns = attr.getOwnerElement().getNamespaceURI();
                    if (!Util.isEmpty(ns)) {
                        qualified = !ns.equals(ITS_NS_URI);
                    }
                    values = this.retrieveStorageSizeData(attr.getOwnerElement(), qualified, this.isHTML5);
                    this.setFlag((Node)attr.getOwnerElement(), 11, 'y', attr.getSpecified());
                    this.setFlag((Node)attr.getOwnerElement(), 9, this.toSingleString(values[0], values[1], values[2]), attr.getSpecified());
                }
            }
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    private String retrieveLocaleFilterList(Element elem, boolean qualified, boolean useHTML5) {
        if (useHTML5) {
            return elem.getAttribute("its-locale-filter-list").trim();
        }
        if (qualified) {
            return elem.getAttributeNS(ITS_NS_URI, "localeFilterList").trim();
        }
        return elem.getAttribute("localeFilterList").trim();
    }

    private String retrieveSubFilter(Element elem, boolean qualified, boolean useHTML5) {
        if (useHTML5) {
            return elem.getAttribute("data-itsx-sub-filter").trim();
        }
        if (qualified) {
            return elem.getAttributeNS(ITSX_NS_URI, "subFilter").trim();
        }
        return elem.getAttribute("subFilter").trim();
    }

    private boolean retrieveLocNoteType(Element elem, boolean qualified, boolean required, boolean useHTML5) {
        String type = useHTML5 ? elem.getAttribute("its-loc-note-type") : (qualified ? elem.getAttributeNS(ITS_NS_URI, "locNoteType") : elem.getAttribute("locNoteType"));
        if (type.isEmpty() && required) {
            throw new ITSException(String.format("%s attribute missing.", this.isHTML5 ? "its-loc-note-type" : "locNoteType"));
        }
        if (type.equals("alert")) {
            return true;
        }
        if (!type.equals("description") && !type.isEmpty()) {
            throw new ITSException(String.format("Invalide value '%s' for localozation note type.", type));
        }
        return false;
    }

    private String retrieveAllowedCharsData(Element elem, boolean qualified, boolean useHTML5) {
        if (useHTML5) {
            if (elem.hasAttribute("its-allowed-characters")) {
                return elem.getAttribute("its-allowed-characters");
            }
        } else if (qualified) {
            if (elem.hasAttributeNS(ITS_NS_URI, "allowedCharacters")) {
                return elem.getAttributeNS(ITS_NS_URI, "allowedCharacters");
            }
        } else if (elem.hasAttribute("allowedCharacters")) {
            return elem.getAttribute("allowedCharacters");
        }
        return null;
    }

    private String[] retrieveStorageSizeData(Element elem, boolean qualified, boolean useHTML5) {
        String[] data = new String[3];
        if (useHTML5) {
            if (elem.hasAttribute("its-storage-size")) {
                data[0] = elem.getAttribute("its-storage-size");
            }
            if (elem.hasAttribute("its-storage-encoding")) {
                data[1] = elem.getAttribute("its-storage-encoding");
            }
            if (elem.hasAttribute("its-line-break-type")) {
                data[2] = elem.getAttribute("its-line-break-type");
            }
        } else if (qualified) {
            if (elem.hasAttributeNS(ITS_NS_URI, "storageSize")) {
                data[0] = elem.getAttributeNS(ITS_NS_URI, "storageSize");
            }
            if (elem.hasAttributeNS(ITS_NS_URI, "storageEncoding")) {
                data[1] = elem.getAttributeNS(ITS_NS_URI, "storageEncoding");
            }
            if (elem.hasAttributeNS(ITS_NS_URI, "lineBreakType")) {
                data[2] = elem.getAttributeNS(ITS_NS_URI, "lineBreakType");
            }
        } else {
            if (elem.hasAttribute("storageSize")) {
                data[0] = elem.getAttribute("storageSize");
            }
            if (elem.hasAttribute("storageEncoding")) {
                data[1] = elem.getAttribute("storageEncoding");
            }
            if (elem.hasAttribute("lineBreakType")) {
                data[2] = elem.getAttribute("lineBreakType");
            }
        }
        return data;
    }

    private String[] retrieveLocQualityIssueData(Element elem, boolean qualified) {
        String[] data = new String[6];
        if (qualified) {
            if (elem.hasAttributeNS(ITS_NS_URI, "locQualityIssuesRef")) {
                data[0] = elem.getAttributeNS(ITS_NS_URI, "locQualityIssuesRef");
            }
            if (elem.hasAttributeNS(ITS_NS_URI, "locQualityIssueType")) {
                data[1] = elem.getAttributeNS(ITS_NS_URI, "locQualityIssueType");
            }
            if (elem.hasAttributeNS(ITS_NS_URI, "locQualityIssueComment")) {
                data[2] = elem.getAttributeNS(ITS_NS_URI, "locQualityIssueComment");
            }
            if (elem.hasAttributeNS(ITS_NS_URI, "locQualityIssueSeverity")) {
                data[3] = elem.getAttributeNS(ITS_NS_URI, "locQualityIssueSeverity");
            }
            if (elem.hasAttributeNS(ITS_NS_URI, "locQualityIssueProfileRef")) {
                data[4] = elem.getAttributeNS(ITS_NS_URI, "locQualityIssueProfileRef");
            }
            data[5] = elem.hasAttributeNS(ITS_NS_URI, "locQualityIssueEnabled") ? elem.getAttributeNS(ITS_NS_URI, "locQualityIssueEnabled") : "yes";
        } else {
            if (elem.hasAttribute("locQualityIssuesRef")) {
                data[0] = elem.getAttribute("locQualityIssuesRef");
            }
            if (elem.hasAttribute("locQualityIssueType")) {
                data[1] = elem.getAttribute("locQualityIssueType");
            }
            if (elem.hasAttribute("locQualityIssueComment")) {
                data[2] = elem.getAttribute("locQualityIssueComment");
            }
            if (elem.hasAttribute("locQualityIssueSeverity")) {
                data[3] = elem.getAttribute("locQualityIssueSeverity");
            }
            if (elem.hasAttribute("locQualityIssueProfileRef")) {
                data[4] = elem.getAttribute("locQualityIssueProfileRef");
            }
            data[5] = elem.hasAttribute("locQualityIssueEnabled") ? elem.getAttribute("locQualityIssueEnabled") : "yes";
        }
        return data;
    }

    private GenericAnnotations fetchLocQualityStandoffData(String ref) {
        GenericAnnotations anns;
        Element elem1;
        if (Util.isEmpty(ref)) {
            throw new InvalidParameterException("The reference URI cannot be null or empty.");
        }
        int n = ref.lastIndexOf(35);
        String id = null;
        String firstPart = null;
        if (n > -1) {
            id = ref.substring(n + 1);
            firstPart = ref.substring(0, n);
        }
        try {
            String tmp = String.format("//%s:%s[@xml:id='%s']", this.isHTML5 ? HTML_NS_PREFIX : ITS_NS_PREFIX, this.isHTML5 ? "script" : "locQualityIssues", id);
            XPathExpression expr = this.xpath.compile(tmp);
            elem1 = (Element)expr.evaluate(this.doc, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("XPath error.", e);
        }
        if (elem1 == null) {
            this.logger.warn("Cannot find standoff markup for '{}'", (Object)ref);
            anns = new GenericAnnotations();
            GenericAnnotation ann = this.addIssueItem(anns);
            ann.setString(LQIISSUESREF, ref);
            return anns;
        }
        if (this.isHTML5) {
            // empty if block
        }
        anns = new GenericAnnotations();
        NodeList items = elem1.getElementsByTagNameNS(ITS_NS_URI, "locQualityIssue");
        for (int i = 0; i < items.getLength(); ++i) {
            Element elem2 = (Element)items.item(i);
            GenericAnnotation ann = this.addIssueItem(anns);
            ann.setString(LQIISSUESREF, ref);
            String[] values = this.retrieveLocQualityIssueData(elem2, false);
            if (values[0] != null) {
                this.logger.warn("Cannot have a standoff reference in a standoff element (reference='{}').", (Object)ref);
            }
            if (values[1] != null) {
                ann.setString(LQITYPE, values[1]);
            }
            if (values[2] != null) {
                ann.setString(LQICOMMENT, values[2]);
            }
            if (values[3] != null) {
                ann.setFloat(LQISEVERITY, Float.valueOf(Float.parseFloat(values[3])));
            }
            if (values[4] != null) {
                ann.setString(LQIPROFILEREF, values[4]);
            }
            if (values[5] == null) continue;
            ann.setBoolean(LQIENABLED, values[5].equals("yes"));
        }
        return anns;
    }

    private boolean isVersion2() throws XPathExpressionException {
        if (this.version.equals("0")) {
            XPathExpression expr = this.xpath.compile("//*/@its:version|//its:span/@version");
            NodeList NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
            if (NL == null || NL.getLength() == 0) {
                this.version = ITS_VERSION2;
            } else {
                if (NL.getLength() > 0) {
                    this.version = ((Attr)NL.item(0)).getValue();
                    if (!this.version.equals(ITS_VERSION1) && !this.version.equals(ITS_VERSION2)) {
                        throw new ITSException(String.format("Invalid or missing ITS version (\"%s\")", this.version));
                    }
                }
                if (NL.getLength() > 1) {
                    throw new ITSException("More than one ITS version is defined in this document.");
                }
            }
        }
        return this.version.equals(ITS_VERSION2);
    }

    public static String getTextContent(Node node) {
        Node tmp = node.getFirstChild();
        while (tmp != null) {
            if (tmp.getNodeType() == 3) {
                return tmp.getNodeValue();
            }
            tmp = tmp.getNextSibling();
        }
        return "";
    }

    private String resolvePointer(Node node, String pointer) {
        try {
            XPathExpression expr = this.xpath.compile(pointer);
            NodeList list = (NodeList)expr.evaluate(node, XPathConstants.NODESET);
            if (list == null || list.getLength() == 0) {
                return "";
            }
            switch (list.item(0).getNodeType()) {
                case 1: {
                    return ITSEngine.getTextContent(list.item(0));
                }
                case 2: {
                    return list.item(0).getNodeValue();
                }
            }
        }
        catch (XPathExpressionException e) {
            return "Bad XPath expression in pointer \"" + pointer + "\".";
        }
        return "pointer(" + pointer + ")";
    }

    private String resolveExpressionAsString(Node node, String expression) {
        try {
            XPathExpression expr = this.xpath.compile(expression);
            return (String)expr.evaluate(node, XPathConstants.STRING);
        }
        catch (XPathExpressionException e) {
            return "Bab XPath expression \"" + expression + "\".";
        }
    }

    private List<String> resolveExpressionAsList(Node node, String expression) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            XPathExpression expr = this.xpath.compile(expression);
            NodeList nl = (NodeList)expr.evaluate(node, XPathConstants.NODESET);
            for (int i = 0; i < nl.getLength(); ++i) {
                Node tmpNode = nl.item(i);
                if (tmpNode.getNodeType() == 1) {
                    list.add(tmpNode.getTextContent());
                    continue;
                }
                list.add(tmpNode.getNodeValue());
            }
        }
        catch (XPathExpressionException e) {
            list.add("Bab XPath expression \"" + expression + "\".");
        }
        return list;
    }

    private void setFlag(Node node, int position, char value, boolean override) {
        StringBuilder data = new StringBuilder();
        if (node.getUserData(FLAGNAME) == null) {
            data.append(FLAGDEFAULTDATA);
        } else {
            data.append((String)node.getUserData(FLAGNAME));
        }
        if (override || data.charAt(position) != '?') {
            data.setCharAt(position, value);
        }
        node.setUserData(FLAGNAME, data.toString(), null);
    }

    private void setFlag(Node node, int position, String value, boolean override) {
        StringBuilder data = new StringBuilder();
        if (node.getUserData(FLAGNAME) == null) {
            data.append(FLAGDEFAULTDATA);
        } else {
            data.append((String)node.getUserData(FLAGNAME));
        }
        int n1 = 0;
        int n2 = data.indexOf(FLAGSEP, 0);
        for (int i = 0; i <= position; ++i) {
            n1 = n2;
            n2 = data.indexOf(FLAGSEP, n1 + 1);
        }
        if (override || n2 > n1 + 1) {
            data.replace(n1 + 1, n2, value);
        }
        node.setUserData(FLAGNAME, data.toString(), null);
    }

    private String getFlagData(String data, int position) {
        int n1 = 0;
        int n2 = data.indexOf(FLAGSEP, 0);
        for (int i = 0; i <= position; ++i) {
            n1 = n2;
            n2 = data.indexOf(FLAGSEP, n1 + 1);
        }
        if (n2 > n1 + 1) {
            return data.substring(n1 + 1, n2);
        }
        return "";
    }

    @Override
    public boolean getTranslate(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().translate;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return false;
        }
        return tmp.charAt(0) == 'y';
    }

    @Override
    public String getTargetPointer(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().targetPointer;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        return this.getFlagData(tmp, 3);
    }

    @Override
    public String getIdValue(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().idValue;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        return this.getFlagData(tmp, 4);
    }

    @Override
    public int getDirectionality(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().dir;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return 1;
        }
        return tmp.charAt(1);
    }

    @Override
    public int getWithinText() {
        return this.trace.peek().withinText;
    }

    @Override
    public boolean getTerm(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().term;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return false;
        }
        return tmp.charAt(3) == 'y';
    }

    @Override
    public String getTermInfo(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().termInfo;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(3) != 'y') {
            return null;
        }
        return this.getFlagData(tmp, 0);
    }

    @Override
    public String getLocNote(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().locNote;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(4) == '?') {
            return null;
        }
        return this.getFlagData(tmp, 1);
    }

    @Override
    public String getLocNoteType(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().locNoteType;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(4) == '?') {
            return null;
        }
        if (tmp.charAt(4) == 'a') {
            return "alert";
        }
        return "description";
    }

    @Override
    public String getDomains(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().domains;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(7) != 'y') {
            return null;
        }
        return this.getFlagData(tmp, 5);
    }

    @Override
    public boolean preserveWS() {
        return this.trace.peek().preserveWS;
    }

    @Override
    public String getLanguage() {
        return this.trace.peek().language;
    }

    @Override
    public String getExternalResourceRef(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().externalRes;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(8) != 'y') {
            return null;
        }
        return this.getFlagData(tmp, 6);
    }

    @Override
    public String getLocaleFilter() {
        return this.trace.peek().localeFilter;
    }

    @Override
    public String getLocQualityIssuesRef(Attr attribute) {
        return this.getLQIValue(LQIISSUESREF, attribute, 0);
    }

    @Override
    public int getLocQualityIssueCount(Attr attribute) {
        if (attribute == null) {
            GenericAnnotations lqi = this.trace.peek().lqIssues;
            if (lqi == null) {
                return 0;
            }
            return lqi.size();
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return 0;
        }
        if (tmp.charAt(10) != 'y') {
            return 0;
        }
        GenericAnnotations anns = new GenericAnnotations(this.getFlagData(tmp, 8));
        return anns.getAnnotations(LQISSUE).size();
    }

    public GenericAnnotations getLocQualityIssues(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().lqIssues;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(10) != 'y') {
            return null;
        }
        return new GenericAnnotations(this.getFlagData(tmp, 8));
    }

    @Override
    public String getLocQualityIssueType(Attr attribute, int index) {
        return this.getLQIValue(LQITYPE, attribute, index);
    }

    @Override
    public String getLocQualityIssueComment(Attr attribute, int index) {
        return this.getLQIValue(LQICOMMENT, attribute, index);
    }

    @Override
    public Float getLocQualityIssueSeverity(Attr attribute, int index) {
        if (attribute == null) {
            if (this.trace.peek().lqIssues == null) {
                return null;
            }
            return this.trace.peek().lqIssues.getAnnotations(LQISSUE).get(index).getFloat(LQISEVERITY);
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(10) != 'y') {
            return null;
        }
        GenericAnnotations anns = new GenericAnnotations(this.getFlagData(tmp, 8));
        return anns.getAnnotations(LQISSUE).get(index).getFloat(LQISEVERITY);
    }

    @Override
    public String getLocQualityIssueProfileRef(Attr attribute, int index) {
        return this.getLQIValue(LQIPROFILEREF, attribute, index);
    }

    @Override
    public Boolean getLocQualityIssueEnabled(Attr attribute, int index) {
        if (attribute == null) {
            if (this.trace.peek().lqIssues == null) {
                return null;
            }
            return this.trace.peek().lqIssues.getAnnotations(LQISSUE).get(index).getBoolean(LQIENABLED);
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(10) != 'y') {
            return null;
        }
        GenericAnnotations anns = new GenericAnnotations(this.getFlagData(tmp, 8));
        return anns.getAnnotations(LQISSUE).get(index).getBoolean(LQIENABLED);
    }

    private String getLQIValue(String fieldName, Attr attribute, int index) {
        if (attribute == null) {
            if (this.trace.peek().lqIssues == null) {
                return null;
            }
            return this.trace.peek().lqIssues.getAnnotations(LQISSUE).get(index).getString(fieldName);
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(10) != 'y') {
            return null;
        }
        GenericAnnotations anns = new GenericAnnotations(this.getFlagData(tmp, 8));
        return anns.getAnnotations(LQISSUE).get(index).getString(fieldName);
    }

    @Override
    public String getStorageSize(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().storageSize;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(11) != 'y') {
            return null;
        }
        String[] values = this.fromSingleString(this.getFlagData(tmp, 9));
        return values[0];
    }

    @Override
    public String getStorageEncoding(Attr attribute) {
        if (attribute == null) {
            String tmp = this.trace.peek().storageEncoding;
            if (tmp == null) {
                return "UTF-8";
            }
            return tmp;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(11) != 'y') {
            return null;
        }
        String[] values = this.fromSingleString(this.getFlagData(tmp, 9));
        if (values[1] == null) {
            return "UTF-8";
        }
        return values[1];
    }

    @Override
    public String getLineBreakType(Attr attribute) {
        if (attribute == null) {
            String tmp = this.trace.peek().lineBreakType;
            if (tmp == null) {
                return "lf";
            }
            return tmp;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(11) != 'y') {
            return null;
        }
        String[] values = this.fromSingleString(this.getFlagData(tmp, 9));
        if (values[2] == null) {
            return "lf";
        }
        return values[2];
    }

    @Override
    public String getAllowedCharacters(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().allowedChars;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(12) != '?') {
            return this.getFlagData(tmp, 10);
        }
        return null;
    }

    public String getSubFilter(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().subFilter;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(13) != 'y') {
            return null;
        }
        return this.getFlagData(tmp, 11);
    }

    @Override
    public String getToolsRef() {
        return this.trace.peek().toolsRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareTargetPointers() {
        this.hasTargetPointer = false;
        try {
            Node srcNode;
            if (!this.getTargetPointerRuleTriggered()) {
                return;
            }
            this.startTraversal();
            while ((srcNode = this.nextNode()) != null) {
                String pointer;
                if (srcNode.getNodeType() != 1 || this.backTracking() || !this.getTranslate(null) || (pointer = this.getTargetPointer(null)) == null) continue;
                this.resolveTargetPointer(this.getXPath(), srcNode, pointer);
            }
        }
        finally {
            this.startTraversal();
        }
    }

    private void resolveTargetPointer(XPath xpath, Node srcNode, String pointer) {
        try {
            XPathExpression expr = xpath.compile(pointer);
            Node trgNode = (Node)expr.evaluate(srcNode, XPathConstants.NODE);
            if (trgNode == null) {
                return;
            }
            if (srcNode.getNodeType() != trgNode.getNodeType()) {
                this.logger.warn("Potential issue with target pointer '{}'.\nThe source and target node are of different types. Depending on the content of the source, this may or may not be an issue.", (Object)pointer);
            }
            TargetPointerEntry tpe = new TargetPointerEntry(srcNode, trgNode);
            srcNode.setUserData(SRC_TRGPTRFLAGNAME, tpe, null);
            trgNode.setUserData(TRG_TRGPTRFLAGNAME, tpe, null);
            this.hasTargetPointer = true;
        }
        catch (XPathExpressionException e) {
            throw new OkapiIOException(String.format("Bab XPath expression in target pointer '%s'.", pointer));
        }
    }

    public boolean getHasTargetPointer() {
        return this.hasTargetPointer;
    }

    public TargetPointerEntry getTargetPointerEntry(Node node) {
        TargetPointerEntry tpe = (TargetPointerEntry)node.getUserData(TRG_TRGPTRFLAGNAME);
        if (tpe != null || (tpe = (TargetPointerEntry)node.getUserData(SRC_TRGPTRFLAGNAME)) != null) {
            // empty if block
        }
        return tpe;
    }
}

