/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.its;

import java.io.File;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiBadFilterParametersException;
import net.sf.okapi.filters.its.html5.HTML5Filter;
import nu.validator.htmlparser.dom.HtmlDocumentBuilder;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.its.ITSEngine;
import org.w3c.its.ITraversal;

public class Main {
    public static final String DC_TRANSLATE = "translate";
    public static final String DC_LOCALIZATIONNOTE = "locnote";
    public static final String DC_TERMINOLOGY = "terminology";
    public static final String DC_DIRECTIONALITY = "dir";
    public static final String DC_LANGUAGEINFORMATION = "lang";
    public static final String DC_WITHINTEXT = "withintext";
    public static final String DC_DOMAIN = "domain";
    public static final String DC_LOCALEFILTER = "localefilter";
    public static final String DC_EXTERNALRESOURCE = "externalresource";
    public static final String DC_TARGETPOINTER = "targetpointer";
    public static final String DC_IDVALUE = "idvalue";
    public static final String DC_PRESERVESPACE = "preservespace";
    public static final String DC_LOCQUALITYISSUE = "locqualityissue";
    public static final String DC_STORAGESIZE = "storagesize";
    public static final String DC_ALLOWEDCHARACTERS = "allowedcharacters";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        PrintWriter writer = null;
        try {
            Node node;
            Document doc;
            System.out.println("ITSTest - Test File Geneator for XML+ITS and HTML5+ITS");
            File inputFile = null;
            File outputFile = null;
            File rulesFile = null;
            String dc = DC_TRANSLATE;
            boolean isHTML5 = false;
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.equals("-r")) {
                    rulesFile = new File(args[++i]);
                    continue;
                }
                if (arg.equals("-dc")) {
                    dc = args[++i].toLowerCase();
                    continue;
                }
                if (arg.equals("-?")) {
                    Main.showUsage();
                    return;
                }
                if (arg.equals("-l")) {
                    System.out.println("translate\nlocnote\nterminology\ndir\nlang\nwithintext\ndomain\nlocalefilter\nexternalresource\ntargetpointer\nidvalue\npreservespace\nlocqualityissue\nstoragesize\nallowedcharacters");
                    return;
                }
                if (inputFile == null) {
                    inputFile = new File(args[i]);
                    isHTML5 = Util.getExtension(args[i]).toLowerCase().startsWith(".htm");
                    continue;
                }
                outputFile = new File(args[i]);
            }
            if (inputFile == null) {
                Main.showUsage();
                return;
            }
            if (outputFile == null) {
                String name = inputFile.getAbsolutePath();
                int n = name.lastIndexOf(46);
                if (n > -1) {
                    name = name.substring(0, n);
                }
                name = name + "output";
                name = name + ".txt";
                outputFile = new File(name);
            }
            System.out.println("   input: " + inputFile.getAbsolutePath());
            System.out.println("  output: " + outputFile.getAbsolutePath());
            if (rulesFile != null) {
                System.out.print("   rules: " + rulesFile.getAbsolutePath());
            }
            Util.createDirectories(outputFile.getAbsolutePath());
            writer = new PrintWriter(outputFile.getAbsolutePath(), "UTF-8");
            if (isHTML5) {
                HtmlDocumentBuilder docBuilder = new HtmlDocumentBuilder();
                doc = docBuilder.parse(inputFile);
            } else {
                DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
                fact.setNamespaceAware(true);
                fact.setValidating(false);
                doc = fact.newDocumentBuilder().parse(inputFile);
            }
            ITraversal trav = Main.applyITSRules(doc, inputFile, rulesFile, isHTML5);
            String path = null;
            Stack<Integer> stack = new Stack<Integer>();
            stack.push(1);
            int prevCount = 0;
            trav.startTraversal();
            while ((node = trav.nextNode()) != null) {
                switch (node.getNodeType()) {
                    case 1: {
                        if (trav.backTracking()) {
                            int n = path.lastIndexOf(47);
                            if (n > -1) {
                                path = path.substring(0, n);
                            }
                            prevCount = (Integer)stack.pop();
                            break;
                        }
                        Element element = (Element)node;
                        Node prev = element;
                        while ((prev = prev.getPreviousSibling()) != null && (prev.getNodeType() != 1 || prev.getNodeType() == 1 && !prev.getNodeName().equals(element.getNodeName()))) {
                        }
                        if (prev != null && prev.getNodeName().equals(element.getNodeName())) {
                            stack.push(prevCount + 1);
                        } else {
                            stack.push(1);
                        }
                        path = element == doc.getDocumentElement() ? "/" + element.getNodeName() : path + String.format("/%s[%d]", element.getNodeName(), stack.peek());
                        Main.output(writer, dc, path, trav, null);
                        if (element.hasAttributes()) {
                            NamedNodeMap map = element.getAttributes();
                            ArrayList<String> list = new ArrayList<String>();
                            for (int i = 0; i < map.getLength(); ++i) {
                                list.add(((Attr)map.item(i)).getNodeName());
                            }
                            Collections.sort(list);
                            for (String attrName : list) {
                                Attr attr = (Attr)map.getNamedItem(attrName);
                                if (attr.getNodeName().startsWith("xmlns:")) continue;
                                Main.output(writer, dc, path + "/@" + attr.getNodeName(), trav, attr);
                            }
                        }
                        if (element.hasChildNodes()) break;
                        int n = path.lastIndexOf(47);
                        if (n > -1) {
                            path = path.substring(0, n);
                        }
                        prevCount = (Integer)stack.pop();
                    }
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
    }

    private static void showUsage() {
        System.out.println("Usage: <inputFile>[ <outputFile>][ <options>]");
        System.out.println("Where the options are:");
        System.out.println(" -? shows this help");
        System.out.println(" -r <ruleFile> : associates the input with an ITS rule file");
        System.out.println(" -l : lists all the avaibale data categories to use with -dc");
        System.out.println(" -dc <data-category> : sets the data category to process (default=translate)");
    }

    private static void output(PrintWriter writer, String dc, String path, ITraversal trav, Attr attr) {
        writer.print(path);
        String out1 = null;
        if (dc.equals(DC_TRANSLATE)) {
            out1 = trav.getTranslate(attr) ? "yes" : "no";
            writer.print(String.format("\ttranslate=\"%s\"", Main.escape(out1)));
        } else if (dc.equals(DC_LOCALIZATIONNOTE)) {
            out1 = trav.getLocNote(attr);
            if (out1 != null) {
                writer.print(String.format("\tlocNote=\"%s\"", Main.escape(out1)));
                out1 = trav.getLocNoteType(attr);
                writer.print(String.format("\tlocNoteType=\"%s\"", Main.escape(out1)));
            }
        } else if (dc.equals(DC_TERMINOLOGY)) {
            String string = out1 = trav.getTerm(attr) ? "yes" : "no";
            if (out1 != null) {
                writer.print(String.format("\tterm=\"%s\"", Main.escape(out1)));
            }
            writer.print("\t");
            out1 = trav.getTermInfo(attr);
            if (out1 != null) {
                writer.print(String.format("\ttermInfo=\"%s\"", Main.escape(out1)));
            }
        } else if (dc.equals(DC_DIRECTIONALITY)) {
            int dir = trav.getDirectionality(attr);
            switch (dir) {
                case 3: {
                    out1 = "lro";
                    break;
                }
                case 1: {
                    out1 = "ltr";
                    break;
                }
                case 2: {
                    out1 = "rlo";
                    break;
                }
                case 0: {
                    out1 = "rtl";
                }
            }
            writer.print(String.format("\tdir=\"%s\"", Main.escape(out1)));
        } else if (dc.equals(DC_LANGUAGEINFORMATION)) {
            out1 = trav.getLanguage();
            if (out1 != null) {
                writer.print(String.format("\tlang=\"%s\"", Main.escape(out1)));
            }
        } else if (dc.equals(DC_WITHINTEXT)) {
            if (attr != null) {
                return;
            }
            int wt = trav.getWithinText();
            switch (wt) {
                case 2: {
                    out1 = "nested";
                    break;
                }
                case 0: {
                    out1 = "no";
                    break;
                }
                case 1: {
                    out1 = "yes";
                }
            }
            writer.print(String.format("\twithinText=\"%s\"", Main.escape(out1)));
        } else if (dc.equals(DC_DOMAIN)) {
            out1 = trav.getDomains(attr);
            if (out1 != null) {
                writer.print(String.format("\tdomains=\"%s\"", Main.escape(out1)));
            }
        } else if (dc.equals(DC_LOCALEFILTER)) {
            out1 = trav.getLocaleFilter();
            if (out1 != null) {
                writer.print(String.format("\tlocaleFilterList=\"%s\"", Main.escape(out1)));
            }
        } else if (dc.equals(DC_EXTERNALRESOURCE)) {
            out1 = trav.getExternalResourceRef(attr);
            if (out1 != null) {
                writer.print(String.format("\texternalResource=\"%s\"", Main.escape(out1)));
            }
        } else if (dc.equals(DC_TARGETPOINTER)) {
            out1 = trav.getTargetPointer(attr);
            if (out1 != null) {
                writer.print(String.format("\ttargetPointer=\"%s\"", Main.escape(out1)));
            }
        } else if (dc.equals(DC_IDVALUE)) {
            out1 = trav.getIdValue(attr);
            if (out1 != null) {
                writer.print(String.format("\tidValue=\"%s\"", Main.escape(out1)));
            }
        } else if (dc.equals(DC_PRESERVESPACE)) {
            String string = out1 = trav.preserveWS() ? "preserve" : "default";
            if (out1 != null) {
                writer.print(String.format("\tpreserveSpace=\"%s\"", Main.escape(out1)));
            }
        } else if (dc.equals(DC_LOCQUALITYISSUE)) {
            int count = trav.getLocQualityIssueCount(attr);
            if (count == 0) {
                writer.print("\n");
                return;
            }
            out1 = trav.getLocQualityIssuesRef(attr);
            writer.print(String.format("\tlocQualityIssuesRef=\"%s\"", Main.escape(out1 == null ? "" : out1)));
            writer.print("\t");
            for (int i = 0; i < count; ++i) {
                Boolean outBool1 = trav.getLocQualityIssueEnabled(attr, i);
                writer.print(String.format("\tlocQualityIssueEnabled[%d]=\"%s\"", i, outBool1 == null ? "false" : (outBool1 != false ? "yes" : "no")));
                writer.print("\t");
                out1 = trav.getLocQualityIssueComment(attr, i);
                writer.print(String.format("\tlocQualityIssueComment[%d]=\"%s\"", i, Main.escape(out1 == null ? "" : out1)));
                writer.print("\t");
                out1 = trav.getLocQualityIssueProfileRef(attr, i);
                writer.print(String.format("\tlocQualityIssueProfileRef[%d]=\"%s\"", i, Main.escape(out1 == null ? "" : out1)));
                writer.print("\t");
                Float outFloat1 = trav.getLocQualityIssueSeverity(attr, i);
                writer.print(String.format("\tlocQualityIssueSeverity[%d]=\"%f\"", i, Float.valueOf(outFloat1 == null ? 0.0f : outFloat1.floatValue())));
                writer.print("\t");
                out1 = trav.getLocQualityIssueType(attr, i);
                writer.print(String.format("\tlocQualityIssueType[%d]=\"%s\"", i, Main.escape(out1 == null ? "" : out1)));
            }
        } else if (dc.equals(DC_STORAGESIZE)) {
            out1 = trav.getStorageSize(attr);
            if (out1 != null) {
                writer.print(String.format("\tstorageSize=\"%s\"", Main.escape(out1)));
            }
            writer.print("\t");
            out1 = trav.getStorageEncoding(attr);
            if (out1 != null) {
                writer.print(String.format("\tstorageEncoding=\"%s\"", Main.escape(out1)));
            }
            writer.print("\t");
            out1 = trav.getLineBreakType(attr);
            if (out1 != null) {
                writer.print(String.format("\tlineBreakType=\"%s\"", Main.escape(out1)));
            }
        } else if (dc.equals(DC_ALLOWEDCHARACTERS) && (out1 = trav.getAllowedCharacters(attr)) != null) {
            writer.print(String.format("\tallowedCharacters=\"%s\"", Main.escape(out1)));
        }
        writer.print("\n");
    }

    private static String escape(String text) {
        text = text.replace("\n", "\\n");
        text = text.replace("\t", "\\t");
        return Util.escapeToXML(text, 3, false, null);
    }

    private static ITraversal applyITSRules(Document doc, File inputFile, File rulesFile, boolean isHTML5) {
        ITSEngine itsEng = new ITSEngine(doc, inputFile.toURI(), isHTML5, null);
        if (isHTML5) {
            URL url = HTML5Filter.class.getResource("default.fprm");
            try {
                itsEng.addExternalRules(url.toURI());
            }
            catch (URISyntaxException e) {
                throw new OkapiBadFilterParametersException("Cannot load default parameters.");
            }
        }
        if (rulesFile != null) {
            itsEng.addExternalRules(rulesFile.toURI());
        }
        if (isHTML5) {
            HTML5Filter.loadLinkedRules(doc, inputFile.toURI(), itsEng);
        }
        itsEng.applyRules(-1L);
        return itsEng;
    }
}

