/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import net.sf.okapi.common.DefaultFilenameFilter;
import net.sf.okapi.common.Util;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultFilenameFilterTest {
    private File root;

    @Before
    public void setUp() throws URISyntaxException {
        URL url = DefaultFilenameFilterTest.class.getResource("/test.txt");
        this.root = new File(Util.getDirectoryName(url.getPath()));
    }

    @Test
    public void testPattern1() {
        File[] files = this.root.listFiles(new DefaultFilenameFilter("t*.txt", false));
        Assert.assertEquals(6L, files.length);
        for (File file : files) {
            Assert.assertTrue(file.getName().startsWith("t") || file.getName().startsWith("T"));
            Assert.assertTrue(file.getName().endsWith(".txt"));
        }
    }

    @Test
    public void testPattern2() {
        File[] files = this.root.listFiles(new DefaultFilenameFilter("test?.t?t", false));
        Assert.assertEquals(2L, files.length);
        for (File file : files) {
            Assert.assertTrue(file.getName().startsWith("test") || file.getName().startsWith("Test"));
            Assert.assertTrue(file.getName().endsWith(".txt") || file.getName().endsWith(".tzt"));
        }
    }

    @Test
    public void testPattern3() {
        File[] files = this.root.listFiles(new DefaultFilenameFilter("testE*.t?t", false));
        Assert.assertEquals(2L, files.length);
        for (File file : files) {
            Assert.assertTrue(file.getName().startsWith("TestE"));
            Assert.assertTrue(file.getName().endsWith(".txt") || file.getName().endsWith(".tzt"));
        }
    }

    @Test
    public void testPattern4() {
        File[] files = this.root.listFiles(new DefaultFilenameFilter("test.txt", false));
        Assert.assertEquals(1L, files.length);
        Assert.assertEquals("test.txt", files[0].getName());
    }

    @Test
    public void testPattern5() {
        File[] files = this.root.listFiles(new DefaultFilenameFilter("TestEtc.*", false));
        Assert.assertEquals(2L, files.length);
        for (File file : files) {
            Assert.assertTrue(file.getName().startsWith("TestEt"));
        }
    }

    @Test
    public void testPattern6() {
        File[] files = this.root.listFiles(new DefaultFilenameFilter("*.tzt", false));
        Assert.assertEquals(1L, files.length);
        Assert.assertEquals("testB.tzt", files[0].getName());
        files = this.root.listFiles(new DefaultFilenameFilter(".tzt"));
        Assert.assertEquals(1L, files.length);
        Assert.assertEquals("testB.tzt", files[0].getName());
    }

    @Test
    public void testPattern7() {
        File[] files = this.root.listFiles(new DefaultFilenameFilter("*.htm", false));
        Assert.assertEquals(0L, files.length);
        files = this.root.listFiles(new DefaultFilenameFilter(".htm"));
        Assert.assertEquals(0L, files.length);
    }

    @Test
    public void testPattern8() {
        File[] files = this.root.listFiles(new DefaultFilenameFilter("t*.txt", true));
        Assert.assertEquals(2L, files.length);
        for (File file : files) {
            Assert.assertTrue(file.getName().startsWith("t"));
            Assert.assertTrue(file.getName().endsWith(".txt"));
        }
    }
}

