/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.util.Locale;
import net.sf.okapi.common.LocaleId;
import org.junit.Assert;
import org.junit.Test;

public class LocaleIdTest {
    @Test
    public void testIdentity() {
        LocaleId locId1 = LocaleId.ENGLISH;
        LocaleId locId2 = new LocaleId("en", true);
        Assert.assertEquals(0L, locId1.compareTo(locId2));
        Assert.assertEquals(locId1.hashCode(), locId2.hashCode());
    }

    @Test
    public void testConstructorFromIdentifier() {
        LocaleId locId = new LocaleId("en-CA", true);
        Assert.assertEquals("en", locId.getLanguage());
        Assert.assertEquals("ca", locId.getRegion());
        locId = new LocaleId("EN_CA", true);
        Assert.assertEquals("en", locId.getLanguage());
        Assert.assertEquals("ca", locId.getRegion());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorFromNullIdentifier() {
        new LocaleId((String)null, true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorFromEmptyIdentifier() {
        new LocaleId("", true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorFrombadXIdentifier() {
        new LocaleId("z-test", true);
    }

    @Test
    public void testConstructorFromGoodXIdentifier() {
        new LocaleId("x-custom", true);
    }

    @Test
    public void testConstructorFromBadIdentifier() {
        LocaleId locId = new LocaleId("EN_CA", false);
        Assert.assertEquals("EN_CA", locId.getLanguage());
        Assert.assertNull(null, locId.getRegion());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorFromNullLanguage() {
        new LocaleId((String)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorFromEmptyLanguage() {
        new LocaleId("");
    }

    @Test
    public void testConstructorFromLanguage() {
        LocaleId locId = new LocaleId("en");
        Assert.assertEquals("en", locId.getLanguage());
        Assert.assertNull(locId.getRegion());
        locId = new LocaleId("EN");
        Assert.assertEquals("en", locId.getLanguage());
        Assert.assertNull(locId.getRegion());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorFromNullLanguageAndRegion() {
        new LocaleId((String)null, "CA");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorFromEmptyLanguageAndRegion() {
        new LocaleId("", "CA");
    }

    @Test
    public void testConstructorFromLanguageAndRegion() {
        LocaleId locId = new LocaleId("de", "CH");
        Assert.assertEquals("de", locId.getLanguage());
        Assert.assertEquals("ch", locId.getRegion());
        locId = new LocaleId("DE", null);
        Assert.assertEquals("de", locId.getLanguage());
        Assert.assertNull(locId.getRegion());
        locId = new LocaleId("DE", "");
        Assert.assertEquals("de", locId.getLanguage());
        Assert.assertNull(locId.getRegion());
    }

    @Test
    public void testConstructorFromLanguageRegionUserPart() {
        LocaleId locId = new LocaleId("de", "CH", "win");
        Assert.assertEquals("de", locId.getLanguage());
        Assert.assertEquals("ch", locId.getRegion());
        Assert.assertEquals("win", locId.getUserPart());
        Assert.assertEquals("de-ch-x-win", locId.toString());
        locId = new LocaleId("de", "CH", "WIN");
        Assert.assertEquals("de", locId.getLanguage());
        Assert.assertEquals("ch", locId.getRegion());
        Assert.assertEquals("win", locId.getUserPart());
        Assert.assertEquals("de-ch-x-win", locId.toString());
        locId = new LocaleId("DE", null, null);
        Assert.assertEquals("de", locId.getLanguage());
        Assert.assertNull(locId.getRegion());
        Assert.assertNull(locId.getUserPart());
        locId = new LocaleId("DE", null, "win");
        Assert.assertEquals("de", locId.getLanguage());
        Assert.assertNull(locId.getRegion());
        Assert.assertNull(locId.getUserPart());
        locId = new LocaleId("DE", "", "");
        Assert.assertEquals("de", locId.getLanguage());
        Assert.assertNull(locId.getRegion());
        Assert.assertNull(locId.getUserPart());
        locId = new LocaleId("DE", "", "win");
        Assert.assertEquals("de", locId.getLanguage());
        Assert.assertNull(locId.getRegion());
        Assert.assertNull(locId.getUserPart());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorFromNullJavaLocale() {
        new LocaleId((Locale)null);
    }

    @Test
    public void testConstructorFromJavaLocale() {
        LocaleId locId = new LocaleId(Locale.CANADA_FRENCH);
        Assert.assertEquals("fr", locId.getLanguage());
        Assert.assertEquals("ca", locId.getRegion());
        locId = new LocaleId(Locale.SIMPLIFIED_CHINESE);
        Assert.assertEquals("zh", locId.getLanguage());
        Assert.assertEquals("cn", locId.getRegion());
        locId = new LocaleId(Locale.CHINESE);
        Assert.assertEquals("zh", locId.getLanguage());
        Assert.assertNull(locId.getRegion());
        locId = new LocaleId(Locale.TRADITIONAL_CHINESE);
        Assert.assertEquals("zh", locId.getLanguage());
        Assert.assertEquals("tw", locId.getRegion());
        locId = new LocaleId(new Locale("th", "TH", "TH"));
        Assert.assertEquals("th", locId.getLanguage());
        Assert.assertEquals("th", locId.getRegion());
    }

    @Test
    public void testFromBCP() {
        LocaleId locId = LocaleId.fromBCP47("en-us");
        Assert.assertEquals("en", locId.getLanguage());
        Assert.assertEquals("us", locId.getRegion());
        locId = LocaleId.fromBCP47("kok");
        Assert.assertEquals("kok", locId.getLanguage());
        locId = LocaleId.fromBCP47("ar-Latn-EG");
        Assert.assertEquals("ar", locId.getLanguage());
        Assert.assertEquals("eg", locId.getRegion());
        locId = LocaleId.fromBCP47("az-latn");
        Assert.assertEquals("az", locId.getLanguage());
        Assert.assertNull(locId.getRegion());
        locId = LocaleId.fromBCP47("zh-Hant-TW");
        Assert.assertEquals("zh", locId.getLanguage());
        Assert.assertEquals("tw", locId.getRegion());
        locId = LocaleId.fromBCP47("zh-Latn-TW-pinyin");
        Assert.assertEquals("zh", locId.getLanguage());
        Assert.assertEquals("tw", locId.getRegion());
        locId = LocaleId.fromBCP47("es-419");
        Assert.assertEquals("es", locId.getLanguage());
        Assert.assertEquals("419", locId.getRegion());
        locId = LocaleId.fromBCP47("de-CH-1996");
        Assert.assertEquals("de", locId.getLanguage());
        Assert.assertEquals("ch", locId.getRegion());
        locId = LocaleId.fromBCP47("ja-Latn-hepburn");
        Assert.assertEquals("ja", locId.getLanguage());
    }

    @Test
    public void testFromPOSIX() {
        LocaleId locId = LocaleId.fromPOSIXLocale("zu");
        Assert.assertEquals("zu", locId.getLanguage());
        locId = LocaleId.fromPOSIXLocale("kok");
        Assert.assertEquals("kok", locId.getLanguage());
        locId = LocaleId.fromPOSIXLocale("de_AT");
        Assert.assertEquals("de", locId.getLanguage());
        Assert.assertEquals("at", locId.getRegion());
        Assert.assertEquals(null, locId.getUserPart());
        locId = LocaleId.fromPOSIXLocale("de_AT.UTF-8");
        Assert.assertEquals("de", locId.getLanguage());
        Assert.assertEquals("at", locId.getRegion());
        Assert.assertEquals(null, locId.getUserPart());
        locId = LocaleId.fromPOSIXLocale("de_AT.UTF-8@ATS");
        Assert.assertEquals("de", locId.getLanguage());
        Assert.assertEquals("at", locId.getRegion());
        Assert.assertEquals("ats", locId.getUserPart());
        locId = LocaleId.fromPOSIXLocale("sr@latin");
        Assert.assertEquals("sr", locId.getLanguage());
        Assert.assertEquals("latin", locId.getUserPart());
    }

    @Test
    public void testToPOSIX() {
        LocaleId locId = LocaleId.fromPOSIXLocale("en_US.UTF-8");
        String res = locId.toPOSIXLocaleId();
        Assert.assertNotNull(res);
        Assert.assertEquals("en_US", res);
        locId = LocaleId.fromPOSIXLocale("DE");
        res = locId.toPOSIXLocaleId();
        Assert.assertNotNull(res);
        Assert.assertEquals("de", res);
    }

    @Test
    public void testToJavaLocale() {
        LocaleId locId = new LocaleId(Locale.CANADA_FRENCH);
        Locale loc = locId.toJavaLocale();
        Assert.assertNotNull(loc);
        Assert.assertEquals(Locale.CANADA_FRENCH.toString(), loc.toString());
        Locale jloc = new Locale("th", "TH", "TH");
        locId = new LocaleId(jloc);
        loc = locId.toJavaLocale();
        Assert.assertNotNull(loc);
        Assert.assertEquals(jloc.toString(), loc.toString());
        locId = new LocaleId(Locale.CHINESE);
        loc = locId.toJavaLocale();
        Assert.assertNotNull(loc);
        Assert.assertEquals(Locale.CHINESE.toString(), loc.toString());
    }

    @Test
    public void testEqualsWithLocaleId() {
        LocaleId locId1 = new LocaleId("fi-fi", false);
        LocaleId locId2 = new LocaleId("fi-se", false);
        Assert.assertFalse(locId1.equals(locId2));
        locId1 = new LocaleId("kok-abc", false);
        locId2 = new LocaleId("KOK_aBc", true);
        Assert.assertTrue(locId1.equals(locId2));
        locId1 = new LocaleId("br");
        locId2 = new LocaleId("br");
        Assert.assertTrue(locId1.equals(locId2));
    }

    @Test
    public void testEqualsWithString() {
        LocaleId locId1 = new LocaleId("fi-fi", false);
        Assert.assertFalse(locId1.equals("fi-se"));
        locId1 = new LocaleId("kok-abc", false);
        Assert.assertTrue(locId1.equals("KOK-aBc"));
        locId1 = new LocaleId("br");
        Assert.assertTrue(locId1.equals("BR"));
    }

    @Test
    public void testUsage() {
        Assert.assertEquals("Austria", new LocaleId("de-at", false).toJavaLocale().getDisplayCountry(Locale.ENGLISH));
        Assert.assertEquals("French", new LocaleId("fr-ca", false).toJavaLocale().getDisplayLanguage(Locale.ENGLISH));
    }

    @Test
    public void testSameLanguageWithLocaleId() {
        LocaleId locId1 = new LocaleId("fi-fi", false);
        LocaleId locId2 = new LocaleId("fi-se", false);
        Assert.assertTrue(locId1.sameLanguageAs(locId2));
        locId1 = new LocaleId("kok", false);
        locId2 = new LocaleId("KOK_id", true);
        Assert.assertTrue(locId1.sameLanguageAs(locId2));
        locId1 = new LocaleId("br");
        locId2 = new LocaleId("br");
        Assert.assertTrue(locId1.sameLanguageAs(locId2));
    }

    @Test
    public void testSameLanguageWithString() {
        LocaleId locId = new LocaleId("fi-fi", false);
        Assert.assertTrue(locId.sameLanguageAs("fi-se"));
        locId = new LocaleId("kok", false);
        Assert.assertTrue(locId.sameLanguageAs("KoK_id"));
        locId = new LocaleId("br");
        Assert.assertTrue(locId.sameLanguageAs("br"));
    }

    @Test
    public void testDifferentLanguages() {
        LocaleId locId1 = new LocaleId("fi-fi", false);
        LocaleId locId2 = new LocaleId("sv-fi", true);
        Assert.assertFalse(locId1.sameLanguageAs(locId2));
        locId1 = new LocaleId("nn", false);
        Assert.assertFalse(locId1.sameLanguageAs("no"));
    }

    @Test
    public void testSameRegionWithLocaleId() {
        LocaleId locId1 = new LocaleId("fi-fi", false);
        LocaleId locId2 = new LocaleId("sv-fi", false);
        Assert.assertTrue(locId1.sameRegionAs(locId2));
        locId1 = new LocaleId("fi-fi", false);
        locId2 = new LocaleId("sv_FI", true);
        Assert.assertTrue(locId1.sameRegionAs(locId2));
        locId1 = new LocaleId("fi-fi", false);
        locId2 = new LocaleId("sv_FI", false);
        Assert.assertFalse(locId1.sameRegionAs(locId2));
    }

    @Test
    public void testSameRegionWithString() {
        LocaleId locId = new LocaleId("fi-fi", false);
        Assert.assertTrue(locId.sameRegionAs("sv-fi"));
        locId = new LocaleId("fi-fi", false);
        Assert.assertTrue(locId.sameRegionAs("sv_FI"));
        locId = new LocaleId("sv_FI", false);
        Assert.assertFalse(locId.sameRegionAs("fi-fi"));
    }

    @Test
    public void testDifferentRegions() {
        LocaleId locId1 = new LocaleId("sv-se", false);
        LocaleId locId2 = new LocaleId("sv-fi", true);
        Assert.assertFalse(locId1.sameRegionAs(locId2));
    }

    @Test
    public void testSameUserPartWithLocaleId() {
        LocaleId locId1 = new LocaleId("fi-fi", false);
        LocaleId locId2 = new LocaleId("sv-fi", false);
        Assert.assertTrue(locId1.sameUserPartAs(locId2));
        locId1 = new LocaleId("fi-fi", false);
        locId2 = new LocaleId("sv_FI", true);
        Assert.assertTrue(locId1.sameUserPartAs(locId2));
        locId1 = new LocaleId("fi-fi", false);
        locId2 = new LocaleId("sv_FI", false);
        Assert.assertTrue(locId1.sameUserPartAs(locId2));
        locId1 = new LocaleId("es-us-x-win", false);
        locId2 = LocaleId.fromPOSIXLocale("en_us@win");
        Assert.assertTrue(locId1.sameUserPartAs(locId2));
        locId1 = LocaleId.fromPOSIXLocale("es_us@mac");
        locId2 = LocaleId.fromPOSIXLocale("en_us@win");
        Assert.assertFalse(locId1.sameUserPartAs(locId2));
    }

    @Test
    public void testSameUserPartWithString() {
        LocaleId locId = new LocaleId("fi-fi", false);
        Assert.assertTrue(locId.sameUserPartAs("sv-fi"));
        locId = new LocaleId("fi-fi", false);
        Assert.assertTrue(locId.sameUserPartAs("sv_FI"));
        locId = new LocaleId("sv_FI", false);
        Assert.assertTrue(locId.sameUserPartAs("fi-fi"));
        locId = new LocaleId("es-us-x-win", false);
        Assert.assertTrue(locId.sameUserPartAs("en-x-win"));
        locId = LocaleId.fromPOSIXLocale("es_us@mac");
        Assert.assertFalse(locId.sameUserPartAs("es_us-x-win"));
    }

    @Test
    public void testDifferentUserParts() {
        LocaleId locId1 = new LocaleId("sv-se", false);
        LocaleId locId2 = new LocaleId("sv-fi", true);
        Assert.assertTrue(locId1.sameUserPartAs(locId2));
        locId1 = new LocaleId("es-us-x-win", false);
        locId2 = new LocaleId("es-us-x-mac", false);
        Assert.assertFalse(locId1.sameUserPartAs(locId2));
    }

    @Test
    public void testSplitLanguageCode() {
        String in = "en";
        String[] res = LocaleId.splitLanguageCode(in);
        Assert.assertEquals(res[0], "en");
        Assert.assertEquals(res[1], "");
    }

    @Test
    public void testSplitLanguageCode_4Letters() {
        String in = "en-BZ";
        String[] res = LocaleId.splitLanguageCode(in);
        Assert.assertEquals(res[0], "en");
        Assert.assertEquals(res[1], "BZ");
    }

    @Test
    public void testSplitLanguageCode_Underline() {
        String in = "en_BZ";
        String[] res = LocaleId.splitLanguageCode(in);
        Assert.assertEquals(res[0], "en");
        Assert.assertEquals(res[1], "BZ");
    }

    @Test
    public void testRegionAndUserPart() {
        LocaleId locId = new LocaleId("ja-jp-x-calja", true);
        Assert.assertEquals("ja", locId.getLanguage());
        Assert.assertEquals("jp", locId.getRegion());
        Assert.assertEquals("calja", locId.getUserPart());
        locId = new LocaleId("ar-Latn-EG", true);
        Assert.assertEquals("eg", locId.getRegion());
        Assert.assertEquals(null, locId.getUserPart());
        locId = new LocaleId("zh-Hant-TW", true);
        Assert.assertEquals("tw", locId.getRegion());
        Assert.assertEquals(null, locId.getUserPart());
        locId = new LocaleId("zh-Latn-TW-pinyin", true);
        Assert.assertEquals("tw", locId.getRegion());
        Assert.assertEquals(null, locId.getUserPart());
        locId = new LocaleId("de-CH-1996", true);
        Assert.assertEquals("ch", locId.getRegion());
        Assert.assertEquals(null, locId.getUserPart());
        locId = new LocaleId("ja-Latn-hepburn", true);
        Assert.assertEquals(null, locId.getRegion());
        Assert.assertEquals(null, locId.getUserPart());
    }

    @Test
    public void testIsBidirectional() {
        Assert.assertTrue(LocaleId.isBidirectional(LocaleId.fromBCP47("ar")));
        Assert.assertTrue(LocaleId.isBidirectional(LocaleId.fromBCP47("he")));
        Assert.assertTrue(LocaleId.isBidirectional(LocaleId.fromBCP47("ar-SA")));
        Assert.assertTrue(LocaleId.isBidirectional(LocaleId.fromBCP47("ur-pk")));
        Assert.assertTrue(LocaleId.isBidirectional(LocaleId.fromBCP47("syc")));
        Assert.assertTrue(LocaleId.isBidirectional(LocaleId.fromBCP47("dv")));
        Assert.assertTrue(LocaleId.isBidirectional(LocaleId.fromPOSIXLocale("ar_EG")));
        Assert.assertFalse(LocaleId.isBidirectional(LocaleId.fromBCP47("en-ar")));
        Assert.assertFalse(LocaleId.isBidirectional(LocaleId.fromBCP47("arn")));
        Assert.assertFalse(LocaleId.isBidirectional(LocaleId.fromBCP47("tr")));
    }

    @Test
    public void testVariablesWithString() {
        String srcLoc = new LocaleId("de", "CH").toString();
        String trgLoc = new LocaleId("en", "IE").toString();
        Assert.assertEquals("", LocaleId.replaceVariables("", srcLoc, trgLoc));
        Assert.assertEquals("de-ch,en-ie", LocaleId.replaceVariables("${srcLang},${trgLang}", srcLoc, trgLoc));
        Assert.assertEquals("DE-CH,EN-IE", LocaleId.replaceVariables("${srcLangU},${trgLangU}", srcLoc, trgLoc));
        Assert.assertEquals("de-ch,en-ie", LocaleId.replaceVariables("${srcLangL},${trgLangL}", srcLoc, trgLoc));
        Assert.assertEquals("de_CH,en_IE", LocaleId.replaceVariables("${srcLoc},${trgLoc}", srcLoc, trgLoc));
        Assert.assertEquals("de,en", LocaleId.replaceVariables("${srcLocLang},${trgLocLang}", srcLoc, trgLoc));
        Assert.assertEquals("CH,IE", LocaleId.replaceVariables("${srcLocReg},${trgLocReg}", srcLoc, trgLoc));
        Assert.assertEquals("CH,", LocaleId.replaceVariables("${srcLocReg},${trgLocReg}", srcLoc, null));
        Assert.assertEquals(",en-ie", LocaleId.replaceVariables("${srcLang},${trgLang}", null, trgLoc));
    }

    @Test
    public void testVariablesWithLocaleId() {
        LocaleId srcLoc = new LocaleId("de", "CH");
        LocaleId trgLoc = new LocaleId("en", "IE");
        Assert.assertEquals("", LocaleId.replaceVariables("", srcLoc, trgLoc));
        Assert.assertEquals("de-ch,en-ie", LocaleId.replaceVariables("${srcLang},${trgLang}", srcLoc, trgLoc));
        Assert.assertEquals("DE-CH,EN-IE", LocaleId.replaceVariables("${srcLangU},${trgLangU}", srcLoc, trgLoc));
        Assert.assertEquals("de-ch,en-ie", LocaleId.replaceVariables("${srcLangL},${trgLangL}", srcLoc, trgLoc));
        Assert.assertEquals("de_CH,en_IE", LocaleId.replaceVariables("${srcLoc},${trgLoc}", srcLoc, trgLoc));
        Assert.assertEquals("de,en", LocaleId.replaceVariables("${srcLocLang},${trgLocLang}", srcLoc, trgLoc));
        Assert.assertEquals("CH,IE", LocaleId.replaceVariables("${srcLocReg},${trgLocReg}", srcLoc, trgLoc));
        Assert.assertEquals("CH,", LocaleId.replaceVariables("${srcLocReg},${trgLocReg}", srcLoc, null));
        Assert.assertEquals(",en-ie", LocaleId.replaceVariables("${srcLang},${trgLang}", null, trgLoc));
    }
}

