/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.annotation;

import java.util.Collections;
import java.util.LinkedList;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.resource.TextFragment;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AltTranslationTest {
    private TextFragment source1;
    private TextFragment source2;
    private TextFragment source3;
    private TextFragment target1;
    private TextFragment target2;
    private TextFragment target3;
    private AltTranslation at1;
    private AltTranslation at2;
    private AltTranslation at3;
    private AltTranslation at4;
    private AltTranslation at5;
    private AltTranslation at6;

    @Before
    public void setUp() throws Exception {
        this.source1 = new TextFragment("source one");
        this.source2 = new TextFragment("source two");
        this.source3 = new TextFragment("source three");
        this.target1 = new TextFragment("target one");
        this.target2 = new TextFragment("target two");
        this.target3 = new TextFragment("target three");
        this.at1 = new AltTranslation(LocaleId.ENGLISH, LocaleId.SPANISH, null, this.source1, this.target1, MatchType.MT, 60, "");
        this.at2 = new AltTranslation(LocaleId.ENGLISH, LocaleId.SPANISH, null, this.source2, this.target2, MatchType.EXACT, 90, "");
        this.at3 = new AltTranslation(LocaleId.ENGLISH, LocaleId.SPANISH, null, this.source3, this.target3, MatchType.EXACT_PREVIOUS_VERSION, 100, "");
        this.at4 = new AltTranslation(LocaleId.ENGLISH, LocaleId.SPANISH, null, this.source1, this.target1, MatchType.FUZZY, 60, "");
        this.at5 = new AltTranslation(LocaleId.ENGLISH, LocaleId.SPANISH, null, this.source2, this.target2, MatchType.EXACT_TEXT_ONLY, 95, "");
        this.at6 = new AltTranslation(LocaleId.ENGLISH, LocaleId.SPANISH, null, this.source3, this.target3, MatchType.FUZZY_UNIQUE_ID, 99, "");
    }

    @Test
    public void altTranslationSortedList() {
        LinkedList<AltTranslation> ats = new LinkedList<AltTranslation>();
        ats.add(this.at1);
        ats.add(this.at2);
        ats.add(this.at3);
        Collections.sort(ats);
        junit.framework.Assert.assertEquals(this.at3, ats.get(0));
        junit.framework.Assert.assertEquals(this.at2, ats.get(1));
        junit.framework.Assert.assertEquals(this.at1, ats.get(2));
    }

    @Test
    public void altTranslationFuzzySortedList() {
        LinkedList<AltTranslation> ats = new LinkedList<AltTranslation>();
        ats.add(this.at4);
        ats.add(this.at5);
        ats.add(this.at6);
        Collections.sort(ats);
        junit.framework.Assert.assertEquals(this.at5, ats.get(0));
        junit.framework.Assert.assertEquals(this.at6, ats.get(1));
        junit.framework.Assert.assertEquals(this.at4, ats.get(2));
    }

    @Test
    public void instanceEquality() {
        AltTranslation h1;
        AltTranslation h2 = h1 = new AltTranslation(LocaleId.ENGLISH, LocaleId.SPANISH, null, this.source2, this.target2, MatchType.EXACT, 90, "");
        Assert.assertTrue("instance equality", h1.equals(h2));
    }

    @Test
    public void equals() {
        AltTranslation h1 = new AltTranslation(LocaleId.ENGLISH, LocaleId.SPANISH, null, this.source2, this.target2, MatchType.EXACT, 90, "");
        Assert.assertTrue("equals", h1.equals(this.at2));
    }

    @Test
    public void notEquals() {
        Assert.assertFalse("not equals", this.at1.equals(this.at2));
    }

    @Test
    public void compareToEquals() {
        AltTranslation h1 = new AltTranslation(LocaleId.ENGLISH, LocaleId.SPANISH, null, this.source2, this.target2, MatchType.EXACT, 90, "");
        Assert.assertEquals(0L, h1.compareTo(this.at2));
    }

    @Test
    public void compareToGreaterThanScore() {
        AltTranslation h1 = new AltTranslation(LocaleId.ENGLISH, LocaleId.SPANISH, null, this.source2, this.target2, MatchType.FUZZY, 90, "");
        AltTranslation h2 = new AltTranslation(LocaleId.ENGLISH, LocaleId.SPANISH, null, this.source2, this.target2, MatchType.FUZZY, 50, "");
        Assert.assertTrue(h1.compareTo(h2) < 0);
    }

    @Test
    public void compareToLessThanScore() {
        AltTranslation h2 = new AltTranslation(LocaleId.ENGLISH, LocaleId.SPANISH, null, this.source2, this.target2, MatchType.FUZZY, 50, "");
        AltTranslation h1 = new AltTranslation(LocaleId.ENGLISH, LocaleId.SPANISH, null, this.source2, this.target2, MatchType.FUZZY, 90, "");
        Assert.assertTrue(h2.compareTo(h1) > 0);
    }

    @Test
    public void compareToLessThanMatchType() {
        AltTranslation h1 = new AltTranslation(LocaleId.ENGLISH, LocaleId.SPANISH, null, this.source2, this.target2, MatchType.EXACT, 90, "");
        AltTranslation h2 = new AltTranslation(LocaleId.ENGLISH, LocaleId.SPANISH, null, this.source2, this.target2, MatchType.MT, 90, "");
        Assert.assertTrue(h1.compareTo(h2) < 0);
    }

    @Test
    public void compareToGreaterThanMatchType() {
        AltTranslation h2 = new AltTranslation(LocaleId.ENGLISH, LocaleId.SPANISH, null, this.source2, this.target2, MatchType.MT, 90, "");
        AltTranslation h1 = new AltTranslation(LocaleId.ENGLISH, LocaleId.SPANISH, null, this.source2, this.target2, MatchType.EXACT, 90, "");
        Assert.assertTrue(h2.compareTo(h1) > 0);
    }

    @Test
    public void compareToLessThanSource() {
        AltTranslation h1 = new AltTranslation(LocaleId.ENGLISH, LocaleId.SPANISH, null, new TextFragment("A"), this.target2, MatchType.EXACT, 90, "");
        AltTranslation h2 = new AltTranslation(LocaleId.ENGLISH, LocaleId.SPANISH, null, new TextFragment("B"), this.target2, MatchType.MT, 90, "");
        Assert.assertTrue(h1.compareTo(h2) < 0);
    }

    @Test
    public void compareToGreaterThanSource() {
        AltTranslation h2 = new AltTranslation(LocaleId.ENGLISH, LocaleId.SPANISH, null, new TextFragment("B"), this.target2, MatchType.MT, 90, "");
        AltTranslation h1 = new AltTranslation(LocaleId.ENGLISH, LocaleId.SPANISH, null, new TextFragment("A"), this.target2, MatchType.EXACT, 90, "");
        Assert.assertTrue(h2.compareTo(h1) > 0);
    }

    @Test
    public void testHasSeveralBestMatches() {
        AltTranslation at1 = new AltTranslation(LocaleId.ENGLISH, LocaleId.SPANISH, null, this.source1, this.target1, MatchType.EXACT, 100, "");
        AltTranslation at2 = new AltTranslation(LocaleId.ENGLISH, LocaleId.SPANISH, null, this.source1, this.target1, MatchType.EXACT, 100, "");
        AltTranslationsAnnotation atAnn = new AltTranslationsAnnotation();
        atAnn.add(at1);
        atAnn.add(at2);
        Assert.assertFalse(atAnn.hasSeveralBestMatches(true));
        AltTranslation at3 = new AltTranslation(LocaleId.ENGLISH, LocaleId.SPANISH, null, this.source1, this.target2, MatchType.EXACT, 100, "");
        atAnn.add(at3);
        Assert.assertTrue(atAnn.hasSeveralBestMatches(true));
    }
}

