/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.annotation;

import java.security.InvalidParameterException;
import java.util.List;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.IssueType;
import net.sf.okapi.common.resource.Code;

public class IssueAnnotation
extends GenericAnnotation {
    public static final int SEVERITY_LOW = 0;
    public static final int SEVERITY_MEDIUM = 1;
    public static final int SEVERITY_HIGH = 2;
    private static final String CODES_SEP = "\u2628";
    private IssueType issueType;

    public IssueAnnotation(IssueType issueType, String comment, int severity, String segId, int srcStart, int srcEnd, int trgStart, int trgEnd, List<Code> codes) {
        super("its-lqi");
        this.setBoolean("lqiEnabled", true);
        this.setIssueType(issueType);
        this.setString("lqiComment", comment);
        this.setSeverity(severity);
        this.setSourcePosition(srcStart, srcEnd);
        this.setTargetPosition(trgStart, trgEnd);
        this.setString("lqiXSegId", segId);
        this.setCodes(codes);
    }

    public IssueType getIssueType() {
        return this.issueType;
    }

    public void setIssueType(IssueType issueType) {
        this.issueType = issueType;
        this.setString("lqiXType", issueType.toString());
        this.setString("lqiType", IssueType.getITSType(issueType));
    }

    public String getITSType() {
        return this.getString("lqiType");
    }

    public void setITSType(String itsType) {
        this.setString("lqiType", itsType);
    }

    public String getSegId() {
        return this.getString("lqiXSegId");
    }

    public int getSourceStart() {
        return this.getInteger("lqiXStart");
    }

    public int getSourceEnd() {
        return this.getInteger("lqiXEnd");
    }

    public void setSourcePosition(int start, int end) {
        this.setInteger("lqiXStart", start);
        this.setInteger("lqiXEnd", end);
    }

    public int getTargetStart() {
        return this.getInteger("lqiXTrgStart");
    }

    public int getTargetEnd() {
        return this.getInteger("lqiXTrgEnd");
    }

    public void setTargetPosition(int start, int end) {
        this.setInteger("lqiXTrgStart", start);
        this.setInteger("lqiXTrgEnd", end);
    }

    public boolean getEnabled() {
        return this.getBoolean("lqiEnabled");
    }

    public void setEnabled(boolean enabled) {
        this.setBoolean("lqiEnabled", enabled);
    }

    public double getSeverity() {
        return this.getDouble("lqiSeverity");
    }

    public void setSeverity(double severity) {
        if (severity < 0.0 || severity > 2.0) {
            throw new InvalidParameterException("Invalid severity value.");
        }
        this.setDouble("lqiSeverity", severity);
    }

    public String getComment() {
        return this.getString("lqiComment");
    }

    public void setComment(String comment) {
        this.setString("lqiComment", comment);
    }

    public String getCodes() {
        return this.getString("lqiXCodes");
    }

    public String[] getCodesAsArray() {
        String tmp = this.getString("lqiXCodes");
        if (tmp == null) {
            return null;
        }
        return tmp.split(CODES_SEP, 0);
    }

    public void setCodes(List<Code> codes) {
        if (Util.isEmpty(codes)) {
            this.setString("lqiXCodes", null);
        } else {
            StringBuilder values = new StringBuilder();
            for (Code code : codes) {
                values.append(CODES_SEP);
                values.append(code.getData());
            }
            this.setString("lqiXCodes", values.toString().substring(1));
        }
    }

    @Override
    public String toString() {
        this.setString("lqiXIssueType", this.issueType.toString());
        return super.toString();
    }

    @Override
    public void fromString(String storage) {
        super.fromString(storage);
        this.issueType = IssueType.valueOf(this.getString("lqiXIssueType"));
        this.setString("lqiXIssueType", null);
    }
}

