/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filters;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.InputDocument;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.EndSubfilter;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.INameable;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.StartSubfilter;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import org.junit.Assert;

public class FilterTestDriver {
    private boolean showSkeleton = true;
    private int displayLevel = 0;
    private boolean ok;

    public static boolean laxCompareEvent(Event manual, Event generated) {
        if (generated.getEventType() != manual.getEventType()) {
            return false;
        }
        IResource mr = manual.getResource();
        IResource gr = generated.getResource();
        if (mr != null && gr != null && mr.getSkeleton() != null && gr.getSkeleton() != null && !((Object)mr.getSkeleton()).toString().equals(((Object)gr.getSkeleton()).toString())) {
            return false;
        }
        switch (generated.getEventType()) {
            case DOCUMENT_PART: {
                Property mdpProp;
                Property gdpProp;
                DocumentPart mdp = (DocumentPart)mr;
                DocumentPart gdp = (DocumentPart)gr;
                if (mdp.isReferent() != gdp.isReferent()) {
                    return false;
                }
                if (mdp.isTranslatable() != gdp.isTranslatable()) {
                    return false;
                }
                if (!((Object)mdp.getPropertyNames()).equals(gdp.getPropertyNames())) {
                    return false;
                }
                for (String propName : gdp.getPropertyNames()) {
                    gdpProp = gdp.getProperty(propName);
                    mdpProp = mdp.getProperty(propName);
                    if (gdpProp.isReadOnly() != mdpProp.isReadOnly()) {
                        return false;
                    }
                    if (gdpProp.getValue().equals(mdpProp.getValue())) continue;
                    return false;
                }
                if (!((Object)mdp.getSourcePropertyNames()).equals(gdp.getSourcePropertyNames())) {
                    return false;
                }
                for (String propName : gdp.getSourcePropertyNames()) {
                    gdpProp = gdp.getSourceProperty(propName);
                    mdpProp = mdp.getSourceProperty(propName);
                    if (gdpProp.isReadOnly() != mdpProp.isReadOnly()) {
                        return false;
                    }
                    if (gdpProp.getValue().equals(mdpProp.getValue())) continue;
                    return false;
                }
                break;
            }
            case TEXT_UNIT: {
                Property mtuProp;
                Property gtuProp;
                ITextUnit mtu = (ITextUnit)mr;
                ITextUnit gtu = (ITextUnit)gr;
                if (!((Object)mtu.getPropertyNames()).equals(gtu.getPropertyNames())) {
                    return false;
                }
                for (String propName : gtu.getPropertyNames()) {
                    gtuProp = gtu.getProperty(propName);
                    mtuProp = mtu.getProperty(propName);
                    if (gtuProp.isReadOnly() != mtuProp.isReadOnly()) {
                        return false;
                    }
                    if (gtuProp.getValue().equals(mtuProp.getValue())) continue;
                    return false;
                }
                if (!((Object)mtu.getSourcePropertyNames()).equals(gtu.getSourcePropertyNames())) {
                    return false;
                }
                for (String propName : gtu.getSourcePropertyNames()) {
                    gtuProp = gtu.getSourceProperty(propName);
                    mtuProp = mtu.getSourceProperty(propName);
                    if (gtuProp.isReadOnly() != mtuProp.isReadOnly()) {
                        return false;
                    }
                    if (gtuProp.getValue().equals(mtuProp.getValue())) continue;
                    return false;
                }
                String tmp = mtu.getName();
                if (tmp == null ? gtu.getName() != null : !tmp.equals(gtu.getName())) {
                    return false;
                }
                tmp = mtu.getType();
                if (tmp == null ? gtu.getType() != null : !tmp.equals(gtu.getType())) {
                    return false;
                }
                if (mtu.isTranslatable() != gtu.isTranslatable()) {
                    return false;
                }
                if (mtu.isReferent() != gtu.isReferent()) {
                    return false;
                }
                if (mtu.preserveWhitespaces() != gtu.preserveWhitespaces()) {
                    return false;
                }
                if (!mtu.toString().equals(gtu.toString())) {
                    return false;
                }
                if (mtu.getSource().getUnSegmentedContentCopy().getCodes().size() != gtu.getSource().getUnSegmentedContentCopy().getCodes().size()) {
                    return false;
                }
                int i = -1;
                for (Code c : mtu.getSource().getUnSegmentedContentCopy().getCodes()) {
                    if (c.getType() == null || c.getType().equals(gtu.getSource().getUnSegmentedContentCopy().getCode(++i).getType())) continue;
                    return false;
                }
                break;
            }
        }
        return true;
    }

    public static boolean laxCompareEvents(List<Event> manual, List<Event> generated) {
        if (manual.size() != generated.size()) {
            return false;
        }
        Iterator<Event> manualIt = manual.iterator();
        for (Event ge : generated) {
            Event me = manualIt.next();
            if (FilterTestDriver.laxCompareEvent(me, ge)) continue;
            return false;
        }
        return true;
    }

    public static void checkCodeData(TextFragment tf1, TextFragment tf2) {
        List<Code> srcCodes = tf1.getCodes();
        List<Code> trgCodes = tf2.getCodes();
        for (Code srcCode : srcCodes) {
            for (Code trgCode : trgCodes) {
                if (srcCode.getId() != trgCode.getId()) continue;
                switch (srcCode.getTagType()) {
                    case OPENING: {
                        if (trgCode.getTagType() == TextFragment.TagType.CLOSING) break;
                        Assert.assertEquals(srcCode.getData(), trgCode.getData());
                        break;
                    }
                    case CLOSING: {
                        if (trgCode.getTagType() == TextFragment.TagType.OPENING) break;
                        Assert.assertEquals(srcCode.getData(), trgCode.getData());
                        break;
                    }
                    default: {
                        Assert.assertEquals(srcCode.getData(), trgCode.getData());
                    }
                }
            }
        }
    }

    public static boolean compareEvent(Event manual, Event generated, boolean includeSkeleton) {
        if (generated.getEventType() != manual.getEventType()) {
            System.err.println("Event type difference: " + generated.getEventType().toString() + " and " + manual.getEventType().toString());
            return false;
        }
        switch (generated.getEventType()) {
            case DOCUMENT_PART: {
                DocumentPart mdp = (DocumentPart)manual.getResource();
                DocumentPart gdp = (DocumentPart)generated.getResource();
                if (!FilterTestDriver.compareIResource(mdp, gdp, includeSkeleton)) {
                    return false;
                }
                if (!FilterTestDriver.compareINameable(mdp, gdp)) {
                    return false;
                }
                if (mdp.isReferent() == gdp.isReferent()) break;
                return false;
            }
            case START_GROUP: {
                StartGroup sg1 = (StartGroup)manual.getResource();
                StartGroup sg2 = (StartGroup)generated.getResource();
                if (!FilterTestDriver.compareIResource(sg1, sg2, includeSkeleton)) {
                    return false;
                }
                if (!FilterTestDriver.compareINameable(sg1, sg2)) {
                    return false;
                }
                if (sg1.isReferent() == sg2.isReferent()) break;
                return false;
            }
            case END_GROUP: {
                if (FilterTestDriver.compareIResource(manual.getResource(), generated.getResource(), includeSkeleton)) break;
                return false;
            }
            case START_SUBFILTER: {
                StartSubfilter ssf1 = (StartSubfilter)manual.getResource();
                StartSubfilter ssf2 = (StartSubfilter)generated.getResource();
                if (!FilterTestDriver.compareIResource(ssf1, ssf2, includeSkeleton)) {
                    return false;
                }
                if (!FilterTestDriver.compareINameable(ssf1, ssf2)) {
                    return false;
                }
                if (ssf1.isReferent() == ssf2.isReferent()) break;
                return false;
            }
            case END_SUBFILTER: {
                EndSubfilter esf1 = (EndSubfilter)manual.getResource();
                EndSubfilter esf2 = (EndSubfilter)generated.getResource();
                if (FilterTestDriver.compareIResource(esf1, esf2, includeSkeleton)) break;
                return false;
            }
            case TEXT_UNIT: {
                ITextUnit tu = manual.getTextUnit();
                if (FilterTestDriver.compareTextUnit(tu, generated.getTextUnit())) break;
                System.err.println("Text unit difference, tu id=" + tu.getId());
                return false;
            }
        }
        return true;
    }

    public static boolean compareEvents(List<Event> list1, List<Event> list2) {
        return FilterTestDriver.compareEvents(list1, list2, true);
    }

    public static boolean compareEvents(List<Event> list1, List<Event> list2, boolean includeSkeleton) {
        for (int i = 0; i < list1.size(); ++i) {
            Event event1 = list1.get(i);
            if (i >= list2.size()) {
                System.err.println("Less events in second list");
                return false;
            }
            Event event2 = list2.get(i);
            if (FilterTestDriver.compareEvent(event1, event2, includeSkeleton)) continue;
            return false;
        }
        if (list1.size() != list2.size()) {
            System.err.println("Less events in first list");
            return false;
        }
        return true;
    }

    public static boolean compareEvents(List<Event> list1, List<Event> list2, List<Event> subDocEvents, boolean includeSkeleton) {
        for (int i = 0; i < list1.size(); ++i) {
            StartSubDocument ssd;
            Event event1 = list1.get(i);
            if (i >= list2.size()) {
                System.err.println("Less events in second list");
                return false;
            }
            Event event2 = list2.get(i);
            if (FilterTestDriver.compareEvent(event1, event2, includeSkeleton)) continue;
            Event subDocEvent = subDocEvents.get(i);
            if (subDocEvent != null && (ssd = (StartSubDocument)subDocEvent.getResource()) != null) {
                System.err.println("Sub-document: " + ssd.getName());
            }
            return false;
        }
        if (list1.size() != list2.size()) {
            System.err.println("Less events in first list");
            return false;
        }
        return true;
    }

    public static boolean compareEventTypesOnly(List<Event> manual, List<Event> generated) {
        if (manual.size() != generated.size()) {
            return false;
        }
        Iterator<Event> manualIt = manual.iterator();
        for (Event ge : generated) {
            Event me = manualIt.next();
            if (ge.getEventType() == me.getEventType()) continue;
            return false;
        }
        return true;
    }

    public void setShowSkeleton(boolean value) {
        this.showSkeleton = value;
    }

    public void setDisplayLevel(int value) {
        this.displayLevel = value;
    }

    public boolean process(IFilter filter) {
        this.ok = true;
        int startDoc = 0;
        int endDoc = 0;
        int startGroup = 0;
        int endGroup = 0;
        int startSubDoc = 0;
        int endSubDoc = 0;
        int startSubfilter = 0;
        int endSubfilter = 0;
        while (filter.hasNext()) {
            Event event = filter.next();
            switch (event.getEventType()) {
                case START_DOCUMENT: {
                    ++startDoc;
                    this.checkStartDocument((StartDocument)event.getResource());
                    if (this.displayLevel < 2) break;
                    System.out.println("---Start Document");
                    this.printSkeleton(event.getResource());
                    break;
                }
                case END_DOCUMENT: {
                    ++endDoc;
                    if (this.displayLevel < 2) break;
                    System.out.println("---End Document");
                    this.printSkeleton(event.getResource());
                    break;
                }
                case START_SUBDOCUMENT: {
                    ++startSubDoc;
                    if (this.displayLevel < 2) break;
                    System.out.println("---Start Sub Document");
                    this.printSkeleton(event.getResource());
                    break;
                }
                case END_SUBDOCUMENT: {
                    ++endSubDoc;
                    if (this.displayLevel < 2) break;
                    System.out.println("---End Sub Document");
                    this.printSkeleton(event.getResource());
                    break;
                }
                case START_GROUP: {
                    ++startGroup;
                    if (this.displayLevel < 2) break;
                    System.out.println("---Start Group");
                    this.printSkeleton(event.getResource());
                    break;
                }
                case END_GROUP: {
                    ++endGroup;
                    if (this.displayLevel < 2) break;
                    System.out.println("---End Group");
                    this.printSkeleton(event.getResource());
                    break;
                }
                case TEXT_UNIT: {
                    ITextUnit tu = event.getTextUnit();
                    if (this.displayLevel < 1) break;
                    this.printTU(tu);
                    if (this.displayLevel < 2) break;
                    this.printResource(tu);
                    this.printSkeleton(tu);
                    break;
                }
                case DOCUMENT_PART: {
                    if (this.displayLevel < 2) break;
                    System.out.println("---Document Part");
                    this.printResource((INameable)event.getResource());
                    this.printSkeleton(event.getResource());
                    break;
                }
                case START_SUBFILTER: {
                    ++startSubfilter;
                    if (this.displayLevel < 2) break;
                    System.out.println("---Start Subfilter");
                    this.printSkeleton(event.getResource());
                    break;
                }
                case END_SUBFILTER: {
                    ++endSubfilter;
                    if (this.displayLevel < 2) break;
                    System.out.println("---End Subfilter");
                    this.printSkeleton(event.getResource());
                }
            }
        }
        if (startDoc != 1) {
            System.err.println(String.format("ERROR: START_DOCUMENT = %d", startDoc));
            this.ok = false;
        }
        if (endDoc != 1) {
            System.err.println(String.format("ERROR: END_DOCUMENT = %d", endDoc));
            this.ok = false;
        }
        if (startSubDoc != endSubDoc) {
            System.err.println(String.format("ERROR: START_SUBDOCUMENT=%d, END_SUBDOCUMENT=%d", startSubDoc, endSubDoc));
            this.ok = false;
        }
        if (startGroup != endGroup) {
            System.out.println(String.format("ERROR: START_GROUP=%d, END_GROUP=%d", startGroup, endGroup));
            this.ok = false;
        }
        return this.ok;
    }

    private void printTU(ITextUnit tu) {
        System.out.println("---Text Unit");
        System.out.println("S=[" + tu.toString() + "]");
        for (LocaleId lang : tu.getTargetLocales()) {
            System.out.println("T(" + lang + ")=[" + tu.getTarget(lang).toString() + "]");
        }
    }

    private void printResource(INameable res) {
        if (res == null) {
            System.out.println("NULL resource.");
            this.ok = false;
        }
        System.out.print("  id='" + res.getId() + "'");
        System.out.print(" name='" + res.getName() + "'");
        System.out.print(" type='" + res.getType() + "'");
        System.out.println(" mimeType='" + res.getMimeType() + "'");
    }

    private void printSkeleton(IResource res) {
        if (!this.showSkeleton) {
            return;
        }
        ISkeleton skel = res.getSkeleton();
        if (skel != null) {
            System.out.println("---");
            System.out.println(((Object)skel).toString());
            System.out.println("---");
        }
    }

    private void checkStartDocument(StartDocument startDoc) {
        if (this.displayLevel < 1) {
            return;
        }
        String tmp = startDoc.getEncoding();
        if (tmp == null || tmp.length() == 0) {
            System.err.println("WARNING: No encoding specified in StartDocument.");
        } else if (this.displayLevel > 1) {
            System.out.println("StartDocument encoding = " + tmp);
        }
        LocaleId locId = startDoc.getLocale();
        if (Util.isNullOrEmpty(locId)) {
            System.err.println("WARNING: No language specified in StartDocument.");
        } else if (this.displayLevel > 1) {
            System.out.println("StartDocument language = " + locId.toString());
        }
        tmp = startDoc.getName();
        if (tmp == null || tmp.length() == 0) {
            System.err.println("WARNING: No name specified in StartDocument.");
        } else if (this.displayLevel > 1) {
            System.out.println("StartDocument name = " + tmp);
        }
        if (this.displayLevel < 2) {
            return;
        }
        System.err.println("StartDocument MIME type = " + startDoc.getMimeType());
        System.err.println("StartDocument Type = " + startDoc.getType());
    }

    public static String generateOutput(List<Event> list, EncoderManager encoderManager, LocaleId trgLang) {
        GenericSkeletonWriter writer = new GenericSkeletonWriter();
        return FilterTestDriver.generateOutput(list, trgLang, writer, encoderManager, false);
    }

    public static String generateChangedOutput(List<Event> list, EncoderManager encoderManager, LocaleId trgLang) {
        GenericSkeletonWriter writer = new GenericSkeletonWriter();
        return FilterTestDriver.generateOutput(list, trgLang, writer, encoderManager, true);
    }

    public static String generateOutput(List<Event> list, LocaleId trgLang, ISkeletonWriter skelWriter, EncoderManager encoderManager) {
        return FilterTestDriver.generateOutput(list, trgLang, skelWriter, encoderManager, false);
    }

    public static String generateOutput(List<Event> list, LocaleId trgLang, ISkeletonWriter skelWriter, EncoderManager encoderManager, boolean changeTarget) {
        StringBuilder tmp = new StringBuilder();
        for (Event event : list) {
            switch (event.getEventType()) {
                case START_DOCUMENT: {
                    tmp.append(skelWriter.processStartDocument(trgLang, "UTF-8", null, encoderManager, (StartDocument)event.getResource()));
                    break;
                }
                case END_DOCUMENT: {
                    tmp.append(skelWriter.processEndDocument((Ending)event.getResource()));
                    break;
                }
                case START_SUBDOCUMENT: {
                    tmp.append(skelWriter.processStartSubDocument((StartSubDocument)event.getResource()));
                    break;
                }
                case END_SUBDOCUMENT: {
                    tmp.append(skelWriter.processEndSubDocument((Ending)event.getResource()));
                    break;
                }
                case TEXT_UNIT: {
                    ITextUnit tu = event.getTextUnit();
                    if (changeTarget) {
                        TextContainer tc = tu.createTarget(trgLang, false, 7);
                        TextFragment tf = tc.getFirstContent();
                        tf.setCodedText(tf.getCodedText().toUpperCase());
                    }
                    tmp.append(skelWriter.processTextUnit(tu));
                    break;
                }
                case DOCUMENT_PART: {
                    DocumentPart dp = (DocumentPart)event.getResource();
                    tmp.append(skelWriter.processDocumentPart(dp));
                    break;
                }
                case START_GROUP: {
                    StartGroup startGroup = (StartGroup)event.getResource();
                    tmp.append(skelWriter.processStartGroup(startGroup));
                    break;
                }
                case END_GROUP: {
                    tmp.append(skelWriter.processEndGroup((Ending)event.getResource()));
                    break;
                }
                case START_SUBFILTER: {
                    StartSubfilter startSubfilter = (StartSubfilter)event.getResource();
                    tmp.append(skelWriter.processStartSubfilter(startSubfilter));
                    break;
                }
                case END_SUBFILTER: {
                    tmp.append(skelWriter.processEndSubfilter((EndSubfilter)event.getResource()));
                }
            }
        }
        skelWriter.close();
        return tmp.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ITextUnit getTextUnit(IFilter filter, InputDocument doc, String defaultEncoding, LocaleId srcLang, LocaleId trgLang, int tuNumber) {
        try {
            if (doc.paramFile == null || doc.paramFile == "") {
                IParameters params = filter.getParameters();
                if (params != null) {
                    params.reset();
                }
            } else {
                String root = Util.getDirectoryName(doc.path);
                IParameters params = filter.getParameters();
                if (params != null) {
                    params.load(Util.toURI(root + "/" + doc.paramFile), false);
                }
            }
            int num = 0;
            filter.open(new RawDocument(new File(doc.path).toURI(), defaultEncoding, srcLang, trgLang));
            while (filter.hasNext()) {
                Event event = filter.next();
                switch (event.getEventType()) {
                    case TEXT_UNIT: {
                        if (++num != tuNumber) break;
                        ITextUnit iTextUnit = event.getTextUnit();
                        return iTextUnit;
                    }
                }
            }
        }
        finally {
            if (filter != null) {
                filter.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testStartDocument(IFilter filter, InputDocument doc, String defaultEncoding, LocaleId srcLang, LocaleId trgLang) {
        try {
            if (doc.paramFile == null || doc.paramFile == "") {
                IParameters params = filter.getParameters();
                if (params != null) {
                    params.reset();
                }
            } else {
                String root = Util.getDirectoryName(doc.path);
                IParameters params = filter.getParameters();
                if (params != null) {
                    params.load(Util.toURI(root + File.separator + doc.paramFile), false);
                }
            }
            filter.open(new RawDocument(new File(doc.path).toURI(), defaultEncoding, srcLang, trgLang));
            if (filter.hasNext()) {
                Event event = filter.next();
                Assert.assertTrue("First event is not a StartDocument event.", event.getEventType() == EventType.START_DOCUMENT);
                StartDocument sd = (StartDocument)event.getResource();
                Assert.assertNotNull("No StartDocument", sd);
                Assert.assertNotNull("Name is null", sd.getName());
                Assert.assertNotNull("Encoding is null", sd.getEncoding());
                Assert.assertNotNull("ID is null", sd.getId());
                Assert.assertNotNull("Language is null", sd.getLocale());
                Assert.assertNotNull("Linebreak is null", sd.getLineBreak());
                Assert.assertNotNull("FilterWriter is null", sd.getFilterWriter());
                Assert.assertNotNull("Mime type is null", sd.getMimeType());
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (filter != null) {
                filter.close();
            }
        }
        return false;
    }

    public static ITextUnit getTextUnit(List<Event> list, int tuNumber) {
        int n = 0;
        for (Event event : list) {
            if (event.getEventType() != EventType.TEXT_UNIT || ++n != tuNumber) continue;
            return event.getTextUnit();
        }
        return null;
    }

    public static StartGroup getGroup(List<Event> list, int groupNumber) {
        int n = 0;
        for (Event event : list) {
            if (event.getEventType() != EventType.START_GROUP || ++n != groupNumber) continue;
            return (StartGroup)event.getResource();
        }
        return null;
    }

    public static StartDocument getStartDocument(List<Event> list) {
        for (Event event : list) {
            if (event.getEventType() != EventType.START_DOCUMENT) continue;
            return (StartDocument)event.getResource();
        }
        return null;
    }

    public static StartSubDocument getStartSubDocument(List<Event> list, int subDocNumber) {
        int n = 0;
        for (Event event : list) {
            if (event.getEventType() != EventType.START_SUBDOCUMENT || ++n != subDocNumber) continue;
            return (StartSubDocument)event.getResource();
        }
        return null;
    }

    public static DocumentPart getDocumentPart(List<Event> list, int dpNumber) {
        int n = 0;
        for (Event event : list) {
            if (event.getEventType() != EventType.DOCUMENT_PART || ++n != dpNumber) continue;
            return (DocumentPart)event.getResource();
        }
        return null;
    }

    public static boolean compareTextUnit(ITextUnit tu1, ITextUnit tu2) {
        if (!FilterTestDriver.compareINameable(tu1, tu2)) {
            System.err.println("Difference in INameable");
            return false;
        }
        if (tu1.isReferent() != tu2.isReferent()) {
            System.err.println("isReferent difference");
            return false;
        }
        if (tu1.preserveWhitespaces() != tu2.preserveWhitespaces()) {
            System.err.println("preserveWhitespaces difference");
            return false;
        }
        if (!FilterTestDriver.compareTextContainer(tu1.getSource(), tu2.getSource())) {
            System.err.println("TextContainer difference");
            return false;
        }
        return true;
    }

    public static boolean compareIResource(IResource item1, IResource item2, boolean includeSkeleton) {
        if (item1 == null) {
            return item2 == null;
        }
        if (item2 == null) {
            return false;
        }
        String tmp1 = item1.getId();
        String tmp2 = item2.getId();
        if (tmp1 == null) {
            if (tmp2 != null) {
                return false;
            }
        } else {
            if (tmp2 == null) {
                return false;
            }
            if (!tmp1.equals(tmp2)) {
                return false;
            }
        }
        if (!includeSkeleton) {
            return true;
        }
        ISkeleton skl1 = item1.getSkeleton();
        ISkeleton skl2 = item2.getSkeleton();
        if (skl1 == null) {
            if (skl2 != null) {
                return false;
            }
        } else {
            if (skl2 == null) {
                return false;
            }
            tmp1 = ((Object)skl1).toString();
            tmp2 = ((Object)skl2).toString();
            if (tmp1 == null) {
                if (tmp2 != null) {
                    return false;
                }
            } else {
                if (tmp2 == null) {
                    return false;
                }
                if (!tmp1.equals(tmp2)) {
                    System.err.println("Skeleton differences: 1='" + tmp1 + "'\n2='" + tmp2 + "'");
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean compareINameable(INameable item1, INameable item2) {
        Property p2;
        Property p1;
        if (item1 == null) {
            return item2 == null;
        }
        if (item2 == null) {
            return false;
        }
        Set<String> names1 = item1.getPropertyNames();
        Set<String> names2 = item2.getPropertyNames();
        if (names1.size() != names2.size()) {
            System.err.println("Number of resource-level properties difference");
            return false;
        }
        for (String name : item1.getPropertyNames()) {
            p1 = item1.getProperty(name);
            if (FilterTestDriver.compareProperty(p1, p2 = item2.getProperty(name))) continue;
            return false;
        }
        names1 = item1.getSourcePropertyNames();
        names2 = item2.getSourcePropertyNames();
        if (names1.size() != names2.size()) {
            System.err.println("Number of source properties difference");
            return false;
        }
        for (String name : item1.getSourcePropertyNames()) {
            p1 = item1.getSourceProperty(name);
            if (FilterTestDriver.compareProperty(p1, p2 = item2.getSourceProperty(name))) continue;
            return false;
        }
        String tmp1 = item1.getName();
        String tmp2 = item2.getName();
        if (tmp1 == null) {
            if (tmp2 != null) {
                System.err.println("Name null difference");
                return false;
            }
        } else {
            if (tmp2 == null) {
                System.err.println("Name null difference");
                return false;
            }
            if (!tmp1.equals(tmp2)) {
                System.err.println("Name difference");
                return false;
            }
        }
        tmp1 = item1.getType();
        tmp2 = item2.getType();
        if (tmp1 == null) {
            if (tmp2 != null) {
                System.err.println("Type null difference");
                return false;
            }
        } else {
            if (tmp2 == null) {
                System.err.println("Type null difference");
                return false;
            }
            if (!tmp1.equals(tmp2)) {
                System.err.println("Type difference");
                return false;
            }
        }
        tmp1 = item1.getMimeType();
        tmp2 = item2.getMimeType();
        if (tmp1 == null) {
            if (tmp2 != null) {
                System.err.println("Mime-type null difference");
                return false;
            }
        } else {
            if (tmp2 == null) {
                System.err.println("Mime-type null difference");
                return false;
            }
            if (!tmp1.equals(tmp2)) {
                System.err.println("Mime-type difference");
                return false;
            }
        }
        if (item1.isTranslatable() != item2.isTranslatable()) {
            System.err.println("isTranslatable difference");
            return false;
        }
        return true;
    }

    public static boolean compareProperty(Property p1, Property p2) {
        if (p1 == null) {
            if (p2 != null) {
                System.err.println("Property name null difference");
                return false;
            }
            return true;
        }
        if (p2 == null) {
            System.err.println("Property name null difference");
            return false;
        }
        if (!p1.getName().equals(p2.getName())) {
            System.err.println("Property name difference");
            return false;
        }
        if (p1.isReadOnly() != p2.isReadOnly()) {
            System.err.println("Property isReadOnly difference");
            return false;
        }
        if (p1.getValue() == null) {
            if (p2.getValue() != null) {
                System.err.println("Property value null difference");
                return false;
            }
            return true;
        }
        if (!p1.getValue().equals(p2.getValue()) && !p1.getName().equals("start")) {
            System.err.println("Property value difference");
            return false;
        }
        return true;
    }

    public static boolean compareTextContainer(TextContainer t1, TextContainer t2) {
        if (t1 == null) {
            if (t2 != null) {
                System.err.println("Text container null difference");
                return false;
            }
            return true;
        }
        if (t2 == null) {
            System.err.println("Text container null difference");
            return false;
        }
        if (!FilterTestDriver.compareTextFragment(t1.getUnSegmentedContentCopy(), t2.getUnSegmentedContentCopy())) {
            System.err.println("Fragment difference");
            return false;
        }
        if (t1.hasBeenSegmented()) {
            if (!t2.hasBeenSegmented()) {
                System.err.println("isSegmented difference");
                return false;
            }
            ISegments t1Segments = t1.getSegments();
            ISegments t2Segments = t2.getSegments();
            if (t1Segments.count() != t2Segments.count()) {
                System.err.println("Number of segments difference");
                return false;
            }
            for (Segment seg1 : t1Segments) {
                Segment seg2 = t2Segments.get(seg1.id);
                if (seg2 == null) {
                    System.err.println("Segment in t2 not found.");
                    return false;
                }
                if (FilterTestDriver.compareTextFragment(seg1.text, seg2.text)) continue;
                System.err.println("Text fragment difference");
                return false;
            }
        } else if (t2.hasBeenSegmented()) {
            System.err.println("Segmentation difference");
            return false;
        }
        return true;
    }

    public static boolean compareTextFragment(TextFragment tf1, TextFragment tf2) {
        if (tf1 == null) {
            if (tf2 != null) {
                System.err.println("Fragment null difference");
                return false;
            }
            return true;
        }
        if (tf2 == null) {
            System.err.println("Fragment null difference");
            return false;
        }
        List<Code> codes1 = tf1.getCodes();
        List<Code> codes2 = tf2.getCodes();
        if (codes1.size() != codes2.size()) {
            System.err.println("Number of codes difference");
            System.err.println("original codes=" + codes1.toString());
            System.err.println("     new codes=" + codes2.toString());
            return false;
        }
        for (int i = 0; i < codes1.size(); ++i) {
            Code code1 = codes1.get(i);
            Code code2 = codes2.get(i);
            if (code1.getId() != code2.getId()) {
                System.err.println("ID difference");
                return false;
            }
            String tmp1 = code1.getData();
            String tmp2 = code2.getData();
            if (tmp1 == null) {
                if (tmp2 != null) {
                    System.err.println("Data null difference");
                    return false;
                }
            } else {
                if (tmp2 == null) {
                    System.err.println("Data null difference");
                    return false;
                }
                if (!tmp1.equals(tmp2)) {
                    System.err.println("Data difference: 1=[" + tmp1 + "] and 2=[" + tmp2 + "]");
                    return false;
                }
            }
            tmp1 = code1.getOuterData();
            tmp2 = code2.getOuterData();
            if (tmp1 == null) {
                if (tmp2 != null) {
                    System.err.println("Outer data null difference");
                    return false;
                }
            } else {
                if (tmp2 == null) {
                    System.err.println("Outer data null difference");
                    return false;
                }
                if (!tmp1.equals(tmp2)) {
                    System.err.println("Outer data difference");
                    return false;
                }
            }
            tmp1 = code1.getType();
            tmp2 = code2.getType();
            if (tmp1 == null) {
                if (tmp2 != null) {
                    System.err.println("Type null difference");
                    return false;
                }
            } else {
                if (tmp2 == null) {
                    System.err.println("Type null difference");
                    return false;
                }
                if (!tmp1.equals(tmp2)) {
                    System.err.println("Type difference");
                    return false;
                }
            }
            if (code1.getTagType() != code2.getTagType()) {
                System.err.println("Tag-type difference");
                return false;
            }
            if (code1.hasReference() != code2.hasReference()) {
                System.err.println("hasReference difference");
                return false;
            }
            if (code1.isCloneable() != code2.isCloneable()) {
                System.err.println("isCloenable difference");
                return false;
            }
            if (code1.isDeleteable() != code2.isDeleteable()) {
                System.err.println("isDeleteable difference");
                return false;
            }
            if (code1.hasAnnotation() == code2.hasAnnotation()) continue;
            System.err.println("annotation difference");
            return false;
        }
        if (!tf1.getCodedText().equals(tf2.getCodedText())) {
            System.err.println("Coded text difference:\n1=\"" + tf1.getCodedText() + "\"\n2=\"" + tf2.getCodedText() + "\"");
            return false;
        }
        return true;
    }
}

