/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filterwriter;

import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.annotation.IssueAnnotation;
import net.sf.okapi.common.resource.Code;

public class ITSContent {
    public static final String ITS_NS_URI = "http://www.w3.org/2005/11/its";
    public static final String STANDOFFMARKER = "$#@StandOff@#$";
    public static final String REF_PREFIX = "REF:";
    private CharsetEncoder encoder;
    private boolean isHTML5;
    private List<GenericAnnotations> standoff;
    private String prefix;

    public ITSContent(CharsetEncoder encoder, boolean isHTML5) {
        this.encoder = encoder;
        this.isHTML5 = isHTML5;
        this.prefix = isHTML5 ? "its-" : "its:";
    }

    public String writeStandoffLQI() {
        String res = this.writeStandoffLQI(this.getStandoff());
        this.clearStandoff();
        return res;
    }

    public String writeStandoffLQI(List<GenericAnnotations> annotations) {
        if (annotations == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (GenericAnnotations anns : annotations) {
            List<GenericAnnotation> list = anns.getAnnotations("its-lqi");
            if (list.isEmpty()) continue;
            if (this.isHTML5) {
                sb.append("<script id=\"" + anns.getData() + "\" type=\"application/its+xml\">\n");
                sb.append("<its:locQualityIssues xmlns:its=\"http://www.w3.org/2005/11/its\" version=\"2.0\" ");
            } else {
                sb.append("<its:locQualityIssues ");
            }
            sb.append("xml:id=\"" + anns.getData() + "\">\n");
            for (GenericAnnotation ann : list) {
                Double dblVal;
                Boolean booVal;
                sb.append("<its:locQualityIssue");
                String strVal = ann.getString("lqiComment");
                if (strVal != null) {
                    sb.append(" locQualityIssueComment=\"" + Util.escapeToXML(strVal, 3, false, this.encoder) + "\"");
                }
                if ((booVal = ann.getBoolean("lqiEnabled")) != null && !booVal.booleanValue()) {
                    sb.append(" locQualityIssueEnabled=\"no\"");
                }
                if ((strVal = ann.getString("lqiProfileRef")) != null) {
                    sb.append(" locQualityIssueProfileRef=\"" + Util.escapeToXML(strVal, 3, false, this.encoder) + "\"");
                }
                if ((dblVal = ann.getDouble("lqiSeverity")) != null) {
                    sb.append(" locQualityIssueSeverity=\"" + Util.formatDouble(dblVal) + "\"");
                }
                if ((strVal = ann.getString("lqiType")) != null) {
                    sb.append(" locQualityIssueType=\"" + strVal + "\"");
                }
                if (ann instanceof IssueAnnotation) {
                    IssueAnnotation iann = (IssueAnnotation)ann;
                    sb.append(" okp:lqiType=\"" + iann.getIssueType().toString() + "\"");
                    sb.append(String.format(" okp:lqiPos=\"%d %d %d %d\"", iann.getSourceStart(), iann.getSourceEnd(), iann.getTargetStart(), iann.getTargetEnd()));
                    strVal = iann.getCodes();
                    if (strVal != null) {
                        sb.append(" okp:lqiCodes=\"" + Util.escapeToXML(strVal, 3, false, this.encoder) + "\"");
                    }
                    if ((strVal = iann.getSegId()) != null) {
                        sb.append(" okp:lqiSegId=\"" + Util.escapeToXML(strVal, 3, false, this.encoder) + "\"");
                    }
                }
                sb.append("/>\n");
            }
            sb.append("</its:locQualityIssues>\n");
            if (!this.isHTML5) continue;
            sb.append("</script>\n");
        }
        return sb.toString();
    }

    public String writeStandoffProvenance(List<GenericAnnotations> annotations) {
        StringBuilder sb = new StringBuilder();
        for (GenericAnnotations anns : annotations) {
            List<GenericAnnotation> list = anns.getAnnotations("its-prov");
            if (list.isEmpty()) continue;
            if (this.isHTML5) {
                sb.append("<script id=\"" + anns.getData() + "\" type=\"application/its+xml\">");
            }
            sb.append("<its:provenanceRecords xmlns:its=\"http://www.w3.org/2005/11/its\" version=\"2.0\" ");
            sb.append("xml:id=\"" + anns.getData() + "\">");
            for (GenericAnnotation ann : list) {
                sb.append("<its:provenanceRecord");
                String strVal = ann.getString("provPerson");
                if (strVal != null) {
                    sb.append(this.outputRefOrValue(" person", strVal, false));
                }
                if ((strVal = ann.getString("provOrg")) != null) {
                    sb.append(this.outputRefOrValue(" org", strVal, false));
                }
                if ((strVal = ann.getString("provTool")) != null) {
                    sb.append(this.outputRefOrValue(" tool", strVal, false));
                }
                if ((strVal = ann.getString("provRevPerson")) != null) {
                    sb.append(this.outputRefOrValue(" revPerson", strVal, false));
                }
                if ((strVal = ann.getString("provRevOrg")) != null) {
                    sb.append(this.outputRefOrValue(" revOrg", strVal, false));
                }
                if ((strVal = ann.getString("provRevTool")) != null) {
                    sb.append(this.outputRefOrValue(" revTool", strVal, false));
                }
                if ((strVal = ann.getString("provRef")) != null) {
                    sb.append(" provRef=\"" + Util.escapeToXML(strVal, 3, false, this.encoder) + "\"");
                }
                sb.append("/>");
            }
            sb.append("</its:provenanceRecords>");
            if (!this.isHTML5) continue;
            sb.append("</script>");
        }
        return sb.toString();
    }

    private String outputRefOrValue(String partialName, String value, boolean useHTML5Notation) {
        if (value.startsWith(REF_PREFIX)) {
            value = value.substring(REF_PREFIX.length());
            partialName = partialName + (useHTML5Notation ? "-ref" : "Ref");
        }
        return partialName + "=\"" + Util.escapeToXML(value, 3, false, this.encoder) + "\"";
    }

    public void outputAnnotations(Code code, StringBuilder output) {
        this.outputAnnotations(code.getGenericAnnotations(), output, true);
    }

    public void outputAnnotations(GenericAnnotations anns, StringBuilder output, boolean inline) {
        GenericAnnotations newSet;
        String refId;
        Boolean booVal;
        GenericAnnotation ann2;
        if (anns == null) {
            return;
        }
        for (GenericAnnotation ann2 : anns) {
            if (ann2.getType().equals("its-disamb")) {
                this.printITSStringAttribute(ann2.getString("disambClass"), this.isHTML5 ? "disambig-class" : "disambigClass", output);
                this.printITSDoubleAttribute(ann2.getDouble("disambConfidence"), this.isHTML5 ? "disambig-confidence" : "disambigConfidence", output);
                String value = ann2.getString("disambGranularity");
                if (!value.equals("entity")) {
                    this.printITSStringAttribute(value, this.isHTML5 ? "disambig-granularity" : "disambigGranularity", output);
                }
                this.printITSStringAttribute(ann2.getString("disambIdent"), this.isHTML5 ? "disambig-ident" : "disambigIdent", output);
                this.printITSStringAttribute(ann2.getString("disambSource"), this.isHTML5 ? "disambig-source" : "disambigSource", output);
                continue;
            }
            if (ann2.getType().equals("its-term")) {
                this.printITSBooleanAttribute(true, "term", output);
                this.printITSDoubleAttribute(ann2.getDouble("termConfidence"), this.isHTML5 ? "term-confidence" : "termConfidence", output);
                this.printITSStringAttribute(ann2.getString("termInfo"), this.isHTML5 ? "term-info" : "termInfo", output);
                continue;
            }
            if (ann2.getType().equals("its-allowedchars")) {
                this.printITSStringAttribute(ann2.getString("allowedcharsValue"), this.isHTML5 ? "allowed-characters" : "allowedCharacters", output);
                continue;
            }
            if (ann2.getType().equals("its-storagesize")) {
                this.printITSIntegerAttribute(ann2.getInteger("storagesizeSize"), this.isHTML5 ? "storage-size" : "storageSize", output);
                String tmp = ann2.getString("storagesizeEncoding");
                if (!tmp.equals("UTF-8")) {
                    this.printITSStringAttribute(tmp, this.isHTML5 ? "storage-encoding" : "storageEncoding", output);
                }
                if ((tmp = ann2.getString("storagesizeLinebreak")).equals("lf")) continue;
                this.printITSStringAttribute(tmp, this.isHTML5 ? "storage-linebreak" : "storageLinebreak", output);
                continue;
            }
            if (ann2.getType().equals("its-ln")) {
                if (inline && !this.isHTML5) {
                    output.append(" comment=\"" + Util.escapeToXML(ann2.getString("lnValue"), 3, false, this.encoder) + "\"");
                    this.printITSExtStringAttribute(ann2.getString("lnType"), "itsLocNoteType", output);
                    continue;
                }
                this.printITSStringAttribute(ann2.getString("lnValue"), this.isHTML5 ? "loc-note" : "locNote", output);
                this.printITSIntegerAttribute(ann2.getInteger("its-ln"), this.isHTML5 ? "loc-note" : "locNote", output);
                continue;
            }
            if (ann2.getType().equals("its-domain")) {
                this.printITSExtStringAttribute(ann2.getString("domainValue"), "itsDomain", output);
                continue;
            }
            if (ann2.getType().equals("its-externalres")) {
                this.printITSExtStringAttribute(ann2.getString("its-externalresValue"), "itsExternalResourceRef", output);
                continue;
            }
            if (!ann2.getType().equals("its-lqi") && !ann2.getType().equals("its-prov")) continue;
        }
        List<GenericAnnotation> list = anns.getAnnotations("its-lqi");
        if (list.size() == 1) {
            ann2 = list.get(0);
            this.printITSStringAttribute(ann2.getString("lqiComment"), this.isHTML5 ? "loc-quality-issue-comment" : "locQualityIssueComment", output);
            booVal = ann2.getBoolean("lqiEnabled");
            if (booVal != null && !booVal.booleanValue()) {
                this.printITSBooleanAttribute(booVal, this.isHTML5 ? "loc-quality-issue-enabled" : "locQualityIssueEnabled", output);
            }
            this.printITSStringAttribute(ann2.getString("lqiProfileRef"), this.isHTML5 ? "loc-quality-issue-profile" : "locQualityIssueProfile", output);
            this.printITSDoubleAttribute(ann2.getDouble("lqiSeverity"), this.isHTML5 ? "loc-quality-issue-severity" : "locQualityIssueSeverity", output);
            this.printITSStringAttribute(ann2.getString("lqiType"), this.isHTML5 ? "loc-quality-issue-type" : "locQualityIssueType", output);
        } else if (list.size() > 1) {
            refId = anns.getData();
            if (refId == null) {
                anns.setData(Util.makeId(UUID.randomUUID().toString()));
                refId = anns.getData();
            }
            if (this.isHTML5) {
                output.append(" its-loc-quality-issues-ref=\"#" + refId + "\"");
            } else {
                output.append(" its:locQualityIssuesRef=\"#" + refId + "\"");
            }
            newSet = new GenericAnnotations();
            newSet.setData(refId);
            newSet.addAll(list);
            if (this.standoff == null) {
                this.standoff = new ArrayList<GenericAnnotations>();
            }
            this.standoff.add(newSet);
        }
        list = anns.getAnnotations("its-prov");
        if (list.size() == 1) {
            ann2 = list.get(0);
            this.printITSStringAttribute(ann2.getString("lqiComment"), this.isHTML5 ? "loc-quality-issue-comment" : "locQualityIssueComment", output);
            booVal = ann2.getBoolean("lqiEnabled");
            if (booVal != null && !booVal.booleanValue()) {
                this.printITSBooleanAttribute(booVal, "locQualityIssueEnabled", output);
            }
            this.printITSStringAttribute(ann2.getString("lqiProfileRef"), this.isHTML5 ? "loc-quality-issue-profile" : "locQualityIssueProfile", output);
            this.printITSDoubleAttribute(ann2.getDouble("lqiSeverity"), this.isHTML5 ? "loc-quality-issue-severity" : "locQualityIssueSeverity", output);
            this.printITSStringAttribute(ann2.getString("lqiType"), this.isHTML5 ? "loc-quality-issue-type" : "locQualityIssueType", output);
        } else if (list.size() > 0) {
            refId = anns.getData();
            if (refId == null) {
                anns.setData(Util.makeId(UUID.randomUUID().toString()));
                refId = anns.getData();
            }
            if (this.isHTML5) {
                output.append(" its-provenance-records-ref=\"#" + refId + "\"");
            } else {
                output.append(" its:provenanceRecordsRef=\"#" + refId + "\"");
            }
            newSet = new GenericAnnotations();
            newSet.setData(refId);
            newSet.addAll(list);
            if (this.standoff == null) {
                this.standoff = new ArrayList<GenericAnnotations>();
            }
            this.standoff.add(newSet);
        }
    }

    public List<GenericAnnotations> getStandoff() {
        return this.standoff;
    }

    public boolean hasStandoff() {
        return !Util.isEmpty(this.standoff);
    }

    public void clearStandoff() {
        this.standoff = null;
    }

    private void printITSStringAttribute(String value, String attrName, StringBuilder output) {
        if (value != null) {
            String ref = "";
            if (value.startsWith(REF_PREFIX)) {
                ref = this.isHTML5 ? "-ref" : "Ref";
                value = value.substring(REF_PREFIX.length());
            }
            output.append(" " + this.prefix + attrName + ref + "=\"" + Util.escapeToXML(value, 3, false, this.encoder) + "\"");
        }
    }

    private void printITSExtStringAttribute(String value, String attrName, StringBuilder output) {
        if (value != null) {
            output.append((this.isHTML5 ? " data-" : " okp:") + attrName + "=\"" + Util.escapeToXML(value, 3, false, this.encoder) + "\"");
        }
    }

    private void printITSDoubleAttribute(Double value, String attrName, StringBuilder output) {
        if (value != null) {
            output.append(" " + this.prefix + attrName + "=\"" + Util.formatDouble(value) + "\"");
        }
    }

    private void printITSIntegerAttribute(Integer value, String attrName, StringBuilder output) {
        if (value != null) {
            output.append(" " + this.prefix + attrName + "=\"" + value + "\"");
        }
    }

    private void printITSBooleanAttribute(Boolean value, String attrName, StringBuilder output) {
        if (value != null) {
            output.append(" " + this.prefix + attrName + "=\"" + (value != false ? "yes" : "no") + "\"");
        }
    }
}

