/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filterwriter;

import java.nio.charset.CharsetEncoder;
import java.util.List;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.filterwriter.ITSContent;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;

public class XLIFFContent {
    public static final String ITS_PREFIX = "its:";
    public static final String REF_PREFIX = "REF:";
    private String codedText;
    private List<Code> codes;
    private XLIFFContent innerContent;
    private CharsetEncoder chsEnc;
    private List<GenericAnnotations> standoff;
    private ITSContent itsCont;

    public XLIFFContent() {
        this.codedText = "";
    }

    public XLIFFContent(TextFragment content) {
        this.setContent(content);
    }

    public void setCharsetEncoder(CharsetEncoder chsEnc) {
        this.chsEnc = chsEnc;
    }

    public CharsetEncoder getCharsetEncoder() {
        return this.chsEnc;
    }

    public XLIFFContent setContent(TextFragment content) {
        return this.setContent(content, false);
    }

    public XLIFFContent setContent(TextFragment content, boolean resetStandoff) {
        this.codedText = content.getCodedText();
        this.codes = content.getCodes();
        if (resetStandoff) {
            this.clearStandoff();
        }
        return this;
    }

    public String toString() {
        return this.toString(1, true, false, false);
    }

    public String toString(boolean gMode) {
        return this.toString(1, true, false, gMode);
    }

    public String toString(int quoteMode, boolean escapeGT, boolean codeOnlyMode, boolean gMode) {
        StringBuilder tmp = new StringBuilder();
        block15: for (int i = 0; i < this.codedText.length(); ++i) {
            switch (this.codedText.codePointAt(i)) {
                case 57601: {
                    int index = TextFragment.toIndex(this.codedText.charAt(++i));
                    Code code = this.codes.get(index);
                    if (codeOnlyMode) {
                        tmp.append(code.toString());
                        continue block15;
                    }
                    if (!code.hasOnlyAnnotation()) {
                        if (gMode) {
                            tmp.append(String.format("<g id=\"%d\">", code.getId()));
                        } else {
                            tmp.append(String.format("<bpt id=\"%d\">", code.getId()));
                            tmp.append(Util.escapeToXML(code.toString(), quoteMode, escapeGT, this.chsEnc));
                            tmp.append("</bpt>");
                        }
                    }
                    if (code.hasAnnotation("protected")) {
                        tmp.append("<mrk mtype=\"protected\">");
                        continue block15;
                    }
                    if (!code.hasAnnotation("generic")) continue block15;
                    tmp.append("<mrk mtype=\"x-its\"");
                    this.outputITSAttributes(code.getGenericAnnotations(), quoteMode, escapeGT, tmp, true);
                    tmp.append(">");
                    continue block15;
                }
                case 57602: {
                    int index = TextFragment.toIndex(this.codedText.charAt(++i));
                    Code code = this.codes.get(index);
                    if (codeOnlyMode) {
                        tmp.append(code.toString());
                        continue block15;
                    }
                    if (code.hasAnnotation("generic")) {
                        tmp.append("</mrk>");
                    } else if (code.hasAnnotation("protected")) {
                        tmp.append("</mrk>");
                    }
                    if (code.hasOnlyAnnotation()) continue block15;
                    if (gMode) {
                        tmp.append("</g>");
                        continue block15;
                    }
                    tmp.append(String.format("<ept id=\"%d\">", code.getId()));
                    tmp.append(Util.escapeToXML(code.toString(), quoteMode, escapeGT, this.chsEnc));
                    tmp.append("</ept>");
                    continue block15;
                }
                case 57603: {
                    int index = TextFragment.toIndex(this.codedText.charAt(++i));
                    Code code = this.codes.get(index);
                    if (codeOnlyMode) {
                        tmp.append(code.toString());
                        continue block15;
                    }
                    if (gMode) {
                        if (code.getTagType() == TextFragment.TagType.OPENING) {
                            tmp.append(String.format("<bx id=\"%d\"/>", code.getId()));
                            continue block15;
                        }
                        if (code.getTagType() == TextFragment.TagType.CLOSING) {
                            tmp.append(String.format("<ex id=\"%d\"/>", code.getId()));
                            continue block15;
                        }
                        tmp.append(String.format("<x id=\"%d\"/>", code.getId()));
                        continue block15;
                    }
                    if (code.getTagType() == TextFragment.TagType.OPENING) {
                        tmp.append(String.format("<it id=\"%d\" pos=\"open\">", code.getId()));
                        tmp.append(Util.escapeToXML(code.toString(), quoteMode, escapeGT, this.chsEnc));
                        tmp.append("</it>");
                        continue block15;
                    }
                    if (code.getTagType() == TextFragment.TagType.CLOSING) {
                        tmp.append(String.format("<it id=\"%d\" pos=\"close\">", code.getId()));
                        tmp.append(Util.escapeToXML(code.toString(), quoteMode, escapeGT, this.chsEnc));
                        tmp.append("</it>");
                        continue block15;
                    }
                    tmp.append(String.format("<ph id=\"%d\">", code.getId()));
                    tmp.append(Util.escapeToXML(code.toString(), quoteMode, escapeGT, this.chsEnc));
                    tmp.append("</ph>");
                    continue block15;
                }
                case 62: {
                    if (escapeGT) {
                        tmp.append("&gt;");
                        continue block15;
                    }
                    if (i > 0 && this.codedText.charAt(i - 1) == ']') {
                        tmp.append("&gt;");
                        continue block15;
                    }
                    tmp.append('>');
                    continue block15;
                }
                case 13: {
                    tmp.append("&#13;");
                    continue block15;
                }
                case 60: {
                    tmp.append("&lt;");
                    continue block15;
                }
                case 38: {
                    tmp.append("&amp;");
                    continue block15;
                }
                case 34: {
                    if (quoteMode > 0) {
                        tmp.append("&quot;");
                        continue block15;
                    }
                    tmp.append('\"');
                    continue block15;
                }
                case 39: {
                    switch (quoteMode) {
                        case 1: {
                            tmp.append("&apos;");
                            continue block15;
                        }
                        case 2: {
                            tmp.append("&#39;");
                            continue block15;
                        }
                    }
                    tmp.append(this.codedText.charAt(i));
                    continue block15;
                }
                default: {
                    if (this.codedText.charAt(i) > '\u007f') {
                        if (Character.isHighSurrogate(this.codedText.charAt(i))) {
                            int cp = this.codedText.codePointAt(i++);
                            String buf = new String(Character.toChars(cp));
                            if (this.chsEnc != null && !this.chsEnc.canEncode(buf)) {
                                tmp.append(String.format("&#x%x;", cp));
                                continue block15;
                            }
                            tmp.append(buf);
                            continue block15;
                        }
                        if (this.chsEnc != null && !this.chsEnc.canEncode(this.codedText.charAt(i))) {
                            tmp.append(String.format("&#x%04x;", this.codedText.codePointAt(i)));
                            continue block15;
                        }
                        tmp.append(this.codedText.charAt(i));
                        continue block15;
                    }
                    tmp.append(this.codedText.charAt(i));
                }
            }
        }
        return tmp.toString();
    }

    public String toSegmentedString(TextContainer container, int quoteMode, boolean escapeGT, boolean withMarkers, boolean gMode) {
        StringBuilder tmp = new StringBuilder();
        if (this.innerContent == null) {
            this.innerContent = new XLIFFContent();
            this.innerContent.setCharsetEncoder(this.chsEnc);
        } else {
            this.innerContent.clearStandoff();
        }
        for (TextPart part : container) {
            if (withMarkers && part.isSegment() && container.hasBeenSegmented()) {
                tmp.append(String.format("<mrk mid=\"%s\" mtype=\"seg\">", ((Segment)part).id));
            }
            this.innerContent.setContent(part.text);
            tmp.append(this.innerContent.toString(quoteMode, escapeGT, false, gMode));
            this.standoff = this.innerContent.getStandoff();
            if (!withMarkers || !part.isSegment() || !container.hasBeenSegmented() || !withMarkers) continue;
            tmp.append("</mrk>");
        }
        return tmp.toString();
    }

    public List<GenericAnnotations> getStandoff() {
        return this.standoff;
    }

    public void clearStandoff() {
        this.standoff = null;
        if (this.itsCont != null) {
            this.itsCont.clearStandoff();
        }
    }

    private void outputITSAttributes(GenericAnnotations anns, int quoteMode, boolean escapeGT, StringBuilder output, boolean inline) {
        if (this.itsCont == null) {
            this.itsCont = new ITSContent(this.chsEnc, false);
        }
        this.itsCont.outputAnnotations(anns, output, inline);
        this.standoff = this.itsCont.getStandoff();
    }
}

