/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filterwriter;

import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.filterwriter.XLIFFContent;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.TextFragment;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class XLIFFContentTest {
    private XLIFFContent fmt;

    @Before
    public void setUp() throws Exception {
        this.fmt = new XLIFFContent();
    }

    @Test
    public void testSimpleDefault() {
        TextFragment tf = this.createTextFragment();
        Assert.assertEquals(tf.getCodes().size(), 5L);
        Assert.assertEquals("t1<bpt id=\"1\">&lt;b1&gt;</bpt><bpt id=\"2\">&lt;b2&gt;</bpt><ph id=\"3\">{\\x1\\}</ph>t2<ept id=\"2\">&lt;/b2&gt;</ept><ept id=\"1\">&lt;/b1&gt;</ept>t3", this.fmt.setContent(tf).toString());
    }

    @Test
    public void testSimpleGX() {
        TextFragment tf = this.createTextFragment();
        Assert.assertEquals(tf.getCodes().size(), 5L);
        Assert.assertEquals("t1<g id=\"1\"><g id=\"2\"><x id=\"3\"/>t2</g></g>t3", this.fmt.setContent(tf).toString(true));
    }

    @Test
    public void testMisOrderedGX1() {
        TextFragment tf = this.createMisOrderedTextFragment1();
        Assert.assertEquals(tf.getCodes().size(), 4L);
        Assert.assertEquals("t1<bx id=\"1\"/>t2<bx id=\"2\"/>t3<ex id=\"1\"/>t4<ex id=\"2\"/>t5", this.fmt.setContent(tf).toString(true));
    }

    @Test
    public void testMisOrderedGX2() {
        TextFragment tf = this.createMisOrderedTextFragment2();
        Assert.assertEquals(tf.getCodes().size(), 4L);
        Assert.assertEquals("<ex id=\"3\"/><g id=\"1\"></g><bx id=\"2\"/>", this.fmt.setContent(tf).toString(true));
    }

    @Test
    public void testMisOrderedComplexGX() {
        TextFragment tf = this.createMisOrderedComplexFragmentUnit();
        Assert.assertEquals(tf.getCodes().size(), 8L);
        Assert.assertEquals("<bx id=\"1\"/><bx id=\"2\"/><g id=\"3\"></g><ex id=\"1\"/><bx id=\"4\"/><ex id=\"2\"/><ex id=\"4\"/>", this.fmt.setContent(tf).toString(true));
    }

    @Test
    public void testMisOrderedComplexBPT() {
        TextFragment tf = this.createMisOrderedComplexFragmentUnit();
        Assert.assertEquals(tf.getCodes().size(), 8L);
        Assert.assertEquals("<it id=\"1\" pos=\"open\">&lt;b1&gt;</it><it id=\"2\" pos=\"open\">&lt;b2&gt;</it><bpt id=\"3\">&lt;b2&gt;</bpt><ept id=\"3\">&lt;/b2&gt;</ept><it id=\"1\" pos=\"close\">&lt;/b1&gt;</it><it id=\"4\" pos=\"open\">&lt;b3&gt;</it><it id=\"2\" pos=\"close\">&lt;/b2&gt;</it><it id=\"4\" pos=\"close\">&lt;/b3&gt;</it>", this.fmt.setContent(tf).toString(false));
    }

    @Test
    public void testDisambiguityAnnotationAndLocNote() {
        GenericAnnotations anns = new GenericAnnotations();
        GenericAnnotation ga = anns.add("its-disamb");
        ga.setString("disambSource", "src");
        ga.setString("disambGranularity", "entity");
        TextFragment tf = new TextFragment("Before the span after.");
        int diff = tf.annotate(7, 15, "generic", anns);
        tf.annotate(7 + diff / 2, 15 + diff, "generic", new GenericAnnotations(new GenericAnnotation("its-ln", "lnValue", "comment", "lnType", "alert")));
        Assert.assertEquals("Before <mrk mtype=\"x-its\" its:disambigSource=\"src\"><mrk mtype=\"x-its\" comment=\"comment\" okp:itsLocNoteType=\"alert\">the span</mrk></mrk> after.", this.fmt.setContent(tf).toString(true));
    }

    @Test
    public void testVariousAnnotations() {
        GenericAnnotations anns = new GenericAnnotations();
        anns.add(new GenericAnnotation("its-allowedchars", "allowedcharsValue", "[a-z]"));
        anns.add(new GenericAnnotation("its-storagesize", "storagesizeSize", 25, "storagesizeEncoding", "iso-8859-1", "storagesizeLinebreak", "nel"));
        anns.add(new GenericAnnotation("its-term", "termConfidence", 0.5, "termInfo", "REF:myUri"));
        anns.add(new GenericAnnotation("its-lqi", "lqiType", "grammar", "lqiComment", "blah", "lqiSeverity", 98.5));
        TextFragment tf = new TextFragment("Before the span after.");
        tf.annotate(7, 15, "generic", anns);
        Assert.assertEquals("Before <mrk mtype=\"x-its\" its:allowedCharacters=\"[a-z]\" its:storageSize=\"25\" its:storageEncoding=\"iso-8859-1\" its:storageLinebreak=\"nel\" its:term=\"yes\" its:termConfidence=\"0.5\" its:termInfoRef=\"myUri\" its:locQualityIssueComment=\"blah\" its:locQualityIssueSeverity=\"98.5\" its:locQualityIssueType=\"grammar\">the span</mrk> after.", this.fmt.setContent(tf).toString(true));
    }

    @Test
    public void testmultipleLQI() {
        TextFragment tf = new TextFragment("Span 1 Span 2");
        GenericAnnotations anns = new GenericAnnotations();
        anns.setData("id1");
        anns.add(new GenericAnnotation("its-lqi", "lqiComment", "comment-1a"));
        anns.add(new GenericAnnotation("its-lqi", "lqiComment", "comment-1b"));
        tf.annotate(0, 6, "generic", anns);
        anns = new GenericAnnotations();
        anns.add(new GenericAnnotation("its-lqi", "lqiComment", "comment-2a"));
        anns.add(new GenericAnnotation("its-lqi", "lqiComment", "comment-2b"));
        tf.annotate(11, 17, "generic", anns);
        Assert.assertEquals("<mrk mtype=\"x-its\" its:locQualityIssuesRef=\"#VARID\">Span 1</mrk> <mrk mtype=\"x-its\" its:locQualityIssuesRef=\"#VARID\">Span 2</mrk>", this.stripVariableID(this.fmt.setContent(tf).toString(true)));
    }

    @Test
    public void testAnnotationOnOriginalCode() {
        TextFragment tf = new TextFragment("Before ");
        Code start = tf.append(TextFragment.TagType.OPENING, "span", "<its:span allowedCharacters='[a-z]'>");
        tf.append("the span");
        Code end = tf.append(TextFragment.TagType.CLOSING, "span", "</its:span>");
        tf.append(" after.");
        GenericAnnotations anns = new GenericAnnotations(new GenericAnnotation("its-allowedchars", "allowedcharsValue", "[a-z]"));
        GenericAnnotations.addAnnotations(start, anns);
        GenericAnnotations.addAnnotations(end, anns);
        Assert.assertEquals("Before <g id=\"1\"><mrk mtype=\"x-its\" its:allowedCharacters=\"[a-z]\">the span</mrk></g> after.", this.fmt.setContent(tf).toString(true));
    }

    private TextFragment createTextFragment() {
        TextFragment tf = new TextFragment();
        tf.append("t1");
        tf.append(TextFragment.TagType.OPENING, "b1", "<b1>");
        tf.append(TextFragment.TagType.OPENING, "b2", "<b2>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "{\\x1\\}");
        tf.append("t2");
        tf.append(TextFragment.TagType.CLOSING, "b2", "</b2>");
        tf.append(TextFragment.TagType.CLOSING, "b1", "</b1>");
        tf.append("t3");
        return tf;
    }

    private TextFragment createMisOrderedTextFragment1() {
        TextFragment tf = new TextFragment();
        tf.append("t1");
        tf.append(TextFragment.TagType.OPENING, "b1", "<b1>");
        tf.append("t2");
        tf.append(TextFragment.TagType.OPENING, "b2", "<b2>");
        tf.append("t3");
        tf.append(TextFragment.TagType.CLOSING, "b1", "</b1>");
        tf.append("t4");
        tf.append(TextFragment.TagType.CLOSING, "b2", "</b2>");
        tf.append("t5");
        return tf;
    }

    private TextFragment createMisOrderedTextFragment2() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.CLOSING, "b1", "</b1>");
        tf.append(TextFragment.TagType.OPENING, "b2", "<b2>");
        tf.append(TextFragment.TagType.CLOSING, "b2", "</b2>");
        tf.append(TextFragment.TagType.OPENING, "b3", "<b3>");
        return tf;
    }

    private TextFragment createMisOrderedComplexFragmentUnit() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "b1", "<b1>");
        tf.append(TextFragment.TagType.OPENING, "b2", "<b2>");
        tf.append(TextFragment.TagType.OPENING, "b2", "<b2>");
        tf.append(TextFragment.TagType.CLOSING, "b2", "</b2>");
        tf.append(TextFragment.TagType.CLOSING, "b1", "</b1>");
        tf.append(TextFragment.TagType.OPENING, "b3", "<b3>");
        tf.append(TextFragment.TagType.CLOSING, "b2", "</b2>");
        tf.append(TextFragment.TagType.CLOSING, "b3", "</b3>");
        return tf;
    }

    private String stripVariableID(String text) {
        text = text.replaceAll("locQualityIssuesRef=\"#(.*?)\"", "locQualityIssuesRef=\"#VARID\"");
        return text;
    }
}

