/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filterwriter;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.TestUtil;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.filterwriter.XLIFFWriter;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class XLIFFWriterTest {
    private XLIFFWriter writer;
    private String root;
    private LocaleId locEN = LocaleId.fromString("en");
    private LocaleId locFR = LocaleId.fromString("fr");

    @Before
    public void setUp() {
        this.writer = new XLIFFWriter();
        this.root = TestUtil.getParentDir(this.getClass(), "/");
    }

    @Test
    public void testMinimal() throws IOException {
        this.writer.create(this.root + "out.xlf", null, this.locEN, null, null, "original.ext", null);
        this.writer.writeStartFile(null, null, null);
        this.writer.writeEndFile();
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\" xmlns:its=\"http://www.w3.org/2005/11/its\">\n<file original=\"unknown\" source-language=\"en\" datatype=\"x-undefined\">\n<body>\n</body>\n</file>\n</xliff>\n", result);
    }

    @Test
    public void testVeryMinimal() throws IOException {
        this.writer.create(this.root + "out.xlf", null, this.locEN, null, null, "original.ext", null);
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\" xmlns:its=\"http://www.w3.org/2005/11/its\">\n<file original=\"original.ext\" source-language=\"en\" datatype=\"x-undefined\">\n<body>\n</body>\n</file>\n</xliff>\n", result);
    }

    @Test
    public void testWithExtra() throws IOException {
        this.writer.create(this.root + "out.xlf", null, this.locEN, null, null, "original.ext", null);
        this.writer.writeStartFile(null, null, null, "<phase-group phase-name=\"a\" process-name=\"b\"/>");
        this.writer.writeEndFile();
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\" xmlns:its=\"http://www.w3.org/2005/11/its\">\n<file original=\"unknown\" source-language=\"en\" datatype=\"x-undefined\">\n<header><phase-group phase-name=\"a\" process-name=\"b\"/></header>\n<body>\n</body>\n</file>\n</xliff>\n", result);
    }

    @Test
    public void testBasicSourceOnly() throws IOException {
        this.writer.create(this.root + "out.xlf", null, this.locEN, null, null, "original.ext", null);
        TextUnit tu = new TextUnit("tu1", "src1 with <>");
        this.writer.writeTextUnit(tu);
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\" xmlns:its=\"http://www.w3.org/2005/11/its\">\n<file original=\"original.ext\" source-language=\"en\" datatype=\"x-undefined\">\n<body>\n<trans-unit id=\"tu1\">\n<source xml:lang=\"en\">src1 with &lt;></source>\n</trans-unit>\n</body>\n</file>\n</xliff>\n", result);
    }

    @Test
    public void testAnnotations() throws IOException {
        this.writer.create(this.root + "out.xlf", null, this.locEN, this.locFR, null, "original.ext", null);
        this.writer.writeStartFile(null, null, null);
        TextUnit tu = new TextUnit("tu1");
        TextFragment tf = tu.getSource().getFirstSegment().getContent();
        tf.append("t1 t2");
        GenericAnnotations anns1 = new GenericAnnotations();
        anns1.setData("lqi1");
        GenericAnnotation ann1 = anns1.add("its-lqi");
        ann1.setString("lqiComment", "rem1");
        ann1.setBoolean("lqiEnabled", false);
        ann1.setString("lqiProfileRef", "uri");
        GenericAnnotation ann2 = anns1.add("its-lqi");
        ann2.setString("lqiComment", "rem2");
        ann2.setBoolean("lqiEnabled", true);
        ann2.setDouble("lqiSeverity", 12.34);
        ann2.setString("lqiType", "grammar");
        tf.annotate(0, 2, "generic", anns1);
        tf = tu.createTarget(this.locFR, false, 7).getFirstContent();
        GenericAnnotation ann3 = ann2.clone();
        ann3.setString("lqiComment", "rem3");
        ann3.setDouble("lqiSeverity", 99.0);
        GenericAnnotations anns3 = new GenericAnnotations();
        anns3.setData("lqi2");
        anns3.add(ann3);
        anns3.add(new GenericAnnotation("its-lqi", "lqiComment", "rem4"));
        tf.annotate(7, 9, "generic", anns3);
        this.writer.writeTextUnit(tu);
        this.writer.writeEndFile();
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\" xmlns:its=\"http://www.w3.org/2005/11/its\">\n<file original=\"unknown\" source-language=\"en\" target-language=\"fr\" datatype=\"x-undefined\">\n<body>\n<trans-unit id=\"tu1\">\n<source xml:lang=\"en\"><mrk mtype=\"x-its\" its:locQualityIssuesRef=\"#VARID\">t1</mrk> t2</source>\n<target xml:lang=\"fr\"><mrk mtype=\"x-its\" its:locQualityIssuesRef=\"#VARID\">t1</mrk> <mrk mtype=\"x-its\" its:locQualityIssuesRef=\"#VARID\">t2</mrk></target>\n<its:locQualityIssues xml:id=\"VARID\">\n<its:locQualityIssue locQualityIssueComment=\"rem1\" locQualityIssueEnabled=\"no\" locQualityIssueProfileRef=\"uri\"/>\n<its:locQualityIssue locQualityIssueComment=\"rem2\" locQualityIssueSeverity=\"12.34\" locQualityIssueType=\"grammar\"/>\n</its:locQualityIssues>\n<its:locQualityIssues xml:id=\"VARID\">\n<its:locQualityIssue locQualityIssueComment=\"rem1\" locQualityIssueEnabled=\"no\" locQualityIssueProfileRef=\"uri\"/>\n<its:locQualityIssue locQualityIssueComment=\"rem2\" locQualityIssueSeverity=\"12.34\" locQualityIssueType=\"grammar\"/>\n</its:locQualityIssues>\n<its:locQualityIssues xml:id=\"VARID\">\n<its:locQualityIssue locQualityIssueComment=\"rem3\" locQualityIssueSeverity=\"99\" locQualityIssueType=\"grammar\"/>\n<its:locQualityIssue locQualityIssueComment=\"rem4\"/>\n</its:locQualityIssues>\n</trans-unit>\n</body>\n</file>\n</xliff>\n", this.stripVariableID(result));
    }

    @Test
    public void testmultipleLQI() throws IOException {
        this.writer.create(this.root + "out.xlf", null, this.locEN, this.locFR, null, "original.ext", null);
        this.writer.writeStartFile(null, null, null);
        TextUnit tu = new TextUnit("tu1");
        TextFragment tf = tu.getSource().getFirstSegment().getContent();
        tf.setCodedText("Span 1 Span 2");
        GenericAnnotations anns = new GenericAnnotations();
        anns.add(new GenericAnnotation("its-lqi", "lqiComment", "comment-1a"));
        anns.add(new GenericAnnotation("its-lqi", "lqiComment", "comment-1b"));
        tf.annotate(0, 6, "generic", anns);
        anns = new GenericAnnotations();
        anns.add(new GenericAnnotation("its-lqi", "lqiComment", "comment-2a"));
        anns.add(new GenericAnnotation("its-lqi", "lqiComment", "comment-2b"));
        tf.annotate(11, 17, "generic", anns);
        tu.createTarget(this.locFR, false, 7);
        this.writer.writeTextUnit(tu);
        this.writer.writeEndFile();
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\" xmlns:its=\"http://www.w3.org/2005/11/its\">\n<file original=\"unknown\" source-language=\"en\" target-language=\"fr\" datatype=\"x-undefined\">\n<body>\n<trans-unit id=\"tu1\">\n<source xml:lang=\"en\"><mrk mtype=\"x-its\" its:locQualityIssuesRef=\"#VARID\">Span 1</mrk> <mrk mtype=\"x-its\" its:locQualityIssuesRef=\"#VARID\">Span 2</mrk></source>\n<target xml:lang=\"fr\"><mrk mtype=\"x-its\" its:locQualityIssuesRef=\"#VARID\">Span 1</mrk> <mrk mtype=\"x-its\" its:locQualityIssuesRef=\"#VARID\">Span 2</mrk></target>\n<its:locQualityIssues xml:id=\"VARID\">\n<its:locQualityIssue locQualityIssueComment=\"comment-1a\"/>\n<its:locQualityIssue locQualityIssueComment=\"comment-1b\"/>\n</its:locQualityIssues>\n<its:locQualityIssues xml:id=\"VARID\">\n<its:locQualityIssue locQualityIssueComment=\"comment-2a\"/>\n<its:locQualityIssue locQualityIssueComment=\"comment-2b\"/>\n</its:locQualityIssues>\n<its:locQualityIssues xml:id=\"VARID\">\n<its:locQualityIssue locQualityIssueComment=\"comment-1a\"/>\n<its:locQualityIssue locQualityIssueComment=\"comment-1b\"/>\n</its:locQualityIssues>\n<its:locQualityIssues xml:id=\"VARID\">\n<its:locQualityIssue locQualityIssueComment=\"comment-2a\"/>\n<its:locQualityIssue locQualityIssueComment=\"comment-2b\"/>\n</its:locQualityIssues>\n</trans-unit>\n</body>\n</file>\n</xliff>\n", this.stripVariableID(result));
    }

    @Test
    public void testTextWithDefaultCodes() throws IOException {
        this.writer.create(this.root + "out.xlf", null, this.locEN, null, null, "original.ext", null);
        TextUnit tu = new TextUnit("tu1");
        tu.getSource().getFirstSegment().getContent().append(TextFragment.TagType.OPENING, "z", "<z>");
        tu.getSource().getFirstSegment().getContent().append("s1");
        tu.getSource().getFirstSegment().getContent().append(TextFragment.TagType.CLOSING, "z", "</z>");
        tu.getSource().getFirstSegment().getContent().append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>");
        this.writer.writeTextUnit(tu);
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\" xmlns:its=\"http://www.w3.org/2005/11/its\">\n<file original=\"original.ext\" source-language=\"en\" datatype=\"x-undefined\">\n<body>\n<trans-unit id=\"tu1\">\n<source xml:lang=\"en\"><g id=\"1\">s1</g><x id=\"2\"/></source>\n</trans-unit>\n</body>\n</file>\n</xliff>\n", result);
    }

    @Test
    public void testTextWithEncapsulatedCodes() throws IOException {
        this.writer.setPlaceholderMode(false);
        this.writer.create(this.root + "out.xlf", null, this.locEN, null, null, "original.ext", null);
        TextUnit tu = new TextUnit("tu1");
        tu.getSource().getFirstSegment().getContent().append(TextFragment.TagType.OPENING, "z", "<z>");
        tu.getSource().getFirstSegment().getContent().append("s1");
        tu.getSource().getFirstSegment().getContent().append(TextFragment.TagType.CLOSING, "z", "</z>");
        tu.getSource().getFirstSegment().getContent().append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>");
        this.writer.writeTextUnit(tu);
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\" xmlns:its=\"http://www.w3.org/2005/11/its\">\n<file original=\"original.ext\" source-language=\"en\" datatype=\"x-undefined\">\n<body>\n<trans-unit id=\"tu1\">\n<source xml:lang=\"en\"><bpt id=\"1\">&lt;z></bpt>s1<ept id=\"1\">&lt;/z></ept><ph id=\"2\">&lt;br/></ph></source>\n</trans-unit>\n</body>\n</file>\n</xliff>\n", result);
    }

    @Test
    public void testBasicSourceOnlyGtEscaped() throws IOException {
        this.writer.create(this.root + "out.xlf", null, this.locEN, null, null, "original.ext", null);
        TextUnit tu = new TextUnit("tu1", "src1 with <>");
        this.writer.setEscapeGt(true);
        this.writer.writeTextUnit(tu);
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\" xmlns:its=\"http://www.w3.org/2005/11/its\">\n<file original=\"original.ext\" source-language=\"en\" datatype=\"x-undefined\">\n<body>\n<trans-unit id=\"tu1\">\n<source xml:lang=\"en\">src1 with &lt;&gt;</source>\n</trans-unit>\n</body>\n</file>\n</xliff>\n", result);
    }

    @Test
    public void testBasicSourceAndTarget() throws IOException {
        this.writer.create(this.root + "out.xlf", null, this.locEN, this.locFR, null, "original.ext", null);
        TextUnit tu = new TextUnit("tu1", "src1<&\"'>");
        tu.setTarget(this.locFR, new TextContainer("trg1"));
        this.writer.writeTextUnit(tu);
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\" xmlns:its=\"http://www.w3.org/2005/11/its\">\n<file original=\"original.ext\" source-language=\"en\" target-language=\"fr\" datatype=\"x-undefined\">\n<body>\n<trans-unit id=\"tu1\">\n<source xml:lang=\"en\">src1&lt;&amp;\"'></source>\n<target xml:lang=\"fr\">trg1</target>\n</trans-unit>\n</body>\n</file>\n</xliff>\n", result);
    }

    @Test
    public void testCompleteSourceAndTarget() throws IOException {
        this.writer.create(this.root + "out.xlf", "skel.skl", this.locEN, this.locFR, "dtValue", "original.ext", "messageValue");
        TextUnit tu = new TextUnit("tu1", "src1<&\"'>");
        tu.setTarget(this.locFR, new TextContainer("trg1"));
        this.writer.writeTextUnit(tu);
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\" xmlns:its=\"http://www.w3.org/2005/11/its\">\n<!--messageValue-->\n<file original=\"original.ext\" source-language=\"en\" target-language=\"fr\" datatype=\"x-dtValue\">\n<header><skl><external-file href=\"skel.skl\"></external-file></skl></header>\n<body>\n<trans-unit id=\"tu1\">\n<source xml:lang=\"en\">src1&lt;&amp;\"'></source>\n<target xml:lang=\"fr\">trg1</target>\n</trans-unit>\n</body>\n</file>\n</xliff>\n", result);
    }

    @Test
    public void testBasicWithITSProperties() throws IOException {
        this.writer.create(this.root + "out.xlf", null, this.locEN, null, null, "original.ext", null);
        TextUnit tu = new TextUnit("tu1", "text");
        GenericAnnotation.addAnnotation(tu, new GenericAnnotation("its-domain", "domainValue", "dom1, dom2"));
        GenericAnnotation.addAnnotation(tu, new GenericAnnotation("its-externalres", "its-externalresValue", "http://example.com/res"));
        this.writer.writeTextUnit(tu);
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\" xmlns:its=\"http://www.w3.org/2005/11/its\">\n<file original=\"original.ext\" source-language=\"en\" datatype=\"x-undefined\">\n<body>\n<trans-unit id=\"tu1\" okp:itsDomain=\"dom1, dom2\" okp:itsExternalResourceRef=\"http://example.com/res\">\n<source xml:lang=\"en\">text</source>\n</trans-unit>\n</body>\n</file>\n</xliff>\n", result);
    }

    private String readFile(String path) throws IOException {
        byte[] buffer = new byte[1024];
        int count = 0;
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(path));
        StringBuilder sb = new StringBuilder();
        while ((count = bis.read(buffer)) != -1) {
            sb.append(new String(buffer, 0, count));
        }
        String tmp = sb.toString().replace("\r\n", "\n");
        tmp = tmp.replace("\r", "\n");
        return tmp;
    }

    private String stripVariableID(String text) {
        text = text.replaceAll("locQualityIssuesRef=\"#(.*?)\"", "locQualityIssuesRef=\"#VARID\"");
        text = text.replaceAll("xml:id=\"(.*?)\"", "xml:id=\"VARID\"");
        return text;
    }
}

