/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.Stack;
import junit.framework.TestCase;
import net.sf.okapi.common.filterwriter.XLIFFContent;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.TextFragment;

public class OptimizerTest
extends TestCase {
    public void testOptimizer() {
        TextFragment tf = new TextFragment();
        XLIFFContent fmt = new XLIFFContent();
        tf.append("Hello ");
        tf.append(TextFragment.TagType.OPENING, "b1", "<b1>");
        tf.append(TextFragment.TagType.OPENING, "b2", "<b2>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("bold");
        tf.append(TextFragment.TagType.CLOSING, "b2", "</b2>");
        tf.append(TextFragment.TagType.CLOSING, "b1", "</b1>");
        tf.append("world");
        OptimizerTest.assertEquals(tf.getCodes().size(), 5);
        OptimizerTest.optimizeCodes(tf);
        OptimizerTest.assertEquals(tf.getCodes().size(), 3);
        fmt.setContent(tf);
        System.out.println(fmt.toString());
    }

    private static void optimizeCodes(TextFragment frag) {
        Stack<Code> stack = new Stack<Code>();
        String text = frag.getCodedText();
        int i = 0;
        while (i < text.length()) {
            int start = -1;
            int end = -1;
            boolean stop = false;
            stack.clear();
            while (i < text.length()) {
                char ch = text.charAt(i);
                if (TextFragment.isMarker(ch)) {
                    Code code = frag.getCode(text.charAt(++i));
                    switch (code.getTagType()) {
                        case OPENING: {
                            stack.push(code);
                            if (start == -1) {
                                start = i - 1;
                                break;
                            }
                            end = i + 1;
                            break;
                        }
                        case CLOSING: {
                            if (stack.size() == 0) {
                                if (start == -1) {
                                    start = i - 1;
                                    break;
                                }
                                end = i + 1;
                                break;
                            }
                            if (((Code)stack.peek()).getTagType() == TextFragment.TagType.OPENING && ((Code)stack.peek()).getType().equals(code.getType())) {
                                stack.pop();
                                if (start == -1) {
                                    start = i - 1;
                                } else {
                                    end = i + 1;
                                }
                            }
                            stop = true;
                            break;
                        }
                        case PLACEHOLDER: {
                            stack.push(code);
                            if (start != -1) break;
                            start = i - 1;
                        }
                    }
                } else if (start > -1) break;
                if (stop) break;
                ++i;
            }
            if (start <= -1 || end - start <= 2) continue;
            i += frag.changeToCode(start, end, TextFragment.TagType.PLACEHOLDER, "group");
            text = frag.getCodedText();
        }
        frag.renumberCodes();
    }
}

