/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonPart;
import org.junit.Assert;
import org.junit.Test;

public class TextUnitUtilTest {
    private GenericContent fmt = new GenericContent();
    private LocaleId locTrg = LocaleId.fromString("trg");

    @Test
    public void testAdjustTargetFragment() {
        TextFragment toTransSrc = this.makeFragment1();
        TextFragment proposalTrg = this.makeFragment1Bis("trg");
        Assert.assertEquals("{B}A{/B}B{BR/}C trg", proposalTrg.toText());
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(toTransSrc, proposalTrg, true, true, null, null);
        Assert.assertEquals("[b]A[/b]B[br/]C trg", proposalTrg.toText());
    }

    @Test
    public void testAdjustIncompleteTargetFragmentAutoAdded() {
        TextFragment toTransSrc = this.makeFragment1();
        TextFragment proposalTrg = this.makeFragment1Bis("trg");
        proposalTrg.remove(6, 8);
        Assert.assertEquals("{B}A{/B}BC trg", proposalTrg.toText());
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(toTransSrc, proposalTrg, true, true, null, null);
        Assert.assertEquals("[b]A[/b]BC trg[br/]", proposalTrg.toText());
    }

    @Test
    public void testAdjustIncompleteTargetFragmentNoAddition() {
        TextFragment toTransSrc = this.makeFragment1();
        TextFragment proposalTrg = this.makeFragment1Bis("with warning");
        proposalTrg.remove(6, 8);
        Assert.assertEquals("{B}A{/B}BC with warning", proposalTrg.toText());
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(toTransSrc, proposalTrg, true, false, null, null);
        Assert.assertEquals("[b]A[/b]BC with warning", proposalTrg.toText());
    }

    @Test
    public void testAdjustNoCodes() {
        TextUnit tu = new TextUnit("1", "src");
        TextFragment newSrc = new TextFragment("src");
        TextFragment newTrg = new TextFragment("trg");
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(tu.getSource().getSegments().getFirstContent(), newTrg, true, false, newSrc, tu);
        Assert.assertEquals(this.locTrg, newTrg.toText());
    }

    @Test
    public void testAdjustSameMarkers() {
        ITextUnit tu = this.createTextUnit1();
        TextFragment tf = new TextFragment("T ");
        tf.append(TextFragment.TagType.OPENING, "b", "<T>");
        tf.append("BOLD");
        tf.append(TextFragment.TagType.CLOSING, "b", "</T>");
        tf.append(" T ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "<PH/>");
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(tu.getSource().getSegments().getFirstContent(), tf, true, false, null, tu);
        Assert.assertEquals("T <b>BOLD</b> T <br/>", tf.toText());
        this.fmt.setContent(tf);
        Assert.assertEquals("T <1>BOLD</1> T <2/>", this.fmt.toString());
    }

    @Test
    public void testAdjustExtraMarkers() {
        ITextUnit tu = this.createTextUnit1();
        TextFragment tf = new TextFragment("T ");
        tf.append(TextFragment.TagType.OPENING, "b", "<T>");
        tf.append("BOLD");
        tf.append(TextFragment.TagType.CLOSING, "b", "</T>");
        tf.append(" T ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "<PH/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "extra", "<EXTRA/>");
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(tu.getSource().getSegments().getFirstContent(), tf, true, false, null, tu);
        Assert.assertEquals("T <b>BOLD</b> T <br/><EXTRA/>", tf.toText());
        this.fmt.setContent(tf);
        Assert.assertEquals("T <1>BOLD</1> T <2/><3/>", this.fmt.toString());
    }

    @Test
    public void testAdjustMissingMarker() {
        ITextUnit tu = this.createTextUnit1();
        TextFragment tf = new TextFragment("T ");
        tf.append(TextFragment.TagType.OPENING, "b", "<T>");
        tf.append("BOLD");
        tf.append(" T ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "<PH/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "extra", "<EXTRA/>");
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(tu.getSource().getSegments().getFirstContent(), tf, true, false, null, tu);
        Assert.assertEquals("T <b>BOLD T <br/><EXTRA/>", tf.toText());
        this.fmt.setContent(tf);
        Assert.assertEquals("T <b1/>BOLD T <2/><3/>", this.fmt.toString());
    }

    @Test
    public void testAdjustDifferentTextSameMarkers() {
        ITextUnit tu = this.createTextUnit1();
        TextFragment tf = new TextFragment("U ");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("BOLD");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(" U ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>");
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(tu.getSource().getFirstContent(), tf, true, false, null, tu);
        Assert.assertEquals("U <b>BOLD</b> U <br/>", tf.toText());
        Assert.assertEquals("U <1>BOLD</1> U <2/>", this.fmt.setContent(tf).toString());
    }

    @Test
    public void testMovedCodes() {
        TextFragment oriFrag = new TextFragment("s1 ");
        oriFrag.append(TextFragment.TagType.PLACEHOLDER, "c1", "[c1]");
        oriFrag.append(" s2 ");
        oriFrag.append(TextFragment.TagType.OPENING, "c2", "[c2>]");
        oriFrag.append(" s3 ");
        oriFrag.append(TextFragment.TagType.CLOSING, "c2", "[<c2]");
        TextFragment trgFrag = GenericContent.fromLetterCodedToFragment("<g2>t3</g2> t1 <x1/> t2", null, false, true);
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(oriFrag, trgFrag, true, false, null, null);
        Assert.assertEquals("[c2>]t3[<c2] t1 [c1] t2", this.fmt.setContent(trgFrag).toString(true));
    }

    @Test
    public void testAddMissingCodes() {
        TextFragment oriFrag = GenericContent.fromLetterCodedToFragment("src<x1/>", null, false, true);
        TextFragment trgFrag = GenericContent.fromLetterCodedToFragment("trg", null, false, true);
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(oriFrag, trgFrag, true, true, null, null);
        Assert.assertEquals("trg<1/>", this.fmt.setContent(trgFrag).toString());
        oriFrag = GenericContent.fromLetterCodedToFragment("src<x1/>", null, false, true);
        trgFrag = GenericContent.fromLetterCodedToFragment("trg<x2/>", null, false, true);
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(oriFrag, trgFrag, true, true, null, null);
        Assert.assertEquals("trg<2/><1/>", this.fmt.setContent(trgFrag).toString());
        oriFrag = GenericContent.fromLetterCodedToFragment("src<x1/><x2/>", null, false, true);
        trgFrag = GenericContent.fromLetterCodedToFragment("trg<x2/>", null, false, true);
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(oriFrag, trgFrag, true, true, null, null);
        Assert.assertEquals("trg<2/><1/>", this.fmt.setContent(trgFrag).toString());
        oriFrag = GenericContent.fromLetterCodedToFragment("<x1/>src<x2/>", null, false, true);
        trgFrag = GenericContent.fromLetterCodedToFragment("trg<x2/>", null, false, true);
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(oriFrag, trgFrag, true, true, null, null);
        Assert.assertEquals("<1/>trg<2/>", this.fmt.setContent(trgFrag).toString());
        oriFrag = GenericContent.fromLetterCodedToFragment("<x1/> src", null, false, true);
        trgFrag = GenericContent.fromLetterCodedToFragment("trg", null, false, true);
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(oriFrag, trgFrag, true, true, null, null);
        Assert.assertEquals("<1/>trg", this.fmt.setContent(trgFrag).toString());
        oriFrag = GenericContent.fromLetterCodedToFragment("<x1/> src<x2/>", null, false, true);
        trgFrag = GenericContent.fromLetterCodedToFragment("trg", null, false, true);
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(oriFrag, trgFrag, true, true, null, null);
        Assert.assertEquals("<1/>trg<2/>", this.fmt.setContent(trgFrag).toString());
        oriFrag = GenericContent.fromLetterCodedToFragment("<x1/> src<x2/>", null, false, true);
        trgFrag = GenericContent.fromLetterCodedToFragment("<x2/>trg", null, false, true);
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(oriFrag, trgFrag, true, true, null, null);
        Assert.assertEquals("<1/><2/>trg", this.fmt.setContent(trgFrag).toString());
    }

    @Test
    public void testUtils() {
        String st = "12345678";
        Assert.assertEquals("45678", Util.trimStart(st, "123"));
        Assert.assertEquals("12345", Util.trimEnd(st, "678"));
        Assert.assertEquals("12345678", Util.trimEnd(st, "9"));
        st = "     ";
        Assert.assertEquals("", Util.trimStart(st, " "));
        Assert.assertEquals("", Util.trimEnd(st, " "));
        st = "  1234   ";
        TextFragment tf = new TextFragment(st);
        TextUnitUtil.trimLeading(tf, null);
        Assert.assertEquals("1234   ", tf.toText());
        TextUnitUtil.trimTrailing(tf, null);
        Assert.assertEquals("1234", tf.toText());
        st = "     ";
        tf = new TextFragment(st);
        TextUnitUtil.trimLeading(tf, null);
        Assert.assertEquals("", tf.toText());
        TextUnitUtil.trimTrailing(tf, null);
        Assert.assertEquals("", tf.toText());
        st = "     ";
        tf = new TextFragment(st);
        TextUnitUtil.trimTrailing(tf, null);
        Assert.assertEquals("", tf.toText());
        TextFragment tc = new TextFragment("test");
        Code c = new Code(TextFragment.TagType.PLACEHOLDER, "code");
        tc.append(c);
        tc.append(" string");
        TextFragment tcc = new TextFragment();
        Code c2 = new Code(TextFragment.TagType.PLACEHOLDER, "code");
        tcc.append("   ");
        tcc.append(c2);
        tcc.append("    123456  ");
        GenericSkeleton skel = new GenericSkeleton();
        TextUnitUtil.trimLeading(tcc, skel);
        TextUnit tu1 = new TextUnit("tu1");
        tu1.setSourceContent(tcc);
        Assert.assertEquals("    123456  ", ((Object)tu1).toString());
        Assert.assertEquals("   ", skel.toString());
        TextFragment tcc2 = new TextFragment("    123456  ");
        Code c3 = new Code(TextFragment.TagType.PLACEHOLDER, "code");
        tcc2.append(c3);
        GenericSkeleton skel2 = new GenericSkeleton();
        TextUnitUtil.trimTrailing(tcc2, skel2);
        tu1.setSourceContent(tcc2);
        Assert.assertEquals("    123456  ", ((Object)tu1).toString());
        Assert.assertEquals("", skel2.toString());
        TextFragment tcc4 = new TextFragment("    123456  ");
        Code c4 = new Code(TextFragment.TagType.PLACEHOLDER, "code");
        tcc4.append(c4);
        char ch = TextUnitUtil.getLastChar(tcc4);
        Assert.assertEquals(54L, ch);
        TextFragment tcc5 = new TextFragment("    123456  ");
        TextUnitUtil.deleteLastChar(tcc5);
        Assert.assertEquals("    12345  ", tcc5.getCodedText());
        TextFragment tcc6 = new TextFragment("123456_    ");
        Assert.assertTrue(TextUnitUtil.endsWith(tcc6, "_"));
        Assert.assertTrue(TextUnitUtil.endsWith(tcc6, "6_"));
        Assert.assertFalse(TextUnitUtil.endsWith(tcc6, "  "));
        TextFragment tcc7 = new TextFragment("123456<splicer>    ");
        Assert.assertTrue(TextUnitUtil.endsWith(tcc7, "<splicer>"));
        Assert.assertTrue(TextUnitUtil.endsWith(tcc7, "6<splicer>"));
        Assert.assertFalse(TextUnitUtil.endsWith(tcc7, "  "));
    }

    @Test
    public void testGetText() {
        TextFragment tf = new TextFragment("ab");
        tf.append(TextFragment.TagType.OPENING, "type1", "z");
        tf.append("cde");
        tf.append(TextFragment.TagType.PLACEHOLDER, "type2", "z");
        tf.append("fgh");
        tf.append(TextFragment.TagType.PLACEHOLDER, "type3", "z");
        tf.append("ijklm");
        tf.append(TextFragment.TagType.CLOSING, "type1", "z");
        Assert.assertEquals("abcdefghijklm", TextUnitUtil.getText(tf));
        ArrayList<Integer> positions = new ArrayList<Integer>();
        Assert.assertEquals("abcdefghijklm", TextUnitUtil.getText(tf, positions));
        Assert.assertEquals(4L, positions.size());
        Assert.assertEquals(2L, positions.get(0).intValue());
        Assert.assertEquals(7L, positions.get(1).intValue());
        Assert.assertEquals(12L, positions.get(2).intValue());
        Assert.assertEquals(19L, positions.get(3).intValue());
        tf = new TextFragment("ab");
        tf.append(TextFragment.TagType.OPENING, "type1", "z");
        tf.append("cde");
        tf.append(TextFragment.TagType.PLACEHOLDER, "type2", "z");
        tf.append("fgh");
        tf.append(TextFragment.TagType.PLACEHOLDER, "type3", "z");
        tf.append("ijklm");
        tf.append(TextFragment.TagType.CLOSING, "type1", "z");
        tf.append("n");
        Assert.assertEquals("abcdefghijklmn", TextUnitUtil.getText(tf));
        positions = new ArrayList();
        Assert.assertEquals("abcdefghijklmn", TextUnitUtil.getText(tf, positions));
        Assert.assertEquals(4L, positions.size());
        Assert.assertEquals(2L, positions.get(0).intValue());
        Assert.assertEquals(7L, positions.get(1).intValue());
        Assert.assertEquals(12L, positions.get(2).intValue());
        Assert.assertEquals(19L, positions.get(3).intValue());
        String st = "abcdefghijklmn";
        Assert.assertEquals(st, TextUnitUtil.getText(new TextFragment(st)));
        tf = new TextFragment("abcde");
        tf.append(TextFragment.TagType.PLACEHOLDER, "iso", "z");
        tf.append(TextFragment.TagType.PLACEHOLDER, "iso", "z");
        tf.append("fghijklm");
        tf.append(TextFragment.TagType.PLACEHOLDER, "iso", "z");
        tf.append(TextFragment.TagType.PLACEHOLDER, "iso", "z");
        tf.append("n");
        Assert.assertEquals("abcdefghijklmn", TextUnitUtil.getText(tf));
        positions = new ArrayList();
        Assert.assertEquals("abcdefghijklmn", TextUnitUtil.getText(tf, positions));
        Assert.assertEquals(4L, positions.size());
        Assert.assertEquals(5L, positions.get(0).intValue());
        Assert.assertEquals(7L, positions.get(1).intValue());
        Assert.assertEquals(17L, positions.get(2).intValue());
        Assert.assertEquals(19L, positions.get(3).intValue());
        st = "abcdefghijklmn";
        Assert.assertEquals(st, TextUnitUtil.getText(new TextFragment(st)));
    }

    @Test
    public void testRemoveQualifiers() {
        ITextUnit tu = TextUnitUtil.buildTU("\"qualified text\"");
        TextUnitUtil.removeQualifiers(tu, "\"");
        Assert.assertEquals("qualified text", tu.getSource().toString());
        tu.setSourceContent(new TextFragment("((({[qualified text]})))"));
        Assert.assertEquals("((({[qualified text]})))", tu.getSource().toString());
        TextUnitUtil.removeQualifiers(tu, "((({", "})))");
        Assert.assertEquals("[qualified text]", tu.getSource().toString());
        GenericSkeleton tuSkel = (GenericSkeleton)tu.getSkeleton();
        Assert.assertNotNull(tuSkel);
        List<GenericSkeletonPart> parts = tuSkel.getParts();
        Assert.assertEquals(5L, parts.size());
        String tuRef = TextFragment.makeRefMarker("$self$");
        Assert.assertEquals("\"", parts.get(0).toString());
        Assert.assertEquals("((({", parts.get(1).toString());
        Assert.assertEquals(tuRef, parts.get(2).toString());
        Assert.assertEquals("})))", parts.get(3).toString());
        Assert.assertEquals("\"", parts.get(4).toString());
    }

    @Test
    public void testSimplifyCodes() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        TextUnit tu = new TextUnit("tu1");
        tu.setSourceContent(tf);
        Assert.assertEquals("<x1/>T1<x2/>", tu.getSource().toString());
        TextUnitUtil.simplifyCodes(tu, true);
        Assert.assertEquals("T1", tu.getSource().toString());
        GenericSkeleton tuSkel = (GenericSkeleton)tu.getSkeleton();
        Assert.assertNotNull(tuSkel);
        List<GenericSkeletonPart> parts = tuSkel.getParts();
        Assert.assertEquals(3L, parts.size());
        Assert.assertEquals("<x1/>", parts.get(0).toString());
        String tuRef = TextFragment.makeRefMarker("$self$");
        Assert.assertEquals(tuRef, parts.get(1).toString());
        Assert.assertEquals("<x2/>", parts.get(2).toString());
    }

    @Test
    public void testSimplifyCodes_segmentedTU() {
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", new TextFragment("[seg 1]")));
        tc.append(new TextPart("[text part 1]"));
        tc.append(new Segment("s2", new TextFragment("[seg 2]")));
        tc.append(new TextPart("[text part 2]"));
        tc.append(new TextPart("[text part 3]"));
        tc.append(new Segment("s3", new TextFragment("[seg 3]")));
        tc.append(new Segment("s4", new TextFragment("[seg 4]")));
        String[] res = TextUnitUtil.simplifyCodes(tc, false);
        Assert.assertEquals("[seg 1][text part 1][seg 2][text part 2][text part 3][seg 3][seg 4]", tc.toString());
        Assert.assertNull(res);
    }

    @Test
    public void testSimplifyCodes_segmentedTU2() {
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", new TextFragment("[seg 1]")));
        String[] res = TextUnitUtil.simplifyCodes(tc, false);
        Assert.assertEquals("[seg 1]", tc.toString());
        Assert.assertNull(res);
    }

    @Test
    public void testSimplifyCodes_segmentedTU3() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x11", "<x11/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x12", "<x12/>");
        tf1.append("[seg 1]");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x13", "<x13/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x14", "<x14/>");
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf1));
        String[] res = TextUnitUtil.simplifyCodes(tc, true);
        Assert.assertEquals("[seg 1]", tc.toString());
        Assert.assertNotNull(res);
        Assert.assertEquals("<x11/><x12/>", res[0]);
        Assert.assertEquals("<x13/><x14/>", res[1]);
    }

    @Test
    public void testSimplifyCodes_segmentedTU4() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x11", "<x11/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x12", "<x12/>");
        tf1.append("   [seg 1]");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x13", "<x13/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x14", "<x14/>");
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf1));
        String[] res = TextUnitUtil.simplifyCodes(tc, true);
        Assert.assertEquals("[seg 1]", tc.toString());
        Assert.assertNotNull(res);
        Assert.assertEquals("<x11/><x12/>   ", res[0]);
        Assert.assertEquals("<x13/><x14/>", res[1]);
    }

    @Test
    public void testSimplifyCodes_segmentedTU5() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x11", "<x11/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x12", "<x12/>");
        tf1.append("   [seg 1]");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x13", "<x13/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x14", "<x14/>");
        TextFragment tf2 = new TextFragment();
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x21", "<x21/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x22", "<x22/>");
        tf2.append("   [seg 2]");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x23", "<x23/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x24", "<x24/>");
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf1));
        tc.append(new Segment("s2", tf2));
        String[] res = TextUnitUtil.simplifyCodes(tc, true);
        Assert.assertEquals("[seg 1]<x13/><x14/><x21/><x22/>   [seg 2]", tc.toString());
        Assert.assertNotNull(res);
        Assert.assertEquals("<x11/><x12/>   ", res[0]);
        Assert.assertEquals("<x23/><x24/>", res[1]);
        Assert.assertEquals(5L, tc.count());
        Assert.assertTrue(tc.get(0).isSegment());
        Assert.assertFalse(tc.get(1).isSegment());
        Assert.assertFalse(tc.get(2).isSegment());
        Assert.assertFalse(tc.get(3).isSegment());
        Assert.assertTrue(tc.get(4).isSegment());
        Assert.assertEquals("[seg 1]", tc.get(0).toString());
        Assert.assertEquals("<x13/><x14/>", tc.get(1).toString());
        Assert.assertEquals("<x21/><x22/>", tc.get(2).toString());
        Assert.assertEquals("<x21/><x22/>", tc.get(2).toString());
        Assert.assertEquals("   ", tc.get(3).toString());
        Assert.assertEquals("[seg 2]", tc.get(4).toString());
        ISegments segs = tc.getSegments();
        Assert.assertEquals(2L, segs.count());
    }

    @Test
    public void testSimplifyCodes_segmentedTU6() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x/>");
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x/>");
        tf.append("The plan of");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x4", "<x/>");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append("happiness");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append(TextFragment.TagType.OPENING, "d", "<d>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x5", "<x/>");
        tf.append(TextFragment.TagType.CLOSING, "d", "</d>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x6", "<x/>");
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf));
        String[] res = TextUnitUtil.simplifyCodes(tc, true);
        Assert.assertEquals("<x/><x/><a><x/>The plan of</a><b><x/></b><c>happiness</c><d><x/></d><x/>", tc.toString());
        Assert.assertNotNull(res);
        Assert.assertEquals(null, res[0]);
        Assert.assertEquals(null, res[1]);
        Assert.assertEquals(3L, tc.count());
        Assert.assertFalse(tc.get(0).isSegment());
        Assert.assertTrue(tc.get(1).isSegment());
        Assert.assertFalse(tc.get(2).isSegment());
        Assert.assertEquals("<x/><x/><a><x/>", tc.get(0).toString());
        Assert.assertEquals("The plan of</a><b><x/></b><c>happiness", tc.get(1).toString());
        Assert.assertEquals("</c><d><x/></d><x/>", tc.get(2).toString());
        ISegments segs = tc.getSegments();
        Assert.assertEquals(1L, segs.count());
    }

    @Test
    public void testSegmentId() {
        TextFragment tf = new TextFragment();
        tf.append(new Code(TextFragment.TagType.OPENING, "x", "code1"));
        tf.append("seg");
        tf.append(new Code(TextFragment.TagType.CLOSING, "x", "code2"));
        Segment seg = new Segment("0", tf);
        TextContainer tc = new TextContainer(seg);
        Assert.assertEquals(1L, tc.count());
        Assert.assertEquals("0", tc.getSegments().get(0).getId());
        TextUnitUtil.simplifyCodes(tc, false);
        Assert.assertEquals(3L, tc.count());
        Assert.assertEquals("0", tc.getSegments().get(0).getId());
    }

    @Test
    public void testSegmentId2() {
        TextFragment tf1 = new TextFragment();
        tf1.append(new Code(TextFragment.TagType.OPENING, "x1", "code1"));
        tf1.append("seg1");
        tf1.append(new Code(TextFragment.TagType.CLOSING, "x1", "code2"));
        TextFragment tf2 = new TextFragment();
        tf2.append(new Code(TextFragment.TagType.OPENING, "x2", "code3"));
        tf2.append("seg2");
        tf2.append(new Code(TextFragment.TagType.CLOSING, "x2", "code4"));
        Segment seg1 = new Segment("1", tf1);
        Segment seg2 = new Segment("5", tf2);
        TextContainer tc = new TextContainer(seg1);
        tc.append(seg2);
        Assert.assertEquals(2L, tc.count());
        TextUnitUtil.simplifyCodes(tc, false);
        Assert.assertEquals(6L, tc.count());
        Assert.assertEquals("1", tc.getSegments().get(0).getId());
        Assert.assertEquals("seg1", tc.getSegments().get(0).getContent().toString());
        Assert.assertEquals("5", tc.getSegments().get(1).getId());
        Assert.assertEquals("seg2", tc.getSegments().get(1).getContent().toString());
    }

    @Test
    public void testSegmentId3() {
        TextFragment tf1 = new TextFragment();
        tf1.append(new Code(TextFragment.TagType.OPENING, "x1", "code1"));
        tf1.append("seg1");
        tf1.append(new Code(TextFragment.TagType.CLOSING, "x1", "code2"));
        TextFragment tf2 = new TextFragment();
        tf2.append(new Code(TextFragment.TagType.OPENING, "x2", "code3"));
        tf2.append("seg2");
        tf2.append(new Code(TextFragment.TagType.CLOSING, "x2", "code4"));
        Segment seg1 = new Segment("1", tf1);
        Segment seg2 = new Segment("5", tf2);
        TextContainer tc = new TextContainer(seg1);
        tc.append(seg2);
        Assert.assertEquals(2L, tc.count());
        TextFragment tf = TextUnitUtil.storeSegmentation(tc);
        Assert.assertEquals("[#$1@%$seg_start$]code1seg1code2[#$1@%$seg_end$][#$5@%$seg_start$]code3seg2code4[#$5@%$seg_end$]", tf.toText());
        tc.clear();
        Assert.assertEquals("(2: seg_start 1) (10: seg_end 1) (14: seg_start 5) (22: seg_end 5)", TextUnitUtil.restoreSegmentation(tc, tf));
    }

    @Test
    public void testStoreSegmentation() {
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", new TextFragment("[seg 1]")));
        tc.append(new TextPart("[text part 1]"));
        tc.append(new Segment("s2", new TextFragment("[seg 2]")));
        tc.append(new TextPart("[text part 2]"));
        tc.append(new TextPart("[text part 3]"));
        tc.append(new Segment("s3", new TextFragment("[seg 3]")));
        TextFragment tf = TextUnitUtil.storeSegmentation(tc);
        Assert.assertEquals("<1/>[seg 1]<2/><3/>[text part 1]<4/><5/>[seg 2]<6/><7/>[text part 2]<8/><9/>[text part 3]<10/><11/>[seg 3]<12/>", this.fmt.setContent(tf).toString());
        List<Code> codes = tf.getCodes();
        Assert.assertEquals(12L, codes.size());
        Assert.assertEquals("[#$s1@%$seg_start$]", codes.get(0).toString());
        Assert.assertEquals("[#$s1@%$seg_end$]", codes.get(1).toString());
        Assert.assertEquals("$tp_start$", codes.get(2).toString());
        Assert.assertEquals("$tp_end$", codes.get(3).toString());
        Assert.assertEquals("[#$s2@%$seg_start$]", codes.get(4).toString());
        Assert.assertEquals("[#$s2@%$seg_end$]", codes.get(5).toString());
        Assert.assertEquals("$tp_start$", codes.get(6).toString());
        Assert.assertEquals("$tp_end$", codes.get(7).toString());
        Assert.assertEquals("$tp_start$", codes.get(8).toString());
        Assert.assertEquals("$tp_end$", codes.get(9).toString());
        Assert.assertEquals("[#$s3@%$seg_start$]", codes.get(10).toString());
        Assert.assertEquals("[#$s3@%$seg_end$]", codes.get(11).toString());
    }

    @Test
    public void testTreeSet() {
        TreeSet<Integer> set = new TreeSet<Integer>();
        set.add(5);
        set.add(1);
        set.add(5);
        set.add(3);
        set.add(9);
        Assert.assertEquals(4L, set.size());
        Assert.assertEquals("[1, 3, 5, 9]", set.toString());
    }

    @Test
    public void testTreeMap() {
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        map.put(5, "");
        map.put(1, "");
        map.put(5, "");
        map.put(3, "");
        map.put(9, "");
        Assert.assertEquals(4L, map.size());
    }

    @Test
    public void testHashtableSort() {
        Hashtable<String, String> h = new Hashtable<String, String>();
        h.put("a", "b");
        h.put("c", "d");
        h.put("e", "f");
        h.put("a", "bb");
        ArrayList v = new ArrayList(h.keySet());
        Collections.sort(v);
    }

    @Test
    public void testRestoreSegmentation() {
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", new TextFragment("[seg 1]")));
        tc.append(new TextPart("[text part 1]"));
        tc.append(new Segment("s2", new TextFragment("[seg 2]")));
        tc.append(new TextPart("[text part 2]"));
        tc.append(new TextPart("[text part 3]"));
        tc.append(new Segment("s3", new TextFragment("[seg 3]")));
        tc.append(new Segment("s4", new TextFragment("[seg 4]")));
        TextFragment tf = TextUnitUtil.storeSegmentation(tc);
        Assert.assertEquals("<1/>[seg 1]<2/><3/>[text part 1]<4/><5/>[seg 2]<6/><7/>[text part 2]<8/><9/>[text part 3]<10/><11/>[seg 3]<12/><13/>[seg 4]<14/>", this.fmt.setContent(tf).toString());
        TextUnitUtil.restoreSegmentation(tc, tf);
        Assert.assertEquals("(2: seg_start s1) (9: seg_end s1) (13: tp_start) (26: tp_end) (30: seg_start s2) (37: seg_end s2) (41: tp_start) (54: tp_end) (58: tp_start) (71: tp_end) (75: seg_start s3) (82: seg_end s3) (86: seg_start s4) (93: seg_end s4)", TextUnitUtil.testMarkers());
        Assert.assertEquals("[seg 1][text part 1][seg 2][text part 2][text part 3][seg 3][seg 4]", tc.toString());
        Iterator<TextPart> it = tc.iterator();
        TextPart part = null;
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue(part.isSegment());
            Assert.assertEquals("[seg 1]", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse(part.isSegment());
            Assert.assertEquals("[text part 1]", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue(part.isSegment());
            Assert.assertEquals("[seg 2]", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse(part.isSegment());
            Assert.assertEquals("[text part 2]", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse(part.isSegment());
            Assert.assertEquals("[text part 3]", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue(part.isSegment());
            Assert.assertEquals("[seg 3]", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue(part.isSegment());
            Assert.assertEquals("[seg 4]", part.toString());
        }
    }

    @Test
    public void testRestoreSegmentation2() {
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", new TextFragment("[seg 1]")));
        tc.append(new TextPart("[text part 1]"));
        tc.append(new Segment("s2", new TextFragment("[seg 2]")));
        tc.append(new TextPart("[text part 2]"));
        tc.append(new TextPart("[text part 3]"));
        tc.append(new Segment("s3", new TextFragment("[seg 3]")));
        tc.append(new TextPart("[text part 4]"));
        TextFragment tf = TextUnitUtil.storeSegmentation(tc);
        Assert.assertEquals("<1/>[seg 1]<2/><3/>[text part 1]<4/><5/>[seg 2]<6/><7/>[text part 2]<8/><9/>[text part 3]<10/><11/>[seg 3]<12/><13/>[text part 4]<14/>", this.fmt.setContent(tf).toString());
        TextUnitUtil.restoreSegmentation(tc, tf);
        Assert.assertEquals("[seg 1][text part 1][seg 2][text part 2][text part 3][seg 3][text part 4]", tc.toString());
        Iterator<TextPart> it = tc.iterator();
        TextPart part = null;
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue(part.isSegment());
            Assert.assertEquals("[seg 1]", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse(part.isSegment());
            Assert.assertEquals("[text part 1]", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue(part.isSegment());
            Assert.assertEquals("[seg 2]", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse(part.isSegment());
            Assert.assertEquals("[text part 2]", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse(part.isSegment());
            Assert.assertEquals("[text part 3]", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue(part.isSegment());
            Assert.assertEquals("[seg 3]", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse(part.isSegment());
            Assert.assertEquals("[text part 4]", part.toString());
        }
    }

    @Test
    public void testRestoreSegmentation3() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x11", "<x11/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x12", "<x12/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x13", "<x13/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x14", "<x14/>");
        TextFragment tf2 = new TextFragment();
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x21", "<x21/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x22", "<x22/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x23", "<x23/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x24", "<x24/>");
        TextFragment tf3 = new TextFragment();
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x31", "<x31/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x32", "<x32/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x33", "<x33/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x34", "<x34/>");
        Assert.assertEquals("<1/><2/><3/><4/>", this.fmt.setContent(tf1).toString());
        Assert.assertEquals("<1/><2/><3/><4/>", this.fmt.setContent(tf2).toString());
        Assert.assertEquals("<1/><2/><3/><4/>", this.fmt.setContent(tf3).toString());
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf1));
        tc.append(new TextPart("[text part 1]"));
        tc.append(new Segment("s2", tf2));
        tc.append(new TextPart("[text part 2]"));
        tc.append(new TextPart("[text part 3]"));
        tc.append(new Segment("s3", tf3));
        tc.append(new TextPart("[text part 4]"));
        TextFragment tf = TextUnitUtil.storeSegmentation(tc);
        Assert.assertEquals("<1/><2/><3/><4/><5/><6/><7/>[text part 1]<8/><9/><10/><11/><12/><13/><14/><15/>[text part 2]<16/><17/>[text part 3]<18/><19/><20/><21/><22/><23/><24/><25/>[text part 4]<26/>", this.fmt.setContent(tf).toString());
        TextUnitUtil.simplifyCodes(tf, false);
        Assert.assertEquals("<1/>[text part 1]<2/>[text part 2]<3/>[text part 3]<4/>[text part 4]<5/>", this.fmt.setContent(tf).toString());
        List<Code> codes = tf.getCodes();
        Assert.assertEquals("[#$s1@%$seg_start$]<x11/><x12/><x13/><x14/>[#$s1@%$seg_end$]$tp_start$", codes.get(0).toString());
        Assert.assertEquals("$tp_end$[#$s2@%$seg_start$]<x21/><x22/><x23/><x24/>[#$s2@%$seg_end$]$tp_start$", codes.get(1).toString());
        Assert.assertEquals("$tp_end$$tp_start$", codes.get(2).toString());
        Assert.assertEquals("$tp_end$[#$s3@%$seg_start$]<x31/><x32/><x33/><x34/>[#$s3@%$seg_end$]$tp_start$", codes.get(3).toString());
        Assert.assertEquals("$tp_end$", codes.get(4).toString());
        TextUnitUtil.restoreSegmentation(tc, tf);
        Assert.assertEquals("<x11/><x12/><x13/><x14/>[text part 1]<x21/><x22/><x23/><x24/>[text part 2][text part 3]<x31/><x32/><x33/><x34/>[text part 4]", tc.toString());
        Iterator<TextPart> it = tc.iterator();
        TextPart part = null;
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue(part.isSegment());
            Assert.assertEquals("<x11/><x12/><x13/><x14/>", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse(part.isSegment());
            Assert.assertEquals("[text part 1]", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue(part.isSegment());
            Assert.assertEquals("<x21/><x22/><x23/><x24/>", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse(part.isSegment());
            Assert.assertEquals("[text part 2]", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse(part.isSegment());
            Assert.assertEquals("[text part 3]", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue(part.isSegment());
            Assert.assertEquals("<x31/><x32/><x33/><x34/>", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse(part.isSegment());
            Assert.assertEquals("[text part 4]", part.toString());
        }
    }

    @Test
    public void testRestoreSegmentation3_2() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x11", "<x11/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x12", "<x12/>");
        tf1.append("[seg 1]");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x13", "<x13/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x14", "<x14/>");
        TextFragment tf2 = new TextFragment();
        tf2.append("[seg 2]");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x21", "<x21/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x22", "<x22/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x23", "<x23/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x24", "<x24/>");
        TextFragment tf3 = new TextFragment();
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x31", "<x31/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x32", "<x32/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x33", "<x33/>");
        tf3.append("[seg 3]");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x34", "<x34/>");
        Assert.assertEquals("<1/><2/>[seg 1]<3/><4/>", this.fmt.setContent(tf1).toString());
        Assert.assertEquals("[seg 2]<1/><2/><3/><4/>", this.fmt.setContent(tf2).toString());
        Assert.assertEquals("<1/><2/><3/>[seg 3]<4/>", this.fmt.setContent(tf3).toString());
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf1));
        tc.append(new TextPart("[text part 1]"));
        tc.append(new Segment("s2", tf2));
        tc.append(new TextPart("[text part 2]"));
        tc.append(new TextPart("[text part 3]"));
        tc.append(new Segment("s3", tf3));
        tc.append(new TextPart("[text part 4]"));
        TextFragment tf = TextUnitUtil.storeSegmentation(tc);
        Assert.assertEquals("<1/><2/><3/>[seg 1]<4/><5/><6/><7/>[text part 1]<8/><9/>[seg 2]<10/><11/><12/><13/><14/><15/>[text part 2]<16/><17/>[text part 3]<18/><19/><20/><21/><22/>[seg 3]<23/><24/><25/>[text part 4]<26/>", this.fmt.setContent(tf).toString());
        Assert.assertEquals("[#$s1@%$seg_start$]<x11/><x12/>[seg 1]<x13/><x14/>[#$s1@%$seg_end$]$tp_start$[text part 1]$tp_end$[#$s2@%$seg_start$][seg 2]<x21/><x22/><x23/><x24/>[#$s2@%$seg_end$]$tp_start$[text part 2]$tp_end$$tp_start$[text part 3]$tp_end$[#$s3@%$seg_start$]<x31/><x32/><x33/>[seg 3]<x34/>[#$s3@%$seg_end$]$tp_start$[text part 4]$tp_end$", tf.toText());
        TextUnitUtil.simplifyCodes(tf, false);
        Assert.assertEquals("<1/>[seg 1]<2/>[text part 1]<3/>[seg 2]<4/>[text part 2]<5/>[text part 3]<6/>[seg 3]<7/>[text part 4]<8/>", this.fmt.setContent(tf).toString());
        List<Code> codes = tf.getCodes();
        Assert.assertEquals(8L, codes.size());
        Assert.assertEquals("[#$s1@%$seg_start$]<x11/><x12/>", codes.get(0).toString());
        Assert.assertEquals("<x13/><x14/>[#$s1@%$seg_end$]$tp_start$", codes.get(1).toString());
        Assert.assertEquals("$tp_end$[#$s2@%$seg_start$]", codes.get(2).toString());
        Assert.assertEquals("<x21/><x22/><x23/><x24/>[#$s2@%$seg_end$]$tp_start$", codes.get(3).toString());
        Assert.assertEquals("$tp_end$$tp_start$", codes.get(4).toString());
        Assert.assertEquals("$tp_end$[#$s3@%$seg_start$]<x31/><x32/><x33/>", codes.get(5).toString());
        Assert.assertEquals("<x34/>[#$s3@%$seg_end$]$tp_start$", codes.get(6).toString());
        Assert.assertEquals("$tp_end$", codes.get(7).toString());
        TextUnitUtil.restoreSegmentation(tc, tf);
        Assert.assertEquals("(0-19: tp_start) (0-31: tp_end) (2: seg_start s1) (9: seg_end s1) (9-0: tp_start) (9-12: tp_end) (11: tp_start) (24: tp_end) (26: seg_start s2) (33: seg_end s2) (33-0: tp_start) (33-24: tp_end) (35: tp_start) (48: tp_end) (50: tp_start) (63: tp_end) (63-27: tp_start) (63-45: tp_end) (65: seg_start s3) (72: seg_end s3) (72-0: tp_start) (72-6: tp_end) (74: tp_start) (87: tp_end)", TextUnitUtil.testMarkers());
        Assert.assertEquals("<x11/><x12/>[seg 1]<x13/><x14/>[text part 1][seg 2]<x21/><x22/><x23/><x24/>[text part 2][text part 3]<x31/><x32/><x33/>[seg 3]<x34/>[text part 4]", tc.toString());
        Assert.assertEquals(12L, tc.count());
        Assert.assertTrue(!tc.get(0).isSegment());
        Assert.assertTrue(tc.get(1).isSegment());
        Assert.assertTrue(!tc.get(2).isSegment());
        Assert.assertTrue(!tc.get(3).isSegment());
        Assert.assertTrue(tc.get(4).isSegment());
        Assert.assertTrue(!tc.get(5).isSegment());
        Assert.assertTrue(!tc.get(6).isSegment());
        Assert.assertTrue(!tc.get(7).isSegment());
        Assert.assertTrue(!tc.get(8).isSegment());
        Assert.assertTrue(tc.get(9).isSegment());
        Assert.assertTrue(!tc.get(10).isSegment());
        Assert.assertTrue(!tc.get(11).isSegment());
        Assert.assertEquals("<x11/><x12/>", tc.get(0).toString());
        Assert.assertEquals("[seg 1]", tc.get(1).toString());
        Assert.assertEquals("<x13/><x14/>", tc.get(2).toString());
        Assert.assertEquals("[text part 1]", tc.get(3).toString());
        Assert.assertEquals("[seg 2]", tc.get(4).toString());
        Assert.assertEquals("<x21/><x22/><x23/><x24/>", tc.get(5).toString());
        Assert.assertEquals("[text part 2]", tc.get(6).toString());
        Assert.assertEquals("[text part 3]", tc.get(7).toString());
        Assert.assertEquals("<x31/><x32/><x33/>", tc.get(8).toString());
        Assert.assertEquals("[seg 3]", tc.get(9).toString());
        Assert.assertEquals("<x34/>", tc.get(10).toString());
        Assert.assertEquals("[text part 4]", tc.get(11).toString());
    }

    @Test
    public void testRestoreSegmentation3_3() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x11", "<x11/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x12", "<x12/>");
        tf1.append("[seg 1]");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x13", "<x13/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x14", "<x14/>");
        TextFragment tf2 = new TextFragment();
        tf2.append("[seg 2]");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x21", "<x21/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x22", "<x22/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x23", "<x23/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x24", "<x24/>");
        TextFragment tf3 = new TextFragment();
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x31", "<x31/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x32", "<x32/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x33", "<x33/>");
        tf3.append("[seg 3]");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x34", "<x34/>");
        Assert.assertEquals("<1/><2/>[seg 1]<3/><4/>", this.fmt.setContent(tf1).toString());
        Assert.assertEquals("[seg 2]<1/><2/><3/><4/>", this.fmt.setContent(tf2).toString());
        Assert.assertEquals("<1/><2/><3/>[seg 3]<4/>", this.fmt.setContent(tf3).toString());
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf1));
        tc.append(new TextPart("[text part 1]"));
        tc.append(new Segment("s2", tf2));
        tc.append(new TextPart("[text part 2]"));
        tc.append(new TextPart("[text part 3]"));
        tc.append(new Segment("s3", tf3));
        tc.append(new TextPart("[text part 4]"));
        TextFragment tf = TextUnitUtil.storeSegmentation(tc);
        Assert.assertEquals("<1/><2/><3/>[seg 1]<4/><5/><6/><7/>[text part 1]<8/><9/>[seg 2]<10/><11/><12/><13/><14/><15/>[text part 2]<16/><17/>[text part 3]<18/><19/><20/><21/><22/>[seg 3]<23/><24/><25/>[text part 4]<26/>", this.fmt.setContent(tf).toString());
        Assert.assertEquals("[#$s1@%$seg_start$]<x11/><x12/>[seg 1]<x13/><x14/>[#$s1@%$seg_end$]$tp_start$[text part 1]$tp_end$[#$s2@%$seg_start$][seg 2]<x21/><x22/><x23/><x24/>[#$s2@%$seg_end$]$tp_start$[text part 2]$tp_end$$tp_start$[text part 3]$tp_end$[#$s3@%$seg_start$]<x31/><x32/><x33/>[seg 3]<x34/>[#$s3@%$seg_end$]$tp_start$[text part 4]$tp_end$", tf.toText());
        String[] res = TextUnitUtil.simplifyCodes(tf, true);
        Assert.assertEquals("[seg 1]<2/>[text part 1]<3/>[seg 2]<4/>[text part 2]<5/>[text part 3]<6/>[seg 3]<7/>[text part 4]", this.fmt.setContent(tf).toString());
        Assert.assertEquals("[seg 1]<x13/><x14/>[#$s1@%$seg_end$]$tp_start$[text part 1]$tp_end$[#$s2@%$seg_start$][seg 2]<x21/><x22/><x23/><x24/>[#$s2@%$seg_end$]$tp_start$[text part 2]$tp_end$$tp_start$[text part 3]$tp_end$[#$s3@%$seg_start$]<x31/><x32/><x33/>[seg 3]<x34/>[#$s3@%$seg_end$]$tp_start$[text part 4]", tf.toText());
        Assert.assertEquals("[#$s1@%$seg_start$]<x11/><x12/>", res[0]);
        Assert.assertEquals("$tp_end$", res[1]);
        List<Code> codes = tf.getCodes();
        Assert.assertEquals(6L, codes.size());
        Assert.assertEquals("<x13/><x14/>[#$s1@%$seg_end$]$tp_start$", codes.get(0).toString());
        Assert.assertEquals("$tp_end$[#$s2@%$seg_start$]", codes.get(1).toString());
        Assert.assertEquals("<x21/><x22/><x23/><x24/>[#$s2@%$seg_end$]$tp_start$", codes.get(2).toString());
        Assert.assertEquals("$tp_end$$tp_start$", codes.get(3).toString());
        Assert.assertEquals("$tp_end$[#$s3@%$seg_start$]<x31/><x32/><x33/>", codes.get(4).toString());
        Assert.assertEquals("<x34/>[#$s3@%$seg_end$]$tp_start$", codes.get(5).toString());
        TextUnitUtil.restoreSegmentation(tc, tf);
        Assert.assertEquals("(7: seg_end s1) (7-0: tp_start) (7-12: tp_end) (9: tp_start) (22: tp_end) (24: seg_start s2) (31: seg_end s2) (31-0: tp_start) (31-24: tp_end) (33: tp_start) (46: tp_end) (48: tp_start) (61: tp_end) (61-27: tp_start) (61-45: tp_end) (63: seg_start s3) (70: seg_end s3) (70-0: tp_start) (70-6: tp_end) (72: tp_start)", TextUnitUtil.testMarkers());
        Assert.assertEquals("<x13/><x14/>[text part 1][seg 2]<x21/><x22/><x23/><x24/>[text part 2][text part 3]<x31/><x32/><x33/>[seg 3]<x34/>", tc.toString());
        TextPart part = null;
        Assert.assertEquals(9L, tc.count());
        part = tc.get(0);
        Assert.assertFalse(part.isSegment());
        Assert.assertEquals("<x13/><x14/>", part.toString());
        part = tc.get(1);
        Assert.assertFalse(part.isSegment());
        Assert.assertEquals("[text part 1]", part.toString());
        part = tc.get(2);
        Assert.assertTrue(part.isSegment());
        Assert.assertEquals("[seg 2]", part.toString());
        part = tc.get(3);
        Assert.assertFalse(part.isSegment());
        Assert.assertEquals("<x21/><x22/><x23/><x24/>", part.toString());
        part = tc.get(4);
        Assert.assertFalse(part.isSegment());
        Assert.assertEquals("[text part 2]", part.toString());
        part = tc.get(5);
        Assert.assertFalse(part.isSegment());
        Assert.assertEquals("[text part 3]", part.toString());
        part = tc.get(6);
        Assert.assertFalse(part.isSegment());
        Assert.assertEquals("<x31/><x32/><x33/>", part.toString());
        part = tc.get(7);
        Assert.assertTrue(part.isSegment());
        Assert.assertEquals("[seg 3]", part.toString());
        part = tc.get(8);
        Assert.assertFalse(part.isSegment());
        Assert.assertEquals("<x34/>", part.toString());
    }

    @Test
    public void testRestoreSegmentation3_4() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x11", "<x11/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x12", "<x12/>");
        tf1.append("[seg 1]");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x13", "<x13/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x14", "<x14/>");
        TextFragment tf2 = new TextFragment();
        tf2.append("[seg 2]");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x21", "<x21/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x22", "<x22/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x23", "<x23/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x24", "<x24/>");
        TextFragment tf3 = new TextFragment();
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x31", "<x31/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x32", "<x32/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x33", "<x33/>");
        tf3.append("[seg 3]");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x34", "<x34/>");
        Assert.assertEquals("<1/><2/>[seg 1]<3/><4/>", this.fmt.setContent(tf1).toString());
        Assert.assertEquals("[seg 2]<1/><2/><3/><4/>", this.fmt.setContent(tf2).toString());
        Assert.assertEquals("<1/><2/><3/>[seg 3]<4/>", this.fmt.setContent(tf3).toString());
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf1));
        tc.append(new TextPart("[text part 1]"));
        tc.append(new Segment("s2", tf2));
        tc.append(new TextPart("[text part 2]"));
        tc.append(new TextPart("[text part 3]"));
        tc.append(new Segment("s3", tf3));
        tc.append(new TextPart("[text part 4]"));
        TextFragment tf = TextUnitUtil.storeSegmentation(tc);
        Assert.assertEquals("<1/><2/><3/>[seg 1]<4/><5/><6/><7/>[text part 1]<8/><9/>[seg 2]<10/><11/><12/><13/><14/><15/>[text part 2]<16/><17/>[text part 3]<18/><19/><20/><21/><22/>[seg 3]<23/><24/><25/>[text part 4]<26/>", this.fmt.setContent(tf).toString());
        Assert.assertEquals("[#$s1@%$seg_start$]<x11/><x12/>[seg 1]<x13/><x14/>[#$s1@%$seg_end$]$tp_start$[text part 1]$tp_end$[#$s2@%$seg_start$][seg 2]<x21/><x22/><x23/><x24/>[#$s2@%$seg_end$]$tp_start$[text part 2]$tp_end$$tp_start$[text part 3]$tp_end$[#$s3@%$seg_start$]<x31/><x32/><x33/>[seg 3]<x34/>[#$s3@%$seg_end$]$tp_start$[text part 4]$tp_end$", tf.toText());
        String[] res = TextUnitUtil.simplifyCodes(tc, true);
        Assert.assertEquals("<1/><2/><3/>[seg 1]<4/><5/><6/><7/>[text part 1]<8/><9/>[seg 2]<10/><11/><12/><13/><14/><15/>[text part 2]<16/><17/>[text part 3]<18/><19/><20/><21/><22/>[seg 3]<23/><24/><25/>[text part 4]<26/>", this.fmt.setContent(tf).toString());
        Assert.assertEquals("[#$s1@%$seg_start$]<x11/><x12/>[seg 1]<x13/><x14/>[#$s1@%$seg_end$]$tp_start$[text part 1]$tp_end$[#$s2@%$seg_start$][seg 2]<x21/><x22/><x23/><x24/>[#$s2@%$seg_end$]$tp_start$[text part 2]$tp_end$$tp_start$[text part 3]$tp_end$[#$s3@%$seg_start$]<x31/><x32/><x33/>[seg 3]<x34/>[#$s3@%$seg_end$]$tp_start$[text part 4]$tp_end$", tf.toText());
        Assert.assertEquals("<x11/><x12/>", res[0]);
        Assert.assertEquals("", res[1]);
        TextPart part = null;
        Assert.assertEquals(11L, tc.count());
        part = tc.get(0);
        Assert.assertTrue(part.isSegment());
        Assert.assertEquals("[seg 1]", part.toString());
        part = tc.get(1);
        Assert.assertFalse(part.isSegment());
        Assert.assertEquals("<x13/><x14/>", part.toString());
        part = tc.get(2);
        Assert.assertFalse(part.isSegment());
        Assert.assertEquals("[text part 1]", part.toString());
        part = tc.get(3);
        Assert.assertTrue(part.isSegment());
        Assert.assertEquals("[seg 2]", part.toString());
        part = tc.get(4);
        Assert.assertFalse(part.isSegment());
        Assert.assertEquals("<x21/><x22/><x23/><x24/>", part.toString());
        part = tc.get(5);
        Assert.assertFalse(part.isSegment());
        Assert.assertEquals("[text part 2]", part.toString());
        part = tc.get(6);
        Assert.assertFalse(part.isSegment());
        Assert.assertEquals("[text part 3]", part.toString());
        part = tc.get(7);
        Assert.assertFalse(part.isSegment());
        Assert.assertEquals("<x31/><x32/><x33/>", part.toString());
        part = tc.get(8);
        Assert.assertTrue(part.isSegment());
        Assert.assertEquals("[seg 3]", part.toString());
        part = tc.get(9);
        Assert.assertFalse(part.isSegment());
        Assert.assertEquals("<x34/>", part.toString());
        part = tc.get(10);
        Assert.assertFalse(part.isSegment());
        Assert.assertEquals("[text part 4]", part.toString());
    }

    @Test
    public void testExtractSegMarkers() {
        String st = "$tp_end$[#$s3@%$seg_start$]<x31/><x32/><x33/><x34/>[#$s3@%$seg_end$]$tp_start$";
        TextFragment tf = new TextFragment();
        String res = TextUnitUtil.extractSegMarkers(tf, st, false);
        Assert.assertEquals("<1/><2/><3/><4/>", this.fmt.setContent(tf).toString());
        Assert.assertEquals("$tp_end$[#$s3@%$seg_start$]<x31/><x32/><x33/><x34/>[#$s3@%$seg_end$]$tp_start$", res);
        List<Code> codes = tf.getCodes();
        Assert.assertEquals(4L, codes.size());
        Assert.assertEquals("$tp_end$", codes.get(0).toString());
        Assert.assertEquals("[#$s3@%$seg_start$]", codes.get(1).toString());
        Assert.assertEquals("[#$s3@%$seg_end$]", codes.get(2).toString());
        Assert.assertEquals("$tp_start$", codes.get(3).toString());
        tf = new TextFragment();
        res = TextUnitUtil.extractSegMarkers(tf, st, true);
        Assert.assertEquals("<1/><2/><3/><4/>", this.fmt.setContent(tf).toString());
        Assert.assertEquals("<x31/><x32/><x33/><x34/>", res);
        codes = tf.getCodes();
        Assert.assertEquals(4L, codes.size());
        Assert.assertEquals("$tp_end$", codes.get(0).toString());
        Assert.assertEquals("[#$s3@%$seg_start$]", codes.get(1).toString());
        Assert.assertEquals("[#$s3@%$seg_end$]", codes.get(2).toString());
        Assert.assertEquals("$tp_start$", codes.get(3).toString());
    }

    @Test
    public void testRestoreSegmentation4() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x11", "<x11/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x12", "<x12/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x13", "<x13/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x14", "<x14/>");
        TextFragment tf2 = new TextFragment();
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x21", "<x21/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x22", "<x22/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x23", "<x23/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x24", "<x24/>");
        TextFragment tf3 = new TextFragment();
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x31", "<x31/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x32", "<x32/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x33", "<x33/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x34", "<x34/>");
        Assert.assertEquals("<1/><2/><3/><4/>", this.fmt.setContent(tf1).toString());
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf1));
        tc.append(new TextPart("[text part 1]"));
        tc.append(new Segment("s2", tf2));
        tc.append(new TextPart("[text part 2]"));
        tc.append(new TextPart("[text part 3]"));
        tc.append(new Segment("s3", tf3));
        tc.append(new TextPart("[text part 4]"));
        TextFragment tf = TextUnitUtil.storeSegmentation(tc);
        Assert.assertEquals("<1/><2/><3/><4/><5/><6/><7/>[text part 1]<8/><9/><10/><11/><12/><13/><14/><15/>[text part 2]<16/><17/>[text part 3]<18/><19/><20/><21/><22/><23/><24/><25/>[text part 4]<26/>", this.fmt.setContent(tf).toString());
        TextUnitUtil.restoreSegmentation(tc, tf);
        Assert.assertEquals("<x11/><x12/><x13/><x14/>[text part 1]<x21/><x22/><x23/><x24/>[text part 2][text part 3]<x31/><x32/><x33/><x34/>[text part 4]", tc.toString());
    }

    @Test
    public void testRestoreSegmentation5() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x1", "[#$0@%$seg_start$]");
        tf1.append("T1");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x2", "[#$0@%$seg_end$]$tp_start$ $tp_end$[#$1@%$seg_start$]<br /> <br />");
        tf1.append(" T2");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x3", "[#$1@%$seg_end$]");
        TextContainer tc = new TextContainer();
        TextUnitUtil.restoreSegmentation(tc, tf1);
        Assert.assertEquals("T1 <br /> <br /> T2", tc.toString());
        Assert.assertEquals(4L, tc.count());
        Segment s1 = tc.getSegments().get(0);
        Segment s2 = tc.getSegments().get(1);
        Assert.assertEquals("T1", s1.getContent().toText());
        Assert.assertEquals(" T2", s2.getContent().toText());
        Iterator<TextPart> it = tc.iterator();
        TextPart part = null;
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue(part.isSegment());
            Assert.assertEquals("T1", part.toString());
            Assert.assertEquals("0", ((Segment)part).getId());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse(part.isSegment());
            Assert.assertEquals(" ", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse(part.isSegment());
            Assert.assertEquals("<br /> <br />", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue(part.isSegment());
            Assert.assertEquals(" T2", part.toString());
            Assert.assertEquals("1", ((Segment)part).getId());
        }
    }

    @Test
    public void testRestoreSegmentation6() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x1", "[#$0@%$seg_start$]   [#$0@%$seg_end$]$tp_start$  $tp_end$$tp_start$ $tp_end$$tp_start$  $tp_end$[#$1@%$seg_start$]");
        tf1.append("T1");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x2", "[#$1@%$seg_end$]");
        TextContainer tc = new TextContainer();
        TextUnitUtil.restoreSegmentation(tc, tf1);
        Assert.assertEquals("        T1", tc.toString());
        Assert.assertEquals(5L, tc.count());
        Assert.assertEquals(2L, tc.getSegments().count());
        Segment s1 = tc.getSegments().get(0);
        Segment s2 = tc.getSegments().get(1);
        Assert.assertEquals("   ", s1.getContent().toText());
        Assert.assertEquals("T1", s2.getContent().toText());
    }

    @Test
    public void testRestoreSegmentation7() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x1", "[<br1> <br2> [#$0@%$seg_end$][#$1@%$seg_start$][#$1@%$seg_end$]$tp_start$ T1 $tp_end$$tp_start$ T2 $tp_end$[#$2@%$seg_start$]<br /> <br />]");
        TextContainer tc = new TextContainer();
        TextUnitUtil.restoreSegmentation(tc, tf1);
        Assert.assertEquals("[<br1> <br2>  T1  T2 <br /> <br />]", tc.toString());
        Assert.assertEquals(5L, tc.count());
        TextPart tp1 = tc.get(0);
        Assert.assertEquals("[<br1> <br2> ", tp1.getContent().toText());
        TextPart tp2 = tc.get(1);
        Assert.assertEquals("", tp2.getContent().toText());
        TextPart tp4 = tc.get(2);
        Assert.assertEquals(" T1 ", tp4.getContent().toText());
        TextPart tp5 = tc.get(3);
        Assert.assertEquals(" T2 ", tp5.getContent().toText());
        TextPart tp6 = tc.get(4);
        Assert.assertEquals("<br /> <br />]", tp6.getContent().toText());
        Assert.assertEquals(1L, tc.getSegments().count());
        Segment s1 = tc.getSegments().get(0);
        Assert.assertEquals("", s1.getContent().toText());
    }

    @Test
    public void testTrimSegments() {
        TextFragment tf1 = new TextFragment();
        tf1.append(" [seg 1]");
        TextFragment tf2 = new TextFragment();
        tf2.append("  [seg 2]   ");
        TextFragment tf3 = new TextFragment();
        tf3.append("    [seg 3]     ");
        TextFragment tf4 = new TextFragment();
        tf4.append("[seg 4]");
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf1));
        tc.append(new Segment("s2", tf2));
        tc.append(new Segment("s3", tf3));
        tc.append(new Segment("s4", tf4));
        Assert.assertEquals(" [seg 1]  [seg 2]       [seg 3]     [seg 4]", tc.toString());
        Assert.assertEquals(4L, tc.count());
        Assert.assertTrue(tc.get(0).isSegment());
        Assert.assertTrue(tc.get(1).isSegment());
        Assert.assertTrue(tc.get(2).isSegment());
        Assert.assertTrue(tc.get(3).isSegment());
        Assert.assertEquals(" [seg 1]", tc.get(0).toString());
        Assert.assertEquals("  [seg 2]   ", tc.get(1).toString());
        Assert.assertEquals("    [seg 3]     ", tc.get(2).toString());
        Assert.assertEquals("[seg 4]", tc.get(3).toString());
        TextUnitUtil.trimSegments(tc);
        Assert.assertEquals(9L, tc.count());
        Assert.assertTrue(!tc.get(0).isSegment());
        Assert.assertTrue(tc.get(1).isSegment());
        Assert.assertTrue(!tc.get(2).isSegment());
        Assert.assertTrue(tc.get(3).isSegment());
        Assert.assertTrue(!tc.get(4).isSegment());
        Assert.assertTrue(!tc.get(5).isSegment());
        Assert.assertTrue(tc.get(6).isSegment());
        Assert.assertTrue(!tc.get(7).isSegment());
        Assert.assertTrue(tc.get(8).isSegment());
        Assert.assertEquals(" ", tc.get(0).toString());
        Assert.assertEquals("[seg 1]", tc.get(1).toString());
        Assert.assertEquals("  ", tc.get(2).toString());
        Assert.assertEquals("[seg 2]", tc.get(3).toString());
        Assert.assertEquals("   ", tc.get(4).toString());
        Assert.assertEquals("    ", tc.get(5).toString());
        Assert.assertEquals("[seg 3]", tc.get(6).toString());
        Assert.assertEquals("     ", tc.get(7).toString());
        Assert.assertEquals("[seg 4]", tc.get(8).toString());
    }

    @Test
    public void testTrimSegments_leading() {
        TextFragment tf1 = new TextFragment();
        tf1.append(" [seg 1]");
        TextFragment tf2 = new TextFragment();
        tf2.append("  [seg 2]   ");
        TextFragment tf3 = new TextFragment();
        tf3.append("    [seg 3]     ");
        TextFragment tf4 = new TextFragment();
        tf4.append("[seg 4]");
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf1));
        tc.append(new Segment("s2", tf2));
        tc.append(new Segment("s3", tf3));
        tc.append(new Segment("s4", tf4));
        Assert.assertEquals(" [seg 1]  [seg 2]       [seg 3]     [seg 4]", tc.toString());
        Assert.assertEquals(4L, tc.count());
        Assert.assertTrue(tc.get(0).isSegment());
        Assert.assertTrue(tc.get(1).isSegment());
        Assert.assertTrue(tc.get(2).isSegment());
        Assert.assertTrue(tc.get(3).isSegment());
        Assert.assertEquals(" [seg 1]", tc.get(0).toString());
        Assert.assertEquals("  [seg 2]   ", tc.get(1).toString());
        Assert.assertEquals("    [seg 3]     ", tc.get(2).toString());
        Assert.assertEquals("[seg 4]", tc.get(3).toString());
        TextUnitUtil.trimSegments(tc, true, false);
        Assert.assertEquals(7L, tc.count());
        Assert.assertTrue(!tc.get(0).isSegment());
        Assert.assertTrue(tc.get(1).isSegment());
        Assert.assertTrue(!tc.get(2).isSegment());
        Assert.assertTrue(tc.get(3).isSegment());
        Assert.assertTrue(!tc.get(4).isSegment());
        Assert.assertTrue(tc.get(5).isSegment());
        Assert.assertTrue(tc.get(6).isSegment());
        Assert.assertEquals(" ", tc.get(0).toString());
        Assert.assertEquals("[seg 1]", tc.get(1).toString());
        Assert.assertEquals("  ", tc.get(2).toString());
        Assert.assertEquals("[seg 2]   ", tc.get(3).toString());
        Assert.assertEquals("    ", tc.get(4).toString());
        Assert.assertEquals("[seg 3]     ", tc.get(5).toString());
        Assert.assertEquals("[seg 4]", tc.get(6).toString());
    }

    @Test
    public void testTrimSegments_trailing() {
        TextFragment tf1 = new TextFragment();
        tf1.append(" [seg 1]");
        TextFragment tf2 = new TextFragment();
        tf2.append("  [seg 2]   ");
        TextFragment tf3 = new TextFragment();
        tf3.append("    [seg 3]     ");
        TextFragment tf4 = new TextFragment();
        tf4.append("[seg 4]");
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf1));
        tc.append(new Segment("s2", tf2));
        tc.append(new Segment("s3", tf3));
        tc.append(new Segment("s4", tf4));
        Assert.assertEquals(" [seg 1]  [seg 2]       [seg 3]     [seg 4]", tc.toString());
        Assert.assertEquals(4L, tc.count());
        Assert.assertTrue(tc.get(0).isSegment());
        Assert.assertTrue(tc.get(1).isSegment());
        Assert.assertTrue(tc.get(2).isSegment());
        Assert.assertTrue(tc.get(3).isSegment());
        Assert.assertEquals(" [seg 1]", tc.get(0).toString());
        Assert.assertEquals("  [seg 2]   ", tc.get(1).toString());
        Assert.assertEquals("    [seg 3]     ", tc.get(2).toString());
        Assert.assertEquals("[seg 4]", tc.get(3).toString());
        TextUnitUtil.trimSegments(tc, false, true);
        Assert.assertEquals(6L, tc.count());
        Assert.assertTrue(tc.get(0).isSegment());
        Assert.assertTrue(tc.get(1).isSegment());
        Assert.assertTrue(!tc.get(2).isSegment());
        Assert.assertTrue(tc.get(3).isSegment());
        Assert.assertTrue(!tc.get(4).isSegment());
        Assert.assertTrue(tc.get(5).isSegment());
        Assert.assertEquals(" [seg 1]", tc.get(0).toString());
        Assert.assertEquals("  [seg 2]", tc.get(1).toString());
        Assert.assertEquals("   ", tc.get(2).toString());
        Assert.assertEquals("    [seg 3]", tc.get(3).toString());
        Assert.assertEquals("     ", tc.get(4).toString());
        Assert.assertEquals("[seg 4]", tc.get(5).toString());
    }

    private TextFragment makeFragment1() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "b", "[b]");
        tf.append("A");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "[br/]");
        tf.append("B");
        tf.append(TextFragment.TagType.CLOSING, "b", "[/b]");
        tf.append("C");
        return tf;
    }

    private TextFragment makeFragment1Bis(String extra) {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "b", "{B}");
        tf.append("A");
        tf.append(TextFragment.TagType.CLOSING, "b", "{/B}");
        tf.append("B");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "{BR/}");
        tf.append("C " + extra);
        return tf;
    }

    private ITextUnit createTextUnit1() {
        TextUnit tu = new TextUnit("1", "t ");
        TextFragment tf = tu.getSource().getSegments().getFirstContent();
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("bold");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(" t ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>");
        return tu;
    }
}

