/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.microsoft;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String CLIENTID = "clientId";
    private static final String SECRET = "secret";
    private static final String CATEGORY = "category";
    private String clientId = "";
    private String secret = "";
    private String category = "";

    public Parameters() {
        this.reset();
        this.toString();
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.clientId = this.buffer.getEncodedString(CLIENTID, this.clientId);
        this.secret = this.buffer.getEncodedString(SECRET, this.secret);
        this.category = this.buffer.getString(CATEGORY, this.category);
    }

    @Override
    public void reset() {
        this.clientId = "";
        this.secret = "";
        this.category = "";
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setEncodedString(CLIENTID, this.clientId);
        this.buffer.setEncodedString(SECRET, this.secret);
        this.buffer.setString(CATEGORY, this.category);
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(CLIENTID, "Client ID (See http://msdn.microsoft.com/en-us/library/hh454950.aspx)", "The ClientID to identify the user");
        desc.add(SECRET, "Secret (See http://msdn.microsoft.com/en-us/library/hh454950.aspx)", "A code obtained from Microsoft Azure");
        desc.add(CATEGORY, "Category (See http://hub.microsofttranslator.com", "A category code for an MT system trained by user data, if any");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Microsoft MT Connector Settings", true, false);
        desc.addTextInputPart(paramsDesc.get(CLIENTID));
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(SECRET));
        tip.setPassword(true);
        tip = desc.addTextInputPart(paramsDesc.get(CATEGORY));
        tip.setAllowEmpty(true);
        return desc;
    }
}

