/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.its.html5;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.FileUtil;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiBadFilterParametersException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.its.ITSFilter;
import net.sf.okapi.filters.its.Parameters;
import net.sf.okapi.filters.its.html5.HTML5SkeletonWriter;
import nu.validator.htmlparser.dom.HtmlDocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.its.ITSEngine;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@UsingParameters(value=Parameters.class)
public class HTML5Filter
extends ITSFilter {
    public HTML5Filter() {
        super(true, "text/html");
        URL url = this.getClass().getResource("default.fprm");
        try {
            this.params.load(new URI(url.toString().replace('\\', '/')), false);
        }
        catch (URISyntaxException e) {
            throw new OkapiBadFilterParametersException("Cannot load default parameters.");
        }
    }

    @Override
    public String getName() {
        return "okf_itshtml5";
    }

    @Override
    public String getDisplayName() {
        return "HTML5-ITS Filter";
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), "text/html", this.getClass().getName(), "Standard HTML5", "Configuration for standard HTML5 documents.", "default.fprm", ".html;.htm;"));
        return list;
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new HTML5SkeletonWriter();
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping(this.getMimeType(), "net.sf.okapi.common.encoder.HtmlEncoder");
        }
        return this.encoderManager;
    }

    @Override
    protected void initializeDocument() {
        this.input.setEncoding("UTF-8");
        BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(this.input.getStream(), this.input.getEncoding());
        detector.detectBom();
        if (detector.isAutodetected()) {
            this.encoding = detector.getEncoding();
            if (this.encoding.equals("UTF-16LE") || this.encoding.equals("UTF-16BE")) {
                this.encoding = "UTF-16";
            }
            this.input.setEncoding(this.encoding);
        }
        HtmlDocumentBuilder docBuilder = new HtmlDocumentBuilder();
        try {
            InputSource is = new InputSource(this.input.getStream());
            is.setEncoding(this.input.getEncoding());
            this.doc = docBuilder.parse(is);
        }
        catch (SAXException e) {
            throw new OkapiIOException("Error when parsing the document.\n" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error when reading the document.\n" + e.getMessage(), e);
        }
        this.encoding = this.doc.getXmlEncoding();
        if (this.encoding == null) {
            this.encoding = detector.getEncoding();
        }
        this.srcLang = this.input.getSourceLocale();
        if (this.srcLang == null) {
            throw new NullPointerException("Source language not set.");
        }
        this.hasUTF8BOM = detector.hasUtf8Bom();
        this.lineBreak = detector.getNewlineType().toString();
        if (this.input.getInputURI() != null) {
            this.docName = this.input.getInputURI().getPath();
        }
    }

    @Override
    protected void applyRules(ITSEngine itsEng) {
        HTML5Filter.loadLinkedRules(this.doc, this.input.getInputURI(), itsEng);
        itsEng.applyRules(2092958L);
    }

    @Override
    protected void createStartDocumentSkeleton(StartDocument startDoc) {
        this.skel = new GenericSkeleton();
        this.skel.add("<!DOCTYPE html>" + this.lineBreak);
    }

    public static void loadLinkedRules(Document doc, URI docURI, ITSEngine itsEng) {
        String href = null;
        try {
            XPathExpression expr = itsEng.getXPath().compile("//h:link[@rel='its-rules']");
            NodeList list = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < list.getLength(); ++i) {
                Element elem = (Element)list.item(i);
                href = elem.getAttribute("href").trim();
                if (href.indexOf(47) == -1 && href.indexOf(92) == -1) {
                    String base = FileUtil.getPartBeforeFile(docURI);
                    href = base + href;
                }
                itsEng.addExternalRules(new URI(href));
            }
        }
        catch (Throwable e) {
            throw new OkapiIOException(String.format("Error trying to load external rules (%s).\n" + e.getMessage(), href));
        }
    }
}

